package com.thebeastshop.pegasus.service.purchase.vo;

import java.io.Serializable;
import java.util.Date;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import org.springframework.beans.factory.annotation.Autowired;

import com.thebeastshop.pegasus.service.purchase.PegasusPurchaseServiceFacade;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

/**
 * 导入模板
 * @author jim.huang
 * @date 2016/4/11
 */
@ExcelTemplate
public class FlowerSkuVO implements Serializable {

	@Autowired
	private PegasusPurchaseServiceFacade PcsFacade = PegasusPurchaseServiceFacade.getInstance();

	// constrcutor
	public FlowerSkuVO() {

	}

	// original
	private Long id;

	private Date createTime;
	
	@ExcelColumn(name="品类")
	@NotNull
	private String skuType;

	@ExcelColumn(name="SKU(code)", cellFormat="TEXT", unique=true)
    @NotNull
	private String skuCode;
	
	@ExcelColumn(name="SKU(name)")
    @NotNull
	private String skuName;

	@ExcelColumn(name="SKU单位")
	private String skuUnit;
	
	@ExcelColumn(name="采购单位")
	private String purchaseUnit;
	
	@ExcelColumn(name="采购单位包含SKU单位数量")
	private Integer purchaseUnitNumber;

	public PegasusPurchaseServiceFacade getPcsFacade() {
		return PcsFacade;
	}

	public void setPcsFacade(PegasusPurchaseServiceFacade pcsFacade) {
		PcsFacade = pcsFacade;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getSkuCode() {
		return skuCode;
	}

	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}

	public String getSkuName() {
		return skuName;
	}

	public void setSkuName(String skuName) {
		this.skuName = skuName;
	}

	public String getSkuType() {
		return skuType;
	}

	public void setSkuType(String skuType) {
		this.skuType = skuType;
	}

	public String getSkuUnit() {
		return skuUnit;
	}

	public void setSkuUnit(String skuUnit) {
		this.skuUnit = skuUnit;
	}

	public String getPurchaseUnit() {
		return purchaseUnit;
	}

	public void setPurchaseUnit(String purchaseUnit) {
		this.purchaseUnit = purchaseUnit;
	}

	public Integer getPurchaseUnitNumber() {
		return purchaseUnitNumber;
	}

	public void setPurchaseUnitNumber(Integer purchaseUnitNumber) {
		this.purchaseUnitNumber = purchaseUnitNumber;
	}
	

}
