package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PrdcJobLineMapper;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJob;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLine;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLineExample;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobLineService;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobLineVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by Administrator on 2015/12/31.
 */
@Service("prdcProcessService")
public class PrdcJobLineServiceImpl implements PrdcJobLineService {
    @Autowired
    private PrdcJobLineMapper prdcJobLineMapper;


    @Override
    public List<PrdcJobLine> getPrdcJobLineByJobId(Long id) {
        PrdcJobLineExample example= new PrdcJobLineExample();
        example.createCriteria().andJobIdEqualTo(id);
        return prdcJobLineMapper.selectByExample(example);
    }

    @Override
    public int getJobLineRealConsumeAmount(Long id,String skuCode) {
        return prdcJobLineMapper.getJobLineRealConsumeAmount(id,skuCode);
    }
}
