/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.integration.sms.SmsUtil;
import com.thebeastshop.pegasus.integration.sms.SmsVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuBarcodeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuDistributeChannelMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.PcsBrand;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuBarcode;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCategory;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCostPriceChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCustomMade;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuDistributeChannel;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuDistributeChannelExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSupplierChange;
import com.thebeastshop.pegasus.service.purchase.service.PcsBrandService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCategoryService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCustomMadeService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuService;
import com.thebeastshop.pegasus.service.purchase.service.PcsTagService;
import com.thebeastshop.pegasus.service.purchase.service.PcsWatermarkService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;

/**
 * @author Eric.Lou
 * @version $Id: PcsSkuServiceImpl.java, v 0.1 2015-08-03 18:24
 */
@Service("pcsSkuService")
public class PcsSkuServiceImpl implements PcsSkuService, CheckAble, CodeAble {

    private final Logger log = LoggerFactory.getLogger(PcsSkuServiceImpl.class);

    @Autowired
    private PcsWatermarkService pcsWatermarkService;

    @Autowired
    private PcsTagService pcsTagService;

    @Autowired
    private PcsSkuMapper pcsSkuMapper;

    @Autowired
    private PcsSkuCategoryService pcsSkuCategoryService;

    @Autowired
    private PcsSkuSalesPriceChangeService pcsSkuSalesPriceChangeService;

    @Autowired
    private PcsSkuCustomMadeService pcsSkuCustomMadeService;

    @Autowired
    private PcsBrandService pcsBrandService;

    @Autowired
    private PcsSkuDistributeChannelMapper pcsSkuDistributeChannelMapper;
    
    @Autowired
    private PcsSkuBarcodeMapper pcsSkuBarcodeMapper;
    
    @Override
    public PcsSkuVO buildFromModel(PcsSku record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsSkuVO vo = new PcsSkuVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    @Override
    public PcsSku bulidFromVO(PcsSkuVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsSku record = new PcsSku();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    @Transactional
    public Long create(PcsSku record) {
        if (check(record)) {
            if (check(record, true)) {
                initDefaultValue(record);
                pcsSkuMapper.insertSelective(record);
                try {
                    String code = generateSkuCode(record);
                    if (check(code)) {
                        record.setCode(code);
                        pcsSkuMapper.updateByPrimaryKeySelective(record);
                    } else {
                        throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "code字段数据库已有相同的值不能重复");
                    }
                } catch (Exception e) {
                    log.error("", e);
                    throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_GENERATE_CODE, "生成SKUCODE失败");
                }
                final String skuCode = record.getCode();
                //直接提交
                if(record.getSkuStatus() == 1) {
	                pcsSkuSalesPriceChangeService.create(skuCode, record.getSalesPrice());
	                pcsSkuSalesPriceChangeService.createCostPriceChange(skuCode, record.getCostPrice());
	                pcsSkuSalesPriceChangeService.createSupplierChange(skuCode, record.getDefaultSupplierId().intValue());
                   /* myScheduler.execute(new Runnable() {
						@Override
						public void run() {
							sendNotice(skuCode);
						}
					});*/
                }
                //更新更新图片名称
                if (EmptyUtil.isNotEmpty(record.getPictureFileId())) {
                    PegasusUtilFacade.getInstance().modifyFileName(record.getPictureFileId(), record.getCode() + ".jpg");
                }
                getBarcodeList(record);
                createPcsSkuBarcode(record.getBarcodeList());
                return record.getId();
            }
        }
        return null;
    }

    private void getBarcodeList(PcsSku vo) {
		List<PcsSkuBarcode> barcodeList = new ArrayList<>();
		if(EmptyUtil.isNotEmpty(vo.getBarcode())) {
			String[] barcodeArr = vo.getBarcode().split(",");
			for(String barcode : barcodeArr) {
				PcsSkuBarcode pcsSkuBarcode = new PcsSkuBarcode();
				pcsSkuBarcode.setAvailable(true);
				pcsSkuBarcode.setBarcode(barcode);
				pcsSkuBarcode.setSkuCode(vo.getCode());
				barcodeList.add(pcsSkuBarcode);
			}
		}
		vo.setBarcodeList(barcodeList);
	}

    @Override
    @Transactional
    public List<Long> createSkus(List<PcsSku> list) {
        List<Long> ids = new ArrayList<Long>();
        for (PcsSku pcsSku : list) {
            ids.add(create(pcsSku));
        }
        return ids;
    }

    private void initDefaultValue(PcsSku record) {
        record.setCode("");
        //record.setSkuStatus(PcsSku.SKU_STATUS_DRAFT);
        record.setCreateTime(new Date());
        record.setPointDeductRule(0);
        record.setPointDeductPoint(new BigDecimal("0.00"));
        record.setPointDuductPrice(new BigDecimal("0.00"));
        record.setCanRemark(0);
    }

    @Override
    @Transactional
    public boolean update(PcsSku record) {
        if (check(record)) {
            if (check(record, false)) {
                PcsSku oldRecord = findById(record.getId());
                List<PcsSkuSalesPriceChange> salesPriceChangelist = pcsSkuSalesPriceChangeService.findByCode(oldRecord.getCode());
                if (((EmptyUtil.isNotEmpty(record.getSalesPrice()))
                		 || EmptyUtil.isEmpty(salesPriceChangelist))  && record.getOptType() != 1 && record.getSkuStatus() == 1) {
                	record.setOldSalesPrice(record.getSalesPrice());
                    if (canUpdateSalesPrice(record.getCode())) {
                        pcsSkuSalesPriceChangeService.create(record.getCode(), record.getSalesPrice());
                        record.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
                        final String skuCode = record.getCode();
                        /*myScheduler.execute(new Runnable() {
							@Override
							public void run() {
								sendNotice(skuCode);
							}
						});*/
                    }
                } 
                List<PcsSkuCostPriceChange> costPriceChangelist = pcsSkuSalesPriceChangeService.findCostPriceChangeByCode(oldRecord.getCode());
                if ((EmptyUtil.isNotEmpty(record.getCostPrice())
                		|| EmptyUtil.isEmpty(costPriceChangelist)) && record.getOptType() != 1 && record.getSkuStatus() == 1) {
                	record.setOldCostPrice(record.getCostPrice());
                	if (canUpdateSalesPrice(record.getCode())) {
                		pcsSkuSalesPriceChangeService.createCostPriceChange(record.getCode(), record.getCostPrice());
                		record.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
                	}
                } 
                List<PcsSkuSupplierChange> supplierChangelist = pcsSkuSalesPriceChangeService.findSupplierChangeByCode(oldRecord.getCode());
                if (((EmptyUtil.isNotEmpty(record.getDefaultSupplierId()))
                		|| EmptyUtil.isEmpty(supplierChangelist))  && record.getOptType() != 1 && record.getSkuStatus() == 1 ) {
                	record.setOldSupplierId(record.getDefaultSupplierId());
                	if (canUpdateSalesPrice(record.getCode())) {
                		pcsSkuSalesPriceChangeService.createSupplierChange(record.getCode(), record.getDefaultSupplierId().intValue());
                		record.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
                	}
                } 
                
                
                
                if(record.getOptType() != 1 && record.getSkuStatus() == 0) {
                	record.setOldSalesPrice(record.getSalesPrice());
                	record.setOldSupplierId(record.getDefaultSupplierId());
                	record.setOldCostPrice(record.getCostPrice());
                }
               /* if (EmptyUtil.isNotEmpty(record.getCostPrice()) && !record.getCostPrice().equals(oldRecord.getCostPrice())) {
                    if (canUpdateSalesPrice(record.getCode())) {
                        pcsSkuSalesPriceChangeService.create(record.getCode(), record.getSalesPrice());
                        record.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
                    }
                }*/
                setNonField(record);
                //保存不改变sku状态
                if(record.getOptType() != 1  && (oldRecord.getSkuStatus() != null && record.getSkuStatus() == 0)) {
                	record.setSkuStatus(oldRecord.getSkuStatus());
                }
                boolean result = pcsSkuMapper.updateByPrimaryKeySelective(record) != 0;
                createPcsSkuBarcode(record.getBarcodeList());
                if (result) {
                    //更新成功后更新图片名称
                    if (EmptyUtil.isNotEmpty(record.getPictureFileId())) {
                        PegasusUtilFacade.getInstance().modifyFileName(record.getPictureFileId(), oldRecord.getCode() + ".jpg");
                    }
                }
                return result;
            }
        }
        return false;
    }

    /**
     * sku审批通知
     */
    private void  sendNotice(String skuCode) {
    	 final SmsUtil smsUtil = SmsUtil.getInstance();
         final SmsVO smsVO = new SmsVO();
         smsVO.setSendTime(new Date());
         CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance()
 				.findConfigByKey("finance.Approval.Mobile");
 		// 收件人
 		String[] toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
 		smsVO.setMobileList(Arrays.asList(toNotifyUsers));
	
 		smsVO.setContent("您好，您有新的SKU需要审批，SKU code："+ skuCode +"，请尽快审批，谢谢！");
 		smsUtil.send(smsVO);
 		
 		// 邮件VO
 		commGlobalConfig = PegasusUtilFacade.getInstance()
 				.findConfigByKey("finance.Approval.Email");
 		toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
		EmailVO emailVO = new EmailVO();
		emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
		emailVO.setSubject("SKU审批");
		emailVO.setContent("您好，您有新的SKU需要审批，SKU code："+ skuCode +"，请尽快审批，谢谢！");
		// 发邮件
		if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
			// 正式环境发邮件
			EmailUtil.getInstance().send(emailVO);
		}
    }
    private void setNonField(PcsSku record) {
        record.setSalesPrice(null);
        record.setCode(null);
        record.setSkuType(null);
        record.setIsImported(null);
        record.setIsMadeBySelf(null);
    }

    /**
     * 是否可以更新售价
     *
     * @param code
     * @return
     */
    @Override
    public Boolean canUpdateSalesPrice(String code) {
        List<PcsSkuSalesPriceChange> processingPriceList = pcsSkuSalesPriceChangeService.findByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (processingPriceList.size() > 0) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * 售价变更审批
     *
     * @param code
     * @param isPass
     * @return
     */
    @Override
    @Transactional
    public Boolean auditSkuSalesPriceChange(String code, Boolean isPass) {
        PcsSkuVO pcsSkuVO = findByCode(code);
        if (EmptyUtil.isEmpty(pcsSkuVO)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "sku实体为空");
        }
        if (!pcsSkuVO.getSkuStatus().equals(PcsSku.SKU_STATUS_WAITING_VERIFY)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "必须是待审核状态");
        }
        PcsSkuSalesPriceChange pcsSkuSalesPriceChange = pcsSkuSalesPriceChangeService.auditSkuSalesPriceChange(code, isPass);
        PcsSkuCostPriceChange pcsSkuCostPriceChange = pcsSkuSalesPriceChangeService.auditSkuCostPriceChange(code, isPass);
        PcsSkuSupplierChange pcsSkuSupplierChange = pcsSkuSalesPriceChangeService.auditSkuSupplierChange(code, isPass);
        PcsSku pcsSku = new PcsSku();
        pcsSku.setId(pcsSkuVO.getId());
        if(EmptyUtil.isNotEmpty(pcsSkuSalesPriceChange)) {
	        if (pcsSkuSalesPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_SUCCESS)) {
	            pcsSku.setSkuStatus(PcsSku.SKU_STATUS_ABLE);
	            pcsSku.setSalesPrice(pcsSkuSalesPriceChange.getNewPrice());
	        } else if (pcsSkuSalesPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_REJECT)) {
	            pcsSku.setSkuStatus(PcsSku.SKU_STATUS_REJECT);
	        }
        }
        if(EmptyUtil.isNotEmpty(pcsSkuCostPriceChange)) {
        	if (pcsSkuCostPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_SUCCESS)) {
        		pcsSku.setSkuStatus(PcsSku.SKU_STATUS_ABLE);
        		pcsSku.setCostPrice(pcsSkuCostPriceChange.getNewPrice());
        	} else if (pcsSkuCostPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_REJECT)) {
        		pcsSku.setSkuStatus(PcsSku.SKU_STATUS_REJECT);
        	}
        }
        if(EmptyUtil.isNotEmpty(pcsSkuSupplierChange)) {
        	if (pcsSkuSupplierChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_SUCCESS)) {
        		pcsSku.setSkuStatus(PcsSku.SKU_STATUS_ABLE);
        		pcsSku.setDefaultSupplierId(pcsSkuSupplierChange.getNewSupplierId().longValue());;
        	} else if (pcsSkuSupplierChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_REJECT)) {
        		pcsSku.setSkuStatus(PcsSku.SKU_STATUS_REJECT);
        	}
        }
        pcsSkuMapper.updateByPrimaryKeySelective(pcsSku);
        return true;
    }

    @Override
    public PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        return pcsSkuSalesPriceChangeService.buildFromModel(pcsSkuSalesPriceChangeService.findSkuSalesPriceChangeByCodeAndProcessing(code));
    }

    @Override
    public List<PcsSku> findSkuByCodes(List<String> codes) {
        List<PcsSku> recordList = new ArrayList<PcsSku>();
        for (String code : codes) {
            PcsSku record = findSkuByCode(code);
            if (EmptyUtil.isNotEmpty(record) && EmptyUtil.isNotEmpty(record.getId())) {
                recordList.add(record);
            }
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    @Transactional
    public Boolean convertSku(PcsSku sku, long skuCustomMadeId) {
        PcsSkuCustomMade pcsSkuCustomMade = pcsSkuCustomMadeService.findById(skuCustomMadeId);
        sku.setIsJit(0);
        if (EmptyUtil.isNotEmpty(pcsSkuCustomMade) && pcsSkuCustomMade.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_WAITING_CONVERT)) {
            if (create(sku) > 0L) {
                pcsSkuCustomMade.setSkuStatus(PcsSkuCustomMade.SKU_STATUS_CONVERT);
                if (pcsSkuCustomMadeService.update(pcsSkuCustomMade)) {
                    return true;
                } else {
                    throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "sku定制单更新失败");
                }
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "sku创建失败");
            }
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "状态必须是待转换");
        }
    }

    private PcsSku findSkuByCode(String code) {
        PcsSkuExample example = new PcsSkuExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsSku> recordList = pcsSkuMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return null;
        } else {
            if (recordList.size() > 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_DUPLICATE, " 根据code[" + code + "]能查出2条以上(含两条)记录");
            } else {
                return recordList.get(0);
            }
        }
    }

    @Override
    public PcsSku findById(long id) {
        if (EmptyUtil.isEmpty(id)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return pcsSkuMapper.selectByPrimaryKey(id);
    }

    @Override
    public PcsSkuVO findByCode(String code) {
        return findByCode(code, false, true);
    }

    @Override
    public PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories) {
        if (EmptyUtil.isEmpty(code)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        List<PcsSkuVO> voList = pcsSkuMapper.findSkuByCodes(Arrays.asList(new String[]{code}));
        if (CollectionUtils.isEmpty(voList)) {
            return null;
        } else {
            if (voList.size() > 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_DUPLICATE, " 根据code能查出2条以上(含两条)记录");
            } else {
                PcsSkuVO sku = voList.get(0);
                // 水印标签不再与sku关联
                // 查询水印
//                Map<String, Object> wmParams = new HashMap<>();
//                wmParams.put("skuCode", sku.getCode());
//                List<PcsWatermarkVO> watermarkList = pcsWatermarkService.queryWatermarkList(wmParams);
//                sku.setWatermarkList(watermarkList);
//                // 查询标签
//                Map<String, Object> tagParams = new HashMap<>();
//                tagParams.put("skuCode", sku.getCode());
//                List<PcsTagVO> tagList = pcsTagService.queryTagList(tagParams);
//                sku.setTagList(tagList);

                if (widthFrontCategories) {
                    // 查询前台类目
                    List<PcsSkuCategory> categoryList = pcsSkuCategoryService.findFrontCategoriesBySkuCode(sku.getCode());
                    sku.setFrontCategoryList(categoryList);
                }

                if (withBackCategories) {
                    // 查询后台类目
                    List<PcsSkuCategory> categoryList = pcsSkuCategoryService.findBackCategoriesBySkuCode(sku.getCode());
                    sku.setBackCategoryList(categoryList);

                    List<PcsSkuCategory> secondaryCategoryList = new ArrayList<>();
                    for (PcsSkuCategory category : sku.getBackCategoryList()) {
                        if (category.getId() != null && !category.getId().equals(sku.getCategoryId())) {
                            secondaryCategoryList.add(category);
                        }
                    }
                    sku.setSecondaryCategoryList(secondaryCategoryList);
                }

                sku.setBarcodeList(pcsSkuBarcodeMapper.selectBySkuCode(sku.getCode()));
                return sku;
            }
        }

    }

    @Override
    public List<PcsSkuVO> findByNameOrCode(String arg0) {
        if (EmptyUtil.isEmpty(arg0)) {
            return Collections.emptyList();
        }
        List<PcsSkuVO> voList = pcsSkuMapper.findSkuByNameOrCode(arg0);
        if (CollectionUtils.isEmpty(voList)) {
            return Collections.emptyList();
        } else {
            return voList;
        }
    }

    @Override
    public List<PcsSkuVO> findByCond(PcsSkuCond cond) {
        return pcsSkuMapper.findSkuByCond(cond);
    }


    @Override
    public List<PcsSkuVO> findByCondForExport(PcsSkuCond cond) {
        return pcsSkuMapper.findSkuByCondForExport(cond);
    }
    @Override
    public List<Map<String,Object>> findSkuCanSaleAndCanSeeByChannelCode(String channelCode){
    	return pcsSkuMapper.findSkuCanSaleAndCanSeeByChannelCode(channelCode);
    }
    
    public Map<String,Object> findSkuCanSaleAndCanSeeInfo(String channelCode,String skuCode){
    	return pcsSkuMapper.findSkuCanSaleAndCanSeeInfo(channelCode, skuCode);
    }

    @Override
    public List<PcsSkuVO> findSkuTagByCond(PcsSkuCond cond) {
        return pcsSkuMapper.findSkuTagByCond(cond);
    }
    @Override
    public Boolean check(Object obj) {
        PcsSku record = (PcsSku) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(PcsSku record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate) {
            PcsSku oldRecord = pcsSkuMapper.selectByPrimaryKey(record.getId());
            if (NullUtil.isNotNull(oldRecord) && EmptyUtil.isNotEmpty(oldRecord.getPictureFileId()) && EmptyUtil.isNotEmpty(record.getPictureFileId()) && !oldRecord.getPictureFileId().equals(record.getPictureFileId())) {
                PegasusUtilFacade.getInstance().deleteFileById(oldRecord.getPictureFileId());
            }
        }
        return true;
    }

    private Boolean check(String code) {
        PcsSkuExample example = new PcsSkuExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsSku> recordList = pcsSkuMapper.selectByExample(example);
        if (recordList.size() == 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public String generateCode(Object id) {
        return null;
    }

    private String generateSkuCode(PcsSku record) {
        String categoryCode = "";
        String createYear = "";
        Integer num = 0;
        String key = "";
        // 分类code
        PcsSkuCategory skuCategory = pcsSkuCategoryService.findBackCategoryById(record.getCategoryId());
        if(NullUtil.isNotNull(skuCategory)){
            categoryCode = skuCategory.getCode();
        }else{
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, " sku 品类无相关数据");
        }
        // 年份
        createYear = DateUtil.format(DateUtil.getNow(),"yyyy");
        createYear = createYear.substring(2);
        // 顺序号
        PcsSkuExample example = new PcsSkuExample();
        PcsSkuExample.Criteria criteria = example.createCriteria();
        criteria.andCodeLike(categoryCode+createYear+"%");
        example.setOrderByClause("id desc limit 1");
        List<PcsSku> skus = pcsSkuMapper.selectByExample(example);
        if(CollectionUtils.isEmpty(skus)){
            num = 1;
        }else{
            String tmp = skus.get(0).getCode();
            String prefix = categoryCode + createYear;
            int i = tmp.toUpperCase().indexOf(prefix.toUpperCase());
            tmp = tmp.substring(i+prefix.length());
            tmp = StringUtils.left(tmp,3);
            Integer _num = Integer.parseInt(tmp);
            _num++;
            num = _num;
        }
        // 识别码
        PcsBrand brand = pcsBrandService.findById(record.getBrandId());
        if(NullUtil.isNotNull(brand) && !NumberUtil.isNullOrZero(brand.getIsOwn())){
            // 自有品牌
            if(record.getSkuType().equals(PcsSku.SKU_TYPE_FINISHED_PRODUCT)){
                // 成品
                if(NumberUtil.isNullOrZero(record.getIsImported())){
                    // 非进口
                    if(!NumberUtil.isNullOrZero(record.getIsMadeBySelf())){
                        // 自产
                        key = "1";
                    }else{
                        // 非自产
                        key = "2";
                    }
                }else{
                    // 进口
                    if(!NumberUtil.isNullOrZero(record.getIsMadeBySelf())){
                        // 自产
                        key = "3";
                    }else{
                        // 非自产
                        key = "4";
                    }
                }
            }else{
                // 非成品
                key = "0";
            }
        }else{
            // 其他品牌
            if(record.getSkuType().equals(PcsSku.SKU_TYPE_FINISHED_PRODUCT)){
                // 成品
                if(!NumberUtil.isNullOrZero(record.getIsImported())){
                    // 进口
                    if(!NumberUtil.isNullOrZero(record.getIsMadeBySelf())){
                        // 自产
                        key = "5";
                    }else{
                        // 非自产
                        key = "6";
                    }
                }else{
                    // 非进口
                    if(!NumberUtil.isNullOrZero(record.getIsMadeBySelf())){
                        // 自产
                        key = "7";
                    }else{
                        // 非自产
                        key = "8";
                    }
                }
            }else{
                // 非成品
                key = "9";
            }
        }
        // 参数不能为空
        if(EmptyUtil.isEmpty(categoryCode)||EmptyUtil.isEmpty(createYear)|| NumberUtil.isNullOrZero(num)||EmptyUtil.isEmpty(key)){
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, " 生成skucode的参数不能为空");
        }
        // 填充map
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("categoryCode", categoryCode);
        params.put("createYear", createYear);
        params.put("num", num);
        params.put("key", key);
        String code = CodeGenerator.getInstance().generate("PCS_SKU", params);
        return code;
    }

    @Override
    public List<PcsSkuVO> findByCodes(List<String> codes) {
        return findByCodes(codes, false);
    }

    @Override
    public List<PcsSkuVO> findByCodes(List<String> codes, boolean withCategories) {
        List<PcsSkuVO> list = EmptyUtil.isEmpty(codes) ? new ArrayList<PcsSkuVO>() : pcsSkuMapper.findSkuByCodes(codes);
        for (int i = 0; i < list.size(); i++) {
            PcsSkuVO skuVO = list.get(i);
            // 标签水印已直接关联到product上，此处不再建立sku与 标签/水印的关联关系
            // 查询水印
            /*Map<String, Object> wmParams = new HashMap<>();
            wmParams.put("skuCode", skuVO.getCode());
            List<PcsWatermarkVO> watermarkList = pcsWatermarkService.queryWatermarkList(wmParams);
            skuVO.setWatermarkList(watermarkList);
            // 查询标签
            Map<String, Object> tagParams = new HashMap<>();
            tagParams.put("skuCode", skuVO.getCode());
            List<PcsTagVO> tagList = pcsTagService.queryTagList(tagParams);
            skuVO.setTagList(tagList);*/

            if (withCategories) {
                List<PcsSkuCategory> categoryList = pcsSkuCategoryService.findFrontCategoriesBySkuCode(skuVO.getCode());
                skuVO.setFrontCategoryList(categoryList);
            }
        }
        return list;
    }

    /**
     * 所有SKU信息
     *
     * @return
     */
    @Override
    public List<PcsSkuInfoVO> allSkuInfo() {
        return pcsSkuMapper.allSkuInfo();
    }

    @Override
    public PcsSkuInfoVO findStockByCode(String skuCode) {
        return pcsSkuMapper.findStockByCode(skuCode);
    }

    @Override
    public List<PcsSkuVO> findChannelSkuForNoDistribute(PcsSkuCond cond) {
        return pcsSkuMapper.findChannelSkuForNoDistribute(cond);
    }

    @Override
    @Transactional
    public void setSkuChannel(List<String> skuCodeList, List<String> channelCodeList,Long operatorId) {
        PcsSkuDistributeChannelExample example = new PcsSkuDistributeChannelExample();
        PcsSkuDistributeChannelExample.Criteria criteria = example.createCriteria();
        if(skuCodeList != null && skuCodeList.size() > 0){
            for(String skuCode:skuCodeList){
                //原先的取消
                criteria.andSkuCodeEqualTo(skuCode);
                List<PcsSkuDistributeChannel> list = pcsSkuDistributeChannelMapper.selectByExample(example);
                if(list != null && list.size() > 0){
                    for(PcsSkuDistributeChannel pcsSkuDistributeChannel:list){
                        pcsSkuDistributeChannel.setCancelFlag(1);
                        pcsSkuDistributeChannelMapper.updateByPrimaryKey(pcsSkuDistributeChannel);
                    }
                }
                if(channelCodeList != null && channelCodeList.size() > 0){
                    for(String channelCode:channelCodeList){
                        PcsSkuDistributeChannel pcsSkuDistributeChannel = new PcsSkuDistributeChannel();
                        pcsSkuDistributeChannel.setCancelFlag(0);
                        pcsSkuDistributeChannel.setChannelCode(channelCode);
                        pcsSkuDistributeChannel.setCreateTime(Calendar.getInstance().getTime());
                        pcsSkuDistributeChannel.setCreateUserId(operatorId);
                        pcsSkuDistributeChannel.setSkuCode(skuCode);
                        pcsSkuDistributeChannelMapper.insert(pcsSkuDistributeChannel);
                    }
                }
            }
        }
    }

	@Override
	public List<PcsSkuVO> findSkuByIds(List<Long> ids) {
		return pcsSkuMapper.findSkuByIds(ids);
	}
	
	@Override
	public List<PcsSkuVO> findSkuAuditByIds(List<Long> ids) {
		return pcsSkuMapper.findSkuAuditByIds(ids);
	}

	@Override
	public Boolean canUpdateCostPrice(String code) {
		List<PcsSkuCostPriceChange> processingPriceList = pcsSkuSalesPriceChangeService.findCostPriceChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (processingPriceList.size() > 0) {
            return false;
        } else {
            return true;
        }
	}

	@Override
	public Boolean canUpdateSupplier(String code) {
		List<PcsSkuSupplierChange> processingPriceList = pcsSkuSalesPriceChangeService.findSupplierChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (processingPriceList.size() > 0) {
            return false;
        } else {
            return true;
        }
	}

	@Override
	public List<Long> updateSkus(List<PcsSkuVO> list) {
		
		return null;
	}
	
	public boolean update(PcsSkuVO vo) {
    	//上传图片
    	if(vo.getOptType() == 1) {
    		Boolean result = this.update(bulidFromVO(vo));
    		return result;
    	} else {
    		PcsSkuVO oldSkuVO = this.findByCode(vo.getCode());
            //vo.setSkuStatus(PcsSku.SKU_STATUS_DRAFT);
            //是否有需要审核修改
            boolean waitingVerify = false;
            //价格变了
            if(!oldSkuVO.getSalesPrice().equals(vo.getSalesPrice())) {
            	vo.setOldSalesPrice(oldSkuVO.getSalesPrice());
            	//waitingVerify = true;
            }
            //成本价格变了
            if(!oldSkuVO.getCostPrice().equals(vo.getCostPrice())) {
            	vo.setOldCostPrice(oldSkuVO.getCostPrice());
            	waitingVerify = true;
            }
            
            //供应商变了
            if(!oldSkuVO.getDefaultSupplierId().equals(vo.getDefaultSupplierId())) {
            	vo.setOldSupplierId(oldSkuVO.getDefaultSupplierId());
            	waitingVerify = true;
            }
            
            if(vo.getSkuStatus() != null && vo.getSkuStatus() == 1) {
            	if(!oldSkuVO.getSalesPrice().equals(oldSkuVO.getOldSalesPrice())) {
            		waitingVerify = true;
            	}
            	if(!oldSkuVO.getDefaultSupplierId().equals(oldSkuVO.getOldSupplierId())) {
            		waitingVerify = true;
            	}
            	if(!oldSkuVO.getCostPrice().equals(oldSkuVO.getOldCostPrice())) {
            		waitingVerify = true;
            	}
            }
            //提交且有需要审核的修改信息，才走审核流程
           /* if(vo.getSkuStatus() != null && vo.getSkuStatus() == 1 && waitingVerify) {
        		vo.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
        	} else {
        		vo.setSkuStatus(PcsSku.SKU_STATUS_DRAFT);
        	}*/
            Boolean result = this.update(bulidFromVO(vo));

            List<Long> categoryIds = vo.getSecondaryCategoryIds();
            if (categoryIds == null) {
                categoryIds = new ArrayList<>();
            }
            categoryIds.add(vo.getCategoryId());
           /* pcsSkuCategoryService.saveOfUpdateBackCategories(vo.getCode(), categoryIds);


            if (StringUtils.isBlank(vo.getCode())) {
                return result;
            }
            try{
                PcsSkuVO newSkuVO = facadePcs.findSkuByCode(vo.getCode());

                //给售价审核人员发邮件
                sendEmailForAuditSkuPrice(newSkuVO);
                //实体变更记录
                if(result){
                    StringBuilder oldInfo = new StringBuilder("");
                    StringBuilder newInfo = new StringBuilder("");

                    oldInfo.append("skuName:");
                    oldInfo.append(StringUtil.get(oldSkuVO.getName()));
                    oldInfo.append(",skuNameCn:");
                    oldInfo.append(StringUtil.get(oldSkuVO.getNameCn()));
                    oldInfo.append(",供应商:");
                    oldInfo.append("["+oldSkuVO.getDefaultSupplierId()+"]"+StringUtil.get(oldSkuVO.getSupplierNameCn()));
                    oldInfo.append(",品牌:");
                    oldInfo.append("["+oldSkuVO.getBrandId()+"]"+StringUtil.get(oldSkuVO.getBrandNameCn()));
                    oldInfo.append(",品类:");
                    oldInfo.append("["+oldSkuVO.getCategoryId()+"]"+StringUtil.get(oldSkuVO.getSkucategoryFullName()));
                    List<PcsSkuCategory> oldSecondaryCategoryList = oldSkuVO.getSecondaryCategoryList();
                    oldInfo.append(",次级品类:");
                    if (CollectionUtils.isNotEmpty(oldSecondaryCategoryList)) {
//                        oldInfo.append("["+StringUtils.join(oldSkuVO.getSecondaryCategoryIds(), ", ") +"]");
                        oldInfo.append("[");
                        for (int i = 0; i < oldSecondaryCategoryList.size(); i++) {
                            PcsSkuCategory category = oldSecondaryCategoryList.get(i);
                            oldInfo.append(category.getId());
                            oldInfo.append(": ");
                            oldInfo.append(category.getFullName());
                            if (i < oldSecondaryCategoryList.size() - 1) {
                                oldInfo.append(", ");
                            }
                        }
                        oldInfo.append("]");
                    }
                    else {
                        oldInfo.append("[]");
                    }

                    oldInfo.append(",成本:");
                    oldInfo.append(StringUtil.get(oldSkuVO.getCostPrice().toString()));
                    oldInfo.append(",最小订货量:");
                    oldInfo.append(oldSkuVO.getMoq()==null?0:oldSkuVO.getMoq());

                    newInfo.append("skuName:");
                    newInfo.append(StringUtil.get(newSkuVO.getName()));
                    newInfo.append(",skuNameCn:");
                    newInfo.append(StringUtil.get(newSkuVO.getNameCn()));
                    newInfo.append(",供应商:");
                    newInfo.append("["+newSkuVO.getDefaultSupplierId()+"]"+StringUtil.get(newSkuVO.getSupplierNameCn()));
                    newInfo.append(",品牌:");
                    newInfo.append("["+newSkuVO.getBrandId()+"]"+StringUtil.get(newSkuVO.getBrandNameCn()));
                    newInfo.append(",品类:");
                    newInfo.append("["+newSkuVO.getCategoryId()+"]"+StringUtil.get(newSkuVO.getSkucategoryFullName()));
                    List<PcsSkuCategory> secondaryCategoryList = newSkuVO.getSecondaryCategoryList();
                    newInfo.append(",次级品类:");
                    if (CollectionUtils.isNotEmpty(secondaryCategoryList)) {
                        newInfo.append("[");
                        for (int i = 0; i < secondaryCategoryList.size(); i++) {
                            PcsSkuCategory category = secondaryCategoryList.get(i);
                            newInfo.append(category.getId());
                            newInfo.append(": ");
                            newInfo.append(category.getFullName());
                            if (i < secondaryCategoryList.size() - 1) {
                                newInfo.append(", ");
                            }
                        }
                        newInfo.append("]");
                    }
                    else {
                        newInfo.append("[]");
                    }
                    newInfo.append(",成本:");
                    newInfo.append(StringUtil.get(newSkuVO.getCostPrice().toString()));
                    newInfo.append(",最小订货量:");
                    newInfo.append(newSkuVO.getMoq()==null?0:newSkuVO.getMoq());

                    ScmEntityOpUtil.getInstance().entityUpdateLog("更新SKU,"
                            + oldInfo.toString()
                            + "-->>"
                            + newInfo.toString()
                            , "PcsSku",newSkuVO.getId().toString());
                }
            }catch (Exception e){
                log.warn("",e);
            }
*/
            return result;
    	}
    }

	@Override
	public long countSkuByCond(PcsSkuCond cond) {
		return pcsSkuMapper.countSkuByCond(cond);
	}

	@Override
	public void createPcsSkuBarcode(List<PcsSkuBarcode> barcodeList) {
		if(EmptyUtil.isNotEmpty(barcodeList)) {
			String skuCode = barcodeList.get(0).getSkuCode();
			pcsSkuBarcodeMapper.deleteBySkuCode(skuCode);
			for(PcsSkuBarcode pcsSkuBarcode : barcodeList) {
				pcsSkuBarcodeMapper.insert(pcsSkuBarcode);
			}
		}
	}

	@Override
	public List<PcsSkuBarcodeVO> selectByBarCode(String barCode) {
		return pcsSkuBarcodeMapper.selectByBarCode(barCode);
	}  
}
