/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCostPriceChangeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuSalesPriceChangeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuSupplierChangeMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCostPriceChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCostPriceChangeExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSalesPriceChangeExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSupplierChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSupplierChangeExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsSkuSalesPriceChangeServiceImpl.java, v 0.1 2015-08-05 14:47
 */
@Service("pcsSkuSalesPriceChangeService")
public class PcsSkuSalesPriceChangeServiceImpl implements PcsSkuSalesPriceChangeService, CheckAble {

    private final Logger log = LoggerFactory.getLogger(PcsSkuSalesPriceChangeServiceImpl.class);

    @Autowired
    private PcsSkuSalesPriceChangeMapper pcsSkuSalesPriceChangeMapper;
    @Autowired
    private PcsSkuCostPriceChangeMapper pcsSkuCostPriceChangeMapper;
    @Autowired
    private PcsSkuSupplierChangeMapper pcsSkuSupplierChangeMapper;

    @Override
    public PcsSkuSalesPriceChangeVO buildFromModel(PcsSkuSalesPriceChange record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsSkuSalesPriceChangeVO vo = new PcsSkuSalesPriceChangeVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    @Override
    public PcsSkuSalesPriceChange bulidFromVO(PcsSkuSalesPriceChangeVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsSkuSalesPriceChange record = new PcsSkuSalesPriceChange();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    @Transactional
    public Long create(String code, BigDecimal price) {
        PcsSkuSalesPriceChange record = new PcsSkuSalesPriceChange();
        record.setSkuCode(code);
        record.setNewPrice(price);
        if (check(record)) {
            if (check(record, true)) {
                record.setChangeTime(new Date());
                record.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
                pcsSkuSalesPriceChangeMapper.insertSelective(record);
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsSkuSalesPriceChange record) {
        if (check(record)) {
            if (check(record, false)) {
                return pcsSkuSalesPriceChangeMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }

    @Override
    public PcsSkuSalesPriceChange findById(long id) {
        return pcsSkuSalesPriceChangeMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsSkuSalesPriceChange> findByCodeAndStatus(String code, Integer status) {
        if (EmptyUtil.isEmpty(code) || EmptyUtil.isEmpty(status)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        PcsSkuSalesPriceChangeExample example = new PcsSkuSalesPriceChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code).andChangeStatusEqualTo(status);
        List<PcsSkuSalesPriceChange> recordList = pcsSkuSalesPriceChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    public PcsSkuSalesPriceChange auditSkuSalesPriceChange(String code, Boolean isPass) {
        PcsSkuSalesPriceChange record = findSkuSalesPriceChangeByCodeAndProcessing(code);
        if(EmptyUtil.isNotEmpty(record)) {
        	record.setChangeStatus(isPass ? PcsSkuSalesPriceChange.STATUS_SUCCESS : PcsSkuSalesPriceChange.STATUS_REJECT);
            if (update(record)) {
                return record;
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "数据库更新失败");
            }
        }  else {
        	return null;
        }
        
    }

    @Override
    public PcsSkuSalesPriceChange findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        List<PcsSkuSalesPriceChange> list = findByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (list.size() == 1) {
            return list.get(0);
        } else if (list.size() > 1) {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_DUPLICATE, "当前SKUCODE有两条以上(含两条)处理中的售价变更,每次只能有一个处理中的售价变更");
        } else if (list.size() == 0) {
            return null;
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
    }

    @Override
    public Boolean check(Object obj) {
        PcsSkuSalesPriceChange record = (PcsSkuSalesPriceChange) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(PcsSkuSalesPriceChange record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        List<PcsSkuSalesPriceChange> oldList = findByCodeAndStatus(record.getSkuCode(), PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (oldList.size() > 0 && isCreate) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "前一个SKU售价审批还未通过或驳回");
        }
        if (oldList.size() > 0 && !isCreate && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "前一个SKU售价审批还未通过或驳回");
        }
        return true;
    }

	@Override
	public Long createSupplierChange(String code, Integer supplierId) {
		PcsSkuSupplierChange record = new PcsSkuSupplierChange();
        record.setSkuCode(code);
        record.setNewSupplierId(supplierId);;
        if (checkSupplierChange(record, true)) {
            record.setChangeTime(new Date());
            record.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
            pcsSkuSupplierChangeMapper.insertSelective(record);
        }
        return null;
	}

	 private Boolean checkCostPriceChange(PcsSkuCostPriceChange record, Boolean isCreate) {
	        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
	            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
	        }
	        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
	            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
	        }
	        List<PcsSkuCostPriceChange> oldList = findCostPriceChangeByCodeAndStatus(record.getSkuCode(), PcsSkuSalesPriceChange.STATUS_PROCESSING);
	        if (oldList.size() > 0 && isCreate) {
	            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "前一个SKU成本审批还未通过或驳回");
	        }
	        if (oldList.size() > 0 && !isCreate && !oldList.get(0).getId().equals(record.getId())) {
	            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "前一个SKU成本审批还未通过或驳回");
	        }
	        return true;
	    }

	 private Boolean checkSupplierChange(PcsSkuSupplierChange record, Boolean isCreate) {
	        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
	            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
	        }
	        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
	            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
	        }
	        List<PcsSkuSupplierChange> oldList = findSupplierChangeByCodeAndStatus(record.getSkuCode(), PcsSkuSalesPriceChange.STATUS_PROCESSING);
	        if (oldList.size() > 0 && isCreate) {
	            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "前一个SKU供应商审批还未通过或驳回");
	        }
	        if (oldList.size() > 0 && !isCreate && !oldList.get(0).getId().equals(record.getId())) {
	            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "前一个SKU供应商审批还未通过或驳回");
	        }
	        return true;
	    }
	@Override
	public Long createCostPriceChange(String code, BigDecimal price) {
		PcsSkuCostPriceChange record = new PcsSkuCostPriceChange();
        record.setSkuCode(code);
        record.setNewPrice(price);
        if (checkCostPriceChange(record, true)) {
            record.setChangeTime(new Date());
            record.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
            pcsSkuCostPriceChangeMapper.insertSelective(record);
        }
        return null;
	}

	@Override
	public PcsSkuCostPriceChange auditSkuCostPriceChange(String code, Boolean isPass) {
		PcsSkuCostPriceChange record = null;
		List<PcsSkuCostPriceChange> list = findCostPriceChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
		if(list == null) {
			return null;
		} else if (list.size() == 1) {
        	record = list.get(0);
        } else if (list.size() > 1) {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_DUPLICATE, "当前SKUCODE有两条以上(含两条)处理中的售价变更,每次只能有一个处理中的售价变更");
        } else if (list.size() == 0) {
            return null;
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        record.setChangeStatus(isPass ? PcsSkuSalesPriceChange.STATUS_SUCCESS : PcsSkuSalesPriceChange.STATUS_REJECT);
        if (checkCostPriceChange(record, false)) { 
        	if(pcsSkuCostPriceChangeMapper.updateByPrimaryKeySelective(record) != 0) {
        		  return record;
        	}
        	return record;
        	
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "数据库更新失败");
        }
	}

	@Override
	public PcsSkuSupplierChange auditSkuSupplierChange(String code, Boolean isPass) {
		PcsSkuSupplierChange record = null;
		List<PcsSkuSupplierChange> list = findSupplierChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (list.size() == 1) {
        	record = list.get(0);
        } else if (list.size() > 1) {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_DUPLICATE, "当前SKUCODE有两条以上(含两条)处理中的售价变更,每次只能有一个处理中的售价变更");
        } else if (list.size() == 0) {
            return null;
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        record.setChangeStatus(isPass ? PcsSkuSalesPriceChange.STATUS_SUCCESS : PcsSkuSalesPriceChange.STATUS_REJECT);
        if (checkSupplierChange(record, false)) { 
        	if(pcsSkuSupplierChangeMapper.updateByPrimaryKeySelective(record) != 0) {
        		  return record;
        	}
        	return record;
        	
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "数据库更新失败");
        }
	}

	@Override
	public List<PcsSkuCostPriceChange> findCostPriceChangeByCodeAndStatus(String code, Integer status) {
		if (EmptyUtil.isEmpty(code) || EmptyUtil.isEmpty(status)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
		PcsSkuCostPriceChangeExample example = new PcsSkuCostPriceChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code).andChangeStatusEqualTo(status);
        List<PcsSkuCostPriceChange> recordList = pcsSkuCostPriceChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
	}

	@Override
	public List<PcsSkuSupplierChange> findSupplierChangeByCodeAndStatus(String code, Integer status) {
		if (EmptyUtil.isEmpty(code) || EmptyUtil.isEmpty(status)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
		PcsSkuSupplierChangeExample example = new PcsSkuSupplierChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code).andChangeStatusEqualTo(status);
        List<PcsSkuSupplierChange> recordList = pcsSkuSupplierChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
	}

	@Override
	public List<PcsSkuSalesPriceChange> findByCode(String code) {
		  if (EmptyUtil.isEmpty(code)) {
	            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
	        }
	        PcsSkuSalesPriceChangeExample example = new PcsSkuSalesPriceChangeExample();
	        example.createCriteria().andSkuCodeEqualTo(code);
	        List<PcsSkuSalesPriceChange> recordList = pcsSkuSalesPriceChangeMapper.selectByExample(example);
	        if (CollectionUtils.isEmpty(recordList)) {
	            return Collections.emptyList();
	        } else {
	            return recordList;
	        }
	}

	@Override
	public List<PcsSkuCostPriceChange> findCostPriceChangeByCode(String code) {
		if (EmptyUtil.isEmpty(code)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
		PcsSkuCostPriceChangeExample example = new PcsSkuCostPriceChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code);
        List<PcsSkuCostPriceChange> recordList = pcsSkuCostPriceChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
	}

	@Override
	public List<PcsSkuSupplierChange> findSupplierChangeByCode(String code) {
		if (EmptyUtil.isEmpty(code)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
		PcsSkuSupplierChangeExample example = new PcsSkuSupplierChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code);
        List<PcsSkuSupplierChange> recordList = pcsSkuSupplierChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
	}

}
