package com.thebeastshop.pegasus.service.purchase.service.impl;

import java.util.List;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuReceiveStandardCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuReceiveStandardMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuReceiveStandardRuleMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuReceiveStandardRule;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuReceiveStandardService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuReceiveStandardRuleVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuReceiveStandardVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

@Service("pcsSkuReceiveStandardService")
public class PcsSkuReceiveStandardServiceImpl implements PcsSkuReceiveStandardService{

	@Autowired
	private PcsSkuReceiveStandardMapper pcsSkuReceiveStandardMapper;
	
	@Autowired
	private PcsSkuReceiveStandardRuleMapper pcsSkuReceiveStandardRuleMapper;
	
	@Override
	public List<PcsSkuReceiveStandardVO> listSkuByCond(PcsSkuReceiveStandardCond cond) {
		return pcsSkuReceiveStandardMapper.listSkuByCond(cond);
	}

	@Override
	@Transactional
	public boolean createOrEditSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
		if(EmptyUtil.isEmpty(vo.getId())){
			return createSkuReceiveStandard(vo);
		}else{
			return editSkuReceiveStandard(vo);
		}
	}

	@Override
	public PcsSkuReceiveStandardVO findPcsSkuReceiveStandardBySkuCode(
			String skuCode) {
		return pcsSkuReceiveStandardMapper.findPcsSkuReceiveStandardBySkuCode(skuCode);
	}

	@Override
	@Transactional
	public boolean editSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
		updateSkuReciveStandardRule(vo);
		return pcsSkuReceiveStandardMapper.updateByPrimaryKeySelective(vo)==1?true:false;
	}

	@Override
	@Transactional
	public boolean createSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
		updateSkuReciveStandardRule(vo);
		return pcsSkuReceiveStandardMapper.insert(vo)==1?true:false;
	}
	
	private void updateSkuReciveStandardRule(PcsSkuReceiveStandardVO vo){
		pcsSkuReceiveStandardMapper.deleteSkuReceiveStandardRuleBySkuCode(vo.getSkuCode());
		if(EmptyUtil.isNotEmpty(vo.getSkuRuleList())){
			for(PcsSkuReceiveStandardRuleVO skuRule : vo.getSkuRuleList()){
				pcsSkuReceiveStandardMapper.insertSkuReceiveStandardRule(skuRule);
			}
		}
	}
	
	public List<PcsSkuReceiveStandardRuleVO> findAllReceiveStandardRule(){
		return pcsSkuReceiveStandardRuleMapper.findAllReceiveStandardRule();
	}
	
	public List<PcsSkuReceiveStandardRuleVO> findSkuReceiveStandardRule(String skuCode){
		return pcsSkuReceiveStandardRuleMapper.findSkuReceiveStandardRule(skuCode);
	}
	
	public PcsSkuReceiveStandardRuleVO findReceiveStandardRuleVOById(Long id){
		PcsSkuReceiveStandardRule rule = pcsSkuReceiveStandardRuleMapper.selectByPrimaryKey(id);
		PcsSkuReceiveStandardRuleVO ruleVO = new PcsSkuReceiveStandardRuleVO();
		BeanUtils.copyProperties(rule, ruleVO);
		return ruleVO;
	}
	
	@Override
	@Transactional
	public boolean createReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo){
		vo.setStatus(PcsSkuReceiveStandardRuleVO.STATUS_ON);
		return pcsSkuReceiveStandardRuleMapper.insert(vo)==1?true:false;
	}
	
	@Override
	@Transactional
	public boolean updateReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo){
		return pcsSkuReceiveStandardRuleMapper.updateByPrimaryKeySelective(vo)==1?true:false;
	}
	
	@Override
	@Transactional
	public boolean deleteReceiveStandardRule(Long id){
		PcsSkuReceiveStandardRuleVO vo = new PcsSkuReceiveStandardRuleVO();
		vo.setId(id);
		vo.setStatus(PcsSkuReceiveStandardRuleVO.STATUS_OFF);
		return updateReceiveStandardRule(vo);
	}

}
