package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuImgMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuQcImgMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuImg;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuQcImg;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuQcImgExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuQcImgService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by admin on 2016/3/31.
 */
@Service
public class PcsSkuQcImgServiceImpl implements PcsSkuQcImgService {
    @Autowired
    private PcsSkuQcImgMapper pcsSkuQcImgMapper;
    @Override
    public int deleteQcImgBySkuCode(String skuCode) {
        PcsSkuQcImg pcsSkuQcImg = new PcsSkuQcImg();
        pcsSkuQcImg.setCancelFlag(1);
        PcsSkuQcImgExample pcsSkuQcImgExample = new PcsSkuQcImgExample();
        pcsSkuQcImgExample.createCriteria().andSkuCodeEqualTo(skuCode);
        return pcsSkuQcImgMapper.updateByExampleSelective(pcsSkuQcImg,pcsSkuQcImgExample);
    }

    @Override
    public int createQcImg(PcsSkuQcImg pcsSkuQcImg) {
        return pcsSkuQcImgMapper.insert(pcsSkuQcImg);
    }

    @Override
    public List<PcsSkuQcImg> findPcsSkuQcImgBySkuCode(String skuCode) {
        PcsSkuQcImgExample example = new PcsSkuQcImgExample();
        PcsSkuQcImgExample.Criteria criteria = example.createCriteria();
        criteria.andSkuCodeEqualTo(skuCode);
        criteria.andCancelFlagEqualTo(0);
        example.setOrderByClause("SEQ");
        return pcsSkuQcImgMapper.selectByExample(example);
    }
}
