/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCustomMadeMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCmSpl;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCustomMade;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCustomMadeExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCmSplService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCustomMadeService;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCond;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCustomMadeVO;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author Eric.Lou
 * @version $Id: PcsSkuCustomMade.java, v 0.1 2015-08-06 13:06
 */
@Service("pcsSkuCustomMadeService")
public class PcsSkuCustomMadeServiceImpl implements PcsSkuCustomMadeService, CheckAble, CodeAble {

    public final Logger log = LoggerFactory.getLogger(PcsSkuCustomMadeServiceImpl.class);

    @Autowired
    private PcsSkuCustomMadeMapper pcsSkuCustomMadeMapper;

    @Autowired
    private PcsSkuCmSplService pcsSkuCmSplService;


    @Override
    public PcsSkuCustomMadeVO buildFromModel(PcsSkuCustomMade record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsSkuCustomMadeVO vo = new PcsSkuCustomMadeVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    @Override
    public PcsSkuCustomMade bulidFromVO(PcsSkuCustomMadeVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsSkuCustomMade record = new PcsSkuCustomMade();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    @Transactional
    public PcsSkuCustomMade create(PcsSkuCustomMade record) {
        if (check(record)) {
            if (check(record, true)) {
                initDefaultValue(record);
                pcsSkuCustomMadeMapper.insertSelective(record);
                try {
                    String code = generateCode(record.getId());
                    if (check(code)) {
                        record.setCode(code);
                        pcsSkuCustomMadeMapper.updateByPrimaryKeySelective(record);
                        return record;
                    } else {
                        throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "code字段数据库已有相同的值不能重复");
                    }
                } catch (Exception e) {
                    log.error("", e);
                    throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_GENERATE_CODE, "生成CODE失败");
                }
            }
        }
        return null;
    }

    private void initDefaultValue(PcsSkuCustomMade record) {
        record.setCreateTime(new Date());
        record.setSkuStatus(PcsSkuCustomMade.SKU_STATUS_WAITING_VERIFY);
    }


    @Override
    @Transactional
    public boolean update(PcsSkuCustomMade record) {
        if (check(record)) {
            if (check(record, false)) {
                record.setCode(null);
                return pcsSkuCustomMadeMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }

    @Override
    public PcsSkuCustomMadeVO findSkuCustomMadeById(long id) {
        return pcsSkuCustomMadeMapper.findSkuCustomMadeById(id);
    }

    @Override
    public PcsSkuCustomMade findById(long id) {
        return pcsSkuCustomMadeMapper.selectByPrimaryKey(id);
    }

    @Override
    public PcsSkuCustomMade findSkuCustomMadeByCode(String code) {
        PcsSkuCustomMadeExample example = new PcsSkuCustomMadeExample();
        example.createCriteria().andCodeEqualTo(code);
        final List<PcsSkuCustomMade> poList = pcsSkuCustomMadeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return null;
        } else {
            if (poList.size() > 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, " 根据code[" + code + "]能查出2条以上(含两条)记录");
            } else {
                return poList.get(0);
            }
        }
    }

    @Override
    public List<PcsSkuCustomMadeVO> findSkuCustomMadeByCond(PcsSkuCond cond) {
        return pcsSkuCustomMadeMapper.findSkuCustomMadeByCond(cond);
    }

    @Override
    @Transactional
    public Boolean createCustomMadeAndLine(PcsSkuCustomMade pcsSkuCustomMade, List<PcsSkuCmSpl> pcsSkuCmSplList) {
        if (pcsSkuCmSplList.size() == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "至少需要一个供应商信息");
        }
        pcsSkuCustomMade = create(pcsSkuCustomMade);
        if (EmptyUtil.isEmpty(pcsSkuCustomMade.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "SKU定制头信息保存失败," + pcsSkuCustomMade.toString());
        }
        for (PcsSkuCmSpl spl : pcsSkuCmSplList) {
            spl.setSkuCustomMadeId(pcsSkuCustomMade.getId());
            if (pcsSkuCmSplService.create(spl).compareTo(0L) < 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "SKU定制行信息保存失败," + spl.toString());
            }
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updateCustomMadeAndLine(PcsSkuCustomMade pcsSkuCustomMade, List<PcsSkuCmSpl> pcsSkuCmSplList) {
        if (pcsSkuCmSplList.size() == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "至少需要一个供应商信息");
        }
        PcsSkuCustomMade old = findById(pcsSkuCustomMade.getId());
        if (old.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_MODIFY)) {
            pcsSkuCustomMade.setSkuStatus(PcsSkuCustomMade.SKU_STATUS_WAITING_VERIFY);
        }
        Boolean madeUpdate = update(pcsSkuCustomMade);
        if (madeUpdate) {
            for (PcsSkuCmSpl spl : pcsSkuCmSplList) {
                if (EmptyUtil.isEmpty(spl.getId())) {
                    spl.setSkuCustomMadeId(pcsSkuCustomMade.getId());
                    if (pcsSkuCmSplService.create(spl).compareTo(0L) < 1) {
                        throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "SKU定制行信息保存失败," + spl.toString());
                    }
                } else {
                    if (!pcsSkuCmSplService.update(spl)) {
                        throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "SKU定制行信息更新失败," + spl.toString());
                    }
                }
            }
            return true;
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "SKU定制头信息更新失败," + pcsSkuCustomMade.toString());
        }
    }

    @Override
    @Transactional
    public Boolean deletePcsCmSpl(long skuCustomMadeId, long skuCmSplId) {
        final PcsSkuCustomMadeVO pcsSkuCustomMade = findSkuCustomMadeById(skuCustomMadeId);
        if (EmptyUtil.isNotEmpty(pcsSkuCustomMade) && EmptyUtil.isNotEmpty(pcsSkuCustomMade.getSkuStatus()) && pcsSkuCustomMade.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_MODIFY)) {
            final PcsSkuCmSpl pcsSkuCmSpl = pcsSkuCmSplService.findById(skuCmSplId);
            if (EmptyUtil.isNotEmpty(pcsSkuCmSpl) && EmptyUtil.isNotEmpty(pcsSkuCmSpl.getSkuCustomMadeId()) && pcsSkuCmSpl.getSkuCustomMadeId().equals(skuCustomMadeId)) {
                return pcsSkuCmSplService.deleteById(skuCmSplId);
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "skuCmSplId 异常");
            }
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "只有待修改状态的定制单可以删减供应商行信息");
        }
    }

    @Override
    @Transactional
    public Boolean convertCustomMadeAndLine(long skuCustomMadeId, long skuCmSplId) {
        PcsSkuCustomMade pcsSkuCustomMade = findById(skuCustomMadeId);
        if (EmptyUtil.isNotEmpty(pcsSkuCustomMade) && EmptyUtil.isNotEmpty(pcsSkuCustomMade.getSkuStatus()) && pcsSkuCustomMade.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_WAITING_VERIFY)) {
            PcsSkuCmSpl pcsSkuCmSpl = pcsSkuCmSplService.findById(skuCmSplId);
            if (EmptyUtil.isNotEmpty(pcsSkuCmSpl) && EmptyUtil.isNotEmpty(pcsSkuCmSpl.getSkuCustomMadeId()) && pcsSkuCmSpl.getSkuCustomMadeId().equals(skuCustomMadeId)) {
                pcsSkuCmSpl.setIsSelected(PegasusConstants.YES);
                if (pcsSkuCmSplService.update(pcsSkuCmSpl)) {
                    pcsSkuCustomMade.setSkuStatus(PcsSkuCustomMade.SKU_STATUS_WAITING_CONVERT);
                    if (update(pcsSkuCustomMade)) {
                        return true;
                    } else {
                        throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "PcsSkuCustomMade 更新失败");
                    }
                } else {
                    throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "PcsSkuCmSpl 更新失败");
                }
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "skuCmSplId 异常");
            }
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "必须是待审核状态的定制单");
        }
    }

    @Override
    @Transactional
    public Boolean rejectCustomMade(long skuCustomMadeId) {
        PcsSkuCustomMade pcsSkuCustomMade = findById(skuCustomMadeId);
        if (EmptyUtil.isNotEmpty(pcsSkuCustomMade) && EmptyUtil.isNotEmpty(pcsSkuCustomMade.getSkuStatus()) && pcsSkuCustomMade.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_WAITING_VERIFY)) {
            pcsSkuCustomMade.setSkuStatus(pcsSkuCustomMade.SKU_STATUS_MODIFY);
            return update(pcsSkuCustomMade);
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "必须是待审核状态的定制单");
        }
    }

    @Override
    public Boolean check(Object obj) {
        PcsSkuCustomMade record = (PcsSkuCustomMade) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(PcsSkuCustomMade record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate) {
            PcsSkuCustomMade oldRecord = pcsSkuCustomMadeMapper.selectByPrimaryKey(record.getId());
            if (NullUtil.isNotNull(oldRecord) && EmptyUtil.isNotEmpty(oldRecord.getFileId()) && EmptyUtil.isNotEmpty(record.getFileId()) && !oldRecord.getFileId().equals(record.getFileId())) {
                PegasusUtilFacade.getInstance().deleteFileById(oldRecord.getFileId());
            }
        }
        return true;
    }

    private Boolean check(String code) {
        return NullUtil.isNull(findSkuCustomMadeByCode(code)) ? true : false;
    }

    @Override
    public String generateCode(Object id) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PCS_SKU_CUSTOM_MADE", params);
        return code;
    }

}
