/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseOrderMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.*;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.integration.sms.SmsUtil;
import com.thebeastshop.pegasus.integration.sms.SmsVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseOrderVO;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import com.thebeastshop.pegasus.util.model.CommCurrency;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.pegasus.util.model.CommTaxRate;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author Eric.Lou
 * @version $Id: PcsPurchaseOrderServiceImpl.java, v 0.1 2015-08-10 10:28
 */
@Service("pcsPurchaseOrderService")
public class PcsPurchaseOrderServiceImpl implements PcsPurchaseOrderService, CheckAble, CodeAble {

    private final Logger log = LoggerFactory.getLogger(PcsPurchaseOrderServiceImpl.class);

    @Autowired
    private PcsPurchaseOrderMapper pcsPurchaseOrderMapper;

    @Autowired
    private PcsPoLineService pcsPoLineService;
    @Autowired
    private PcsPoPlanMapper pcsPoPlanMapper;
    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;
    @Autowired
    private PcsSkuSalesPriceChangeService pcsSkuSalesPriceChangeService;
    

    @Override
    public Boolean check(Object obj) {
        PcsPurchaseOrder record = (PcsPurchaseOrder) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        Boolean currencyFlag = false;
        List<CommCurrency> allCurrency = PegasusUtilFacade.getInstance().findAllCurrency();
        for (CommCurrency c : allCurrency) {
            if (c.getCode().equals(record.getPurchaseCurrencyCode())) {
                record.setPurchaseCurrencyDesc(c.getDescInfo());
                currencyFlag = true;
                break;
            }
        }
        if (!currencyFlag) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }


    private Boolean check(PcsPurchaseOrder record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(String code) {
        return NullUtil.isNull(findPoByCode(code)) ? true : false;
    }

    @Override
    public String generateCode(Object id) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PCS_PURCHASE_ORDER", params);
        return code;
    }

    @Override
    public PcsPurchaseOrder buildFromVO(PcsPurchaseOrderVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsPurchaseOrder record = new PcsPurchaseOrder();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    public PcsPurchaseOrderVO buildFromModel(PcsPurchaseOrder record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsPurchaseOrderVO vo = new PcsPurchaseOrderVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    @Override
    @Transactional
    public PcsPurchaseOrder create(PcsPurchaseOrder record,  boolean saveDraft) {
        if (check(record)) {
            if (check(record, true)) {
                record.setCreateTime(new Date());
                record.setIsReceivedAll(PegasusConstants.YES);
                pcsPurchaseOrderMapper.insertSelective(record);
                try {
                    final String code = generateCode(record.getId());
                    if (check(code)) {
                        record.setCode(code);
                        if(!saveDraft) {
	                      /*  myScheduler.execute(new Runnable() {
	            				@Override
	            				public void run() {
	            					sendNotice(code);
	            				}
	            			});*/
                        }
                        pcsPurchaseOrderMapper.updateByPrimaryKeySelective(record);
                        return record;
                    } else {
                        throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "code字段数据库已有相同的值不能重复");
                    }
                } catch (Exception e) {
                    log.error("", e);
                    throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_GENERATE_CODE, "生成CODE失败");
                }
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsPurchaseOrder record) {
        if (check(record)) {
            if (check(record, false)) {
                record.setCode(null);
                return pcsPurchaseOrderMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }

    @Override
    public PcsPurchaseOrder findPoById(long id) {
        return pcsPurchaseOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    public PcsPurchaseOrderVO findPoVOById(long id) {
        return pcsPurchaseOrderMapper.findPoVOById(id);
    }
    
    @Override
    public PcsPurchaseOrderVO findPurchaseOrderByCommandCode(String commandCode) {
    	return pcsPurchaseOrderMapper.findPurchaseOrderByCommandCode(commandCode);
    }

    @Override
    public PcsPurchaseOrder findPoByCode(String code) {
        PcsPurchaseOrderExample example = new PcsPurchaseOrderExample();
        example.createCriteria().andCodeEqualTo(code);
        final List<PcsPurchaseOrder> poList = pcsPurchaseOrderMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return null;
        } else {
            if (poList.size() > 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, " 根据code[" + code + "]能查出2条以上(含两条)记录");
            } else {
                return poList.get(0);
            }
        }
    }

    @Override
    public List<PcsPurchaseOrderVO> findPOVOByCond(PcsPurchaseOrderCond cond) {
        return pcsPurchaseOrderMapper.findPOVOByCond(cond);
    }

    @Override
    @Transactional
    public Long createPurchaseOrderAndLine(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, boolean saveDraft) {
    	
    	computeTotalPrice(pcsPurchaseOrder, pcsPoLineList);
        if (pcsPoLineList.size() == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "至少需要一个行信息");
        }
        if (saveDraft) {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT);
        } else {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT);
        }
        pcsPurchaseOrder = create(pcsPurchaseOrder, saveDraft);
        if (EmptyUtil.isEmpty(pcsPurchaseOrder.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "头信息保存失败," + pcsPurchaseOrder.toString());
        }
        for (PcsPoLine pcsPoLine : pcsPoLineList) {
        	//SKU没有完成售价审核
        	if(!saveDraft && EmptyUtil.isEmpty(pcsSkuSalesPriceChangeService.findByCodeAndStatus(pcsPoLine.getSkuCode(), PcsSkuSalesPriceChange.STATUS_SUCCESS))) {
        		 throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "采购单中存在售价审批未通过的SKU，提交失败");
        	}
            pcsPoLine.setPoId(pcsPurchaseOrder.getId());
            if (pcsPoLineService.create(pcsPoLine).compareTo(0L) < 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "行信息保存失败," + pcsPoLine.toString());
            }
        }
        return pcsPurchaseOrder.getId();
    }
    
    /**
     * 
     * @param pcsPurchaseOrder
     * @param pcsPoLineList
     */
    private  void  computeTotalPrice(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList) {
		BigDecimal totalAmount =  new BigDecimal(0.00);
		BigDecimal totalTax = new BigDecimal(0.00);
		BigDecimal totalAmountAfterTax = new BigDecimal(0.00);
		BigDecimal otherFeeAfterTax = new BigDecimal(0.00);
		
		if(EmptyUtil.isNotEmpty(pcsPoLineList)) {
	     	for(PcsPoLine pcsPoLine : pcsPoLineList) {
	     		BigDecimal unitPrice = pcsPoLine.getUnitPrice();
	     		int quantity = pcsPoLine.getQuantity();
	     		BigDecimal taxRate = pcsPoLine.getTaxRate();
	     	
	     		taxRate = taxRate.add(new BigDecimal(1));
	     		BigDecimal unitPriceAfterTax = pcsPoLine.getUnitPrice().divide(taxRate, 2,  BigDecimal.ROUND_HALF_EVEN);
	     		pcsPoLine.setTotalPrice(unitPrice.multiply(new BigDecimal(quantity) ));
	     		totalAmount = totalAmount.add(pcsPoLine.getTotalPrice());
	     		pcsPoLine.setUnitPriceAfterTax(unitPriceAfterTax);
	     		pcsPoLine.setTotalPriceAfterTax(unitPriceAfterTax.multiply(new BigDecimal(quantity)));
	     		pcsPoLine.setTaxRate(pcsPoLine.getTaxRate());
	     		totalAmountAfterTax = totalAmountAfterTax.add(pcsPoLine.getTotalPriceAfterTax());
	     		
	     	}
	     	totalAmount = totalAmount.add(pcsPurchaseOrder.getOtherFee());
	     	otherFeeAfterTax = pcsPurchaseOrder.getOtherFee().divide(pcsPurchaseOrder.getOtherFeeTaxRate().add(new BigDecimal(1)), 2,  BigDecimal.ROUND_HALF_EVEN);
	     	totalAmountAfterTax = totalAmountAfterTax.add(otherFeeAfterTax);
	     	totalTax = totalAmount.subtract(totalAmountAfterTax);
	     }
		//pcsPurchaseOrder.setPcsPoLineVOList(pcsPoLineList);
		pcsPurchaseOrder.setTotalAmount(totalAmount);
		pcsPurchaseOrder.setTotalAmountAfterTax(totalAmountAfterTax);
		//totalAmountAfterTax = totalAmountAfterTax.add(pcsPurchaseOrder.getOtherFee());
		//物流费用
		
		if((EmptyUtil.isNotEmpty(pcsPurchaseOrder.getCrossBorderFlag()) && pcsPurchaseOrder.getCrossBorderFlag() == 0) && 
				(EmptyUtil.isNotEmpty(pcsPurchaseOrder.getIncludeShipment()) && pcsPurchaseOrder.getIncludeShipment() == 0)) {
			BigDecimal  logisticsCost = pcsPurchaseOrder.getLogisticsCost() == null ? new BigDecimal(0.0) : pcsPurchaseOrder.getLogisticsCost();
			totalAmount = totalAmount.add(logisticsCost);
			pcsPurchaseOrder.setTotalAmount(totalAmount);
			pcsPurchaseOrder.setTotalAmountAfterTax(totalAmountAfterTax.add(logisticsCost));
			//totalAmountAfterTax = totalAmountAfterTax.add(pcsPurchaseOrder.getTaxes());
		}
		pcsPurchaseOrder.setOtherFeeTaxRate(pcsPurchaseOrder.getOtherFeeTaxRate());
    }

    @Override
    @Transactional
    public Boolean updatePurchaseOrderAndLine(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, boolean saveDraft) {
    	computeTotalPrice(pcsPurchaseOrder, pcsPoLineList);
        if (pcsPoLineList.size() == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "至少需要一个行信息");
        }
        if (!saveDraft) {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT);
            final String code = pcsPurchaseOrder.getCode();
            /*myScheduler.execute(new Runnable() {
				@Override
				public void run() {
					sendNotice(code);
				}
			});*/
        }
        Boolean update = update(pcsPurchaseOrder);
        if (update) {
            for (PcsPoLine pcsPoLine : pcsPoLineList) {
            	//SKU没有完成售价审核
            	if(!saveDraft && EmptyUtil.isEmpty(pcsSkuSalesPriceChangeService.findByCodeAndStatus(pcsPoLine.getSkuCode(), PcsSkuSalesPriceChange.STATUS_SUCCESS))) {
            		 throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "采购单中存在售价审批未通过的SKU，提交失败");
            	}
                if (EmptyUtil.isEmpty(pcsPoLine.getId())) {
                    pcsPoLine.setPoId(pcsPurchaseOrder.getId());
                    if (pcsPoLineService.create(pcsPoLine).compareTo(0L) < 1) {
                        throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "行信息保存失败," + pcsPoLine.toString());
                    }
                } else {
                    if (!pcsPoLineService.update(pcsPoLine)) {
                        throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "行信息更新失败," + pcsPoLine.toString());
                    }
                }
            }
            return true;
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "头信息更新失败," + pcsPurchaseOrder.toString());
        }
    }

    /**
     * 审批通知
     */
    private void  sendNotice(String code) {
    	 final SmsUtil smsUtil = SmsUtil.getInstance();
         final SmsVO smsVO = new SmsVO();
         smsVO.setSendTime(new Date());
         CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance()
 				.findConfigByKey("planner.Approval.Mobile");
 		// 收件人
 		String[] toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
 		smsVO.setMobileList(Arrays.asList(toNotifyUsers));
	
 		smsVO.setContent("您好，您有新的采购单需要审批，采购单code："+ code +"，请尽快审批，谢谢！");
 		smsUtil.send(smsVO);
 		
 		// 邮件VO
 		commGlobalConfig = PegasusUtilFacade.getInstance()
 				.findConfigByKey("planner.Approval.Email");
 		toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
		EmailVO emailVO = new EmailVO();
		emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
		emailVO.setSubject("采购单审批");
		emailVO.setContent("您好，您有新的采购单需要审批，采购单 code："+ code +"，请尽快审批，谢谢！");
		// 发邮件
		if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
			// 正式环境发邮件
			EmailUtil.getInstance().send(emailVO);
		}
    }
    @Override
    public List<String> findWarehouseCodeGroup() {
        List<String> warehouseCodeList = pcsPurchaseOrderMapper.findWarehouseCodeGroup();
        if (CollectionUtils.isEmpty(warehouseCodeList)) {
            return Collections.emptyList();
        } else {
            return warehouseCodeList;
        }
    }

    @Override
    @Transactional
    public Boolean auditPurchaseOrder(long id, Boolean isPass, Integer type) {
        PcsPurchaseOrder record = findPoById(id);
        if (EmptyUtil.isNotEmpty(record) && (record.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT) || 
        		record.getPurchaseOrderStatus() == 4)) {
            record.setAuditTime(new Date());
            if (isPass) {
            	if(type == 1) { //planner 审核通过
            		 record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
            	} else {
            		 record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
            	}
            } else {
                record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT);
            }
            boolean update = update(record);
            if (update) {
                return true;
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "审核更新数据库失败");
            }
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "必须是待审核状态");
        }
    }

    @Override
    @Transactional
    public Boolean closePurchaseOrder(long id) {
        PcsPurchaseOrder record = findPoById(id);
        if (EmptyUtil.isNotEmpty(record) && (record.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE)||record.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE))) {
            record.setFinishedTime(new Date());
            record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH);
            boolean update = update(record);
            if (update) {
                return true;
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "关闭采购单更新数据库失败");
            }
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "必须是待收货中状态");
        }
    }

    @Override
    @Transactional
    public Boolean deletePcsPoLine(long poId, long pcsPoLineId) {
        final PcsPurchaseOrder pcsPurchaseOrder = findPoById(poId);
        if (EmptyUtil.isNotEmpty(pcsPurchaseOrder)
                && EmptyUtil.isNotEmpty(pcsPurchaseOrder.getPurchaseOrderStatus())
                && (pcsPurchaseOrder.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT)
                || pcsPurchaseOrder.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT)
        )
                ) {
            final PcsPoLine pcsPoLine = pcsPoLineService.findPoLineById(pcsPoLineId);
            if (EmptyUtil.isNotEmpty(pcsPoLine) && EmptyUtil.isNotEmpty(pcsPoLine.getPoId()) && pcsPoLine.getPoId().equals(poId)) {
                return pcsPoLineService.deleteById(pcsPoLineId);
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "行Id异常");
            }
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "只有待修改状态的采购单可以删减行信息");
        }
    }

    @Override
    @Transactional
    public void processReceicePlan(String poPlanCode, Map<String,Integer> liangpinMap, Map<String,Integer> canciMap) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andCodeEqualTo(poPlanCode);
        List<PcsPoPlan> pcsPoPlanList = pcsPoPlanMapper.selectByExample(example);
        if(pcsPoPlanList != null && pcsPoPlanList.size() > 0){
            PcsPoPlan pcsPoPlan = pcsPoPlanList.get(0);
            pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_FINISHED);
            pcsPoPlanMapper.updateByPrimaryKey(pcsPoPlan);
            List<PcsPoPlanLine> pcsPoPlanLineList = pcsPoPlanLineService.findPoPlanLineByPoPlanId(pcsPoPlan.getId());
            for(PcsPoPlanLine pcsPoPlanLine:pcsPoPlanLineList){
                pcsPoPlanLine.setQuantity(liangpinMap.get(pcsPoPlanLine.getSkuCode()));
                pcsPoPlanLine.setWasteQuantity(canciMap.get(pcsPoPlanLine.getSkuCode()));
                pcsPoPlanLineService.update(pcsPoPlanLine);
            }
            int result = pcsPoPlanMapper.isAllReceivePo(pcsPoPlan.getPoId());
            if(result <= 0){
                PcsPurchaseOrder purchaseOrder = pcsPurchaseOrderMapper.selectByPrimaryKey(pcsPoPlan.getPoId());
                if(purchaseOrder != null){
                    purchaseOrder.setFinishedTime(Calendar.getInstance().getTime());
                    purchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH);
                    pcsPurchaseOrderMapper.updateByPrimaryKey(purchaseOrder);
                }
          }
        }
    }

	@Override
	public boolean updatePurchaseOrder(PcsPurchaseOrder record) {
		return pcsPurchaseOrderMapper.updateByPrimaryKeySelective(record) != 0;
	}


	@Override
	public long countByCond(PcsPurchaseOrderCond cond) {
		return pcsPurchaseOrderMapper.countByCond(cond);
	}

}
