/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanCostMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanLineMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseOrderMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.*;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseOrderVO;
import com.thebeastshop.pegasus.service.purchase.vo.PoInfomationVO;
import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseInnerServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import com.thebeastshop.pegasus.util.model.CommEntityOpRcd;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.PostConstruct;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoPlanServiceImpl.java, v 0.1 2015-08-12 15:03
 */
@Service("pcsPoPlanService")
public class PcsPoPlanServiceImpl implements PcsPoPlanService, CheckAble, CodeAble {

    private final Logger log = LoggerFactory.getLogger(PcsPoPlanServiceImpl.class);

    private PegasusWarehouseInnerServiceFacade facadeWhInner;

    @Autowired
    private PcsPoPlanMapper pcsPoPlanMapper;

    @Autowired
    private PcsPoPlanLineMapper pcsPoPlanLineMapper;

    @Autowired
    private PcsPurchaseOrderMapper pcsPurchaseOrderMapper;

    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;

    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;

    @Autowired
    private PcsPoLineService pcsPoLineService;
    
    @Autowired
    private PcsPoPlanCostMapper pcsPoPlanCostMapper;

    @PostConstruct
    private void init() {
        facadeWhInner = PegasusWarehouseInnerServiceFacade.getInstance();
    }

    @Override
    public PcsPoPlan buildFromVO(PcsPoPlanVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsPoPlan record = new PcsPoPlan();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    public PcsPoPlanVO buildFromModel(PcsPoPlan record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsPoPlanVO vo = new PcsPoPlanVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    private WhCommand bulidWhCommand(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList) {
        PcsPurchaseOrder po = pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId());
        if (EmptyUtil.isEmpty(po)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "采购单号不能为空");
        }
        if (!po.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE) && !po.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "采购单状态必须是收货中");
        }
        if (CollectionUtils.isEmpty(pcsPoPlanLineList)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "pcsPoPlanLineList不能为空");
        }
        WhCommand whCommand = new WhCommand();
        whCommand.setWarehouseCode(po.getWarehouseCode());
        whCommand.setReferenceCode(pcsPoPlan.getCode());
        whCommand.setInOutType(WhCommand.TYPE_PURCHASE_IN);
        List<WhCommandSku> whCommandSkuList = new ArrayList<WhCommandSku>();
        for (PcsPoPlanLine line : pcsPoPlanLineList) {
            if (line.getPlanedQuantity().compareTo(0) <= 0) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造仓库指令的LIST失败,数量必须大于0");
            }
            WhCommandSku whCommandSku = new WhCommandSku();
            whCommandSku.setSkuCode(line.getSkuCode());
            whCommandSku.setPlanedQuantity(line.getPlanedQuantity());
            whCommandSku.setQpb(line.getQpb());
            if(!NumberUtil.isNullOrZero(line.getQuantity())){
                whCommandSku.setQuantity(line.getQuantity());
            }
            if(!NumberUtil.isNullOrZero(line.getWasteQuantity())){
                whCommandSku.setDamagedQuantity(line.getWasteQuantity());
            }
            whCommandSkuList.add(whCommandSku);
        }
        if (CollectionUtils.isEmpty(whCommandSkuList)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造仓库指令的LIST失败,whCommandSkuList不能为空");
        }
        whCommand.setWhCommandSkuList(whCommandSkuList);
        return whCommand;
    }

    @Override
    @Transactional
    public PcsPoPlan create(PcsPoPlan record) {
        if (check(record)) {
            if (check(record, true)) {
                record.setWhCommandCode("");
                record.setPlanStatus(PcsPoPlan.PLAN_STATUS_WAITING_RECEIVE);
                pcsPoPlanMapper.insertSelective(record);
                try {
                    String code = generateCode(record.getId());
                    if (check(code)) {
                        record.setCode(code);
                    } else {
                        throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "code字段数据库已有相同的值不能重复");
                    }
                } catch (WarehouseException we) {
                    log.error("", we);
                    throw new PurchaseException(we.getErrorCode(), "facadeWhInner error:" + we.getMessage());
                } catch (Exception e) {
                    log.error("", e);
                    throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_GENERATE_CODE, e.getMessage());
                }
                pcsPoPlanMapper.updateByPrimaryKeySelective(record);
                return record;
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsPoPlan record) {
        if (check(record)) {
            if (check(record, false)) {
                return pcsPoPlanMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }

    @Override
    public PcsPoPlan findPoPlanById(long id) {
        return pcsPoPlanMapper.selectByPrimaryKey(id);
    }
    
    @Override
    public boolean updatePcsPoPlanById(long id, String date) {
    	int result = 0 ;
    	try {
    		result = pcsPoPlanMapper.updatePcsPoPlanById(id, date);
		} catch (Exception e) {
			log.error(e.getMessage());
		}
    	if(result > 0){
    		return true;
    	}else{
    		return false;
    	}
    }

    @Override
    public PcsPoPlan findPoPlanByCode(String code) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andCodeEqualTo(code);
        final List<PcsPoPlan> poList = pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return null;
        } else {
            if (poList.size() > 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, " 根据code[" + code + "]能查出2条以上(含两条)记录");
            } else {
                return poList.get(0);
            }
        }
    }

    @Override
    public List<PcsPoPlan> findPoPlanByStatus(Integer status) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andPlanStatusEqualTo(status);
        final List<PcsPoPlan> poList = pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        } else {
            return poList;
        }
    }
    private List<PoInfomationVO> findPoInfomation(){
        final List<PoInfomationVO> poList = pcsPoPlanMapper.findPoInfomation();
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        } else {
            return poList;
        }
    }
    @Override
    @Transactional
    public Boolean createPoPlanAndLine(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList) throws Exception {
        if (pcsPoPlanLineList.size() == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "至少需要一个计划行信息");
        }
        pcsPoPlan = create(pcsPoPlan);
        if (EmptyUtil.isEmpty(pcsPoPlan.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "计划头信息保存失败," + pcsPoPlan.toString());
        }
        for (PcsPoPlanLine line : pcsPoPlanLineList) {
            line.setPoPlanId(pcsPoPlan.getId());
            if (pcsPoPlanLineService.create(line).compareTo(0L) < 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "计划行信息保存失败," + line.toString());
            }
        }
        WhCommand whCommand = bulidWhCommand(pcsPoPlan, pcsPoPlanLineList);
        pcsPoPlan.setWhCommandCode(facadeWhInner.createCommand(whCommand));
        if (!update(pcsPoPlan)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "计划头信息更新失败," + pcsPoPlan.toString());
        }
        PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId());
        pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE);
        pcsPurchaseOrderService.update(pcsPurchaseOrder);
        return true;
    }

    @Override
    @Transactional
    public Boolean createPoPlanAndLineThenFinish(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList) throws Exception {
        if (pcsPoPlanLineList.size() == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "至少需要一个计划行信息");
        }
        pcsPoPlan.setPlanedSendDate(DateUtil.getNow());
        pcsPoPlan.setPlanedReceiveDate(DateUtil.getNow());
        pcsPoPlan = create(pcsPoPlan);
        if (EmptyUtil.isEmpty(pcsPoPlan.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "计划头信息保存失败," + pcsPoPlan.toString());
        }
        for (PcsPoPlanLine line : pcsPoPlanLineList) {
            line.setPoPlanId(pcsPoPlan.getId());
            Integer quantity = line.getQuantity();
            Integer wasteQuantity = line.getWasteQuantity();
            if (pcsPoPlanLineService.create(line).compareTo(0L) < 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "计划行信息保存失败," + line.toString());
            }
            line.setQuantity(quantity);
            line.setWasteQuantity(wasteQuantity);
            if (!pcsPoPlanLineService.update(line)) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "计划行信息更新失败," + line.toString());
            }
        }
        WhCommand whCommandForCreate = bulidWhCommand(pcsPoPlan, pcsPoPlanLineList);
        pcsPoPlan.setWhCommandCode(facadeWhInner.createCommandThenFinish(whCommandForCreate));
        if(EmptyUtil.isEmpty(pcsPoPlan.getWhCommandCode())){
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "仓库指令生成失败," + pcsPoPlan.toString());
        }
        pcsPoPlan.setReceiveDate(DateUtil.getNow());
        pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_ALREADY_IN);
        if (!update(pcsPoPlan)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "计划头信息更新失败," + pcsPoPlan.toString());
        }
        return true;
    }

    @Override
    public List<PcsPoPlan> findPcsPoPlanByPoId(long poId) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andPoIdEqualTo(poId);
        final List<PcsPoPlan> poList = pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        } else {
            return poList;
        }
    }

    @Override
    @Transactional
    public Boolean synPoPlanAndLine(PcsPoPlan poPlan) {
        WhCommand whCommand = facadeWhInner.findCommandByCode(poPlan.getWhCommandCode(), true);
        if (EmptyUtil.isNotEmpty(whCommand) && whCommand.getCommandStatus().equals(WhCommand.STATUS_FINISHED)) {
            List<PcsPoPlanLine> pcsPoPlanLineList = pcsPoPlanLineService.findPoPlanLineByPoPlanId(poPlan.getId());
            for (PcsPoPlanLine poPlanLine : pcsPoPlanLineList) {
                for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                    if (!poPlanLine.getSkuCode().equals(whCommandSku.getSkuCode())) {
                        continue;
                    }
                    poPlanLine.setQuantity(whCommandSku.getQuantity());
                    poPlanLine.setWasteQuantity(whCommandSku.getDamagedQuantity());
                    pcsPoPlanLineService.update(poPlanLine);
                }
            }
            poPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_ALREADY_IN);
            poPlan.setReceiveDate(whCommand.getProcessTime());
            update(poPlan);
        }
        return true;
    }
    @Override
    public byte[] exportPoInfomation() {
        List<PoInfomationVO> poList = findPoInfomation();
        if(CollectionUtils.isEmpty(poList)){
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM,"没有相关数据");
        }
        Map<String, List<List<String>>> sheets = new HashMap<String, List<List<String>>>();
        List<List<String>> allLines = new ArrayList<>();
        List<String> head = new ArrayList<>();
        // head
        head.add("采购单编号");
        head.add("采购单状态");
        head.add("供应商");
        head.add("目标仓库");
        head.add("创建时间");
        head.add("创建人");
        head.add("审核时间");
        head.add("SKU");
        head.add("SKU名");
        head.add("要求交货日期");
        head.add("数量");
        head.add("单价");
        head.add("总价");
        head.add("实收良品");
        head.add("实收残次");
        head.add("待收数量");
        allLines.add(head);
        for(PoInfomationVO vo:poList){
            List<String> list = new ArrayList<>();
            list.add(vo.getPoCode());
            list.add(vo.getPurchaseOrderStatus());
            list.add(vo.getSuppName());
            list.add(vo.getHouseName());
            list.add(vo.getCreateTime());
            list.add(vo.getNickName());
            list.add(vo.getAuditTime());
            list.add(vo.getSkuCode());
            list.add(vo.getSkuName());
            list.add(vo.getAskDeliveryDate());
            list.add(vo.getQuantity());
            list.add(vo.getUnitPriceAfterTax());
            list.add(vo.getTotalPriceAfterTax());
            list.add(vo.getReceiveQuantity());
            list.add(vo.getWasteQuantity());
            list.add(vo.getWaitStockAmout());
            allLines.add(list);
        }


        //return bytes
        sheets.put("采购单明细", allLines);
        byte[] res = new ExcelUtil().write(sheets, true);
        return res;
    }

    @Override
    public byte[] exportPoPlanStatusWaitingIn() {
        List<PcsPoPlan> poPlans = findPoPlanByStatus(PcsPoPlan.PLAN_STATUS_WAITING_IN);
        if(CollectionUtils.isEmpty(poPlans)){
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM,"没有相关数据");
        }
        Map<String, List<List<String>>> sheets = new HashMap<String, List<List<String>>>();
        List<List<String>> allLines = new ArrayList<>();
        List<String> head = new ArrayList<>();
        // head
        head.add("采购单编号");
        head.add("创建人");
        head.add("SKU");
        head.add("SKU名");
        head.add("采购单数量");
        head.add("收货计划编号");
        head.add("收货状态");
        head.add("计划发货日期");
//        head.add("供应商");
       
//        head.add("创建时间");
//        head.add("审核人");
//        head.add("审核时间");
       
//        head.add("计划发货日期");
        head.add("计划收货日期");
        head.add("实际收货日期");
        head.add("计划入数量");
      /*  head.add("实际入库数量");
        head.add("实际入库良品数量");
        head.add("实际入库次品数量");*/
//        head.add("采购单价");
//        head.add("行总金额");
        allLines.add(head);

        //缓存
        Map<Long,PcsPurchaseOrderVO> poVOMap = new HashMap<>();
        Map<Long,List<PcsPoLine>> poLinesMap = new HashMap<>();
        Map<Long,String> poAuditUserNameMap = new HashMap<>();

        for (PcsPoPlan poPlan : poPlans) {
            if(!poVOMap.containsKey(poPlan.getPoId())){
                PcsPurchaseOrderVO poVO = pcsPurchaseOrderService.findPoVOById(poPlan.getPoId());
                poVOMap.put(poPlan.getPoId(),poVO);
            }
            if(!poLinesMap.containsKey(poPlan.getPoId())){
               List<PcsPoLine> poLines = pcsPoLineService.findPoLineByPoId(poPlan.getPoId());
               poLinesMap.put(poPlan.getPoId(),poLines);
            }
            if(!poAuditUserNameMap.containsKey(poPlan.getPoId())){
                List<CommEntityOpRcd> commEntityOpRcds = PegasusUtilFacade.getInstance().
                        findEntityOpRcdByClazzAndId("PcsPurchaseOrder", poPlan.getPoId().toString());
                poAuditUserNameMap.put(poPlan.getPoId(),"");
                for (CommEntityOpRcd commEntityOpRcd : commEntityOpRcds) {
                    if(!commEntityOpRcd.getOperationDesc().equals("审核通过采购单")){
                        continue;
                    }
                    poAuditUserNameMap.put(poPlan.getPoId(),commEntityOpRcd.getOperatorName());
                }
            }
        }

         Map<String, Integer> skuPoPlan = new HashMap<>();;
         //遍历poPlan 生成excel line
        for (PcsPoPlan poPlan : poPlans) {
            List<PcsPoPlanLineVO> poPlanLineVOs = pcsPoPlanLineService.findPoPlanLineVOByPoPlanId(poPlan.getId());
            PcsPurchaseOrderVO poVO = poVOMap.get(poPlan.getPoId());//采购单
            List<PcsPoLine> poLines = poLinesMap.get(poPlan.getPoId());//采购单行
            String poAuditUserName = poAuditUserNameMap.get(poPlan.getPoId());
            for (PcsPoPlanLineVO poPlanLineVO : poPlanLineVOs) {
            	
            	String skuCode = poPlanLineVO.getSkuCode();
            	skuPoPlan.put(skuCode, (skuPoPlan.get(skuCode) == null ? 0 : skuPoPlan.get(skuCode)) + 1);
            	
                List<String> line = new ArrayList<>();
                line.add(poVO.getCode());
                line.add(poVO.getCreateOperatorName());
                line.add(poPlanLineVO.getSkuCode());
                line.add(poPlanLineVO.getSkuNameCn());
                line.add(poPlanLineVO.getQuantity() + "");
                line.add(poPlan.getCode());
                line.add("待入库");
//                line.add(poVO.getSupplierNameCn());
               
//                line.add(DateUtil.format(poVO.getCreateTime(),DateUtil.DEFAULT_DATE_FORMAT));
//                line.add(poAuditUserName);
//                line.add(DateUtil.format(poVO.getAuditTime(),DateUtil.DEFAULT_DATE_FORMAT));
               
//                line.add(DateUtil.format(poPlan.getPlanedSendDate(),DateUtil.DEFAULT_DATE_FORMAT));
                line.add(DateUtil.format(poPlan.getPlanedSendDate(),DateUtil.DEFAULT_DATE_FORMAT));
                line.add(DateUtil.format(poPlan.getPlanedReceiveDate(),DateUtil.DEFAULT_DATE_FORMAT));
                line.add(DateUtil.format(poPlan.getReceiveDate(),DateUtil.DEFAULT_DATE_FORMAT));
                line.add(poPlanLineVO.getPlanedQuantity().toString());
              /*  line.add(poPlanLineVO.getQuantity() + poPlanLineVO.getWasteQuantity() + "");
                line.add(poPlanLineVO.getQuantity() + "");
                line.add(poPlanLineVO.getWasteQuantity() + "");*/
                
//                line.add("");
//                line.add("");

//                for (PcsPoLine poLine : poLines) {
//                    if(!poPlanLineVO.getSkuCode().equals(poLine.getSkuCode())){
//                        continue;
//                    }
//                    line.set(12,poLine.getUnitPrice().toString());
//                    line.set(13,poLine.getUnitPrice().multiply(new BigDecimal(poPlanLineVO.getPlanedQuantity())).toString());
//                }

                allLines.add(line);
            }
        }

      /*  //采购单数量补充
       for (int i = 0; i < allLines.size(); i++) {
    		List<String> line = allLines.get(i);
    		if(i != 0) {
	        	String skuCode = line.get(2);
	        	line.set(4, (skuPoPlan.get(skuCode) == null ? "0" : skuPoPlan.get(skuCode))  + "");
    		}
        }*/
        
        //return bytes
        sheets.put("收货计划-待入库", allLines);
        byte[] res = new ExcelUtil().write(sheets, true);
        return res;
    }

    @Override
    public Boolean check(Object obj) {
        PcsPoPlan record = (PcsPoPlan) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(PcsPoPlan record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (isCreate && (EmptyUtil.isEmpty(record.getPoId()))) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "采购单ID为空");
        }
        if (isCreate && EmptyUtil.isEmpty(pcsPurchaseOrderService.findPoById(record.getPoId()))) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "采购单ID数据库不存在");
        }
        return true;
    }

    private Boolean check(String code) {
        return NullUtil.isNull(findPoPlanByCode(code)) ? true : false;
    }

    @Override
    public String generateCode(Object id) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PCS_PO_PLAN", params);
        return code;
    }


    /**
     * 更新采购单收货计划
     *
     * @return 是否成功
     */
    @Override
    public boolean updatePoPlan(PcsPoPlan po) {
        int rs=0;
        rs=pcsPoPlanMapper.updateByPrimaryKeySelective(po);
        return rs>0;
    }

    /**
     * 更新采购单收货计划行；
     *
     * @return 是否成功
     */
    @Override
    public boolean updatePoPlanLine(PcsPoPlanLine line) {
//        if(line.getQuantity()!=null&&line.getQuantity()!=0) {
//            PcsPoPlanLine lineVo = pcsPoPlanLineMapper.selectByPrimaryKey(line.getId());
//            line.setQuantity(lineVo.getQuantity() + line.getQuantity());
//        }
        return pcsPoPlanLineMapper.updateByPrimaryKeySelective(line) !=0;
    }

    @Override
    public boolean isAllPoPlanFinished(Long poId) {
        int result = pcsPoPlanMapper.isAllPoPlanFinished(poId);
        if(result == 0){
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllReceivePo(Long poId) {
        int result = pcsPoPlanMapper.isAllReceivePo(poId);
        if(result == 0){
            return  true;
        }
        return false;
    }

    @Override
    public Boolean closePoPlanByPlanId(Long poPlandId) {
        PcsPoPlan pcsPoPlan = pcsPoPlanMapper.selectByPrimaryKey(poPlandId);
        if(pcsPoPlan != null && pcsPoPlan.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING_RECEIVE)){
            pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_CLOSED);
            pcsPoPlanMapper.updateByPrimaryKey(pcsPoPlan);
            facadeWhInner.colseCommandByReferenceCode(WhCommand.TYPE_PURCHASE_IN,pcsPoPlan.getCode());
            List<PcsPoPlan> pcsPoPlanList = findPcsPoPlanByPoId(pcsPoPlan.getPoId());
            boolean isUpdate = true;
            for(PcsPoPlan pcsPoPlan1:pcsPoPlanList){
                if(pcsPoPlan1.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING_IN) || pcsPoPlan1.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING_RECEIVE) || pcsPoPlan1.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING)){
                    isUpdate = false;
                    break;
                }
            }
            if(isUpdate){
                PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId());
                if(!pcsPurchaseOrder.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE)){
                    pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                    pcsPurchaseOrderService.update(pcsPurchaseOrder);
                }
            }
        }else{
            throw new RuntimeException("收货计划不存在或收货计划不是待收货状态");
        }
        return true;
    }

	@Override
	@Transactional
	public int createPoPlanFee(PcsPoPlanCost pcsPoPlanCost) {
		pcsPoPlanCost.setTotalPrice(pcsPoPlanCost.getUnitPrice().multiply(new BigDecimal(pcsPoPlanCost.getQuantity())));
		pcsPoPlanCost.setAvailable((byte) 1);
		updatePoTotalAmount(pcsPoPlanCost, 0);
		return pcsPoPlanCostMapper.insertSelective(pcsPoPlanCost);
	}

	@Override
	public List<PcsPoPlanCost> selectCostByPoPlanId(Integer poPlanId) {
		return pcsPoPlanCostMapper.selectCostByPoPlanId(poPlanId);
	}

	@Override
	public int updatePoTotalAmount(PcsPoPlanCost pcsPoPlanCost, int optType) {
		PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.findPoById(pcsPoPlanMapper.selectByPrimaryKey(pcsPoPlanCost.getPoPlanId().longValue()).getPoId());
		if(optType == 0) {
			pcsPurchaseOrder.setTotalAmount(pcsPurchaseOrder.getTotalAmount().add(pcsPoPlanCost.getTotalPrice()));
			pcsPurchaseOrder.setTotalAmountAfterTax(pcsPurchaseOrder.getTotalAmountAfterTax().add(pcsPoPlanCost.getTotalPrice()));
		} else {
			pcsPurchaseOrder.setTotalAmount(pcsPurchaseOrder.getTotalAmount().subtract(pcsPoPlanCost.getTotalPrice()));
			pcsPurchaseOrder.setTotalAmountAfterTax(pcsPurchaseOrder.getTotalAmountAfterTax().subtract(pcsPoPlanCost.getTotalPrice()));
		} 
		if(EmptyUtil.isNotEmpty(pcsPurchaseOrder.getCrossBorderFlag()) && pcsPurchaseOrder.getCrossBorderFlag() == 1) {
			return pcsPurchaseOrderService.update(pcsPurchaseOrder) ? 1 : 0;
		} 
		return 1;
		
	}

	@Override
	public int updatePoPlanFee(PcsPoPlanCost pcsPoPlanCost, int optType) {
		//删除
		if(optType == 1) {
			PcsPoPlanCost oldPcsPoPlanCost = pcsPoPlanCostMapper.selectByPrimaryKey(pcsPoPlanCost.getId());
			updatePoTotalAmount(oldPcsPoPlanCost, 1);
		}
		
		return pcsPoPlanCostMapper.updateByPrimaryKeySelective(pcsPoPlanCost);
	}
}
