/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanLineMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLineExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoPlanLineServiceImpl.java, v 0.1 2015-08-12 15:03
 */
@Service("pcsPoPlanLineService")
public class PcsPoPlanLineServiceImpl implements PcsPoPlanLineService, CheckAble {

    private final Logger log = LoggerFactory.getLogger(PcsPoPlanLineServiceImpl.class);

    @Autowired
    private PcsPoPlanLineMapper pcsPoPlanLineMapper;

    @Autowired
    private PcsSkuService pcsSkuService;


    @Override
    public PcsPoPlanLine buildFromVO(PcsPoPlanLineVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsPoPlanLine record = new PcsPoPlanLine();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    public PcsPoPlanLineVO buildFromModel(PcsPoPlanLine record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsPoPlanLineVO vo = new PcsPoPlanLineVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    @Override
    @Transactional
    public Long create(PcsPoPlanLine record) {
        if (check(record)) {
            if (check(record, true)) {
                record.setQuantity(0);
                record.setWasteQuantity(0);
                pcsPoPlanLineMapper.insertSelective(record);
                return record.getId();
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsPoPlanLine record) {
        if (check(record)) {
            if (check(record, false)) {
                return pcsPoPlanLineMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }

    @Override
    public List<PcsPoPlanLine> findPoPlanLineByPoPlanId(long poPlanId) {
        PcsPoPlanLineExample example = new PcsPoPlanLineExample();
        example.createCriteria().andPoPlanIdEqualTo(poPlanId);
        final List<PcsPoPlanLine> list = pcsPoPlanLineMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        } else {
            return list;
        }
    }

    @Override
    public List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanId(long poPlanId) {
        List<PcsPoPlanLineVO> list = pcsPoPlanLineMapper.findPoPlanLineVOByPoPlanId(poPlanId);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        } else {
            return list;
        }
    }

    @Override
    public Boolean check(Object obj) {
        PcsPoPlanLine record = (PcsPoPlanLine) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(PcsPoPlanLine record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (isCreate && EmptyUtil.isEmpty(record.getPlanedQuantity())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "计划数量为空");
        }
        if (isCreate && EmptyUtil.isEmpty(record.getSkuCode())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "skuCode为空");
        }
        if (isCreate && EmptyUtil.isEmpty(pcsSkuService.findByCode(record.getSkuCode()))) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "skuCode数据库不存在");
        }
        return true;
    }

}
