/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import com.google.common.util.concurrent.AbstractScheduledService.Scheduler;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsBrandCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.service.purchase.service.PcsBrandService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCronService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSupplierService;
import com.thebeastshop.pegasus.service.purchase.vo.UserInfo;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;

/**
 * @author Eric.Lou
 * @version $Id: PcsCronServiceImpl.java, v 0.1 2015-08-18 21:46
 */
@Service("pcsCronService")
public class PcsCronServiceImpl implements PcsCronService {

    private final Logger log = LoggerFactory.getLogger(PcsCronServiceImpl.class);

    @Autowired
    private PcsPoPlanService pcsPoPlanService;
    
    @Autowired
    private PcsSkuService pcsSkuService;
    
    @Autowired
    private PcsSupplierService pcsSupplierService;
    
    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;
    
    @Autowired
    private PcsBrandService pcsBrandService;
    
    @Autowired
    private TaskExecutor scheduler;

    @Override
    public void cronSynPoPlanAndLine() {
        List<PcsPoPlan> poPlanList = pcsPoPlanService.findPoPlanByStatus(PcsPoPlan.PLAN_STATUS_WAITING_IN);
        if (CollectionUtils.isNotEmpty(poPlanList)) {
            for (PcsPoPlan poPlan : poPlanList) {
                try {
                    pcsPoPlanService.synPoPlanAndLine(poPlan);
                } catch (Exception e) {
                    log.error("", e);
                }
            }
        }
    }

	@Override
	public void cronSendApprovalEmail() {
		//SKU审核记录数
		PcsSkuCond cond = new PcsSkuCond();
		cond.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
		long skuQuantity = pcsSkuService.countSkuByCond(cond);
		//财务审批供应商记录数
		PcsSupplierCond pcsSupplierCond = new PcsSupplierCond();
		pcsSupplierCond.setSupplierOrderStatus(2);
		long financeSupplierQuantity = pcsSupplierService.countByCond(pcsSupplierCond);
		String emailContent = "您有";
		if(financeSupplierQuantity != 0L || skuQuantity != 0L) {
			
			if( skuQuantity  != 0L) {
				emailContent += skuQuantity + "个SKU";
			}
			if(financeSupplierQuantity != 0L) {
				if( skuQuantity  != 0L) { 
					emailContent += "、";
				}
				emailContent += financeSupplierQuantity + "个供应商";
			}
			emailContent += "需要审批，请尽快审批。</br>去审批：http://scm.thebeastshop.com";
			//emailContent +="(财务)";
			//给财务发送邮件
			sendNotice("finance.Approval.Email", null, emailContent);
		}
		
		//planner，待审核采购单
		PcsPurchaseOrderCond pcsPurchaseOrderCond = new PcsPurchaseOrderCond();
		pcsPurchaseOrderCond.setPoStatus(2);
		long pcsPurchaseOrderQuantity = pcsPurchaseOrderService.countByCond(pcsPurchaseOrderCond);
		emailContent = "您有" + pcsPurchaseOrderQuantity +  "个采购单需要审批，请尽快审批。</br>去审批：http://scm.thebeastshop.com";
		if(pcsPurchaseOrderQuantity != 0L) {
			//emailContent +="(planning)";
			//给planning发送邮件
			sendNotice("planner.Approval.Email", null, emailContent);
		}
		PcsBrandCond pcsBrandCond = new PcsBrandCond();
		pcsBrandCond.setBrandStatus(2);
		long pcsBrandQuantity = pcsBrandService.countByCond(pcsBrandCond);
		emailContent = "您有" + pcsBrandQuantity +  "个品牌需要审批，请尽快审批。</br>去审批：http://scm.thebeastshop.com";
		if(pcsBrandQuantity != 0L) {
			//emailContent +="(法务)";
			//给法务发送邮件
			sendNotice("legal.Approval.Email", null, emailContent);
		}
		Map<Long, String> categoryManagerMap = new HashMap<>();
		CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.71");
		categoryManagerMap.put(71L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.351");
		categoryManagerMap.put(351L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.360");
		categoryManagerMap.put(360L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.345");
		categoryManagerMap.put(345L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.262");
		categoryManagerMap.put(262L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		/*categoryManagerMap.put(71L, "mingze.xia@thebeastshop.com, feng.guo@thebeastshop.com");
		categoryManagerMap.put(351L, "mingze.xia@thebeastshop.com, feng.guo@thebeastshop.com");
		categoryManagerMap.put(360L, "mingze.xia@thebeastshop.com, feng.guo@thebeastshop.com");
		categoryManagerMap.put(345L, "mingze.xia@thebeastshop.com, feng.guo@thebeastshop.com");
		categoryManagerMap.put(262L, "mingze.xia@thebeastshop.com, feng.guo@thebeastshop.com");*/
		
		//categoryManagerMap.put(1L, "feng.guo@thebeastshop.com");
		for(Map.Entry<Long, String> entry : categoryManagerMap.entrySet()) {
			pcsSupplierCond.setCategoryManager(entry.getKey());
			pcsSupplierCond.setSupplierOrderStatus(1);
			long supplierQuantity = pcsSupplierService.countByCond(pcsSupplierCond);
			pcsBrandCond.setCategoryManager(entry.getKey());
			pcsBrandCond.setBrandStatus(1);
			pcsBrandQuantity = pcsBrandService.countByCond(pcsBrandCond);
			emailContent =  "您有";
			UserInfo userInfo = new UserInfo();
			userInfo.setEmail(entry.getValue());
			if(pcsBrandQuantity != 0L || supplierQuantity != 0L) {
				if(supplierQuantity != 0L) {
					emailContent += supplierQuantity + "个供应商";
				}
				if(pcsBrandQuantity != 0L) {
					if(supplierQuantity != 0L) {
						emailContent += "、";
					}
					emailContent += pcsBrandQuantity + "个品牌";
				}
				emailContent += "需要审批，请尽快审批。</br>去审批：http://scm.thebeastshop.com";
				//emailContent += "(品类经理" + entry.getKey() + ")";
				sendNotice("", userInfo, emailContent);
			}
		}
		
	}
	
	   /**
     * 审批通知
     */
	
    private void  sendNotice(final String configKey, final UserInfo userInfo, final String content) {
    	scheduler.execute(new Runnable() {
			@Override
			public void run() {
				try {
		    		CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance()
		       				.findConfigByKey(configKey);
		    		System.out.println(configKey);
		    		
		     		String[] toNotifyUsers = {};
		     		if(EmptyUtil.isNotEmpty(commGlobalConfig)) {
		     			toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
		     		}
		    	
		    		EmailVO emailVO = new EmailVO();
		    		if(userInfo != null ) {
		     			String[]  categoryManager = userInfo.getEmail().split(",");
		     			emailVO.setToAddressList(Arrays.asList(categoryManager));
		    		} else {
		    			emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
		    		}
		    		emailVO.setSubject("审批提醒");
		    		emailVO.setContent(content);
		    		// 发邮件
		    		if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
		    			// 正式环境发邮件
		    			EmailUtil.getInstance().send(emailVO);
		    		}
				} catch (Exception e) {
					e.printStackTrace();
				}
		    	 
			}
		});
    	
    }
}
