package com.thebeastshop.pegasus.service.purchase.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateTagFieldMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateTagMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTag;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTagExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTagField;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTagFieldExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateSkuFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTagService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateSkuFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagEditVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagFieldValueVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintCerVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintSkuCerVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

@Service("csCertificateTagService")
public class PcsCertificateTagServiceImpl implements PcsCertificateTagService {
	
	@Autowired
	PcsCertificateTagMapper pcsCertificateTagMapper;
	
	@Autowired
	PcsCertificateTagFieldMapper pcsCertificateTagFieldMapper;
	
	@Autowired
	private PcsCertificateFieldService pcsCertificateFieldService;
	
	@Autowired
	private PcsCertificateSkuFieldService pcsCertificateSkuFieldService;
	
	
	/**
	 * 查询sku对应合格证标签信息
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 */
	public PcsCertificateTagEditVO getTagAndSkuBySkuCode(String skuCode){
		return pcsCertificateTagMapper.getTagAndSkuBySkuCode(skuCode);
	}
	
	/**
	 * 查询合格证对应字段
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 * @return
	 */
	public List<PcsCertificateTagFieldValueVO> getTagFieldsSkuBySkuCode(String skuCode){
		return pcsCertificateTagFieldMapper.getTagFieldsSkuBySkuCode(skuCode);
	}
	
	/**
	 * 新建标签
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 */
	public int saveCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag){
		pcsCertificateTagMapper.insertSelective(pcsCertificateTag);
		int id = pcsCertificateTag.getId();
		return id;
	}
	
	/**
	 * 更新标签状态
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 */
	public void updateCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag){
		pcsCertificateTagMapper.updateByPrimaryKeySelective(pcsCertificateTag);
	}
	
	
	/**
	 * 新建标签
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 */
	public void saveCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField){
		pcsCertificateTagFieldMapper.insertSelective(pcsCertificateTagField);
	}
	
	/**
	 * 更新标签状态
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 */
	public void updateCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField){
		pcsCertificateTagFieldMapper.updateByPrimaryKeySelective(pcsCertificateTagField);
	}

	/**
	 * 删除标签状态
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 */
	public void deleteCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField){
		PcsCertificateTagFieldExample example = new PcsCertificateTagFieldExample();
		PcsCertificateTagFieldExample.Criteria criteria = example.createCriteria();
		criteria.andCertificateTagIdEqualTo(pcsCertificateTagField.getCertificateTagId());
		pcsCertificateTagFieldMapper.deleteByExample(example);
	}
	
	/**
	 * 新增合格证
	 * @author yu.bao
	 * @date 2016年5月31日
	 * @param cond
	 * @return
	 */
	@Override
	public boolean addPcsCertificateTag(PcsCertificateTagVO vo) {
		pcsCertificateTagMapper.insert(vo);
		List<PcsCertificateTagFieldVO> tagFields = vo.getTagFields();
		if(EmptyUtil.isNotEmpty(tagFields)){
			for(PcsCertificateTagFieldVO field : tagFields){
				field.setCertificateTagId(vo.getId());
				pcsCertificateTagFieldMapper.insert(field);
			}
		}
		return true;
	}
	
	/**
	 * 更新合格证
	 * @author yu.bao
	 * @date 2016年5月31日
	 * @param cond
	 * @return
	 */
	@Override
	public boolean updatePcsCertificateTag(PcsCertificateTagVO vo) {
		//updateByPrimaryKey
		pcsCertificateTagMapper.updateByPrimaryKey(vo);
		PcsCertificateTagFieldExample example = new PcsCertificateTagFieldExample();
		example.createCriteria().andCertificateTagIdEqualTo(vo.getId());
		pcsCertificateTagFieldMapper.deleteByExample(example);
		List<PcsCertificateTagFieldVO> tagFields = vo.getTagFields();
		if(EmptyUtil.isNotEmpty(tagFields)){
			for(PcsCertificateTagFieldVO field : tagFields){
				field.setCertificateTagId(vo.getId());
				pcsCertificateTagFieldMapper.insert(field);
			}
		}
		return true;
	}

	
	/**
	 * 批量新增合格证
	 * @author yu.bao
	 * @date 2016年5月31日
	 * @param cond
	 * @return
	 */
	@Override
	public boolean addPcsCertificateTag(List<PcsCertificateTagVO> vos) {
		if(EmptyUtil.isNotEmpty(vos)){
			for(PcsCertificateTagVO vo : vos){
				PcsCertificateTagExample example = new PcsCertificateTagExample();
				example.createCriteria().andSkuCodeEqualTo(vo.getSkuCode());
				List<PcsCertificateTag> voList = pcsCertificateTagMapper.selectByExample(example);
				if(EmptyUtil.isEmpty(voList)){
					addPcsCertificateTag(vo);
				}else{
					PcsCertificateTag tag = voList.get(0);
					vo.setCreateTime(tag.getCreateTime());
					vo.setCreateUserId(tag.getCreateUserId());
					vo.setId(tag.getId());
					vo.setIsSubmit(tag.getIsSubmit());
					updatePcsCertificateTag(vo);
				}
				
			}
		}
		return true;
	}
	
	


	@Override
	public List<PcsCertificateFieldVO> getTagFieldsSkuByIds(List<Integer> ids) {
		List<PcsCertificateFieldVO>  list = new ArrayList<PcsCertificateFieldVO>();
		if(EmptyUtil.isNotEmpty(ids)) {
			for(Integer id : ids) {
				list.add(pcsCertificateFieldService.findPcsCertificateFieldById(id));
			}
		}
		return list;
	}

	/**
	 * 根据sku查询
	 * @author ztq
	 * @param tag
	 * @return List<PcsCertificateTag> 
	 */
	public PcsCertificateTagVO searchTagBySkuCode(PcsCertificateTag tag){
		PcsCertificateTagExample example = new PcsCertificateTagExample();
		example.createCriteria().andSkuCodeEqualTo(tag.getSkuCode());

		List<PcsCertificateTag> list = pcsCertificateTagMapper.selectByExample(example);
		PcsCertificateTagVO vo = null;
		if(!CollectionUtils.isEmpty(list)){
			vo = new PcsCertificateTagVO();
			vo.setCertificateSize(list.get(0).getCertificateSize());
			vo.setCheckStatus(list.get(0).getCheckStatus());
			vo.setCreateTime(list.get(0).getCreateTime());
			vo.setId(list.get(0).getId());
			vo.setImgUrl(list.get(0).getImgUrl());
			vo.setIsHasTag(list.get(0).getIsHasTag());
			vo.setIsSubmit(list.get(0).getIsSubmit());
		}
		
		return vo;
	}

	@Override
	public List<PcsCertificateTagVO> getCertificateTagBySkuCodes(
			List<String> skuCodes) {
		List<PcsCertificateTagVO> tagList = pcsCertificateTagMapper.getPcsCertificateTagBySkuCodes(skuCodes);
		List<Integer> tagIds = new ArrayList<>();
		if(EmptyUtil.isNotEmpty(tagList)){
			for(PcsCertificateTagVO tagVo : tagList){
				tagIds.add(tagVo.getId());
			}
		}
		if(EmptyUtil.isNotEmpty(tagIds)){
			List<PcsCertificateTagFieldValueVO> fieldValueList =  pcsCertificateTagFieldMapper.getTagFieldByTagIds(tagIds);
			if(EmptyUtil.isNotEmpty(fieldValueList)){
				for(PcsCertificateTagVO tagVo : tagList){
					tagVo.setTagFieldValues(filterTagFieldValueList(fieldValueList,tagVo.getId()));
				}
			}
		}
		return tagList;
	}
	
	@Override
	public List<PcsCertificateTagVO> getTagBySkuCodeBarCode(PrintCerVO cond) {
		if(EmptyUtil.isEmpty(cond) || EmptyUtil.isEmpty(cond.getSkuInfos())){
			return new ArrayList<PcsCertificateTagVO>();
		}
		List<PrintSkuCerVO> skuCodeBarcordList = cond.getSkuInfos();
		Set<String> skuCodes = new HashSet<>();
		for(PrintSkuCerVO sb : skuCodeBarcordList){
			skuCodes.add(sb.getSkuCode());
		}
		//获取标签及标签字段值但不包含从系统获取值
		List<PcsCertificateTagVO> tagList = getCertificateTagBySkuCodes(Arrays.asList(skuCodes.toArray(new String[0])));
		if(EmptyUtil.isEmpty(tagList)){
			return new ArrayList<PcsCertificateTagVO>();
		}
		List<Integer> tagIds = new ArrayList<>();
		if(EmptyUtil.isNotEmpty(tagList)){
			for(PcsCertificateTagVO tagVo : tagList){
				tagIds.add(tagVo.getId());
			}
		}
		List<PcsCertificateTagVO> result = new ArrayList<>();
		for(PrintSkuCerVO skuCodeBarCode : skuCodeBarcordList){
			for(PcsCertificateTagVO tag : tagList){
				if(tag.getSkuCode().equals(skuCodeBarCode.getSkuCode())){
					//拷贝熟悉
					PcsCertificateTagVO cer = new PcsCertificateTagVO();
					BeanUtils.copyProperties(tag, cer);
					if(EmptyUtil.isNotEmpty(tag.getTagFieldValues())){
						List<PcsCertificateTagFieldValueVO> fieldValues = new ArrayList<>();
						for(PcsCertificateTagFieldValueVO f : tag.getTagFieldValues()){
							PcsCertificateTagFieldValueVO field = new PcsCertificateTagFieldValueVO();
							BeanUtils.copyProperties(f, field);
							fieldValues.add(field);
						}
						cer.setTagFieldValues(fieldValues);
					}
					cer.setBarCode(skuCodeBarCode.getBarCode());
					result.add(cer);
					break;
				}
			}
		}
		//获取系统值
		if(EmptyUtil.isNotEmpty(result)){
			for(PcsCertificateTagVO tag : result){
				List<PcsCertificateTagFieldValueVO> tagFieldValues = tag.getTagFieldValues();
				if(EmptyUtil.isEmpty(tagFieldValues)){
					continue;
				}
				for(PcsCertificateTagFieldValueVO fieldValueVO : tagFieldValues){
					if(PcsCertificateFieldVO.WRITE_TYPE_SYS.equals(fieldValueVO.getWriteType())){
						PcsCertificateSkuFieldVO fieldInfo = pcsCertificateSkuFieldService.getPcsCertificateSkuFieldVOById(fieldValueVO.getSkuFieldId());
						String value = pcsCertificateSkuFieldService.getFieldValueBySkuCodeBarCode(fieldInfo, tag.getSkuCode(), tag.getBarCode());
						fieldValueVO.setCertificateFieldValue(value);
					}
				}
			}
		}
		
		return result;
	}
	
	
	private List<PcsCertificateTagFieldValueVO> filterTagFieldValueList(List<PcsCertificateTagFieldValueVO> fieldValueList,Integer tagId){
		List<PcsCertificateTagFieldValueVO> values = new ArrayList<>();
		for(PcsCertificateTagFieldValueVO value : fieldValueList){
			if(tagId.equals(value.getTagId())){
				values.add(value);
			}
		}
		return values;
	}

	
}
