package com.thebeastshop.pegasus.service.purchase.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateSkuFieldMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateSkuField;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateSkuFieldExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateSkuFieldService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateSkuFieldVO;

@Service("pcsCertificateSkuFieldService")
public class PcsCertificateSkuFieldServiceImpl implements PcsCertificateSkuFieldService{

	@Autowired
	private PcsCertificateSkuFieldMapper pcsCertificateSkuFieldMapper;
	
	@Override
	public List<PcsCertificateSkuField> findAll() {
		PcsCertificateSkuFieldExample example = new PcsCertificateSkuFieldExample();
		example.createCriteria();
		return pcsCertificateSkuFieldMapper.selectByExample(example);
	}

	@Override
	public List<PcsCertificateSkuField> findAllSysField() {
		PcsCertificateSkuFieldExample example = new PcsCertificateSkuFieldExample();
		example.createCriteria().andFieldTypeEqualTo(2);
		return pcsCertificateSkuFieldMapper.selectByExample(example);
	}

	@Override
	public List<PcsCertificateSkuField> findAllSkuField() {
		PcsCertificateSkuFieldExample example = new PcsCertificateSkuFieldExample();
		example.createCriteria().andFieldTypeEqualTo(1);
		return pcsCertificateSkuFieldMapper.selectByExample(example);
	}

	@Override
	public String getFieldValueBySkuCode(PcsCertificateSkuFieldVO field,
			String skuCode) {
		return getFieldValueBySkuCodeBarCode(field,skuCode,"");
	}
	
	@Override
	public String getFieldValueBySkuCodeBarCode(PcsCertificateSkuFieldVO field,
			String skuCode,
			String barCode) {
		String sql = field.getFieldTable();
		sql = sql.replaceAll("[?]", "'"+skuCode+"'");
		sql = sql.replaceAll("[#]", "'"+barCode+"'");
		return pcsCertificateSkuFieldMapper.getQueryValue(sql);
	}

	@Override
	public PcsCertificateSkuFieldVO getPcsCertificateSkuFieldVOById(Integer id) {
		return pcsCertificateSkuFieldMapper.getPcsCertificateSkuFieldVOById(id);
	}

}
