package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PcsBuyerCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsBuyerInfoMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.PcsBuyerInfo;
import com.thebeastshop.pegasus.service.purchase.model.PcsBuyerInfoExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsBuyerInfoService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.UserInfo;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by devin.li on 2016/2/12.
 */
@Service("pcsBuyerInfoService")
public class PcsBuyerInfoServiceImpl implements PcsBuyerInfoService {

    @Autowired
    private PcsBuyerInfoMapper pcsBuyerInfoMapper;


    @Override
    public PcsBuyerInfoVO getBuyerInfoById(Long id) {
        PcsBuyerInfo buyerInfo = pcsBuyerInfoMapper.selectByPrimaryKey(id);
        return BeanUtil.buildFrom(buyerInfo,PcsBuyerInfoVO.class);
    }

    @Override
    public List<PcsBuyerInfoVO> getAllBuyers() {
        PcsBuyerInfoExample example = new PcsBuyerInfoExample();
        example.createCriteria().getAllCriteria();
        List<PcsBuyerInfo> buyerInfoVOs = pcsBuyerInfoMapper.selectByExample(example);
        return BeanUtil.buildListFrom(buyerInfoVOs, PcsBuyerInfoVO.class);
    }

    @Override
    public List<Map<String, String>> getAllBuyerInfos() {
        List<PcsBuyerInfoVO> buyers = getAllBuyers();
        List<Map<String,String>> buyerInfos = new ArrayList<>();
        for(PcsBuyerInfo buyer : buyers){
            Map<String,String> buyerInfoMap = new HashMap<>();
            buyerInfoMap.put("value",buyer.getId().toString());
            buyerInfoMap.put("text",buyer.getRealName());
            buyerInfoMap.put("loginUserId",String.valueOf(buyer.getLoginUserId()));
            buyerInfos.add(buyerInfoMap);
        }
        if (CollectionUtils.isEmpty(buyerInfos)) return Collections.EMPTY_LIST;
        return buyerInfos;
    }

    @Override
    public List<PcsBuyerInfoVO> getBuyerByCond(PcsBuyerCond cond) {
        return pcsBuyerInfoMapper.getBuyerInfoByCond(cond);
    }

    @Override
    public Boolean newBuyer(PcsBuyerInfo buyerInfo) {
        if (pcsBuyerInfoMapper.insertSelective(buyerInfo)>0)
        return true;
        else{
          throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_DELETE_DB,"保存失败");
        }
    }

    @Override
    public Boolean updateBuyerInfo(PcsBuyerInfo buyer) {
        if (pcsBuyerInfoMapper.updateByPrimaryKeySelective(buyer) > 0)
            return true;
        else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_DELETE_DB, "更新失败");
        }
    }

	@Override
	public UserInfo findCategoryManagerByBuyer(Integer buyerId) {
		return pcsBuyerInfoMapper.selectCategoryManagerByBuyer(buyerId);
	}

}

