/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.FpcsConsumableAllotMapper;
import com.thebeastshop.pegasus.service.purchase.dao.FpcsSkuOrderMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.*;
import com.thebeastshop.pegasus.service.purchase.service.*;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCond;
import com.thebeastshop.pegasus.service.purchase.vo.FlowerSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuVO;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author jim.huang
 * @version $Id: FpcsSkuServiceImpl.java, v 0.1 2015-08-03 18:24
 */
@Service("fpcsSkuServiceImpl")
public class FpcsSkuServiceImpl implements FpcsSkuService, CheckAble, CodeAble {

    private final Logger log = LoggerFactory.getLogger(FpcsSkuServiceImpl.class);

    @Autowired
    private PcsSkuMapper pcsSkuMapper;

    @Autowired
    private FpcsSkuOrderMapper fpcsSkuOrderMapper;

    @Autowired
    private PcsSkuSalesPriceChangeService pcsSkuSalesPriceChangeService;

    @Autowired
    private PcsSkuCustomMadeService pcsSkuCustomMadeService;

    @Autowired
    private PcsBrandService pcsBrandService;

    @Autowired
    private PcsSkuCategoryService pcsSkuCategoryService;

    @Autowired
    private FpcsConsumableAllotMapper fpcsConsumableAllotMapper;

    @Override
    public PcsSkuVO buildFromModel(PcsSku record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsSkuVO vo = new PcsSkuVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    @Override
    public FpcsSkuOrder bulidFromVO(FlowerSkuVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        FpcsSkuOrder record = new FpcsSkuOrder();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    @Transactional
    public Long create(FpcsSkuOrder record) {
        try {
            if (check(record)) {
                if (check(record, true)) {
                    initDefaultValue(record);
                    try {
                        //查询是否有一样的skucode
                        FpcsSkuOrder queryCriterial = new FpcsSkuOrder();
                        queryCriterial.setSkuCode(record.getSkuCode());
                        FpcsSkuOrder oldFlowerSku = fpcsSkuOrderMapper.getFlowerSkuByQuery(queryCriterial);
                        if(oldFlowerSku!=null){
                            record.setId(oldFlowerSku.getId());
                            fpcsSkuOrderMapper.updateByPrimaryKey(record);
                            return record.getId();
                        }else{
                            Long id = Long.valueOf(fpcsSkuOrderMapper.insertSelective(record));
                            return id;
                        }
                    } catch (Exception e) {
                        log.error(e.getMessage());
                    }
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage());
        }
        return null;
    }

    @Override
    @Transactional
    public List<Long> createSkus(List<FpcsSkuOrder> list) {
        //清除之前导入的鲜花sku
        fpcsSkuOrderMapper.deleteAllData();
        List<Long> ids = new ArrayList<Long>();
        for (FpcsSkuOrder pcsSku : list) {
            ids.add(create(pcsSku));
        }
        return ids;
    }

    private void initDefaultValue(FpcsSkuOrder record) {
        record.setCreatTime(new Date());
    }

    @Override
    @Transactional
    public boolean update(FpcsSkuOrder record) {
        /*if (check(record)) {
            if (check(record, false)) {
                PcsSku oldRecord = findById(record.getId());
                if (EmptyUtil.isNotEmpty(record.getSalesPrice()) && !record.getSalesPrice().equals(oldRecord.getSalesPrice())) {
                    if (canUpdateSalesPrice(record.getCode())) {
                        pcsSkuSalesPriceChangeService.create(record.getCode(), record.getSalesPrice());
                        record.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
                    }
                }
                setNonField(record);
                boolean result = pcsSkuMapper.updateByPrimaryKeySelective(record) != 0;
                if (result) {
                    //更新成功后更新图片名称
                    if (EmptyUtil.isNotEmpty(record.getPictureFileId())) {
                        PegasusUtilFacade.getInstance().modifyFileName(record.getPictureFileId(), oldRecord.getCode() + ".jpg");
                    }
                }
                return result;
            }
        }*/
        return false;
    }

    private void setNonField(PcsSku record) {
        record.setSalesPrice(null);
        record.setCode(null);
        record.setSkuType(null);
        record.setIsImported(null);
        record.setIsMadeBySelf(null);
    }

    /**
     * 是否可以更新售价
     *
     * @param code
     * @return
     */
    @Override
    public Boolean canUpdateSalesPrice(String code) {
        List<PcsSkuSalesPriceChange> processingPriceList = pcsSkuSalesPriceChangeService.findByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (processingPriceList.size() > 0) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * 售价变更审批
     *
     * @param code
     * @param isPass
     * @return
     */
    @Override
    @Transactional
    public Boolean auditSkuSalesPriceChange(String code, Boolean isPass) {
        PcsSkuVO pcsSkuVO = findByCode(code);
        if (EmptyUtil.isEmpty(pcsSkuVO)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "sku实体为空");
        }
        if (!pcsSkuVO.getSkuStatus().equals(PcsSku.SKU_STATUS_WAITING_VERIFY)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "必须是待审核状态");
        }
        PcsSkuSalesPriceChange pcsSkuSalesPriceChange = pcsSkuSalesPriceChangeService.auditSkuSalesPriceChange(code, isPass);
        PcsSku pcsSku = new PcsSku();
        pcsSku.setId(pcsSkuVO.getId());
        if (pcsSkuSalesPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_SUCCESS)) {
            pcsSku.setSkuStatus(PcsSku.SKU_STATUS_ABLE);
            pcsSku.setSalesPrice(pcsSkuSalesPriceChange.getNewPrice());
        } else if (pcsSkuSalesPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_REJECT)) {
            pcsSku.setSkuStatus(PcsSku.SKU_STATUS_REJECT);
        }
        pcsSkuMapper.updateByPrimaryKeySelective(pcsSku);
        return true;
    }

    @Override
    public PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        return pcsSkuSalesPriceChangeService.buildFromModel(pcsSkuSalesPriceChangeService.findSkuSalesPriceChangeByCodeAndProcessing(code));
    }

    @Override
    public List<PcsSku> findSkuByCodes(List<String> codes) {
        List<PcsSku> recordList = new ArrayList<PcsSku>();
        for (String code : codes) {
            PcsSku record = findSkuByCode(code);
            if (EmptyUtil.isNotEmpty(record) && EmptyUtil.isNotEmpty(record.getId())) {
                recordList.add(record);
            }
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    @Transactional
    public Boolean convertSku(PcsSku sku, long skuCustomMadeId) {
        PcsSkuCustomMade pcsSkuCustomMade = pcsSkuCustomMadeService.findById(skuCustomMadeId);
        sku.setIsJit(0);
        if (EmptyUtil.isNotEmpty(pcsSkuCustomMade) && pcsSkuCustomMade.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_WAITING_CONVERT)) {
            if (true) {
                pcsSkuCustomMade.setSkuStatus(PcsSkuCustomMade.SKU_STATUS_CONVERT);
                if (pcsSkuCustomMadeService.update(pcsSkuCustomMade)) {
                    return true;
                } else {
                    throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "sku定制单更新失败");
                }
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "sku创建失败");
            }
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "状态必须是待转换");
        }
    }

    private PcsSku findSkuByCode(String code) {
        PcsSkuExample example = new PcsSkuExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsSku> recordList = pcsSkuMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return null;
        } else {
            if (recordList.size() > 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_DUPLICATE, " 根据code[" + code + "]能查出2条以上(含两条)记录");
            } else {
                return recordList.get(0);
            }
        }
    }

    @Override
    public PcsSku findById(long id) {
        if (EmptyUtil.isEmpty(id)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return pcsSkuMapper.selectByPrimaryKey(id);
    }

    @Override
    public PcsSkuVO findByCode(String code) {
        if (EmptyUtil.isEmpty(code)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        List<PcsSkuVO> voList = pcsSkuMapper.findSkuByCodes(Arrays.asList(new String[]{code}));
        if (CollectionUtils.isEmpty(voList)) {
            return null;
        } else {
            if (voList.size() > 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_DUPLICATE, " 根据code能查出2条以上(含两条)记录");
            } else {
                return voList.get(0);
            }
        }
    }

    @Override
    public List<PcsSkuVO> findByNameOrCode(String arg0) {
        if (EmptyUtil.isEmpty(arg0)) {
            return Collections.emptyList();
        }
        List<PcsSkuVO> voList = pcsSkuMapper.findSkuByNameOrCode(arg0);
        if (CollectionUtils.isEmpty(voList)) {
            return Collections.emptyList();
        } else {
            return voList;
        }
    }

    @Override
    public List<PcsSkuVO> findByCond(PcsSkuCond cond) {
        return pcsSkuMapper.findSkuByCond(cond);
    }

    @Override
    public List<FpcsSkuOrder> getAllFlowerSkuInfo() {
        return fpcsSkuOrderMapper.getAllFlowerSkuInfo();
    }

    @Override
    public List<FpcsSkuOrder> getFlowerSkuInfo(Map<String, Object> params) {
        return fpcsSkuOrderMapper.getFlowerSkuInfo(params);
    }

    @Override
    public List<FpcsSkuOrder> getFlowerSkuByCondition(Date time, String code) {
        return fpcsSkuOrderMapper.getFlowerSkuByCondition(time, code);
    }

    @Override
    public Boolean check(Object obj) {
        FpcsSkuOrder record = (FpcsSkuOrder) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(FpcsSkuOrder record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        /*if (!isCreate) {
            PcsSku oldRecord = pcsSkuMapper.selectByPrimaryKey(record.getId());
            if (NullUtil.isNotNull(oldRecord) && EmptyUtil.isNotEmpty(oldRecord.getPictureFileId()) && EmptyUtil.isNotEmpty(record.getPictureFileId()) && !oldRecord.getPictureFileId().equals(record.getPictureFileId())) {
                PegasusUtilFacade.getInstance().deleteFileById(oldRecord.getPictureFileId());
            }
        }*/
        return true;
    }

    private Boolean check(String code) {
        PcsSkuExample example = new PcsSkuExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsSku> recordList = pcsSkuMapper.selectByExample(example);
        if (recordList.size() == 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public String generateCode(Object id) {
        return null;
    }

/*
    private String generateSkuCode(PcsSku record) {
        String categoryCode = "";
        String createYear = "";
        Integer num = 0;
        String key = "";
        // 分类code
        PcsSkuCategory skuCategory = pcsSkuCategoryService.findBackCategoryById(record.getCategoryId());
        if(NullUtil.isNotNull(skuCategory)){
            categoryCode = skuCategory.getCode();
        }else{
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, " sku 品类无相关数据");
        }
        // 年份
        createYear = DateUtil.format(DateUtil.getNow(),"yyyy");
        createYear = createYear.substring(2);
        // 顺序号
        PcsSkuExample example = new PcsSkuExample();
        PcsSkuExample.Criteria criteria = example.createCriteria();
        criteria.andCodeLike(categoryCode+createYear+"%");
        example.setOrderByClause("id desc limit 1");
        List<PcsSku> skus = pcsSkuMapper.selectByExample(example);
        if(CollectionUtils.isEmpty(skus)){
            num = 1;
        }else{
            String tmp = skus.get(0).getCode();
            String prefix = categoryCode + createYear;
            int i = tmp.indexOf(prefix);
            tmp = tmp.substring(i+prefix.length());
            tmp = StringUtils.left(tmp,3);
            Integer _num = Integer.parseInt(tmp);
            _num++;
            num = _num;
        }
        // 识别码
        PcsBrand brand = pcsBrandService.findById(record.getBrandId());
        if(NullUtil.isNotNull(brand) && !NumberUtil.isNullOrZero(brand.getIsOwn())){
            // 自有品牌
            if(record.getSkuType().equals(PcsSku.SKU_TYPE_FINISHED_PRODUCT)){
                // 成品
                if(NumberUtil.isNullOrZero(record.getIsImported())){
                    // 非进口
                    if(!NumberUtil.isNullOrZero(record.getIsMadeBySelf())){
                        // 自产
                        key = "1";
                    }else{
                        // 非自产
                        key = "2";
                    }
                }else{
                    // 进口
                    if(!NumberUtil.isNullOrZero(record.getIsMadeBySelf())){
                        // 自产
                        key = "3";
                    }else{
                        // 非自产
                        key = "4";
                    }
                }
            }else{
                // 非成品
                key = "0";
            }
        }else{
            // 其他品牌
            if(record.getSkuType().equals(PcsSku.SKU_TYPE_FINISHED_PRODUCT)){
                // 成品
                if(!NumberUtil.isNullOrZero(record.getIsImported())){
                    // 进口
                    if(!NumberUtil.isNullOrZero(record.getIsMadeBySelf())){
                        // 自产
                        key = "5";
                    }else{
                        // 非自产
                        key = "6";
                    }
                }else{
                    // 非进口
                    if(!NumberUtil.isNullOrZero(record.getIsMadeBySelf())){
                        // 自产
                        key = "7";
                    }else{
                        // 非自产
                        key = "8";
                    }
                }
            }else{
                // 非成品
                key = "9";
            }
        }
        // 参数不能为空
        if(EmptyUtil.isEmpty(categoryCode)||EmptyUtil.isEmpty(createYear)|| NumberUtil.isNullOrZero(num)||EmptyUtil.isEmpty(key)){
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, " 生成skucode的参数不能为空");
        }
        // 填充map
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("categoryCode", categoryCode);
        params.put("createYear", createYear);
        params.put("num", num);
        params.put("key", key);
        String code = CodeGenerator.getInstance().generate("PCS_SKU", params);
        return code;
    }
*/

    @Override
    public List<PcsSkuVO> findByCodes(List<String> codes) {
        return EmptyUtil.isEmpty(codes) ? new ArrayList<PcsSkuVO>() : pcsSkuMapper
                .findSkuByCodes(codes);
    }

    /**
     * 所有SKU信息
     *
     * @return
     */
    @Override
    public List<PcsSkuInfoVO> allSkuInfo() {
        return pcsSkuMapper.allSkuInfo();
    }

    @Override
    public PcsSkuInfoVO findStockByCode(String skuCode) {
        return pcsSkuMapper.findStockByCode(skuCode);
    }

    @Override
    public FpcsSkuOrder findSkuById(long id) {
        return this.fpcsSkuOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    @Transactional
    public  int saveConsumableAllot(List<FpcsConsumableAllot> consumableAllotList){
        int i = 0;
        try {
            fpcsConsumableAllotMapper.deleteAllData();
            i = fpcsConsumableAllotMapper.insertConsumableList(consumableAllotList);
        } catch (Exception e) {
            log.error("【耗材导入失败！】"+e.getMessage());
        }
        return i;
    }

    @Override
    public List<FpcsConsumableAllot> getAllConsumableList(){
        return fpcsConsumableAllotMapper.selectAllConsumableList();
    }
}
