/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeCond;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeMaterialVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeVO;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PrdcRecipeService.java, v 0.1 2015-12-30 17:09
 */
public interface PrdcRecipeService {

    /**
     * 根据主键查找配方
     * @param id
     * @return
     */
    PrdcRecipeVO findRecipeVOById(Long id);

    /**
     * 根据配方ID查找配方行
     * @param recipeId
     * @return
     */
    List<PrdcRecipeMaterialVO> findRecipeMaterialVOByRecipeId(Long recipeId);

    /**
     * 根据条件查找配方
     * @param cond 条件
     * @param cascade 是否级联
     * @return
     */
    List<PrdcRecipeVO> findRecipeVOByCond(PrdcRecipeCond cond,Boolean cascade);

    /**
     * 创建配方
     *
     * @param vo
     * @return
     */
    Long create(PrdcRecipeVO vo);

    /**
     * 更新配方
     * @param vo
     * @return
     */
    Boolean update(PrdcRecipeVO vo);

    /**
     * 删除配方行数据
     * @param recipeId
     * @param recipeMaterialId
     * @return
     */
    Boolean deleteRecipeMaterial(Long recipeId,Long recipeMaterialId);

}
