/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.cond.PrdcJobCond;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJob;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLine;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobVO;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskVO;

import java.util.List;
import java.util.Map;

import org.springframework.transaction.annotation.Transactional;

/**
 * @author Eric.Lou
 * @version $Id: PrdcJobService.java, v 0.1 2016-01-04 上午11:17
 */
public interface PrdcJobService {

    /**
     * 根据主键查找任务
     * @param id
     * @return
     */
    PrdcJobVO findJobVOById(Long id);

    /**
     * 根据jobCode查找任务
     * @param code
     * @return
     */
    PrdcJobVO findJobVOByCode(String code);
    /**
     * 根据配方主键查找任务
     * @param recipeId
     * @param cascade 是否级联
     * @return
     */
    List<PrdcJobVO> findJobVOByRecipeId(Long recipeId, Boolean cascade);

    /**
     * 根据任务主键查找任务行
     * @param jobId
     * @return
     */
    List<PrdcJobLineVO> findJobLineVOByJobId(Long jobId);

    /**
     * 根据条件查找任务
     * @param cond 条件
     * @param cascade 是否级联
     * @return
     */
    List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond, Boolean cascade);
    /**
     * 根据条件查找任务
     * @param cond 条件
     * @return
     */
    List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond);

    /**
     * 创建任务,并创建占用
     *
     * @param vo
     * @return
     */
    Long create(PrdcJobVO vo);

    /**
     * 退回修改任务
     *
     * @param vo
     * @return
     */
    Boolean returnModify(PrdcJobVO vo);

    /**
     * 删除任务行数据
     * @param jobId
     * @param jobLineId
     * @return
     */
    Boolean deleteJobLine(Long jobId,Long jobLineId);

    /**
     * 退回修改_取消任务
     *
     * @param jobId
     * @return
     */
    Boolean cancelJobForStatusReturnModify(Long jobId);

    /**
     * 更新生产状态
     * @param jobVO
     * @param jobVO
     * @return
     */
    Boolean startProduction(PrdcJobVO jobVO);

    /**
     * 释放占用资源并更新JOB
     * @param jobVO
     * @param whReleaseOccupationVOList
     */
    Boolean releaseJobLineOccupyAndUpdate(PrdcJobVO jobVO,List<WhReleaseOccupationVO> whReleaseOccupationVOList);

    /**
     * 更新生产状态
     * @param jobVO
     * @return
     */
    Boolean updateJobVO(PrdcJobVO jobVO);

    /**
     *
     * @param jobVO
     * @param whCommands
     * @param whReleaseOccupationVOList
     * @return
     */
    Boolean createCommandsAfterReleaseThenFinishAndUpdate(PrdcJobVO jobVO,List<WhCommand> whCommands,
                                                          List<WhReleaseOccupationVO> whReleaseOccupationVOList)throws Exception;

    /**
     * 创建出库,仓库指令需要的参数
     * @param jobVO
     * @return whCommandList
     */
    public List<WhCommand> buildPrdcCommands(PrdcJobVO jobVO);

    /**
     *
     * @param prdcJobLineList
     * @param occupyType
     * @return
     */
    public List<WhReleaseOccupationVO> buildWhRelease(PrdcJob prdcJob,List<PrdcJobLine> prdcJobLineList, Integer occupyType);

    /**
     * 建立库存占用whOccupy
     * @param prdcJobLineList
     * @param warehouseCode
     * @param occupyType
     * @return
     */
    public List<WhInvOccupy> buildWhOccupy(PrdcJob prdcJob,List<PrdcJobLine> prdcJobLineList, String warehouseCode, Integer occupyType);

    /**
     * 获取仓库名称/编码键值对
     * @return
     */
    public List<Map<String, String>> getWarehouseList(List<String> warehouseCodeList);

    /**
     * 获取配送仓库名称
     * @return
     */
    public String getWarehouseName(String warehouseCode);


    /**
     * 获取单张生产订单最大可启动子任务数
     * @param vo
     * @return
     */
    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo);
    /**
     * 子任务完成时更新加工订单
     * */
    @Transactional
    boolean updatePrdcJobWhenTaskFinish(WhWmsPrdcJobTaskVO vo);

    public List<Map<String,Object>> getWmsPrdcJobTaskFinishedInfo(List<String> prdcJobCodes);

    List<PrdcJob> getPrdcJobProcessingOrPartFinished(List<String> codes);

    /**
     *
     * @param prdcJobLineVOList
     * @param occupyType
     * @return
     */
    public List<WhReleaseOccupationVO> buildWhRelease(List<PrdcJobLineVO> prdcJobLineVOList, Integer occupyType);

    /**
     * 建立库存占用whOccupy
     * @param prdcJobLineVOList
     * @param warehouseCode
     * @param occupyType
     * @return
     */
    public List<WhInvOccupy> buildWhOccupy(List<PrdcJobLineVO> prdcJobLineVOList, String warehouseCode, Integer occupyType);
    /**
     * 更新生产状态
     * @param jobVO
     * @param whInvOccupyList
     * @return
     */
    Boolean checkOccupyAndUpdate(PrdcJobVO jobVO,List<WhInvOccupy> whInvOccupyList);
    
    List<Long> batchCreate(List<PrdcJobVO> list);
    
    List<PrdcJob> findSkuReportJobVO();
}
