package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.cond.PcsWatermarkCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuWatermark;
import com.thebeastshop.pegasus.service.purchase.model.ProdWatermark;
import com.thebeastshop.pegasus.service.purchase.vo.ProdSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsWatermarkVO;
import com.thebeastshop.pegasus.service.purchase.vo.ProductWatermarkVO;

import java.util.List;
import java.util.Map;

import javax.management.OperationsException;

/**
 * Created by Administrator on 2016/5/6.
 * @author gongjun
 * @since 2016-05-06
 */
public interface PcsWatermarkService {

    int addIcon(PcsWatermarkVO watermarkVO);

    int updateIcon(PcsWatermarkVO watermarkVO);

    int updateSkuWatrmarkByCodeList(String skuCode, List<String> codeList);
    
    int updateProdWatrmarkByCodeList(ProdSkuVO prod, List<String> watermarkCodeList,boolean isEmptyBeforeUpdate);

    int saveOrUpdateSkuWatermark(PcsSkuWatermark skuWatermark);

    PcsWatermarkVO findWatermarkById(Long id);

    List<PcsWatermarkVO> queryWatermarkList(Map<String, Object> params);
    
    List<ProdSkuVO> queryProdWatermarkList(PcsWatermarkCond cond);
    
    List<ProdSkuVO> querySkuListByProd(Long prodId);
    
    List<ProdSkuVO> queryProdListBySkuCode(String code);
    
	int deleteProdWatermarkByIds(List<String> idList);

	int saveOrUpdateProdWatermark(ProdWatermark prodWatermark) throws OperationsException;

	List<ProdSkuVO> queryProdWatermarkListByParams(List<String> params);

	ProdSkuVO queryProductByProdId(Long prodId);

    /**
     * 通过 productcodes 查询  可以使用的水印 标签
     * @author lijing
     * @time 2016-09-10 20:11
     * @param productCodes
     * @return
     */
    Map<String,ProductWatermarkVO> seleckWatermarkByProductCodes(List<String> productCodes);
}
