package com.thebeastshop.pegasus.service.purchase.service;

import java.util.List;

import com.thebeastshop.pegasus.service.purchase.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsSupplier;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSupplierVO;

/**
 * @author Eric.Lou
 * @version $Id: PcsSupplierService.java, v 0.1 2015-07-27 17:51
 */
public interface PcsSupplierService {

    /**
     * vo转成model
     *
     * @param vo
     * @return
     */
    PcsSupplier buildFromVO(PcsSupplierVO vo);

    /**
     * model转成vo
     * @param record
     * @return
     */
    PcsSupplierVO buildFromModel(PcsSupplier record);

    /**
     * 创建供应商
     *
     * @param record
     * @return
     */
    Long create(PcsSupplier record, boolean saveDraft);

    /**
     * 更新供应商
     *
     * @param record
     * @return
     */
    Boolean update(PcsSupplier record, boolean saveDraft);

    /**
     * 根据ID查找供应商
     *
     * @param id
     * @return
     */
    PcsSupplier findById(Long id);

    /**
     * 根据供应商名称和状态查找供应商
     *
     * @param cond
     * @return
     */
    List<PcsSupplierVO> findByCond(PcsSupplierCond cond);

    /**
     * 根据条件查找供应商
     *
     * @param cond
     * @return
     */
    List<PcsSupplier> findByCriteria(PcsSupplierCond cond);

    /**
     * 根据名称查找供应商
     *
     * @param name
     * @return
     */
    List<PcsSupplier> findByName(String name);

    /**
     * 根据id集合查找供应商
     *
     * @param ids
     * @return
     */
    List<PcsSupplier> findByIds(List<Long> ids);

    /**
     * 供应商审核
     * @param id
     * @param isPass
     * @return
     */
    Boolean audiSupplier(Long userId, long id, Boolean isPass, Integer type);
    
    long countByCond(PcsSupplierCond cond);
}
