/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service;

import java.util.List;
import java.util.Map;

import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuBarcode;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuVO;

/**
 * @author Eric.Lou
 * @version $Id: PcsSkuService.java, v 0.1 2015-08-03 下午06:13
 */
public interface PcsSkuService {

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsSkuVO buildFromModel(PcsSku record);

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsSku bulidFromVO(PcsSkuVO vo);

    /**
     * 创建sku
     *
     * @param record
     * @return
     */
    Long create(PcsSku record);

    /**
     * 批量创建SKU
     * @param list
     * @return
     */
    List<Long> createSkus(List<PcsSku> list);
    
    List<Long> updateSkus(List<PcsSkuVO> list);

    /**
     * 更新sku
     *
     * @param record
     * @return
     */
    boolean update(PcsSku record);

    /**
     * 根据主键查找sku
     *
     * @param id
     * @return
     */
    PcsSku findById(long id);

    /**
     * 根据CODE查找sku
     *
     * @param code
     * @return
     */
    PcsSkuVO findByCode(String code);

    PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories);
    
    List<Map<String,Object>> findSkuCanSaleAndCanSeeByChannelCode(String channelCode);
    
    Map<String,Object> findSkuCanSaleAndCanSeeInfo(String channelCode,String skuCode);

    /**
     * 根据参数查找sku
     * @param arg0
     * @return
     */
    List<PcsSkuVO> findByNameOrCode(String arg0);

    /**
     * 根据条件查找sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findByCond(PcsSkuCond cond);


    /**
     * 根据条件查找sku
     * 导出使用
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findByCondForExport(PcsSkuCond cond);

    /**
     * 根据条件查找sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findSkuTagByCond(PcsSkuCond cond);
    /**
     * 是否可以更新售价
     *
     * @param code
     * @return
     */
    Boolean canUpdateSalesPrice(String code);

    /**
     * 售价变更审批
     *
     * @param code
     * @param isPass
     * @return
     */
    Boolean auditSkuSalesPriceChange(String code, Boolean isPass);

    /**
     * 根据skucode查找 审批中的售价变更记录
     *
     * @param code
     * @return
     */
    PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code);

    /**
     * 根据CODE集合查找sku
     *
     * @param codes
     * @return
     */
    List<PcsSku> findSkuByCodes(List<String> codes);

    /**
     * 转换sku
     *
     * @param sku
     * @param skuCustomMadeId
     * @return
     */
    Boolean convertSku(PcsSku sku, long skuCustomMadeId);


    List<PcsSkuVO> findByCodes(List<String> codes);

    List<PcsSkuVO> findByCodes(List<String> codes, boolean withCategories);

    /**
     * 所有SKU信息
     *
     * @return
     */
    List<PcsSkuInfoVO> allSkuInfo();

    /**
     * 所有SKU信息
     *
     * @return
     */
    PcsSkuInfoVO findStockByCode(String skuCode);

    List<PcsSkuVO> findChannelSkuForNoDistribute(PcsSkuCond cond);

    void setSkuChannel(List<String> skuCodeList, List<String> channelCodeList,Long operatorId);
    
    List<PcsSkuVO> findSkuByIds(List<Long> ids);
    
    Boolean canUpdateCostPrice(String code);
    
    Boolean canUpdateSupplier(String code);
    
    /**
     * sku总数计算
     * @param cond
     * @return
     */
    long countSkuByCond(PcsSkuCond cond);
    
    /**
     * 创建sku barcode
     * @param barcodeList
     */
    void createPcsSkuBarcode(List<PcsSkuBarcode> barcodeList);
    
    
    List<PcsSkuBarcodeVO> selectByBarCode(String barCode);

	List<PcsSkuVO> findSkuAuditByIds(List<Long> ids);
}
