package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCostPriceChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSupplierChange;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuSalesPriceChangeVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsSkuSalesPriceChange.java, v 0.1 2015-08-05 14:41
 */
public interface PcsSkuSalesPriceChangeService {

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsSkuSalesPriceChangeVO buildFromModel(PcsSkuSalesPriceChange record);

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsSkuSalesPriceChange bulidFromVO(PcsSkuSalesPriceChangeVO vo);

    /**
     * 创建sku售价变动
     *
     * @param code
     * @return
     */
    Long create(String code, BigDecimal price);

    /**
     * 更新sku售价变动
     *
     * @param record
     * @return
     */
    boolean update(PcsSkuSalesPriceChange record);

    /**
     * 根据主键查找sku售价变动
     *
     * @param id
     * @return
     */
    PcsSkuSalesPriceChange findById(long id);

    /**
     * 根据CODE和STATUS查找sku售价变动
     *
     * @param code
     * @return
     */
    List<PcsSkuSalesPriceChange> findByCodeAndStatus(String code, Integer status);
    /**
     * 根据CODE查找sku售价变动
     *
     * @param code
     * @return
     */
    List<PcsSkuSalesPriceChange> findByCode(String code);
    
    List<PcsSkuCostPriceChange> findCostPriceChangeByCode(String code);
    
    List<PcsSkuSupplierChange> findSupplierChangeByCode(String code);

    /**
     * 售价变动审核
     *
     * @param code
     * @param isPass
     */
    PcsSkuSalesPriceChange auditSkuSalesPriceChange(String code, Boolean isPass);

    /**
     * 根据skucode查找 售价变更记录
     *
     * @param code
     * @return
     */
    PcsSkuSalesPriceChange findSkuSalesPriceChangeByCodeAndProcessing(String code);
    
    public Long createSupplierChange(String code, Integer price);
    
    public Long createCostPriceChange(String code, BigDecimal price);
    
    /**
     * 成本变动审核
     *
     * @param code
     * @param isPass
     */
    PcsSkuCostPriceChange auditSkuCostPriceChange(String code, Boolean isPass);
    
    /**
     * 供应商变动审核
     *
     * @param code
     * @param isPass
     */
    PcsSkuSupplierChange auditSkuSupplierChange(String code, Boolean isPass);
    
    
    List<PcsSkuCostPriceChange> findCostPriceChangeByCodeAndStatus(String code, Integer status);
    
    List<PcsSkuSupplierChange> findSupplierChangeByCodeAndStatus(String code, Integer status);

}
