package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCmSpl;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCustomMade;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCond;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCustomMadeVO;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsSkuCustomMade.java, v 0.1 2015-08-06 13:05
 */
public interface PcsSkuCustomMadeService {

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsSkuCustomMadeVO buildFromModel(PcsSkuCustomMade record);

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsSkuCustomMade bulidFromVO(PcsSkuCustomMadeVO vo);

    /**
     * 创建实体
     *
     * @param record
     * @return
     */
    PcsSkuCustomMade create(PcsSkuCustomMade record);

    /**
     * 更新实体
     *
     * @param record
     * @return
     */
    boolean update(PcsSkuCustomMade record);

    /**
     * 根据主键查找实体
     *
     * @param id
     * @return
     */
    PcsSkuCustomMadeVO findSkuCustomMadeById(long id);

    /**
     * 根据主键查找实体
     *
     * @param id
     * @return
     */
    PcsSkuCustomMade findById(long id);

    /**
     * 根据CODE查找实体
     * @param code
     * @return
     */
    PcsSkuCustomMade findSkuCustomMadeByCode(String code);

    /**
     * 根据条件查找实体
     *
     * @param cond
     * @return
     */
    List<PcsSkuCustomMadeVO> findSkuCustomMadeByCond(PcsSkuCond cond);

    /**
     * 创建SKU定制信息,包括SKU主题信息和供应商行信息
     *
     * @param pcsSkuCustomMade
     * @param pcsSkuCmSplList
     * @return
     */
    Boolean createCustomMadeAndLine(PcsSkuCustomMade pcsSkuCustomMade, List<PcsSkuCmSpl> pcsSkuCmSplList);

    /**
     * 更新SKU定制信息,包括SKU主题信息和供应商行信息
     *
     * @param pcsSkuCustomMade
     * @param pcsSkuCmSplList
     * @return
     */
    Boolean updateCustomMadeAndLine(PcsSkuCustomMade pcsSkuCustomMade, List<PcsSkuCmSpl> pcsSkuCmSplList);

    /**
     * 根据定制单ID和关联的供应商ID删除供应商信息
     *
     * @param skuCustomMadeId
     * @param skuCmSplId
     * @return
     */
    Boolean deletePcsCmSpl(long skuCustomMadeId, long skuCmSplId);

    /**
     * sku定制审批转换供应商
     *
     * @param skuCustomMadeId
     * @param skuCmSplId
     * @return
     */
    Boolean convertCustomMadeAndLine(long skuCustomMadeId, long skuCmSplId);

    /**
     * sku定制审批-驳回
     *
     * @param skuCustomMadeId
     * @return
     */
    Boolean rejectCustomMade(long skuCustomMadeId);

}
