package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCmSpl;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCmSplVO;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsSkuCustomMadeSupplier.java, v 0.1 2015-08-06 13:05
 */
public interface PcsSkuCmSplService {

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsSkuCmSplVO buildFromModel(PcsSkuCmSpl record);

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsSkuCmSpl bulidFromVO(PcsSkuCmSplVO vo);

    /**
     * 创建实体
     *
     * @param record
     * @return
     */
    Long create(PcsSkuCmSpl record);

    /**
     * 更新实体
     *
     * @param record
     * @return
     */
    boolean update(PcsSkuCmSpl record);

    /**
     * 根据主键查找实体
     *
     * @param id
     * @return
     */
    PcsSkuCmSpl findById(long id);

    /**
     * 根据sku定制单号查找实体
     *
     * @param skuCustomMadeId
     * @return
     */
    List<PcsSkuCmSplVO> findBySkuCustomMadeId(long skuCustomMadeId);

    /**
     * 根据ID删除实体
     *
     * @param id
     * @return
     */
    boolean deleteById(long id);

}
