package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCategory;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCategoryRelation;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCategoryRelationCond;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFrontBackCategoryVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCategoryVO;

import java.util.List;
import java.util.Map;

/**
 * @author Eric.Lou
 * @version $Id: PcsSkuCategory.java, v 0.1 2015-07-30 16:59
 */
public interface PcsSkuCategoryService {

    /**
     * vo转成model
     *
     * @param vo
     * @return
     */
    PcsSkuCategory bulidFromVO(PcsSkuCategoryVO vo);

    /**
     * model转成vo
     *
     * @param record
     * @return
     */
    PcsSkuCategoryVO bulidFromModel(PcsSkuCategory record);

    /**
     * 创建品类
     *
     * @param record
     * @return
     */
    Long create(PcsSkuCategory record);

    /**
     * 创建后台品类
     *
     * @param record
     * @return
     */
    Long createBackCategory(PcsSkuCategory record);


    /**
     * 更新品类
     *
     * @param record
     * @return
     */
    boolean update(PcsSkuCategory record);

    /**
     * 更新后台品类
     *
     * @param record
     * @return
     */
    boolean updateBackCategory(PcsSkuCategory record);


    /**
     * 根据主键查找分类,唯一
     *
     * @param id
     * @return
     */
    PcsSkuCategory findById(long id);

    PcsSkuCategory findBackCategoryById(long id);

    public List<PcsSkuCategory> findFrontCategoriesBySkuCode(String skuCode);

    public List<PcsSkuCategory> findBackCategoriesBySkuCode(String skuCode);

    List<PcsSkuCategory> findFrontCategoriesBySkuCodeList(List<String> skuCodeList);

    /**
     * 根据父id查找所有子数据
     *
     * @param parentId
     * @return
     */
    List<PcsSkuCategory> findAllChildrens(long parentId);

    /**
     * 根据父id查找所有后台类目子数据
     *
     * @param parentId
     * @return
     */
    List<PcsSkuCategory> findAllBackCategoryChildrens(long parentId);


    /**
     * 查出所有品类
     *
     * @return
     */
    List<PcsSkuCategory> findAll();


    /**
     * 查出所有品类
     *
     * @return
     */
    List<PcsSkuCategory> findAllFrontCategories();



    /**
     * 根据CODE查找品类
     *
     * @param code
     * @return
     */
    PcsSkuCategory findByCode(String code);

    /**
     * 根据名称查找品类
     *
     * @param name
     * @return
     */
    List<PcsSkuCategory> findByName(String name);


    /**
     * 根据名称查找后台品类
     *
     * @param name
     * @return
     */
    List<PcsSkuCategory> findBackCategoryByName(String name);



    /**
     * 根据id集合查找品类
     *
     * @param ids
     * @return
     */
    List<PcsSkuCategory> findByIds(List<Long> ids);


    /**
     * 根据id集合查找后台品类
     *
     * @param ids
     * @return
     */
    List<PcsSkuCategory> findBackCategoriesByIds(List<Long> ids);


    /**
     * 根据code 和 右like code查找分类
     *
     * @param code
     * @return
     */
    List<PcsSkuCategory> findByCodeAndRightLikeCode(String code);



    /**
     * 查找第一层sku品类
     *
     * @return
     */
    List<PcsSkuCategory> findSkuCategoryByParentIdIsNull();

    /**
     * 根据一父ID查找品类
     * @param parentID
     * @return
     */
    PcsSkuCategory findByParentID(Long parentID);

    List<Long> findProductIdsBySkuCodes(List<String> skuCodes);

    List<Long> findProductIdListByCategoryFrontRelationIds(List<Long> ids);

    List<PcsFrontBackCategoryVO> findFrontBackCategoryList(Map<String, Object> params);

    List<PcsSkuCategoryVO> findFrontCategoryList(Map<String, Object> params);

    List<PcsSkuCategoryVO> findBackCategoryList(Map<String, Object> params);

    List<PcsSkuCategoryRelation> findBackCategoryRelationList(PcsSkuCategoryRelationCond cond);

    void saveOrUpdateBackCategoryRelationList(List<PcsSkuCategoryRelation> relationList);

    void saveOrUpdateBackCategoryRelation(PcsSkuCategoryRelation relation);

    Integer addFrontCategoryRelation(PcsSkuCategoryRelation relation);

    Integer addBackCategoryRelation(PcsSkuCategoryRelation relation);

    Integer addFrontBackCategoryRelation(PcsFrontBackCategoryVO frontBackCategoryVO);

    Integer updateBackCategoryRelation(PcsSkuCategoryRelation relation);

    List<PcsSkuCategoryRelation> findFrontCategoryRelation(PcsSkuCategoryRelationCond cond);

    List<Long> findFrontCategoryIdListByBackCategoryId(Long backCategoryRelationId);

    List<Long> findFrontCategoryIdListByBackCategoryIds(List<Long> backCategoryRelationIds);

    List<Long> findBackCategoryIdListByFrontCategoryId(Long frontCategoryRelationId);

    Integer countOfFrontCategoryRelation(PcsSkuCategoryRelationCond cond);

    Integer updateFrontCategoryRelation(PcsSkuCategoryRelation relation);

    Integer deleteFrontCategoryRelationList(List<Long> idList);

    Integer deleteBackCategoryRelationList(List<Long> idList);
    
    /**
     * 插入前台类目表
     * @param map
     * @return
     */
    Long insertIntoCategoryFrontEntity(Map<String,Object> map);
    
    /**
     * 更新前台类目表
     * @param map
     * @return
     */
    Long updateCategoryFrontEntity(Map<String,Object> map);

}
