/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.model.PcsPoLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseOrderVO;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

/**
 * @author Eric.Lou
 * @version $Id: PcsPurchaseOrderService.java, v 0.1 2015-08-10 10:28
 */
public interface PcsPurchaseOrderService {

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsPurchaseOrder buildFromVO(PcsPurchaseOrderVO vo);

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsPurchaseOrderVO buildFromModel(PcsPurchaseOrder record);

    /**
     * 创建采购单
     *
     * @param record
     * @return
     */
    PcsPurchaseOrder create(PcsPurchaseOrder record,  boolean saveDraft);

    /**
     * 更新采购单
     *
     * @param record
     * @return
     */
    boolean update(PcsPurchaseOrder record);
    /**
     * 更新采购单(修改交货日期)
     *
     * @param record
     * @return
     */
    boolean updatePurchaseOrder(PcsPurchaseOrder record);

    /**
     * 根据主键查找订购单
     *
     * @param id
     * @return
     */
    PcsPurchaseOrder findPoById(long id);

    /**
     * 根据主键查找订购单
     *
     * @param id
     * @return
     */
    PcsPurchaseOrderVO findPoVOById(long id);
    
    /**
     * 根据采购单对于出入库指令code查找
     * @author jim.huang
     * @date 2016年4月22日
     * @param commandCode
     * @return
     */
    PcsPurchaseOrderVO findPurchaseOrderByCommandCode(String commandCode);

    /**
     * 根据主键查找订购单
     *
     * @param code
     * @return
     */
    PcsPurchaseOrder findPoByCode(String code);

    /**
     * 根据条件查找采购单
     * @param cond
     * @return
     */
    List<PcsPurchaseOrderVO> findPOVOByCond(PcsPurchaseOrderCond cond);

    /**
     * 创建采购单
     *
     * @param pcsPurchaseOrder
     * @param pcsPoLineList
     * @param saveDraft
     * @return
     */
    Long createPurchaseOrderAndLine(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, boolean saveDraft);

    /**
     * 更新采购单
     *
     * @param pcsPurchaseOrder
     * @param pcsPoLineList
     * @param saveDraft
     * @return
     */
    Boolean updatePurchaseOrderAndLine(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, boolean saveDraft);

    /**
     * 获取warehouseCode集合
     *
     * @return
     */
    List<String> findWarehouseCodeGroup();

    /**
     * 审核采购单
     *
     * @param id
     * @param isPass
     * @return
     */
    Boolean auditPurchaseOrder(long id, Boolean isPass, Integer type);

    /**
     * 关闭采购单,将状态置为已完成
     *
     * @param id
     * @return
     */
    Boolean closePurchaseOrder(long id);

    /**
     * 删除采购单行信息
     *
     * @param poId
     * @param pcsPoLineId
     * @return
     */
    Boolean deletePcsPoLine(long poId, long pcsPoLineId);
    
    void processReceicePlan(String poPlanCode, Map<String,Integer> liangpinMap, Map<String,Integer> canciMap);
    
    /**
     * 计算采购单数量
     * @param cond
     * @return
     */
    long countByCond(PcsPurchaseOrderCond cond);
}
