package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanCost;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoPlanService.java, v 0.1 2015-08-12 15:02
 */
public interface PcsPoPlanService {

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsPoPlan buildFromVO(PcsPoPlanVO vo);

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsPoPlanVO buildFromModel(PcsPoPlan record);
    
    /**
     * 更新收货计划的收货时间
     * @param id
     * @param Date
     * @return
     */
    boolean updatePcsPoPlanById(long id, String date);

    /**
     * 创建实体
     *
     * @param record
     * @return
     */
    PcsPoPlan create(PcsPoPlan record);

    /**
     * 更新实体
     *
     * @param record
     * @return
     */
    boolean update(PcsPoPlan record);

    /**
     * 根据主键查找实体
     *
     * @param id
     * @return
     */
    PcsPoPlan findPoPlanById(long id);

    /**
     * 根据主键查找实体VO
     *
     * @param code
     * @return
     */
    PcsPoPlan findPoPlanByCode(String code);

    /**
     * 根据状态查找实体
     * @param status
     * @return
     */
    List<PcsPoPlan> findPoPlanByStatus(Integer status);

    /**
     * 创建计划信息和计划行信息
     *
     * @param pcsPoPlan
     * @param pcsPoPlanLineList
     * @return
     */
    Boolean createPoPlanAndLine(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList)throws Exception;

    /**
     * 创建计划信息和计划行信息,并自动完成
     *
     * @param pcsPoPlan
     * @param pcsPoPlanLineList
     * @return
     */
    Boolean createPoPlanAndLineThenFinish(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList)throws Exception;

    /**
     * 根据采购单号查询所有收货计划
     *
     * @param poId
     * @return
     */
    List<PcsPoPlan> findPcsPoPlanByPoId(long poId);

    /**
     * 同步仓库指令数据
     *
     * @param poPlan
     * @return
     */
    Boolean synPoPlanAndLine(PcsPoPlan poPlan);

    /**
     * 导出收货计划状态~待入库
     * @return
     */
    byte[] exportPoPlanStatusWaitingIn();

    /**
     * 导出采购订单明细
     * @return
     */
    byte[] exportPoInfomation();

    /**
     * 更新采购单收货计划
     *
     * @return 是否成功
     */
    public boolean updatePoPlan(PcsPoPlan po);

    /**
     * 更新采购单收货计划行；
     *
     * @return 是否成功
     */
    public boolean updatePoPlanLine(PcsPoPlanLine line);
    /**
     * 通过采购单查询采购单所有的采购计划单是否都是收货完成
     * @param poId
     * @return
     */
    public boolean isAllPoPlanFinished(Long poId);
    /**
     * 通过采购单查询采购单收货数据是否完成
     * @param poId
     * @return
     */
    public boolean isAllReceivePo(Long poId);

    /**
     * 关闭收货计划
     * @param poPlandId
     * @return
     */
    @Transactional
    public Boolean closePoPlanByPlanId(Long poPlandId);
    
    int createPoPlanFee(PcsPoPlanCost pcsPoPlanCost);
    
    /**
     * 获取收货计划下的所有费用列表
     * @param poPlanId
     * @return
     */
    List<PcsPoPlanCost> selectCostByPoPlanId(Integer poPlanId);
    
    /**
     * 更新进口采购单总价
     * @param pcsPoPlanCost
     * @return
     */
    int  updatePoTotalAmount(PcsPoPlanCost pcsPoPlanCost, int optType);
    
    
    int updatePoPlanFee(PcsPoPlanCost pcsPoPlanCost, int optType);
}
