package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoPlanLineService.java, v 0.1 2015-08-12 15:03
 */
public interface PcsPoPlanLineService {

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsPoPlanLine buildFromVO(PcsPoPlanLineVO vo);

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsPoPlanLineVO buildFromModel(PcsPoPlanLine record);

    /**
     * 创建实体
     *
     * @param record
     * @return
     */
    Long create(PcsPoPlanLine record);

    /**
     * 更新实体
     *
     * @param record
     * @return
     */
    boolean update(PcsPoPlanLine record);

    /**
     * 根据poPlanId(外键)查找实体
     *
     * @param poPlanId
     * @return
     */
    List<PcsPoPlanLine> findPoPlanLineByPoPlanId(long poPlanId);

    /**
     * 根据poPlanId(外键)查找实体VO
     *
     * @param poPlanId
     * @return
     */
    List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanId(long poPlanId);

}
