package com.thebeastshop.pegasus.service.purchase.service;

import java.util.List;

import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateSkuField;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateSkuFieldVO;

public interface PcsCertificateSkuFieldService {
	
	/**
	 * 获取所有管理字段
	 * */
	List<PcsCertificateSkuField> findAll();
	
	/**
	 * 获取系统字段
	 * */
	List<PcsCertificateSkuField> findAllSysField();
	
	/**
	 * 获取sku字段
	 * */
	List<PcsCertificateSkuField> findAllSkuField();
	
	/**
	 * 根据field,skuCode
	 * 获取字段值
	 * */
	String getFieldValueBySkuCode(PcsCertificateSkuFieldVO field,String skuCode);
	
	/**
	 * 根据field,skuCode,barCode
	 * 获取字段值
	 * */
	String getFieldValueBySkuCodeBarCode(PcsCertificateSkuFieldVO field,String skuCode,String barCode);
	
	/**
	 * 根据id获取
	 * */
	PcsCertificateSkuFieldVO getPcsCertificateSkuFieldVOById(Integer id);

}
