package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.cond.PcsBuyerCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsBuyerInfo;
import com.thebeastshop.pegasus.service.purchase.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.UserInfo;

import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * Created by devin.li on 2016/2/12.
 */
public interface PcsBuyerInfoService {

    /**
     * 根据id获取采购详情
     * @return
     */
    PcsBuyerInfoVO getBuyerInfoById(Long id);

    /**
     * 获取所有采购员信息
     * @return
     */
    List<PcsBuyerInfoVO> getAllBuyers();

    /**
     * 采购员id与姓名对应列表
     * @return
     */
    List<Map<String,String>> getAllBuyerInfos();

    /**
     * 条件查询采购员信息
     * @param cond
     * @return
     */
    List<PcsBuyerInfoVO> getBuyerByCond(PcsBuyerCond cond);

    /**
     * 新建采购员
     * @param buyerInfo
     * @return
     */
    @Transactional
    Boolean newBuyer(PcsBuyerInfo buyerInfo);

    /**
     * 更新采购员信息
     * @param buyer
     * @return
     */
    @Transactional
    Boolean updateBuyerInfo(PcsBuyerInfo buyer);
    
    UserInfo findCategoryManagerByBuyer(Integer buyerId);
}
