/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.model.PcsBrand;
import com.thebeastshop.pegasus.service.purchase.cond.PcsBrandCond;
import com.thebeastshop.pegasus.service.purchase.vo.PcsBrandVO;

import java.util.List;

import org.apache.ibatis.annotations.Param;

/**
 * @author Eric.Lou
 * @version $Id: BrandService.java, v 0.1 2015-07-10 下午4:49
 */
public interface PcsBrandService {

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsBrandVO buildFromModel(PcsBrand record);

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsBrand bulidFromVO(PcsBrandVO vo);

    /**
     * 创建品牌
     *
     * @param record
     * @return
     */
    Long create(PcsBrand record, boolean saveDraft);

    /**
     * 更新品牌
     *
     * @param record
     * @return
     */
    boolean update(PcsBrand record, boolean saveDraft);

    /**
     * 根据主键查找品牌
     *
     * @param id
     * @return
     */
    PcsBrand findById(long id);

    /**
     * 根据条件查找品牌
     *
     * @param cond
     * @return
     */
    List<PcsBrandVO> findByCond(PcsBrandCond cond);

    /**
     * 根据名称查找品牌
     *
     * @param name
     * @return
     */
    List<PcsBrand> findByName(String name);

    /**
     * 根据id集合查找品牌
     *
     * @param ids
     * @return
     */
    List<PcsBrand> findByIds(List<Long> ids);
    
    /**
     * 品牌审核
     * @param id
     * @param isPass
     * @return
     */
    Boolean auditBrand(Long userId, long id, Boolean isPass, Integer type);
    
    /**
     * 记录品牌总数
     * @param cond
     * @return
     */
    long countByCond(PcsBrandCond cond);

}
