package com.thebeastshop.pegasus.service.purchase.flower.vo;

import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumnList;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 实际采购导入Excel模板 - Sheet：实际采购单列表
 *
 * @author gongjun
 * @since 2016-04-12 18:29
 */
@ExcelTemplate
@ExcelSheet("实际采购单列表")
public class FpcsActualExcelVO {

    private Long id;

    @ExcelColumn(name="SKU")
    @NotNull
    private String skuCodeName;

    private String skuCode;

    private String skuName;

    private String skuType;

    private Date purchaseDate;

    @ExcelColumn(name="采购时间")
    @NotNull
    private String purchaseDateString;

    @ExcelColumn(name="单位")
    @NotNull
    private String unit;

    private String skuUnit;

    private Integer purchaseUnitNumber;

    @ExcelColumn(name="价格")
    @NotNull
    private BigDecimal price;

    private BigDecimal totalPrice;

    @ExcelColumn(name="供应商")
    @NotNull
    private Long supplierId;

    private String suppilerName;

    @ExcelColumnList(from = 5, to = -2, type = FpcsChannelQuantity.class, columnFiled = "channelName", valueField = "quantity")
    private List<FpcsChannelQuantity> channelQuantitiyList;

    private Long createUserId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSkuCodeName() {
        return skuCodeName;
    }

    public void setSkuCodeName(String skuCodeName) {
        this.skuCodeName = skuCodeName;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuType() {
        return skuType;
    }

    public void setSkuType(String skuType) {
        this.skuType = skuType;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getSkuUnit() {
        return skuUnit;
    }

    public void setSkuUnit(String skuUnit) {
        this.skuUnit = skuUnit;
    }

    public Integer getPurchaseUnitNumber() {
        return purchaseUnitNumber;
    }

    public void setPurchaseUnitNumber(Integer purchaseUnitNumber) {
        this.purchaseUnitNumber = purchaseUnitNumber;
    }

    public Date getPurchaseDate() {
        return purchaseDate;
    }

    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public String getPurchaseDateString() {
        return purchaseDateString;
    }

    public void setPurchaseDateString(String purchaseDateString) {
        this.purchaseDateString = purchaseDateString;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSuppilerName() {
        return suppilerName;
    }

    public void setSuppilerName(String suppilerName) {
        this.suppilerName = suppilerName;
    }

    public List<FpcsChannelQuantity> getChannelQuantitiyList() {
        return channelQuantitiyList;
    }

    public void setChannelQuantitiyList(List<FpcsChannelQuantity> channelQuantitiyList) {
        this.channelQuantitiyList = channelQuantitiyList;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
}
