package com.thebeastshop.pegasus.service.purchase.flower.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.service.purchase.flower.dao.FpcsPurchaseOrderMapper;
import com.thebeastshop.pegasus.service.purchase.flower.model.FpcsOrderListForm;
import com.thebeastshop.pegasus.service.purchase.flower.model.FpcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.flower.service.FpcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.model.FpcsSkuOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.service.purchase.service.FpcsSkuService;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;

@Service("fpcsPurchaseOrderService")
public class FpcsPurchaseOrderServiceImpl implements FpcsPurchaseOrderService,CheckAble, CodeAble {

	@Autowired
	private FpcsPurchaseOrderMapper fpcsPurchaseOrderMapper;
	
	@Autowired
	private FpcsSkuService fpcsSkuServiceImpl;
	
	@Override
	public List<FpcsPurchaseOrder> select(FpcsPurchaseOrder example) {
		String channelCode = example.getChannelCode();
		String[] channelArray = null;
		if(StringUtils.isNotBlank(channelCode)) {
			channelArray = channelCode.split(",");
		}
		
		return fpcsPurchaseOrderMapper.select(example, channelArray);
	}

	@Override
	public void acceptOrder(FpcsPurchaseOrder example) {
		
		String channelCode = example.getChannelCode();
		String[] channelArray = null;
		if(StringUtils.isNotBlank(channelCode)) {
			channelArray = channelCode.split(",");
		}
		
		List<FpcsPurchaseOrder> orderList = fpcsPurchaseOrderMapper.select(example, channelArray);
		String purTime = String.valueOf(new Date().getTime());
		for(FpcsPurchaseOrder fpcsPurchaseOrder : orderList) {
			if(fpcsPurchaseOrder.getAcceptanceNo() == null) {
				fpcsPurchaseOrder.setAcceptanceNo(purTime);
				fpcsPurchaseOrder.setProcessState((short) 1);
				this.fpcsPurchaseOrderMapper.updateByPrimaryKeySelective(fpcsPurchaseOrder);
			}
		}
		
	}

	@Override
	public String generateCode(Object arg0) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Boolean check(Object obj) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int sumitOrder(FpcsOrderListForm example) {
		
		int resultFlag = 1;
		List<FpcsPurchaseOrder> orderList = example.getFpcsPurchaseOrderList();
		Set<String> channelList = example.getChannelList();
		Iterator<String> it = channelList.iterator();
		 
		Date date=new Date();//取时间
 		Calendar calendar = new GregorianCalendar();
 		calendar.setTime(date);
 		calendar.add(calendar.DATE,1);//把日期往后增加一天.整数往后推,负数往前移动
 		date=calendar.getTime(); //这个时间就是日期往后推一天的结果 
 		/*SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
 		String dateString = formatter.format(date);*/
 		if(example.getPurchaseTime() == null) {
 			example.setPurchaseTime(date);
 		}
		 String channel = "";
		 while(it.hasNext()) {
			 channel = it.next();
		 }
		if(example.getType() == 1) {
			for(FpcsPurchaseOrder order : orderList) {
				if(order.getDemand() != null && order.getDemand() > 0) {
					FpcsSkuOrder pcsSku = fpcsSkuServiceImpl.findSkuById(order.getId());
					order.setCategory(pcsSku.getSkuType());
					order.setSkuCode(pcsSku.getSkuCode());
					order.setSkuName(pcsSku.getSkuName());
					order.setSkuUnit(pcsSku.getSkuUnit());
					order.setPurchaseUnit(pcsSku.getPurchaseUnit());
					order.setPurchaseUnitNumber(pcsSku.getPurchaseUnitNumber());
					order.setId(null);
					order.setChannelCode(channel);
					order.setProcessState((short) 0);
					order.setPurchaseTime(example.getPurchaseTime());
					
					this.fpcsPurchaseOrderMapper.insert(order);
				}
			}
		}  else {
			for(FpcsPurchaseOrder order : orderList) {
				if(order.getId() != null) {
					FpcsPurchaseOrder oldOrder =  this.fpcsPurchaseOrderMapper.selectByPrimaryKey(order.getId());
					if(oldOrder != null && oldOrder.getProcessState() == 1) {
						resultFlag = 0;
						return resultFlag;
					} else {
						this.fpcsPurchaseOrderMapper.updateByPrimaryKeySelective(order);
					}
				}
			}
		}
		return resultFlag;
	}

	@Override
	public List<FpcsPurchaseOrder> getPurchaseOrderList(FpcsPurchaseOrder example) {
		String channelCode = example.getChannelCode();
		String[] channelArray = null;
		if(StringUtils.isNotBlank(channelCode)) {
			channelArray = channelCode.split(",");
		}
		return this.fpcsPurchaseOrderMapper.findPurchaseOrderList(example, channelArray);
	}

	@Override
	public Map<String, Object> getDetailPurchaseOrder(long id) {
		FpcsPurchaseOrder fpcsPurchaseOrder = this.fpcsPurchaseOrderMapper.selectByPrimaryKey(id);
		Map<String, Object>  resultMap = new HashMap<>();
		resultMap.put("flowerShopsList",  this.fpcsPurchaseOrderMapper.findDetailPurchaseOrder(fpcsPurchaseOrder.getPurchaseTime(), 
									fpcsPurchaseOrder.getAcceptanceNo(), fpcsPurchaseOrder.getSkuCode()));
		resultMap.put("purchaseTime", DateUtil.format(fpcsPurchaseOrder.getPurchaseTime(), "yyyy-MM-dd"));
		resultMap.put("skuCode", fpcsPurchaseOrder.getSkuCode());
		return resultMap;
	}

	@Override
	public Map<String,List<List<String>>>  exportPurchaseOrder(FpcsPurchaseOrder example) {
		String channelCode = example.getChannelCode();
		String[] channelArray = null;
		if(StringUtils.isNotBlank(channelCode)) {
			channelArray = channelCode.split(",");
		}
		List<FpcsPurchaseOrder>  storeList = this.fpcsPurchaseOrderMapper.findStoreInfo(example, channelArray);
		List<List<String>> allLines = new ArrayList<>();
        List<String> head = new ArrayList<>();
      
        
        head.add("采购时间");
        head.add("SKU");
        head.add("单位");
        head.add("价格");
        head.add("供应商");
        
        List<List<String>> storeAllLines = new ArrayList<>();
        List<String> storeHead = new ArrayList<>();
        storeHead.add("门店");
        storeHead.add("渠道编号");
        storeHead.add("渠道仓库号");
        storeAllLines.add(storeHead);
        for(FpcsPurchaseOrder store : storeList) {
        	List<String> line = new ArrayList<>();
        	line.add(store.getStoreName());
        	line.add(store.getChannelCode());
        	line.add(store.getWarehouserForSales());
        	storeAllLines.add(line);
        	
        	head.add(store.getStoreName());
        	
        }
        head.add("合计");
        allLines.add(head);
        
        //example.setProcessState((short) 1);
        List<FpcsPurchaseOrder>  purchaseOrderList = this.fpcsPurchaseOrderMapper.findPurchaseOrderList(example, channelArray);
        for(FpcsPurchaseOrder  order : purchaseOrderList) {
        	List<String> line = new ArrayList<>();
        	line.add(DateUtil.format(order.getPurchaseTime(), "yyyy/MM/dd"));
        	line.add(order.getSkuCode() + "/" + order.getSkuName());
        	line.add(order.getSkuUnit());
        	line.add(String.valueOf(order.getTheUnitPrice() == null ? "":order.getTheUnitPrice() ));
        	line.add(order.getSupplier());
        	
        	List<FpcsPurchaseOrder> detailPurchaseOrderList = this.fpcsPurchaseOrderMapper.findDetailPurchaseOrder(order.getPurchaseTime(), 
        									order.getAcceptanceNo(), order.getSkuCode() );
        	for(FpcsPurchaseOrder store : storeList) {
        		FpcsPurchaseOrder  lastOrder = null;
        		for(FpcsPurchaseOrder detail : detailPurchaseOrderList) {
        			if(store.getChannelCode().equals(detail.getChannelCode())) {
        				lastOrder = detail;
        			}
        		}
        		if(lastOrder != null) {
        			line.add(String.valueOf(lastOrder.getTotalDemand()));
        		} else {
        			line.add("0");
        		}
        	}
        	allLines.add(line);
        	line.add(String.valueOf(order.getTotalDemand()));
        }
        
        Map<String,List<List<String>>> sheets = new HashMap<>();
        sheets.put("实际采购单列表", allLines);
        sheets.put("门店明细", storeAllLines);
        return sheets;
	}

	@Override
	public List<FpcsPurchaseOrder> getCacheSkuOrderList(List<FpcsPurchaseOrder> fpcsPurchaseOrderList) {
		for(FpcsPurchaseOrder order : fpcsPurchaseOrderList) {
			if(order.getDemand() != null && order.getDemand() > 0) {
				FpcsSkuOrder pcsSku = fpcsSkuServiceImpl.findSkuById(order.getId());
				order.setCategory(pcsSku.getSkuType());
				order.setSkuCode(pcsSku.getSkuCode());
				order.setSkuName(pcsSku.getSkuName());
				order.setSkuUnit(pcsSku.getSkuUnit());
				order.setPurchaseUnit(pcsSku.getPurchaseUnit());
				order.setPurchaseUnitNumber(pcsSku.getPurchaseUnitNumber());
			}
		}
		return fpcsPurchaseOrderList;
	}

}
