package com.thebeastshop.pegasus.service.purchase.dao;

import com.thebeastshop.pegasus.service.purchase.cond.PcsWatermarkCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsProdWatermark;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuWatermark;
import com.thebeastshop.pegasus.service.purchase.model.ProdWatermark;
import com.thebeastshop.pegasus.service.purchase.vo.ProdSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsWatermarkVO;

import java.util.List;
import java.util.Map;

import com.thebeastshop.pegasus.service.purchase.vo.ProductWatermarkVO;
import org.apache.ibatis.annotations.Param;

/**
 * @author gongjun
 * @since 2016-05-10
 */
public interface PcsWatermarkMapper {

    int insert(PcsWatermarkVO watermarkVO);

    int update(PcsWatermarkVO watermarkVO);

    int insertSkuWatermark(PcsSkuWatermark skuWatermark);

    int updateSkuWatermark(PcsSkuWatermark skuWatermark);

    int deleteSkuWatermark(PcsSkuWatermark skuWatermark);

    int insertProdWatermark(ProdWatermark prodWatermark);

    int updateProdWatermark(ProdWatermark prodWatermark);

    int deleteProdWatermark(ProdWatermark prodWatermark);

    List<PcsSkuWatermark> queryToDeleteSkuWatermarkList(Map<String, Object> params);

    List<PcsProdWatermark> queryToDeleteProdWatermarkList(Map<String, Object> params);
    
    List<ProdWatermark> queryToDeleteProductWatermarkList(Map<String, Object> params);

    int deleteSkuWatermarkByIds(Map<String, Object> params);

    int deleteProdWatermarkByIds(Map<String, Object> params);
    
    int updateProdWatermarkActiveByIds(Map<String, Object> params);
    
    int countOfSkuWatermark(PcsSkuWatermark skuWatermark);

    int countOfProdWatermark(ProdWatermark prodWatermark);
    
    ProdWatermark findProductWatermark(ProdWatermark prodWatermark);

    PcsSkuWatermark findSkuWatermark(PcsSkuWatermark skuWatermark);

    PcsProdWatermark findProdWatermark(PcsProdWatermark prodWatermark);

    PcsWatermarkVO findWatermarkById(Long id);

    List<PcsWatermarkVO> queryWatermarkList(Map<String, Object> params);
    
    List<ProdSkuVO> queryProdWatermarkList(@Param("cond") PcsWatermarkCond cond);
    
    List<ProdSkuVO> querySkuListByProd(Long prodId);
    
    List<ProdSkuVO> queryProdListBySkuCode(String code);
    
    List<String> querySkuCodeListByWatermarkId(Long id);

    List<Long> queryProdIdListByWatermarkId(Long id);

	List<ProdSkuVO> queryProdWatermarkListByParams(Map<String, Object> params);

	ProdSkuVO queryProductByProdId(Long prodId);

    /**
     * 通过productcodes 查询所有可以使用的水印标签
     * @author lijing
     * @param productCodes
     * @return
     */
    List<ProductWatermarkVO> seleckWatermarkByProductCodes(@Param("productCodes") List<String> productCodes);
}
