package com.thebeastshop.pegasus.service.purchase.dao;

import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuExample;
import java.util.List;

import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuVO;
import org.apache.ibatis.annotations.Param;

import java.util.Map;
public interface PcsSkuMapper {
    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku
     *
     * @mbggenerated Sat May 28 18:42:18 CST 2016
     */
    int countByExample(PcsSkuExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku
     *
     * @mbggenerated Sat May 28 18:42:18 CST 2016
     */
    int deleteByExample(PcsSkuExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku
     *
     * @mbggenerated Sat May 28 18:42:18 CST 2016
     */
    int deleteByPrimaryKey(Long id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku
     *
     * @mbggenerated Sat May 28 18:42:18 CST 2016
     */
    int insert(PcsSku record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku
     *
     * @mbggenerated Sat May 28 18:42:18 CST 2016
     */
    int insertSelective(PcsSku record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku
     *
     * @mbggenerated Sat May 28 18:42:18 CST 2016
     */
    List<PcsSku> selectByExample(PcsSkuExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku
     *
     * @mbggenerated Sat May 28 18:42:18 CST 2016
     */
    PcsSku selectByPrimaryKey(Long id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku
     *
     * @mbggenerated Sat May 28 18:42:18 CST 2016
     */
    int updateByExampleSelective(@Param("record") PcsSku record, @Param("example") PcsSkuExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku
     *
     * @mbggenerated Sat May 28 18:42:18 CST 2016
     */
    int updateByExample(@Param("record") PcsSku record, @Param("example") PcsSkuExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku
     *
     * @mbggenerated Sat May 28 18:42:18 CST 2016
     */
    int updateByPrimaryKeySelective(PcsSku record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku
     *
     * @mbggenerated Sat May 28 18:42:18 CST 2016
     */
    int updateByPrimaryKey(PcsSku record);





    // self
    /**
     * 根据code查找sku,关联出供应商名称,品牌名称,品类名称
     *
     * @param code
     * @return vo
     */
    List<PcsSkuVO> findSkuByCodes(@Param("codes") List<String> code);
    
    List<PcsSkuVO> findSkuByIds(@Param("ids") List<Long> ids);
    
    List<PcsSkuVO> findSkuAuditByIds(@Param("ids") List<Long> ids);

    /**
     * 根据参数查找sku,关联出供应商名称,品牌名称,品类名称
     *
     * @param arg0
     * @return
     */
    List<PcsSkuVO> findSkuByNameOrCode(@Param("arg0") String arg0);

    /**
     * 根据条件查出sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findSkuByCond(@Param("cond") PcsSkuCond cond);
    
    long countSkuByCond(@Param("cond") PcsSkuCond cond);

    List<PcsSkuVO> findSkuAll();

    /**
     * 根据条件导出sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findSkuByCondForExport(@Param("cond") PcsSkuCond cond);
    
    List<Map<String,Object>> findSkuCanSaleAndCanSeeByChannelCode(@Param("channelCode")String channelCode);
    
    Map<String,Object> findSkuCanSaleAndCanSeeInfo(@Param("channelCode")String channelCode,@Param("skuCode")String skucode);

    /**
     * 所有SKU信息
     *
     * @return
     */
    List<PcsSkuInfoVO> allSkuInfo();

    /**
     * 根据Code查询SKU信息
     *
     * @return
     */
    PcsSkuInfoVO findStockByCode(@Param("skuCode")String skuCode);

    /**
     * 查询没有分配渠道的SKU
     * @param cond
     * @return
     */
    List<PcsSkuVO> findChannelSkuForNoDistribute(@Param("cond") PcsSkuCond cond);
    
    /**
     * 根据条件查出sku
     *
     * @param cond
     * @return
     */
 List<PcsSkuVO> findSkuTagByCond(@Param("cond") PcsSkuCond cond);
    
    List<String> getCodeByCode(List<String> codeList);
    
    List<Integer> getSalesPriceByCodes(List<String> codes);
    
    int updateSkuCategoryNameByCode(@Param("skuCategoryName") String skuCategoryName, @Param("skuCode")String skuCode);
    
    List<Map> getSalesPriceByProdId(@Param("prodId") Long prodId);
    
    /**
     * 不为空表示有海外购
     * @param codes
     * @return
     */
    String getCrossBorderFlagByCodes(List<String> codes);
}