/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.cron;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import com.thebeastshop.pegasus.service.purchase.service.PrdcJobService;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;

/**
 * @author yu.bao
 * @version $Id: PcsPrdcJobCron.java, v 0.1 2016-06-01
 */
@Component
public class PcsPrdcJobCron {
	
	@Autowired
    private PrdcJobService prdcJobService;
	
	/**
     * 定时更新加工订单信息
     * 每1分钟执行一次
     */
    @Scheduled(cron = "0 0/1 * * * ?")
    public void updatePrdcJobWhenTaskFinish(){
    	final CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("prdcJobFinishCheck");
    	if(config == null){
    		return;
    	}
    	String value = config.getConfigValue();
    	if(!StringUtils.isEmpty(value) && "1".equals(value)){
    		prdcJobService.updatePrdcJobWhenTaskFinish(null);
    	}
    	
    }

}
