/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.cron;

import com.thebeastshop.pegasus.service.purchase.service.PcsCronService;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Date;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoPlanCron.java, v 0.1 2015-08-12 11:27
 */
@Component
public class PcsPoPlanCron {

    private final Logger log = LoggerFactory.getLogger(PcsPoPlanCron.class);

    @Autowired
    private PcsCronService pcsCronService;

    @PostConstruct
    private void init() {

    }

    /**
     * 同步采购单收货信息
     * 每5分钟执行一次
     */
//    @Scheduled(cron = "0 0/1 * * * ?")
    public void cron() {
        log.debug("[同步采购单收货信息]PcsPoPlanCron.cron begin at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
        pcsCronService.cronSynPoPlanAndLine();
        log.debug("[同步采购单收货信息]PcsPoPlanCron.cron end at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
    }

}
