/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase;


import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StringUtils;

import com.thebeastshop.pegasus.service.purchase.cond.PcsBrandCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsBuyerCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsCertificateFieldCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuReceiveStandardCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsTagCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsWatermarkCond;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcJobCond;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeCond;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.flower.model.FpcsOrderListForm;
import com.thebeastshop.pegasus.service.purchase.flower.model.FpcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.flower.service.FpcsActualPurchaseService;
import com.thebeastshop.pegasus.service.purchase.flower.service.FpcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualChannelItemVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualChannelVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualExcelVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsChannelQuantity;
import com.thebeastshop.pegasus.service.purchase.model.FpcsConsumableAllot;
import com.thebeastshop.pegasus.service.purchase.model.FpcsSkuOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsBrand;
import com.thebeastshop.pegasus.service.purchase.model.PcsBuyerInfo;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateField;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateSkuField;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTag;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTagField;
import com.thebeastshop.pegasus.service.purchase.model.PcsClPs;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanCost;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCategory;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCategoryRelation;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCategoryRelationCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCmSpl;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCustomMade;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuQcImg;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSupplier;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJob;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLine;
import com.thebeastshop.pegasus.service.purchase.service.FpcsSkuService;
import com.thebeastshop.pegasus.service.purchase.service.PcsBrandService;
import com.thebeastshop.pegasus.service.purchase.service.PcsBuyerInfoService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateSkuFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTagService;
import com.thebeastshop.pegasus.service.purchase.service.PcsClPsService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCategoryService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCmSplService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCustomMadeService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuImgService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuQcImgService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuReceiveStandardService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSupplierService;
import com.thebeastshop.pegasus.service.purchase.service.PcsTagService;
import com.thebeastshop.pegasus.service.purchase.service.PcsWatermarkService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobLineService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcRecipeService;
import com.thebeastshop.pegasus.service.purchase.vo.FlowerSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.MaterailSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsBrandVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateSkuFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagEditVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagFieldValueVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFrontBackCategoryVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseOrderVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCmSplVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCustomMadeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuReceiveStandardRuleVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuReceiveStandardVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSupplierVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsTagVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsWatermarkVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintCerVO;
import com.thebeastshop.pegasus.service.purchase.vo.ProdSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.ProductWatermarkVO;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.importExcel.AdvancedParseExcelComponent;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;

/**
 * @author Royan
 * @version $Id: PegasusPurchaseServiceFacade.java, v 0.1 2015-07-01 下午3:00
 */
public class PegasusPurchaseServiceFacade {

    private final static Logger log = LoggerFactory.getLogger(PegasusPurchaseServiceFacade.class);

    private static PegasusPurchaseServiceFacade instance;

    @Autowired
    private PcsSupplierService pcsSupplierService;

    @Autowired
    private PcsBrandService pcsBrandService;

    @Autowired
    private PcsSkuCategoryService pcsSkuCategoryService;

    @Autowired
    private PcsSkuService pcsSkuService;

    @Autowired
    private PcsSkuCustomMadeService pcsSkuCustomMadeService;

    @Autowired
    private PcsSkuCmSplService pcsSkuCmSplService;

    @Autowired
    private PcsClPsService pcsClPsService;

    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;

    @Autowired
    private PcsPoLineService pcsPoLineService;

    @Autowired
    private PcsPoPlanService pcsPoPlanService;

    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;

    @Autowired
    private PrdcRecipeService prdcRecipeService;

    @Autowired
    private PrdcJobService prdcJobService;

    @Autowired
    private PrdcJobLineService prdcJobLineService;

    @Autowired
    private PcsBuyerInfoService pcsBuyerInfoService;

    @Autowired
    private FpcsPurchaseOrderService fpcsPurchaseOrderService;

    @Autowired
    public PcsSkuImgService pcsSkuImgService;

    @Autowired
    public PcsSkuQcImgService pcsSkuQcImgService;

    @Autowired
    private FpcsSkuService fpcsSkuService;

    @Autowired
    private FpcsActualPurchaseService fpcsActualPurchaseService;

    @Autowired
    private PcsWatermarkService pcsWatermarkService;

    @Autowired
    private PcsTagService pcsTagService;


    @Autowired
    private PcsCertificateFieldService pcsCertificateFieldService;

    @Autowired
    private PcsCertificateSkuFieldService pcsCertificateSkuFieldService;

    //    @Autowired
    private AdvancedParseExcelComponent advancedParseExcelComponent;
    

    @Autowired
    private PcsCertificateTagService pcsCertificateTagService;
    
    @Autowired
    private PcsSkuReceiveStandardService pcsSkuReceiveStandardService;
    
    @Autowired
    private PcsSkuSalesPriceChangeService pcsSkuSalesPriceChangeService;

    private PegasusPurchaseServiceFacade() {

    }

    public static PegasusPurchaseServiceFacade getInstance() {
        if (instance != null) {
            return instance;
        }

        synchronized (PegasusFacadeLock.class) {
            if (instance == null) {
                log.warn("[fasade init start] PegasusPurchaseServiceFacade");
                new ClassPathXmlApplicationContext("pegasus-service-purchase/spring.xml");
                log.warn("[fasade init finish] PegasusPurchaseServiceFacade");
            }
            instance = (PegasusPurchaseServiceFacade) SpringUtil.getBean("pegasusPurchaseServiceFacade");
        }
        return instance;
    }

    public static <T> T getBean(Class<T> requiredType) {
    	return SpringUtil.getBean(requiredType);
    }
    
    public AdvancedParseExcelComponent getAdvancedParseExcelComponent() {
        return advancedParseExcelComponent;
    }

    /**
     * 创建供应商
     *
     * @param vo
     * @return
     */
    public Long createSupplier(PcsSupplierVO vo) {
        return pcsSupplierService.create(pcsSupplierService.buildFromVO(vo), vo.isSaveDraft());
    }

    /**
     * 通过productcodes 查询所有的 水印标签
     *@author lijing
     * @time 20160910 20:38
     * @param productCodes
     * @return Map<String,ProductWatermarkVO>
     */
    public Map<String,ProductWatermarkVO> selectWaterMarkByProductCodes(List<String> productCodes){
        return pcsWatermarkService.seleckWatermarkByProductCodes(productCodes);
    }
    /**
     * 更新供应商
     *
     * @param vo
     * @return
     */
    public Boolean updateSupplier(PcsSupplierVO vo) {
        return pcsSupplierService.update(pcsSupplierService.buildFromVO(vo), vo.isSaveDraft());
    }

    /**
     * 根据主键查找供应商
     *
     * @param id
     * @return
     */
    public PcsSupplierVO findSupplierById(Long id) {
        PcsSupplier record = pcsSupplierService.findById(id);
        PcsSupplierVO vo = pcsSupplierService.buildFromModel(record);
        return vo;
    }

    /**
     * 根据条件查找供应商
     *
     * @param cond
     * @return
     */
    public List<PcsSupplierVO> findSupplierByCond(PcsSupplierCond cond) {
        List<PcsSupplierVO> recordList = pcsSupplierService.findByCond(cond);
       /* List<PcsSupplierVO> vos = new ArrayList<PcsSupplierVO>(recordList.size());
        for (PcsSupplier record : recordList) {
            PcsSupplierVO vo = pcsSupplierService.buildFromModel(record);
            vos.add(vo);
        }*/
        return recordList;
    }

    /**
     * 根据条件查找供应商
     *
     * @param cond
     * @return
     */
    public List<PcsSupplierVO> findSupplierByCriteria(PcsSupplierCond cond) {
        List<PcsSupplier> recordList = pcsSupplierService.findByCriteria(cond);
        List<PcsSupplierVO> vos = new ArrayList<PcsSupplierVO>(recordList.size());
        for (PcsSupplier record : recordList) {
            PcsSupplierVO vo = pcsSupplierService.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    /**
     * 创建品牌
     *
     * @param vo
     * @return
     */
    public Long createBrand(PcsBrandVO vo) {
        return pcsBrandService.create(pcsBrandService.bulidFromVO(vo), vo.isSaveDraft());
    }

    /**
     * 更新品牌
     *
     * @param vo
     * @return
     */
    public boolean updateBrand(PcsBrandVO vo) {
        return pcsBrandService.update(pcsBrandService.bulidFromVO(vo), vo.isSaveDraft());
    }

    /**
     * 根据主键查找品牌
     *
     * @param id
     * @return
     */
    public PcsBrandVO findBrandById(long id) {
        PcsBrand record = pcsBrandService.findById(id);
        PcsBrandVO vo = pcsBrandService.buildFromModel(record);
        return vo;
    }

    /**
     * 根据条件查找品牌
     *
     * @param cond
     * @return
     */
    public List<PcsBrandVO> findBrandByCond(PcsBrandCond cond) {
        List<PcsBrandVO> recordList = pcsBrandService.findByCond(cond);
      /*  List<PcsBrandVO> vos = new ArrayList<PcsBrandVO>(recordList.size());
        for (PcsBrand record : recordList) {
            PcsBrandVO vo = pcsBrandService.buildFromModel(record);
            vos.add(vo);
        }*/
        return recordList;
    }

    /**
     * 根据主键查找SKU分类
     *
     * @param id
     * @return
     */
    public PcsSkuCategoryVO findSkuCategoryById(long id) {
        PcsSkuCategory record = pcsSkuCategoryService.findById(id);
        PcsSkuCategoryVO vo = pcsSkuCategoryService.bulidFromModel(record);
        return vo;
    }


    /**
     * 根据主键查找后台SKU分类
     *
     * @param id
     * @return
     */
    public PcsSkuCategoryVO findSkuBackCategoryById(long id) {
        PcsSkuCategory record = pcsSkuCategoryService.findBackCategoryById(id);
        PcsSkuCategoryVO vo = pcsSkuCategoryService.bulidFromModel(record);
        return vo;
    }


    public List<PcsSkuCategoryVO> findFrontCategoriesBySkuCode(String skuCode) {
        List<PcsSkuCategory> categoryList = pcsSkuCategoryService.findFrontCategoriesBySkuCode(skuCode);
        List<PcsSkuCategoryVO> voList = BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class);
        return voList;
    }

    public List<PcsSkuCategoryVO> findFrontCategoriesBySkuCodeList(List<String> skuCodeList) {
        List<PcsSkuCategory> categoryList = pcsSkuCategoryService.findFrontCategoriesBySkuCodeList(skuCodeList);
        List<PcsSkuCategoryVO> voList = BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class);
        return voList;
    }

    public List<Long> findProductIdsBySkuCodes(List<String> skuCodes) {
        return pcsSkuCategoryService.findProductIdsBySkuCodes(skuCodes);
    }

    public List<Long> findProductIdsByCategoryFrontRelationIds(List<Long> ids) {
        return pcsSkuCategoryService.findProductIdListByCategoryFrontRelationIds(ids);
    }

    public List<Long> findFrontCategoryIdListByBackCategoryId(Long backCategoryRelationId) {
        return pcsSkuCategoryService.findFrontCategoryIdListByBackCategoryId(backCategoryRelationId);
    }

    public List<Long> findFrontCategoryIdListByBackCategoryIds(List<Long> backCategoryRelationIds) {
        return pcsSkuCategoryService.findFrontCategoryIdListByBackCategoryIds(backCategoryRelationIds);
    }


    public List<Long> findBackCategoryIdListByFrontCategoryId(Long frontCategoryId) {
        return pcsSkuCategoryService.findBackCategoryIdListByFrontCategoryId(frontCategoryId);
    }


    public Integer countOfFrontCategoryRelation(PcsSkuCategoryRelationCond cond) {
        return pcsSkuCategoryService.countOfFrontCategoryRelation(cond);
    }

    public List<PcsSkuCategoryVO> findBackCategoryList(Map<String, Object> params) {
        return pcsSkuCategoryService.findBackCategoryList(params);
    }



    public void synFrontCategoryRelation(String skuCode) {
        Map<String, Object> params = new HashMap<>();
        params.put("skuCode", skuCode);
        List<PcsSkuCategoryVO> backCategoryList = this.findBackCategoryList(params);
        PcsSkuVO sku = this.findSkuByCode(skuCode);
        if (sku == null) {
            return;
        }
        List<Long> backIds = new ArrayList<>();
        for (int i = 0; i < backCategoryList.size(); i++) {
            PcsSkuCategoryVO backCategory = backCategoryList.get(i);
            backIds.add(backCategory.getId());
        }

        List<Long> newFrontCategoryIds = this.findFrontCategoryIdListByBackCategoryIds(backIds);
        log.info("synFrontCategoryRelation 同步sku[{}]类目时，相关的前台类目:[{}]",
                skuCode, org.apache.commons.lang3.StringUtils.join(newFrontCategoryIds, ", "));

        PcsSkuCategoryRelationCond cond = new PcsSkuCategoryRelationCond();
        cond.setSkuCode(skuCode);
        cond.setNotCategoryIdList(newFrontCategoryIds);
        // 查询SKU关联的前端类目关系
        List<PcsSkuCategoryRelation> toDelBackRelationList = this.findFrontCategoryRelation(cond);
        List<Long> toDelIdList = new ArrayList<>();
        for (int i = 0; i < toDelBackRelationList.size(); i++) {
            PcsSkuCategoryRelation relation = toDelBackRelationList.get(i);
            toDelIdList.add(relation.getId());
        }
        // 清除该SKU已有的前端类目关系
        this.deleteFrontCategoryRelationList(toDelIdList);
        if (EmptyUtil.isNotEmpty(toDelIdList)) {
            log.info("synFrontCategoryRelation 同步sku[{}]类目时，清除的前台类目:[{}]",
                    skuCode, org.apache.commons.lang3.StringUtils.join(toDelIdList, ", "));
        }
        // 添加或更新SKU前端类目关系
        List<Long> needToAddCategoryIds = new ArrayList<>();
        for (int i = 0; i < newFrontCategoryIds.size(); i++) {
            Long categoryId = newFrontCategoryIds.get(i);
            PcsSkuCategoryRelation relation = new PcsSkuCategoryRelation();
            relation.setSkuCode(skuCode);
            relation.setCategoryId(categoryId);

            PcsSkuCategoryRelationCond frontCond = new PcsSkuCategoryRelationCond();
            frontCond.setSkuCode(skuCode);
            frontCond.setCategoryId(categoryId);
            List<PcsSkuCategoryRelation> list = this.findFrontCategoryRelation(frontCond);
            if (EmptyUtil.isEmpty(list)) {
                this.addFrontCategoryRelation(relation);
                needToAddCategoryIds.add(relation.getCategoryId());
            }
        }
        if (EmptyUtil.isNotEmpty(needToAddCategoryIds)) {
            log.info("synFrontCategoryRelation 同步sku[{}]类目时，添加的的前台类目：[{}]",
                    sku.getCode(), org.apache.commons.lang3.StringUtils.join(needToAddCategoryIds, ", "));
        }
//        saveOfUpdateBackCategoryRelationList(relationList);

    }

    public List<PcsSkuCategoryRelation> findBackCategoryRelationList(PcsSkuCategoryRelationCond cond) {
        return pcsSkuCategoryService.findBackCategoryRelationList(cond);
    }

    public void saveOrUpdateBackCategoryRelationList(List<PcsSkuCategoryRelation> relationList) {
        pcsSkuCategoryService.saveOrUpdateBackCategoryRelationList(relationList);
    }

    public void saveOrUpdateBackCategoryRelation(PcsSkuCategoryRelation relation) {
        pcsSkuCategoryService.saveOrUpdateBackCategoryRelation(relation);
    }

    public List<PcsFrontBackCategoryVO> findAllFrontBackCategoryList() {
        Map<String, Object> params = new HashMap<>();
        return pcsSkuCategoryService.findFrontBackCategoryList(params);
    }

    public List<PcsSkuCategoryVO> findAllFrontCategoryList() {
        Map<String, Object> params = new HashMap<>();
        return pcsSkuCategoryService.findFrontCategoryList(params);
    }


    public List<PcsSkuCategoryVO> findAllBackCategoryList() {
        Map<String, Object> params = new HashMap<>();
        List<PcsSkuCategoryVO> recordList = pcsSkuCategoryService.findBackCategoryList(params);
        return  recordList;

    }

    public void addFrontCategoryRelation(PcsSkuCategoryRelation relation) {
        pcsSkuCategoryService.addFrontCategoryRelation(relation);
    }

    public void addBackCategoryRelation(PcsSkuCategoryRelation relation) {
        pcsSkuCategoryService.addBackCategoryRelation(relation);
    }


    public List<PcsSkuCategoryRelation> findFrontCategoryRelation(PcsSkuCategoryRelationCond cond) {
        return pcsSkuCategoryService.findFrontCategoryRelation(cond);
    }

    public void updateSkuCategoryRelation(PcsSkuCategoryRelation relation) {
        pcsSkuCategoryService.updateFrontCategoryRelation(relation);
    }


    /**
     * 根据父id查找所有子数据
     *
     * @param parentId
     * @return
     */
    public List<PcsSkuCategoryVO> findSkuCategoryAllChildrens(long parentId) {
        List<PcsSkuCategory> recordList = pcsSkuCategoryService.findAllChildrens(parentId);
        List<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }


    /**
     * 根据父id查找所有后台类目子数据
     *
     * @param parentId
     * @return
     */
    public List<PcsSkuCategoryVO> findSkuBackCategoryAllChildrens(long parentId) {
        List<PcsSkuCategory> recordList = pcsSkuCategoryService.findAllBackCategoryChildrens(parentId);
        List<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }


    /**
     * 根据code 和 右like code查找分类
     *
     * @param code
     * @return
     */
    public List<PcsSkuCategoryVO> findSkuCategoryByCodeAndRightLikeCode(String code) {
        List<PcsSkuCategory> recordList = pcsSkuCategoryService.findByCodeAndRightLikeCode(code);
        List<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
            log.info("FIND CATE CODE:{}, ID: {}", vo.getCode(), vo.getId());
        }
        return vos;
    }

    /**
     * 查找第一层sku品类
     *
     * @return
     */
    public List<PcsSkuCategoryVO> findSkuCategoryByParentIdIsNull() {
        List<PcsSkuCategory> recordList = pcsSkuCategoryService.findSkuCategoryByParentIdIsNull();
        List<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    /**
     * 查找所有的分类
     *
     * @return
     */
    public List<PcsSkuCategoryVO> findCategoryAll() {
        List<PcsSkuCategory> recordList = pcsSkuCategoryService.findAllFrontCategories();
        List<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }
    
    /**
     * 查出所有品类
     *
     * @return
     */
    public List<PcsSkuCategoryVO> findSkuCategoryAll() {
//        List<PcsSkuCategory> recordList = pcsSkuCategoryService.findAll();
        List<PcsSkuCategory> recordList = pcsSkuCategoryService.findAll();
        List<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    /**
     * 创建品类
     *
     * @param vo
     * @return
     */
    public Long createSkuCategory(PcsSkuCategoryVO vo) {
        return pcsSkuCategoryService.create(pcsSkuCategoryService.bulidFromVO(vo));
    }

    /**
     * 创建后台品类
     *
     * @param vo
     * @return
     */
    public Long createSkuBackCategory(PcsSkuCategoryVO vo) {
        return pcsSkuCategoryService.createBackCategory(pcsSkuCategoryService.bulidFromVO(vo));
    }


    /**
     * 更新品类
     *
     * @param vo
     * @return
     */
    public boolean updateSkuCategory(PcsSkuCategoryVO vo) {
        return pcsSkuCategoryService.update(pcsSkuCategoryService.bulidFromVO(vo));
    }

    /**
     * 更新后台品类
     *
     * @param vo
     * @return
     */
    public boolean updateSkuBackCategory(PcsSkuCategoryVO vo) {
        return pcsSkuCategoryService.updateBackCategory(pcsSkuCategoryService.bulidFromVO(vo));
    }


    /**
     * 根据CODE查出品类
     *
     * @param code
     * @return
     */
    public PcsSkuCategoryVO findSkuCategoryByCode(String code) {
        PcsSkuCategory record = pcsSkuCategoryService.findByCode(code);
        PcsSkuCategoryVO vo = pcsSkuCategoryService.bulidFromModel(record);
        return vo;
    }

    public PcsSkuCategory findPcsSkuCategoryById(Long ParentId){
        return  pcsSkuCategoryService.findByParentID(ParentId);
    }

    /**
     * 创建sku
     *
     * @param vo
     * @return
     */
    public long createSku(PcsSkuVO vo) {
        return pcsSkuService.create(pcsSkuService.bulidFromVO(vo));
    }

    /**
     * 批量创建SKU
     * @param list
     * @return
     */
    public List<Long> createSkus(List<PcsSkuVO> list){
        List<PcsSku> skuList = new ArrayList<>();
        for (PcsSkuVO pcsSkuVO : list) {
        	pcsSkuVO.setSkuStatus(PcsSku.SKU_STATUS_DRAFT);
            skuList.add(pcsSkuService.bulidFromVO(pcsSkuVO));
        }
        return pcsSkuService.createSkus(skuList);
    }
    
    /**
     * 批量导入花SKU
     * @param list
     * @return
     */
    public List<Long> createFlowerSkus(List<FlowerSkuVO> list){
        List<FpcsSkuOrder> skuList = new ArrayList<>();
        for (FlowerSkuVO pcsSkuVO : list) {
            skuList.add(fpcsSkuService.bulidFromVO(pcsSkuVO));
        }
        return fpcsSkuService.createSkus(skuList);
    }
    
    /**
     * 批量插入耗材
     * @author jim.huang
     * @date 2016年4月13日
     * @param list
     * @return
     */
    public List<Long> createConsumableSkus(List<FlowerSkuVO> list){
        List<FpcsSkuOrder> skuList = new ArrayList<>();
        for (FlowerSkuVO pcsSkuVO : list) {
            skuList.add(fpcsSkuService.bulidFromVO(pcsSkuVO));
        }
        return fpcsSkuService.createSkus(skuList);
    }

    /**
     * 更新sku
     *
     * @param vo
     * @return
     */
    public Boolean updateSku(PcsSkuVO vo) {
        return pcsSkuService.update(pcsSkuService.bulidFromVO(vo));
    }

    /**
     * 根据主键查出sku
     *
     * @param id
     * @return
     */
    public PcsSkuVO findSkuById(long id) {
        PcsSku record = pcsSkuService.findById(id);
        PcsSkuVO vo = pcsSkuService.buildFromModel(record);
        return vo;
    }

    /**
     * 根据CODE查出sku
     *
     * @param code
     * @return
     */
    public PcsSkuVO findSkuByCode(String code) {
        return pcsSkuService.findByCode(code);
    }

    public PcsSkuVO findSkuByCode(String code, boolean withFrontCategories, boolean withBackCategories) {
        return pcsSkuService.findByCode(code, withFrontCategories, withBackCategories);
    }


    /**
     * 根据名称或者CODE查出SKU
     *
     * @param arg0
     * @return
     */
    public List<PcsSkuVO> findSkuByNameOrCode(String arg0) {
        return pcsSkuService.findByNameOrCode(arg0);
    }

    /**
     * 根据条件查出SKU
     *
     * @param cond
     * @return
     */
    public List<PcsSkuVO> findSkuByCond(PcsSkuCond cond) {
        return pcsSkuService.findByCond(cond);
    }
    
    /**
     * 根据条件查出SKU
     *	导出使用
     * @param cond
     * @return
     */
    public List<PcsSkuVO> findSkuByCondForExport(PcsSkuCond cond) {
        return pcsSkuService.findByCondForExport(cond);
    }
    
    
    public List<Map<String,Object>> findSkuCanSaleAndCanSeeByChannelCode(String channelCode){

        return pcsSkuService.findSkuCanSaleAndCanSeeByChannelCode(channelCode);
    }
    
    /**
     * 根据条件查出SKU 渠道是否可售及可见
     *
     * @return
     */
    public Map<String,Object> findSkuCanSaleAndCanSeeInfo(String channelCode,String skuCode){
        return pcsSkuService.findSkuCanSaleAndCanSeeInfo(channelCode,skuCode);
    }

    /**
     * 根据条件查出SKU
     *
     * @param cond
     * @return
     */
    public List<PcsSkuVO> findSkuTagByCond(PcsSkuCond cond) {
        return pcsSkuService.findSkuTagByCond(cond);
    }
    /**
     * 根据名称查出供应商
     *
     * @param name
     * @return
     */
    public List<PcsSupplierVO> findSupplierByName(String name) {
        List<PcsSupplier> recordList = pcsSupplierService.findByName(name);
        List<PcsSupplierVO> vos = new ArrayList<PcsSupplierVO>(recordList.size());
        for (PcsSupplier record : recordList) {
            PcsSupplierVO vo = pcsSupplierService.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    /**
     * 根据名称查出品牌
     *
     * @param name
     * @return
     */
    public List<PcsBrandVO> findBrandByName(String name) {
        List<PcsBrand> recordList = pcsBrandService.findByName(name);
        List<PcsBrandVO> vos = new ArrayList<PcsBrandVO>(recordList.size());
        for (PcsBrand record : recordList) {
            PcsBrandVO vo = pcsBrandService.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    /**
     * 根据名称查出品类
     *
     * @param name
     * @return
     */
    public List<PcsSkuCategoryVO> findSkuCategoryByName(String name) {
        List<PcsSkuCategory> recordList = pcsSkuCategoryService.findByName(name);
        List<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }


    /**
     * 根据名称查出后台品类
     *
     * @param name
     * @return
     */
    public List<PcsSkuCategoryVO> findSkuBackCategoryByName(String name) {
        List<PcsSkuCategory> recordList = pcsSkuCategoryService.findBackCategoryByName(name);
        List<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }


    public Integer addFrontBackCategoryRelation(PcsFrontBackCategoryVO frontBackCategoryVO) {
        return pcsSkuCategoryService.addFrontBackCategoryRelation(frontBackCategoryVO);
    }

    /**
     * 根据CODE查询是否可更新SKU价格
     *
     * @param code
     * @return
     */
    public Boolean canUpdateSkuSalesPrice(String code) {
        PcsSkuVO vo = pcsSkuService.findByCode(code);
        if (EmptyUtil.isNotEmpty(vo)) {
            return pcsSkuService.canUpdateSalesPrice(code);
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_NOTHING, "无效的code");
        }
    }
    /**
     * 根据CODE查询是否可更新SKU成本
     *
     * @param code
     * @return
     */
    public Boolean canUpdateSkuCostPrice(String code) {
    	PcsSkuVO vo = pcsSkuService.findByCode(code);
    	if (EmptyUtil.isNotEmpty(vo)) {
    		return pcsSkuService.canUpdateCostPrice(code);
    	} else {
    		throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_NOTHING, "无效的code");
    	}
    }
    /**
     * 根据CODE查询是否可更新SKU供应商
     *
     * @param code
     * @return
     */
    public Boolean canUpdateSkuSupplier(String code) {
    	PcsSkuVO vo = pcsSkuService.findByCode(code);
    	if (EmptyUtil.isNotEmpty(vo)) {
    		return pcsSkuService.canUpdateSupplier(code);
    	} else {
    		throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_NOTHING, "无效的code");
    	}
    }

    /**
     * 售价变更审批
     *
     * @param code
     * @param isPass
     * @return
     */
    public Boolean auditSkuSalesPriceChange(String code, Boolean isPass) {
        return pcsSkuService.auditSkuSalesPriceChange(code, isPass);
    }

    /**
     * 根据skucode查找 审批中的售价变更记录
     *
     * @param code
     * @return
     */
    public PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        return pcsSkuService.findSkuSalesPriceChangeByCodeAndProcessing(code);
    }

    /**
     * 创建SKU定制信息,包括SKU主题信息和供应商行信息
     *
     * @param pcsSkuCustomMadeVO
     * @return
     */
    public Boolean createCustomMadeAndLine(PcsSkuCustomMadeVO pcsSkuCustomMadeVO) {
        PcsSkuCustomMade pcsSkuCustomMade = pcsSkuCustomMadeService.bulidFromVO(pcsSkuCustomMadeVO);
        List<PcsSkuCmSpl> pcsSkuCmSplList = new ArrayList<PcsSkuCmSpl>();
        if (CollectionUtils.isEmpty(pcsSkuCustomMadeVO.getSupplierList())) {
            pcsSkuCmSplList = Collections.emptyList();
        } else {
            for (PcsSkuCmSplVO pcsSkuCmSplVO : pcsSkuCustomMadeVO.getSupplierList()) {
                PcsSkuCmSpl pcsSkuCmSpl = pcsSkuCmSplService.bulidFromVO(pcsSkuCmSplVO);
                pcsSkuCmSplList.add(pcsSkuCmSpl);
            }
        }
        return pcsSkuCustomMadeService.createCustomMadeAndLine(pcsSkuCustomMade, pcsSkuCmSplList);
    }

    /**
     * 更新SKU定制信息,包括SKU主题信息和供应商行信息
     *
     * @param pcsSkuCustomMadeVO
     * @return
     */
    public Boolean updateCustomMadeAndLine(PcsSkuCustomMadeVO pcsSkuCustomMadeVO) {
        PcsSkuCustomMade pcsSkuCustomMade = pcsSkuCustomMadeService.bulidFromVO(pcsSkuCustomMadeVO);
        List<PcsSkuCmSpl> pcsSkuCmSplList = new ArrayList<PcsSkuCmSpl>();
        if (CollectionUtils.isEmpty(pcsSkuCustomMadeVO.getSupplierList())) {
            pcsSkuCmSplList = Collections.emptyList();
        } else {
            for (PcsSkuCmSplVO pcsSkuCmSplVO : pcsSkuCustomMadeVO.getSupplierList()) {
                PcsSkuCmSpl pcsSkuCmSpl = pcsSkuCmSplService.bulidFromVO(pcsSkuCmSplVO);
                pcsSkuCmSplList.add(pcsSkuCmSpl);
            }
        }
        return pcsSkuCustomMadeService.updateCustomMadeAndLine(pcsSkuCustomMade, pcsSkuCmSplList);
    }

    /**
     * 根据条件查出SKU定制信息
     *
     * @param cond
     * @return
     */
    public List<PcsSkuCustomMadeVO> findSkuCustomMadeByCond(PcsSkuCond cond) {
        return pcsSkuCustomMadeService.findSkuCustomMadeByCond(cond);
    }

    /**
     * 根据主键查找SKU定制信息
     *
     * @return
     */
    public PcsSkuCustomMadeVO findSkuCustomMadeById(long id) {
        return pcsSkuCustomMadeService.findSkuCustomMadeById(id);
    }

    /**
     * 根据sku定制单主键查找sku定制单的供应商信息
     *
     * @param skuCustomMadeId
     * @return
     */
    public List<PcsSkuCmSplVO> findSkuCmSplBySkuCustomMadeId(long skuCustomMadeId) {
        return pcsSkuCmSplService.findBySkuCustomMadeId(skuCustomMadeId);
    }

    /**
     * 根据定制单ID和关联的供应商ID删除供应商信息
     *
     * @param skuCustomMadeId
     * @param skuCmSplId
     * @return
     */
    public Boolean deletePcsCmSpl(long skuCustomMadeId, long skuCmSplId) {
        return pcsSkuCustomMadeService.deletePcsCmSpl(skuCustomMadeId, skuCmSplId);
    }

    /**
     * sku定制审批转换供应商
     *
     * @param skuCustomMadeId
     * @param skuCmSplId
     * @return
     */
    public Boolean convertCustomMadeAndLine(long skuCustomMadeId, long skuCmSplId) {
        return pcsSkuCustomMadeService.convertCustomMadeAndLine(skuCustomMadeId, skuCmSplId);
    }

    /**
     * sku定制审批-驳回
     *
     * @param skuCustomMadeId
     * @return
     */
    public Boolean rejectCustomMade(long skuCustomMadeId) {
        return pcsSkuCustomMadeService.rejectCustomMade(skuCustomMadeId);
    }

    /**
     * 根据id集合查找供应商
     *
     * @param ids
     * @return
     */
    public List<PcsSupplier> findSupplerByIds(List<Long> ids) {
        return pcsSupplierService.findByIds(ids);
    }

    /**
     * 根据id集合查找品牌
     *
     * @param ids
     * @return
     */
    public List<PcsBrand> findBrandByIds(List<Long> ids) {
        return pcsBrandService.findByIds(ids);
    }

    /**
     * 根据id集合查找品类
     *
     * @param ids
     * @return
     */
    public List<PcsSkuCategory> findSkuCategoryByIds(List<Long> ids) {
        return pcsSkuCategoryService.findByIds(ids);
    }


    /**
     * 根据id集合查找后台品类
     *
     * @param ids
     * @return
     */
    public List<PcsSkuCategory> findSkuBackCategoryByIds(List<Long> ids) {
        return pcsSkuCategoryService.findBackCategoriesByIds(ids);
    }


    /**
     * 根据code集合查找sku
     *
     * @param codes
     * @return
     */
    public List<PcsSkuVO> findSkuByCodes(List<String> codes) {
        return pcsSkuService.findByCodes(codes);
    }

    public List<PcsSkuVO> findSkuByCodes(List<String> codes, boolean withCategories) {
        return pcsSkuService.findByCodes(codes, withCategories);
    }


    /**
     * 查找当前最大ID
     *
     * @return
     */
    public Long findPcsClPsMaxId() {
        return pcsClPsService.findMaxId();
    }

    /**
     * 添加
     * @param pcsClPs
     * @return
     */
    public int addClPs(PcsClPs pcsClPs) {
        return pcsClPsService.add(pcsClPs);
    }


    /**
     * 把 <= maxId 的数据 group by code,change_source
     *
     * @param maxId
     * @return
     */
    public List<PcsClPs> findPcsClPsByMaxId(Long maxId) {
        return pcsClPsService.findByMaxId(maxId);
    }

    /**
     * 清空 <= maxId
     *
     * @param maxId
     * @return
     */
    public boolean deletePcsClPsByMaxId(Long maxId) {
        return pcsClPsService.deleteByMaxId(maxId);
    }

    /**
     * 转换sku
     *
     * @param skuVO
     * @param skuCustomMadeId
     * @return
     */
    public Boolean convertSku(PcsSkuVO skuVO, long skuCustomMadeId) {
        PcsSku pcsSku = pcsSkuService.bulidFromVO(skuVO);
        return pcsSkuService.convertSku(pcsSku, skuCustomMadeId);
    }

    /**
     * 创建采购单包括行信息
     *
     * @param pcsPurchaseOrderVO
     * @return
     */
    public Long createPurchaseOrderAndLine(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.buildFromVO(pcsPurchaseOrderVO);
        List<PcsPoLine> pcsPoLineList = new ArrayList<PcsPoLine>();
        if (CollectionUtils.isEmpty(pcsPurchaseOrderVO.getPcsPoLineVOList())) {
            pcsPoLineList = Collections.emptyList();
        } else {
            for (PcsPoLineVO pcsPoLineVO : pcsPurchaseOrderVO.getPcsPoLineVOList()) {
                PcsPoLine pcsPoLine = pcsPoLineService.buildFromVO(pcsPoLineVO);
                pcsPoLineList.add(pcsPoLine);
            }
        }
        return pcsPurchaseOrderService.createPurchaseOrderAndLine(pcsPurchaseOrder, pcsPoLineList, pcsPurchaseOrderVO.isSaveDraft());
    }

    /**
     * 更新采购单包括行信息
     *
     * @param pcsPurchaseOrderVO
     * @return
     */
    public Boolean updatePurchaseOrderAndLine(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.buildFromVO(pcsPurchaseOrderVO);
        List<PcsPoLine> pcsPoLineList = new ArrayList<PcsPoLine>();
        if (CollectionUtils.isEmpty(pcsPurchaseOrderVO.getPcsPoLineVOList())) {
            pcsPoLineList = Collections.emptyList();
        } else {
            for (PcsPoLineVO pcsPoLineVO : pcsPurchaseOrderVO.getPcsPoLineVOList()) {
                PcsPoLine pcsPoLine = pcsPoLineService.buildFromVO(pcsPoLineVO);
                pcsPoLineList.add(pcsPoLine);
            }
        }
        return pcsPurchaseOrderService.updatePurchaseOrderAndLine(pcsPurchaseOrder, pcsPoLineList, pcsPurchaseOrderVO.isSaveDraft());
    }
    /**
     * 更新采购单
     *
     * @param pcsPurchaseOrderVO
     * @return
     */
    public Boolean updatePurchaseOrder(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
    	PcsPurchaseOrder pcsPurchaseOrder = new PcsPurchaseOrder();
    	BeanUtils.copyProperties(pcsPurchaseOrderVO, pcsPurchaseOrder);
    	return pcsPurchaseOrderService.updatePurchaseOrder(pcsPurchaseOrder);
    }

    /**
     * 根据主键查找采购单
     *
     * @param id
     * @return
     */
    public PcsPurchaseOrderVO findPoVOById(long id) {
        return pcsPurchaseOrderService.findPoVOById(id);
    }

    /**
     * 根据主键查找采购单
     *
     * @param id
     * @return
     */
    public PcsPurchaseOrderVO findPurchaseOrderByCommandCode(String commandCode) {
        return pcsPurchaseOrderService.findPurchaseOrderByCommandCode(commandCode);
    }


    /**
     * 根据采购单号查找行信息
     *
     * @param poId
     * @return
     */
    public List<PcsPoLineVO> findPoLineVOByPoId(long poId) {
        return pcsPoLineService.findPoLineVOByPoId(poId);
    }
    
    /**
     * 查询采购单收货计划
     * @param poId
     * @return
     */
    public List<PcsPoLineVO> findPoSkuByPoId(long poId) {
    	return pcsPoLineService.findPoSkuByPoId(poId);
    }

    /**
     * 根据条件查找采购单
     *
     * @param cond
     * @return
     */
    public List<PcsPurchaseOrderVO> findPOVOByCond(PcsPurchaseOrderCond cond) {
        return pcsPurchaseOrderService.findPOVOByCond(cond);
    }

    /**
     * 关闭采购单,将状态置为已完成
     *
     * @param id
     * @return
     */
    public Boolean closePurchaseOrder(long id) {
        return pcsPurchaseOrderService.closePurchaseOrder(id);
    }

    /**
     * 获取t_pcs_purchase_order表的warehouseCode group
     *
     * @return
     */
    public List<String> findWarehouseCodeGroupFromPurchaseOrder() {
        return pcsPurchaseOrderService.findWarehouseCodeGroup();
    }

    /**
     * 审核采购单
     *
     * @param id
     * @param isPass
     * @return
     */
    public Boolean auditPurchaseOrder(long id, Boolean isPass, Integer type) {
        return pcsPurchaseOrderService.auditPurchaseOrder(id, isPass, type);
    }
    /**
     * 审核供应商
     *
     * @param id
     * @param isPass
     * @return
     */
    public Boolean audiSupplier(Long userId, long id, Boolean isPass, Integer type) {
    	return pcsSupplierService.audiSupplier(userId, id, isPass, type);
    }

    public Boolean audiBrand(Long userId, long id, Boolean isPass, Integer type) { 
    	return pcsBrandService.auditBrand(userId, id, isPass, type);
    }
    /**
     * 新增收货计划
     *
     * @param pcsPoPlanVO
     * @return
     * @throws Exception 
     */
    public Boolean createPoPlanAndLine(PcsPoPlanVO pcsPoPlanVO) throws Exception {
        PcsPoPlan pcsPoPlan = pcsPoPlanService.buildFromVO(pcsPoPlanVO);
        List<PcsPoPlanLine> pcsPoPlanLineList = new ArrayList<PcsPoPlanLine>();
        if (CollectionUtils.isEmpty(pcsPoPlanVO.getPcsPoPlanLineVOList())) {
            pcsPoPlanLineList = Collections.emptyList();
        } else {
            for (PcsPoPlanLineVO pcsPoPlanLineVO : pcsPoPlanVO.getPcsPoPlanLineVOList()) {
                PcsPoPlanLine pcsPoPlanLine = pcsPoPlanLineService.buildFromVO(pcsPoPlanLineVO);
                pcsPoPlanLineList.add(pcsPoPlanLine);
            }
        }
        return pcsPoPlanService.createPoPlanAndLine(pcsPoPlan, pcsPoPlanLineList);
    }

    /**
     * 新增收货计划并自动完成
     *
     * @param pcsPoPlanVO
     * @return
     * @throws Exception 
     */
    public Boolean createPoPlanAndLineThenFinish(PcsPoPlanVO pcsPoPlanVO) throws Exception {
        PcsPoPlan pcsPoPlan = pcsPoPlanService.buildFromVO(pcsPoPlanVO);
        List<PcsPoPlanLine> pcsPoPlanLineList = new ArrayList<PcsPoPlanLine>();
        if (CollectionUtils.isEmpty(pcsPoPlanVO.getPcsPoPlanLineVOList())) {
            pcsPoPlanLineList = Collections.emptyList();
        } else {
            for (PcsPoPlanLineVO pcsPoPlanLineVO : pcsPoPlanVO.getPcsPoPlanLineVOList()) {
                PcsPoPlanLine pcsPoPlanLine = pcsPoPlanLineService.buildFromVO(pcsPoPlanLineVO);
                pcsPoPlanLineList.add(pcsPoPlanLine);
            }
        }
        return pcsPoPlanService.createPoPlanAndLineThenFinish(pcsPoPlan, pcsPoPlanLineList);
    }

    /**
     * 根据采购单号查询所有收货计划
     *
     * @param poId
     * @return
     */
    public List<PcsPoPlanVO> findPcsPoPlanVOByPoId(long poId) {
        List<PcsPoPlan> recordList = pcsPoPlanService.findPcsPoPlanByPoId(poId);
        List<PcsPoPlanVO> vos = new ArrayList<PcsPoPlanVO>(recordList.size());
        for (PcsPoPlan record : recordList) {
            PcsPoPlanVO vo = pcsPoPlanService.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }


    /**
     * 更新收货计划的收货时间
     * @param id
     * @param data
     * @return
     */
    public boolean updatePcsPoPlanById(long id, String date){

        return pcsPoPlanService.updatePcsPoPlanById(id, date);
    }

    /**
     * 删除采购单行信息
     *
     * @param poId
     * @param pcsPoLineId
     * @return
     */
    public Boolean deletePcsPoLine(long poId, long pcsPoLineId) {
        return pcsPurchaseOrderService.deletePcsPoLine(poId, pcsPoLineId);
    }

    /**
     * 根据收货计划ID查找行信息
     *
     * @param poPlanId
     * @return
     */
    public List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanId(long poPlanId) {
        return pcsPoPlanLineService.findPoPlanLineVOByPoPlanId(poPlanId);
    }

    /**
     * 所有SKU信息
     *
     * @return
     */
    public List<PcsSkuInfoVO> allSkuInfo() {
        return pcsSkuService.allSkuInfo();
    }

    /**
     * 按SkuCode查询SKU信息
     *
     * @return
     */
    public PcsSkuInfoVO findStockByCode(String skuCode) {
        return pcsSkuService.findStockByCode(skuCode);
    }

    /**
     * 创建配方
     *
     * @param vo
     * @return
     */
    public Long createRecipe(PrdcRecipeVO vo){
        return prdcRecipeService.create(vo);
    }

    /**
     * 更新配方
     * @param vo
     * @return
     */
    public Boolean updateRecipe(PrdcRecipeVO vo){
        return prdcRecipeService.update(vo);
    }

    /**
     * 根据主键查找配方
     * @param id
     * @return
     */
    public PrdcRecipeVO findRecipeVOById(Long id){
        return prdcRecipeService.findRecipeVOById(id);
    }

    /**
     * 根据条件查找配方
     * @param cond 条件
     * @param cascade 是否级联
     * @return
     */
    public List<PrdcRecipeVO> findRecipeVOByCond(PrdcRecipeCond cond,Boolean cascade){
        return prdcRecipeService.findRecipeVOByCond(cond, cascade);
    }

    /**
     * 删除配方行数据
     * @param recipeId
     * @param recipeMaterialId
     * @return
     */
    public Boolean deleteRecipeMaterial(Long recipeId,Long recipeMaterialId){
        return prdcRecipeService.deleteRecipeMaterial(recipeId, recipeMaterialId);
    }

    /**
     * 创建任务
     *
     * @param vo
     * @return
     */
    public Long createJob(PrdcJobVO vo){
        return prdcJobService.create(vo);
    }

    /**
     * 批量创建人物
     * @param list
     * @return
     */
    public List<Long> batchCreate(List<PrdcJobVO> list) {
    	return prdcJobService.batchCreate(list);
    }
    /**
     * 退回修改任务
     *
     * @param vo
     * @return
     */
    public Boolean returnModifyJob(PrdcJobVO vo){
        return prdcJobService.returnModify(vo);
    }

    /**
     * 根据主键查找任务
     * @param id
     * @return
     */
    public PrdcJobVO findJobVOById(Long id){
        return prdcJobService.findJobVOById(id);
    }
    /**
     * 根据jobCode查找任务
     * @param code
     * @return
     */
    public PrdcJobVO findJobVOByCode(String code) {
        return prdcJobService.findJobVOByCode(code);
    }

    /**
     * 根据条件查找任务
     * @param cond 条件
     * @param cascade 是否级联
     * @return
     */
    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond,Boolean cascade){
        return prdcJobService.findJobVOByCond(cond, cascade);
    }
    
    /**
     * 根据条件查找任务(查询优化)
     * @param cond 条件
     * @param 
     * @return
     */
    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond){
    	return prdcJobService.findJobVOByCond(cond);
    }

    /**
     * 删除任务行数据
     * @param jobId
     * @param jobLineId
     * @return
     */
    public Boolean deleteJobLine(Long jobId,Long jobLineId){
        return prdcJobService.deleteJobLine(jobId, jobLineId);
    }

    /**
     * 退回修改_取消任务
     *
     * @param jobId
     * @return
     */
    public Boolean cancelJobForStatusReturnModify(Long jobId){
        return prdcJobService.cancelJobForStatusReturnModify(jobId);
    }


    /**
     * 根据父id查找所有子分类
     *
     * @param parentId
     * @return
     */
    public List<PcsSkuCategory> findAllSkuCateChildrens(long parentId){
        if (NumberUtil.isNullOrZero(parentId)) {
            return Collections.emptyList();
        }
        return pcsSkuCategoryService.findAllChildrens(parentId);
    }

    /**
     * 根据外键查询jobline
     * @param id
     * @return
     */
    public List<PrdcJobLine> getPrdcJobLine(Long id){return prdcJobLineService.getPrdcJobLineByJobId(id); }

    /**
     * 检查后占用库存并更新job
     * @param jobVO
     * @return
     */

    public Boolean startProduction(PrdcJobVO jobVO){return prdcJobService.startProduction(jobVO);}

    /**
     * 更新生产任务状态
     * @param jobVO
     * @return
     */
    public Boolean updateJobVO(PrdcJobVO jobVO){return prdcJobService.updateJobVO(jobVO);}

    /**
     * 释放占用资源并更新JOB
     * @param jobVO
     * @param whReleaseOccupationVOList
     */
    public Boolean releaseJobLineOccupyAndUpdate(PrdcJobVO jobVO,List<WhReleaseOccupationVO> whReleaseOccupationVOList){

        return prdcJobService.releaseJobLineOccupyAndUpdate(jobVO, whReleaseOccupationVOList);
    }

    /**
     * 释放后创建指令并完成后更新JOB
     * @param jobVO
     * @param whCommands
     * @param whReleaseOccupationVOList
     * @return
     * @throws Exception 
     */
    public Boolean createCommandsAfterReleaseThenFinishAndUpdate(PrdcJobVO jobVO,List<WhCommand> whCommands,

                                                                 List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception{
        return prdcJobService.createCommandsAfterReleaseThenFinishAndUpdate(jobVO, whCommands, whReleaseOccupationVOList);
    }

    /**
     * 获取配送仓库名称
     *
     * @return
     */
    public String getWarehouseName(String warehouseCode){return prdcJobService.getWarehouseName(warehouseCode);}

    /**
     * 获取仓库名称/编码键值对
     * @return
     */
    public List<Map<String, String>> getWarehouseList(List<String> warehouseCodeList){return prdcJobService.getWarehouseList(warehouseCodeList);}

    /**
     * 建立库存占用whOccupy
     * @param prdcJob
     * @param warehouseCode
     * @param occupyType
     * @return
     */
    
    public List<WhInvOccupy> buildWhOccupy(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, String warehouseCode, Integer occupyType){
        return prdcJobService.buildWhOccupy(prdcJob,prdcJobLineList, warehouseCode, occupyType);
    }

    /**
     * 建立释放库存需要的WhReleaseOccupationVO
     * @param prdcJobLineList
     * @param occupyType
     */

    public List<WhReleaseOccupationVO> buildWhRelease(PrdcJob prdcJob,List<PrdcJobLine> prdcJobLineList, Integer occupyType) {
        return prdcJobService.buildWhRelease(prdcJob,prdcJobLineList, occupyType);
    }

    /**
     * 创建出库,仓库指令需要的参数
     * @param jobVO
     * @return whCommandList
     */
    public List<WhCommand> buildPrdcCommands(PrdcJobVO jobVO) {
        return prdcJobService.buildPrdcCommands(jobVO);
    }

    /**
     * 导出收货计划状态~待入库
     * @return
     */
    public byte[] exportPoPlanStatusWaitingIn(){
        return pcsPoPlanService.exportPoPlanStatusWaitingIn();
    }

    public byte[] exportPoInfomation(){
        return pcsPoPlanService.exportPoInfomation();
    }
    /**
     * 根据id获取采购员详情
     * @return
     */
    public PcsBuyerInfoVO getBuyerInfoById(Long id){return pcsBuyerInfoService.getBuyerInfoById(id);}

    /**
     * 获取所有采购员信息
     * @return
     */
    public List<PcsBuyerInfoVO> getAllBuyers(){return pcsBuyerInfoService.getAllBuyers();}

    /**
     * 获取采购员id name对应信息
     * @return
     */
    public List<Map<String, String>> getAllBuyerInfos(){
        return pcsBuyerInfoService.getAllBuyerInfos();}

    /**
     * 条件查询采购员
     * @param cond
     * @return
     */
    public List<PcsBuyerInfoVO> getBuyerByCond(PcsBuyerCond cond){
        return pcsBuyerInfoService.getBuyerByCond(cond);
    }

    /**
     * 新建采购员
     * @param buyerInfo
     * @return
     */
    public Boolean newBuyer(PcsBuyerInfo buyerInfo){return pcsBuyerInfoService.newBuyer(buyerInfo);}

    /**
     * 更新采购员信息
     * @param buyer
     * @return
     */
    public Boolean updateBuyerInfo(PcsBuyerInfo buyer) {
        return pcsBuyerInfoService.updateBuyerInfo(buyer);
    }

    /**
     * 删除SKU的质检图片
     * @param skuCode
     * @return
     */
    public int deleteSkuQcImgBySkuCode(String skuCode){
        return pcsSkuQcImgService.deleteQcImgBySkuCode(skuCode);
    }
    /**
     * 创建SKU的质检图片
     * @param pcsSkuQcImg
     * @return
     */
    public int createSkuQcImg(PcsSkuQcImg pcsSkuQcImg){
        return pcsSkuQcImgService.createQcImg(pcsSkuQcImg);
    }

    public List<PcsSkuQcImg> findPcsSkuQcImgListBySkuCode(String skuCode){

        return pcsSkuQcImgService.findPcsSkuQcImgBySkuCode(skuCode);
    }
    
    public List<FpcsPurchaseOrder> selectFpcsPurchaseOrder(FpcsPurchaseOrder example) {
        return fpcsPurchaseOrderService.select(example);
    }
    /**
     * 获取所有sku信息列表
     * @author jim.huang
     * @date 2016年4月10日
     * @return List<FpcsSkuOrder>
     * @throws Exception
     */
    public List<FpcsSkuOrder> getAllFlowerSkuInfo() throws Exception{

        return fpcsSkuService.getAllFlowerSkuInfo();
    }

    /**
     * 获取sku信息列表
     * @param params
     * @return
     */
    public List<FpcsSkuOrder> getFlowerSkuInfo(Map<String, Object> params) {
        return fpcsSkuService.getFlowerSkuInfo(params);
    }


    /**
     * 获取所有sku信息列表
     * @author jim.huang
     * @date 2016年4月10日
     * @return List<FpcsSkuOrder>
     * @throws Exception
     */
    public List<FpcsSkuOrder> getFlowerSkuByCondition(Date time, String code) throws Exception{

        return fpcsSkuService.getFlowerSkuByCondition(time, code);
    }
	

    public int sumitOrder(FpcsOrderListForm example) {
        return fpcsPurchaseOrderService.sumitOrder(example);
    }
    public  List<FpcsPurchaseOrder> findPurchaseOrderList(FpcsPurchaseOrder cond) {
        return fpcsPurchaseOrderService.getPurchaseOrderList(cond);
    }
    public  List<FpcsPurchaseOrder> getCacheSkuOrderList(List<FpcsPurchaseOrder> fpcsPurchaseOrderList) {
        return fpcsPurchaseOrderService.getCacheSkuOrderList(fpcsPurchaseOrderList);
    }
    public  Map<String, Object> detailPurchaseOrder(long id) {
        return fpcsPurchaseOrderService.getDetailPurchaseOrder(id);
    }

    public  void acceptOrder(FpcsPurchaseOrder cond) {
        fpcsPurchaseOrderService.acceptOrder(cond);
    }
    public Map<String,List<List<String>>>  exportPurchaseOrder(FpcsPurchaseOrder example) {
        return fpcsPurchaseOrderService.exportPurchaseOrder(example);
    }

    public List<FpcsActualExcelVO> queryActualPurchaseList(Map<String, Object> params) {
        return fpcsActualPurchaseService.queryActualPurchaseList(params);
    }

    public List<FpcsChannelQuantity> queryActualPruchaseChannelList(Map<String, Object> params) {
        return fpcsActualPurchaseService.queryActualPruchaseChannelList(params);
    }

    public Long addActualPurchaseLog(FpcsActualExcelVO actualExcelVO) {
        Long ret = fpcsActualPurchaseService.addActualPurchaseLog(actualExcelVO);
        if (ret > 0) {
            List<FpcsChannelQuantity> channelQuantityList = actualExcelVO.getChannelQuantitiyList();
            for (int i = 0, len = channelQuantityList.size(); i < len; i++) {
                FpcsChannelQuantity channelQuantity = channelQuantityList.get(i);
                if (channelQuantity.getQuantity() == null ||
                        channelQuantity.getQuantity() == 0 ||
                        channelQuantity.getSkuCode() == null) {
                    continue;
                }
                channelQuantity.setActualPurchaseId(actualExcelVO.getId());
                fpcsActualPurchaseService.addActualPurhcaseChannel(channelQuantity);
            }
        }
        return ret;
    }

    public List<FpcsActualChannelVO> queryActualChannelList(Map<String, Object> params) {
        return fpcsActualPurchaseService.queryActualChannelList(params);
    }

    public List<FpcsActualChannelItemVO> queryActualChannelItemList(Map<String, Object> params) {
        return fpcsActualPurchaseService.queryActualChannelItemList(params);
    }

    public int saveConsumableAllot(List<PcsSkuVO> skuList, List<MaterailSkuVO> codeCategory){
    	
        int i = 0;
        if(skuList!=null){
            List<FpcsConsumableAllot> consumableAllotList = new ArrayList<FpcsConsumableAllot>();
            for (PcsSkuVO pcsSkuVO : skuList) {
                FpcsConsumableAllot fpcsConsumableAllot = new FpcsConsumableAllot();
                fpcsConsumableAllot.setCreatTime(new Date());
                fpcsConsumableAllot.setSkuCode(pcsSkuVO.getCode());
                fpcsConsumableAllot.setSkuName(pcsSkuVO.getName());
                fpcsConsumableAllot.setMaterial(pcsSkuVO.getMaterial());
                fpcsConsumableAllot.setSpecification(pcsSkuVO.getSpecification());
                fpcsConsumableAllot.setSize(pcsSkuVO.getSize());
                fpcsConsumableAllot.setMaxApplyNumber(pcsSkuVO.getStock());
                fpcsConsumableAllot.setApplyNumber(0);
                if(!CollectionUtils.isEmpty(codeCategory)){
                    for (MaterailSkuVO materailSkuVO : codeCategory) {
                        if(pcsSkuVO.getCode().endsWith(materailSkuVO.getSkuCode())){
                            fpcsConsumableAllot.setCategory(materailSkuVO.getCategory());
                        }
                    }
                }
                consumableAllotList.add(fpcsConsumableAllot);
            }
            i = fpcsSkuService.saveConsumableAllot(consumableAllotList);
        }
        return i;
    }
    
    public List<FpcsConsumableAllot> getAllConsumableList(){

        return fpcsSkuService.getAllConsumableList();
    }

    public List<PcsSkuVO> findChannelSkuForNoDistribute(PcsSkuCond cond) {
        return pcsSkuService.findChannelSkuForNoDistribute(cond);
    }

    public  void setSkuChannel(List<String> skuCodeList, List<String> channelCodeList,Long operatorId){
        pcsSkuService.setSkuChannel(skuCodeList,channelCodeList,operatorId);
    }

    public int addWatermark(PcsWatermarkVO iconVO) {
        return pcsWatermarkService.addIcon(iconVO);
    }

    public int updateWatermark(PcsWatermarkVO watermarkVO) {
        return pcsWatermarkService.updateIcon(watermarkVO) ;
    }

    public PcsWatermarkVO findWatermarkById(Long id) {
        return pcsWatermarkService.findWatermarkById(id);
    }

    public int deleteProdWatermark(List<String> idList){
        return pcsWatermarkService.deleteProdWatermarkByIds(idList);
    }

    public List<PcsWatermarkVO> queryWatermarkList(Map<String, Object> params) {
        return pcsWatermarkService.queryWatermarkList(params);
    }
    
    public List<ProdSkuVO> queryProdWatermarkList(PcsWatermarkCond cond) {
        return pcsWatermarkService.queryProdWatermarkList(cond);
    }
    
    public List<ProdSkuVO> querySkuListByProd(Long prodId) {
        return pcsWatermarkService.querySkuListByProd(prodId);
    }
    
    public List<ProdSkuVO> queryProdListBySkuCode(String code) {
        return pcsWatermarkService.queryProdListBySkuCode(code);
    }

    public List<ProdSkuVO> queryProdTagListByTagCode(PcsTagCond cond) {
    	return pcsTagService.queryProdTagListByTagCode(cond);
    }
    
    public PcsTagVO findTagById(Long id) {
        return pcsTagService.findTagById(id);
    }

    public List<PcsTagVO> queryTagList(Map<String, Object> params) {
        return pcsTagService.queryTagList(params);
    }

    public int addTag(PcsTagVO tagVO) {
        return pcsTagService.addTag(tagVO);
    }

    public int updateTag(PcsTagVO tagVO) {
        return pcsTagService.updateTag(tagVO);
    }

    public List<ProdSkuVO> queryProdSkuListByTagParams(List<String> params) {
		return pcsTagService.queryProdSkuListByTagParams(params);
	}
    
    public int updateSkuWatrmarkByCodeList(String skuCode, List<String> codeList) {
        return pcsWatermarkService.updateSkuWatrmarkByCodeList(skuCode, codeList);
    }
    
    public int updateProdWatrmarkByCodeList(ProdSkuVO prod, List<String> watermarkCodeList,boolean isEmptyBeforeUpdate){
        return pcsWatermarkService.updateProdWatrmarkByCodeList(prod, watermarkCodeList,isEmptyBeforeUpdate);
    }
    
    public int updateProdTagByCodeList(ProdSkuVO prod, List<String> tagCodeList,boolean isEmptyBeforeUpdate) {
        return pcsTagService.updateProdTagByCodeList(prod, tagCodeList,isEmptyBeforeUpdate);
    }

    /**
     * 更新采购单收货计划
     *
     * @return 是否成功
     */
    public boolean updatePoPlan(PcsPoPlan po){
        return  pcsPoPlanService.updatePoPlan(po);
    }

    /**
     * 更新采购单收货计划行；
     *
     * @return 是否成功
     */
    public boolean updatePoPlanLine(PcsPoPlanLine line){
        return  pcsPoPlanService.updatePoPlanLine(line);
    }


    /**
     * 获取生产订单单个耗材实际消耗数
     * @param id
     * @param skuCode
     * @return
     */
    public Integer getJobLineRealConsumeAmount(Long id,String skuCode) {
        return prdcJobLineService.getJobLineRealConsumeAmount(id,skuCode);
    }

    /**
     * 获取单张生产订单最大可启动子任务数
     * @param vo
     * @return
     */
    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo) {
        return prdcJobService.getPrdcJobMaxTask(vo);
    }

    /**
     * 子任务完成是更新加工订单状态
     * @param vo
     * @return
     */
    public boolean updatePrdcJobWhenTaskFinish(WhWmsPrdcJobTaskVO vo) {
        return prdcJobService.updatePrdcJobWhenTaskFinish(vo);
    }

    /**
     * 定时更新加工订单信息
     * 每1分钟执行一次
     * 不是使用,移到corn
     */
    //@Scheduled(cron = "0 0/1 * * * ?")
    public void updatePrdcJobWhenTaskFinish(){
        final CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("prdcJobFinishCheck");
        if(config == null){
            return;
        }

        String value = config.getConfigValue();
        if(!StringUtils.isEmpty(value) && "1".equals(value)){
            prdcJobService.updatePrdcJobWhenTaskFinish(null);
        }

    }

    public List<PcsPoPlanLine> findPoPlanLineByPoPlanId(Long poPlandId){
        return pcsPoPlanLineService.findPoPlanLineByPoPlanId(poPlandId);
    }

    /**
     * 通过采购单查询采购单所有的采购计划单是否都是收货完成
     * @param poId
     * @return
     */
    public boolean isAllPoPlanFinished(Long poId){
        return pcsPoPlanService.isAllPoPlanFinished(poId);
    };

    /**
     * 通过采购单查询采购单收货数据是否完成
     * @param poId
     * @return
     */
    public boolean isAllReceivePo(Long poId){
        return pcsPoPlanService.isAllReceivePo(poId);
    }
    public PcsPoPlan findPcsPoPlanByKey(Long id){
        return pcsPoPlanService.findPoPlanById(id);
    }
    public boolean updatePcsPurchaseOrderById(PcsPurchaseOrder pcsPurchaseOrder){
        return  pcsPurchaseOrderService.update(pcsPurchaseOrder);
    }
    public PcsPurchaseOrder findPcsPurchaseOrderById(Long id){
        PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.findPoById(id);
        return  pcsPurchaseOrder;
    }

    public Boolean closePoPlanByPlanId(Long poPlandId){
        return  pcsPoPlanService.closePoPlanByPlanId(poPlandId);
    }

    public PcsPoPlan findPcsPoPlanByCode(String code){
        return pcsPoPlanService.findPoPlanByCode(code);
    }

    public void processReceicePlan(String poPlanCode ,Map<String,Integer> liangpinMap, Map<String,Integer> canciMap){
        pcsPurchaseOrderService.processReceicePlan(poPlanCode,liangpinMap,canciMap);
    }

    /**
     * 创建标签
     * */
    public boolean createPcsCertificateField(PcsCertificateField field){
        return pcsCertificateFieldService.create(field);
    }

    /**
     * 编辑标签
     * */
    public boolean updatePcsCertificateField(PcsCertificateField field){
        return pcsCertificateFieldService.update(field);
    }

    /**
     * 删除标签
     * 逻辑删除
     * */
    public boolean deletePcsCertificateFieldById(int id){
        return pcsCertificateFieldService.deleteById(id);
    }

    public List<PcsCertificateFieldVO> findPcsCertificateField(PcsCertificateFieldCond cond){
        return pcsCertificateFieldService.findPcsCertificateField(cond);
    }

    public List<PcsCertificateFieldVO> findPcsCertificateField(PcsCertificateFieldCond cond,boolean cascade ){
        return pcsCertificateFieldService.findPcsCertificateField(cond,cascade);
    }

    public PcsCertificateFieldVO findPcsCertificateFieldById(int id){
        return pcsCertificateFieldService.findPcsCertificateFieldById(id);
    }

    public List<PcsCertificateSkuField> findAllPcsCertificateSkuField(){
        return pcsCertificateSkuFieldService.findAll();
    }

    public List<PcsCertificateSkuField> findAllPcsCertificateSkuFieldSku(){
        return pcsCertificateSkuFieldService.findAllSkuField();
    }

    public List<PcsCertificateSkuField> findAllPcsCertificateSkuFieldSys(){
        return pcsCertificateSkuFieldService.findAllSysField();
    }

    /**
     * 根据field,skuCode
     * 获取字段值
     * */
    public String getFieldValueBySkuCode(PcsCertificateSkuFieldVO field,String skuCode){
        return pcsCertificateSkuFieldService.getFieldValueBySkuCode(field, skuCode);
    }

    /**
     * 新增合格证
     * @author yu.bao
     * @date 2016年5月31日
     * @param vo
     * @return
     */
    public boolean addPcsCertificateTag(PcsCertificateTagVO vo){
        return pcsCertificateTagService.addPcsCertificateTag(vo);
    }

    /**
     * 批量新增合格证
     * @author yu.bao
     * @date 2016年5月31日
     * @param cond
     * @return
     */
    public boolean addPcsCertificateTag(List<PcsCertificateTagVO> vos){
        return pcsCertificateTagService.addPcsCertificateTag(vos);
    }

    /**
     * 建立释放库存需要的WhReleaseOccupationVO
     * @param prdcJobLineVOList
     * @param occupyType
     */
    public List<WhReleaseOccupationVO> buildWhRelease(List<PrdcJobLineVO> prdcJobLineVOList, Integer occupyType) {
        return prdcJobService.buildWhRelease(prdcJobLineVOList, occupyType);
    }
    /**
     * 建立库存占用whOccupy
     * @param prdcJobLineVOList
     * @param warehouseCode
     * @param occupyType
     * @return
     */
    public List<WhInvOccupy> buildWhOccupy(List<PrdcJobLineVO> prdcJobLineVOList, String warehouseCode, Integer occupyType){
        return prdcJobService.buildWhOccupy(prdcJobLineVOList, warehouseCode, occupyType);
    }
    /**
     * 检查后占用库存并更新job
     * @param jobVO
     * @return
     */
    public Boolean checkOccupyAndUpdate(PrdcJobVO jobVO,List<WhInvOccupy> whInvOccupyList){return prdcJobService.checkOccupyAndUpdate(jobVO, whInvOccupyList);}

    /**
     * 查询sku对应合格证标签信息
     * @author jim.huang
     * @date 2016年5月30日
     * @param skuCode
     */
    public PcsCertificateTagEditVO getTagAndSkuBySkuCode(String skuCode){
        return pcsCertificateTagService.getTagAndSkuBySkuCode(skuCode);
    }

    /**
     * 查询合格证对应字段
     * @author jim.huang
     * @date 2016年5月30日
     * @param skuCode
     * @return
     */
    public List<PcsCertificateTagFieldValueVO> getTagFieldsSkuBySkuCode(String skuCode){
        return pcsCertificateTagService.getTagFieldsSkuBySkuCode(skuCode);
    }

    /**
     * 新建标签
     * @author jim.huang
     * @date 2016年5月30日
     * @param
     */
    public int saveCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag){
        return pcsCertificateTagService.saveCertificateTagBySkuCode(pcsCertificateTag);
    }

    /**
     * 更新标签状态
     * @author jim.huang
     * @date 2016年5月30日
     * @param
     */
    public void updateCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag){
        pcsCertificateTagService.updateCertificateTagBySkuCode(pcsCertificateTag);
    }

    /**
     * 根据sku查询 合格证
     * @author yu.bao
     * @param
     * @return List<PcsCertificateTag>
     */
    public List<PcsCertificateTagVO> getCertificateTagBySkuCodes(List<String> skuCodes){
        return pcsCertificateTagService.getCertificateTagBySkuCodes(skuCodes);
    }
    
    /**
     * 根据sku,barCode查询 合格证
     * @author yu.bao
     * @param
     * @return List<PcsCertificateTag>
     */
    public List<PcsCertificateTagVO> getTagBySkuCodeBarCode(PrintCerVO cond){
        return pcsCertificateTagService.getTagBySkuCodeBarCode(cond);
    }


    /**
     * 新建标签
     * @author jim.huang
     * @date 2016年5月30日
     * @param
     */
    public void saveCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField){
        pcsCertificateTagService.saveCertificateTagFieldBySkuCode(pcsCertificateTagField);
    }

    /**
     * 更新标签状态
     * @author jim.huang
     * @date 2016年5月30日
     * @param
     */
    public void updateCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField){
        pcsCertificateTagService.updateCertificateTagFieldBySkuCode(pcsCertificateTagField);
    }

    /**
     * 删除标签状态
     * @author jim.huang
     * @date 2016年5月30日
     * @param
     */
    public void deleteCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField){
        pcsCertificateTagService.deleteCertificateTagFieldBySkuCode(pcsCertificateTagField);
    }

    public List<PcsCertificateFieldVO> getTagFieldsSkuByIds(List<Integer> ids) {
        return pcsCertificateTagService.getTagFieldsSkuByIds(ids);
    }

    /**
     * 根据sku查询
     * @author ztq
     * @date 2016年6月1日
     * @param
     */
    public PcsCertificateTagVO searchTagBySkuCode(PcsCertificateTag pcsCertificateTag){
        return pcsCertificateTagService.searchTagBySkuCode(pcsCertificateTag);
    }

    /**
     * 删除前端类目关系
     * @param idList
     */
    public void deleteFrontCategoryRelationList(List<Long> idList) {
        pcsSkuCategoryService.deleteFrontCategoryRelationList(idList);
    }

    /**
     * 删除后端类目关系
     * @param idList
     */
    public void deleteBackCategoryRelationList(List<Long> idList) {
        pcsSkuCategoryService.deleteBackCategoryRelationList(idList);
    }
    
    /**
     * 查询收货标准
     * */
    public List<PcsSkuReceiveStandardVO> listSkuByCond(PcsSkuReceiveStandardCond cond){
    	return pcsSkuReceiveStandardService.listSkuByCond(cond);
    }
    
	/**
	 * 根据skuCode获取查询标准
	 * */
    public PcsSkuReceiveStandardVO findPcsSkuReceiveStandardBySkuCode(String skuCode){
		return pcsSkuReceiveStandardService.findPcsSkuReceiveStandardBySkuCode(skuCode);
	}
    
    /**
	 * 编辑收货标准
	 * */
    public boolean createOrEditSkuReceiveStandard(PcsSkuReceiveStandardVO vo){
		return pcsSkuReceiveStandardService.createOrEditSkuReceiveStandard(vo);
	}
    /**
     * 查询所有启动的收货规则
     * */
    public List<PcsSkuReceiveStandardRuleVO> findAllReceiveStandardRule(){
    	return pcsSkuReceiveStandardService.findAllReceiveStandardRule();
    }
    
    /**
     * 查询sku所有启动的收货规则
     * */
    public List<PcsSkuReceiveStandardRuleVO> findSkuReceiveStandardRule(String skuCode){
    	return pcsSkuReceiveStandardService.findSkuReceiveStandardRule(skuCode);
    }
	
    /**
     * 查询收货规则
     * */
    public PcsSkuReceiveStandardRuleVO findReceiveStandardRuleVOById(Long id){
    	return pcsSkuReceiveStandardService.findReceiveStandardRuleVOById(id);
    }
    /**
     * 创建收货规则
     * */
    public boolean createReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo){
    	return pcsSkuReceiveStandardService.createReceiveStandardRule(vo);
    }
    /**
     * 更新收货规则
     * */
    public boolean updateReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo){
    	return pcsSkuReceiveStandardService.updateReceiveStandardRule(vo);
    }
    /**
     * 删除收货规则
     * 软删除
     * */
    public boolean deleteReceiveStandardRule(Long id){
    	return pcsSkuReceiveStandardService.deleteReceiveStandardRule(id);
    }


    public List<PcsSkuVO> findSkuByIds(List<Long> ids) { 
    	return pcsSkuService.findSkuByIds(ids);
    }
    
    public List<PcsSkuVO> findSkuAuditByIds(List<Long> ids) { 
    	return pcsSkuService.findSkuAuditByIds(ids);
    }
    
    /**
     * 查询sku是否有售价审核通过的记录
     * @param code
     * @param status
     * @return
     */
    public List<PcsSkuSalesPriceChange> findByCodeAndStatus(String code, Integer status) {
    	return pcsSkuSalesPriceChangeService.findByCodeAndStatus(code, status);
    }

	public List<ProdSkuVO> queryProdWatermarkListByParams(List<String> params) {
		return pcsWatermarkService.queryProdWatermarkListByParams(params);
	}

	public ProdSkuVO queryProductByProdId(Long prodId) {
		return pcsWatermarkService.queryProductByProdId(prodId);
	}

	public List<PrdcJob> findSkuReportJobVO() { 
		return prdcJobService.findSkuReportJobVO();
	}

	public int deleteProdTagByIds(List<String> idList) {
		return pcsTagService.deleteProdTagByIds(idList);
	}
	/**
	 * 根据skucodes查询合格正信息
     * @return
     */
    public List<PcsCertificateTagFieldValueVO> getTagsBySkuCode(List<String> skuCodes) {
		List<PcsCertificateTagFieldValueVO> list = pcsCertificateFieldService.getTagsBySkuCode(skuCodes);
		return list;
	}

	public int createPoPlanFee(PcsPoPlanCost pcsPoPlanCost) {
		return pcsPoPlanService.createPoPlanFee(pcsPoPlanCost);
	}
	
	public List<PcsPoPlanCost> selectCostByPoPlanId(Integer poPlanId) {
		return pcsPoPlanService.selectCostByPoPlanId(poPlanId);
	}
	
	public Long insertIntoCategoryFrontEntity(Map<String,Object> map){
		return pcsSkuCategoryService.insertIntoCategoryFrontEntity(map);
	}
	
	public Long updateCategoryFrontEntity(Map<String,Object> map){
		return pcsSkuCategoryService.updateCategoryFrontEntity(map);
	}
	
	public List<PcsSkuBarcodeVO> selectByBarCode(String barCode) { 
		return pcsSkuService.selectByBarCode(barCode);
	}
	
	public int updatePoPlanFee(PcsPoPlanCost pcsPoPlanCost, int optType) {
		return pcsPoPlanService.updatePoPlanFee(pcsPoPlanCost, optType);
	}

}
