/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.ResourceUtils;

public class ApplicationContextUtil {
    private static ConfigurableApplicationContext context;
    private static ApplicationContextUtil instance;

    static {
        DataSource dataSource;
        context = null;
        instance = null;
        String logConfigLocation = "classpath:log4j2.xml";
        File configFile = null;
        try {
            configFile = ResourceUtils.getFile((String)logConfigLocation);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (!configFile.exists()) {
            System.err.println("log4j2 config file:" + configFile.getAbsolutePath() + " not exist");
            System.exit(0);
        }
        System.out.println("log4j2 config file:" + configFile.getAbsolutePath());
        try {
            System.setProperty("log4j.configurationFile", configFile.getAbsolutePath());
        }
        catch (Exception e) {
            System.err.println("log4j2 initialize error:" + e.getLocalizedMessage());
            System.exit(0);
        }
        String configLocation = "classpath:spring.xml";
        try {
            configFile = ResourceUtils.getFile((String)logConfigLocation);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!configFile.exists()) {
            System.err.println("spring config file:" + configFile.getAbsolutePath() + " not exist");
            System.exit(0);
        }
        System.out.println("spring config file:" + configFile.getAbsolutePath());
        if (context == null && (context = new ClassPathXmlApplicationContext("spring.xml")).containsBean("dataSource") && (dataSource = (DataSource)context.getBean("dataSource", DataSource.class)) != null) {
            try {
                Connection connection = dataSource.getConnection();
                connection.close();
            }
            catch (SQLException e) {
                System.err.println("spring initialize error:" + e.getLocalizedMessage());
                System.exit(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationContextUtil getInstance() {
        if (instance != null) return instance;
        Class<ApplicationContextUtil> clazz = ApplicationContextUtil.class;
        synchronized (ApplicationContextUtil.class) {
            if (instance != null) return instance;
            instance = new ApplicationContextUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ConfigurableApplicationContext getContext() {
        return context;
    }

    private ApplicationContextUtil() {
    }
}

