/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.client.SkuESClient;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsSkuCond;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mcPsSkuService")
public class McPsSKuServiceImpl
implements McPsSkuService {
    @Autowired
    private SkuESClient client;
    @Autowired
    private McPsProductService mcPsProductService;

    public boolean create(PsSkuVO vo) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        return this.client.create(vo, stackTraceElement);
    }

    public boolean update(PsSkuVO vo) {
        return this.client.update(vo);
    }

    public boolean update(List<PsSkuVO> vos) {
        return this.client.update(vos);
    }

    public boolean deleteBySkuCode(String skuCode) {
        return this.client.deleteByPrimaryKey(skuCode);
    }

    public List<PsSkuVO> findBySkuName(String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuName", name);
        params.put("skuNameCN", name);
        return this.client.findByFields(params, SearchType.OR);
    }

    public PsSkuVO findBySkuCode(String code) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", code);
        List skuVOs = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(skuVOs)) {
            return null;
        }
        return (PsSkuVO)skuVOs.get(0);
    }

    public List<PsSkuVO> findBySkuCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pagenum", Integer.MAX_VALUE);
        int _page_max = 50;
        if (codes.size() > _page_max) {
            int length = codes.size();
            int len = length / _page_max;
            ArrayList<PsSkuVO> allSkus = new ArrayList<PsSkuVO>(codes.size());
            int i = 0;
            while (i < len) {
                params.put("skuCode", codes.subList(_page_max * i, _page_max * (i + 1)));
                params.put("pagenum", Integer.MAX_VALUE);
                allSkus.addAll(this.client.findByFields(params, SearchType.OR));
                ++i;
            }
            if (length % _page_max > 0) {
                params.put("skuCode", codes.subList(_page_max * len, length));
                params.put("pagenum", Integer.MAX_VALUE);
                allSkus.addAll(this.client.findByFields(params, SearchType.OR));
            }
            return allSkus;
        }
        params.put("skuCode", codes);
        return this.client.findByFields(params, SearchType.OR);
    }

    public List<PsSkuVO> findBySuppIds(List<Long> suppIds) {
        if (CollectionUtils.isEmpty(suppIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("supplierId", suppIds);
        return this.client.findByFields(params, SearchType.OR);
    }

    public List<PsSkuVO> findByBrandIds(List<Long> brandIds) {
        if (CollectionUtils.isEmpty(brandIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("brandId", brandIds);
        return this.client.findByFields(params, SearchType.OR);
    }

    public List<PsSkuVO> findByCateIds(List<Long> cateIds) {
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", cateIds);
        return this.client.findByFields(params, SearchType.OR);
    }

    public List<PsSkuVO> findByCond(PsSkuCond cond) {
        Map params = McReflectionUtil.getFieldNameValue((Object)cond);
        return this.client.findByFields(params, SearchType.ANDLIKE);
    }

    public List<PsSkuVO> findAll() {
        return this.client.findAllByField(null, null);
    }

    public boolean create(List<PsSkuVO> vos) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        return this.client.create(vos, stackTraceElement);
    }

    private PsSkuVO validateSkuCode(String skuCode) {
        PsSkuVO vos = this.findBySkuCode(skuCode);
        if (vos == null) {
            throw new PublicException("PB0002", "SKU \u4e0d\u5b58\u5728");
        }
        return vos;
    }

    public List<PsSkuVO> findByCodeName(String codeName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", codeName);
        params.put("skuName", codeName);
        params.put("skuNameCN", codeName);
        params.put("pagenum", 100);
        return this.client.findByFields(params, SearchType.ORLIKE);
    }

    public List<PsSkuVO> findByCodeName(String codeName, Integer currpage, Integer pagenum) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", codeName);
        params.put("skuName", codeName);
        params.put("skuNameCN", codeName);
        params.put("pagenum", pagenum);
        return this.client.findByFields(params, SearchType.ORLIKE);
    }

    public List<PsSkuVO> findSkuByCodeName(String codeName, Integer currpage, Integer pagenum) {
        return this.client.findSkuByFieldWithKeyWords(codeName, currpage, pagenum);
    }

    public PsSkuVO findBySkuCode(String code, PsMatchCampaignCond cond) {
        PsSkuVO skuVO = this.findBySkuCode(code);
        this.mcPsProductService.calculateDiscountPrice(skuVO, cond);
        return skuVO;
    }

    public List<PsSkuVO> findBySkuName(String codeName, Integer currpage, Integer pagenum, PsMatchCampaignCond cond) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        params.put("or", boolQueryBuilder);
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)codeName).field("skuCode"));
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"skuName", (Object)codeName).slop(2).minimumShouldMatch("75%"));
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"skuNameCN", (Object)codeName).slop(2).minimumShouldMatch("75%"));
        params.put("pagenum", pagenum);
        HashMap sortMap = new HashMap();
        HashMap<String, String> sMap = new HashMap<String, String>();
        sortMap.put("_score", sMap);
        sMap.put("order", "desc");
        sMap.put("mode", "min");
        params.put("sort", sortMap);
        List<PsSkuVO> skuVOs = this.client.findByFields(params, SearchType.ORLIKE);
        if (CollectionUtils.isNotEmpty(skuVOs)) {
            for (PsSkuVO skuVO : skuVOs) {
                this.mcPsProductService.calculateDiscountPrice(skuVO, cond);
            }
        }
        return skuVOs;
    }
}

