/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsTagCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsTagDomain;
import com.thebeastshop.pegasus.merchandise.service.McPcsTagService;
import com.thebeastshop.pegasus.merchandise.vo.PcsTagVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/tag")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="mcPcsTagService")
public class McPcsTagServiceImpl
implements McPcsTagService {
    @Autowired
    private PcsTagDomain pcsTagDomain;

    @POST
    public Long addTag(PcsTagVO tagVO) {
        this.pcsTagDomain.addTag(tagVO);
        return tagVO.getId();
    }

    @PUT
    public int updateTag(PcsTagVO tagVO) {
        return this.pcsTagDomain.updateTag(tagVO);
    }

    @GET
    @Path(value="{id:\\d+}")
    public PcsTagVO findTagById(@PathParam(value="id") Long id) {
        return this.pcsTagDomain.findTagById(id);
    }

    public List<PcsTagVO> queryTagListByProdId(Long prodId) {
        return this.pcsTagDomain.queryTagListByProdId(prodId);
    }

    public List<PcsTagVO> queryTagList(Map<String, Object> params) {
        return this.pcsTagDomain.queryTagList(params);
    }

    public List<ProdSkuVO> queryProdTagListByTagCode(PcsTagCond cond) {
        return this.pcsTagDomain.queryProdTagListByTagCode(cond);
    }

    public List<ProdSkuVO> queryProdSkuListByTagParams(List<String> params) {
        return this.pcsTagDomain.queryProdSkuListByTagParams(params);
    }

    public int updateProdTagByCodeList(ProdSkuVO prod, List<String> codeList, boolean isEmptyBeforeUpdate) {
        return this.pcsTagDomain.updateProdTagByCodeList(prod, codeList, isEmptyBeforeUpdate);
    }

    @DELETE
    public int deleteProdTagByIds(@FormParam(value="idList") List<String> idList) {
        return this.pcsTagDomain.deleteProdTagByIds(idList);
    }
}

