/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryRelationCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuCategoryGmMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuCategoryMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCategoryDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategory;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategoryGm;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategoryRelation;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCategoryService;
import com.thebeastshop.pegasus.merchandise.vo.CategoryTreeNodeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsFrontBackCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryGmInfo;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryRelationVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mcPcsSkuCategoryService")
public class McPcsSkuCategoryServiceImpl
implements McPcsSkuCategoryService {
    private static final Logger log = LoggerFactory.getLogger(McPcsSkuCategoryServiceImpl.class);
    @Autowired
    private PcsSkuCategoryDomain pcsSkuCategoryDomain;
    @Autowired
    private PcsSkuDomain pcsSkuDomain;
    @Autowired
    PcsSkuCategoryMapper pcsSkuCategoryMapper;
    @Autowired
    private PcsSkuCategoryGmMapper pcsSkuCategoryGmMapper;

    public Long create(PcsSkuCategoryVO record) {
        return this.pcsSkuCategoryDomain.create((PcsSkuCategory)this.pcsSkuCategoryDomain.buildFromVO(record));
    }

    public Long createBackCategory(PcsSkuCategoryVO record) {
        return this.pcsSkuCategoryDomain.createBackCategory((PcsSkuCategory)this.pcsSkuCategoryDomain.buildFromVO(record));
    }

    public boolean update(PcsSkuCategoryVO vo) {
        PcsSkuCategory record = (PcsSkuCategory)this.pcsSkuCategoryDomain.buildFromVO(vo);
        return this.pcsSkuCategoryDomain.update(record);
    }

    public boolean updateBackCategory(PcsSkuCategoryVO vo) {
        PcsSkuCategory record = (PcsSkuCategory)this.pcsSkuCategoryDomain.buildFromVO(vo);
        return this.pcsSkuCategoryDomain.updateBackCategory(record);
    }

    public PcsSkuCategoryVO findById(long id) {
        PcsSkuCategory record = this.pcsSkuCategoryDomain.findById(id);
        PcsSkuCategoryVO vo = (PcsSkuCategoryVO)this.pcsSkuCategoryDomain.buildFromModel(record);
        return vo;
    }

    public PcsSkuCategoryVO findBackCategoryById(long id) {
        PcsSkuCategory record = this.pcsSkuCategoryDomain.findBackCategoryById(id);
        PcsSkuCategoryVO vo = (PcsSkuCategoryVO)this.pcsSkuCategoryDomain.buildFromModel(record);
        return vo;
    }

    public List<PcsSkuCategoryVO> findFrontCategoriesBySkuCode(String skuCode) {
        List<PcsSkuCategory> categoryList = this.pcsSkuCategoryDomain.findFrontCategoriesBySkuCode(skuCode);
        List voList = BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class);
        return voList;
    }

    public List<PcsSkuCategoryVO> findBackCategoriesBySkuCode(String skuCode) {
        List<PcsSkuCategory> categoryList = this.pcsSkuCategoryDomain.findBackCategoriesBySkuCode(skuCode);
        List voList = BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class);
        return voList;
    }

    public List<PcsSkuCategoryVO> findFrontCategoriesBySkuCodeList(List<String> skuCodeList) {
        List<PcsSkuCategory> categoryList = this.pcsSkuCategoryDomain.findFrontCategoriesBySkuCodeList(skuCodeList);
        List voList = BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class);
        return voList;
    }

    public List<PcsSkuCategoryVO> findAllChildrens(long parentId) {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryDomain.findAllChildrens(parentId);
        ArrayList<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = (PcsSkuCategoryVO)this.pcsSkuCategoryDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsSkuCategoryVO> findAllBackCategoryChildrens(long parentId) {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryDomain.findAllBackCategoryChildrens(parentId);
        List vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    public List<PcsSkuCategoryVO> findAll() {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryDomain.findAll();
        List vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    public List<PcsSkuCategoryVO> findAllFrontCategories() {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryDomain.findAllFrontCategories();
        List vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    public PcsSkuCategoryVO findByCode(String code) {
        PcsSkuCategory category = this.pcsSkuCategoryDomain.findByCode(code);
        PcsSkuCategoryVO vo = (PcsSkuCategoryVO)this.pcsSkuCategoryDomain.buildFromModel(category);
        return vo;
    }

    public List<PcsSkuCategoryVO> findByName(String name) {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryDomain.findByName(name);
        List vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    public List<PcsSkuCategoryVO> findBackCategoryByName(String name) {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryDomain.findBackCategoryByName(name);
        List vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    public List<PcsSkuCategoryVO> findByIds(List<Long> ids) {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryDomain.findByIds(ids);
        List vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    public List<PcsSkuCategoryVO> findBackCategoriesByIds(List<Long> ids) {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryDomain.findBackCategoriesByIds(ids);
        List vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    public List<PcsSkuCategoryVO> findByCodeAndRightLikeCode(String code) {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryDomain.findByCodeAndRightLikeCode(code);
        List vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    public List<PcsSkuCategoryVO> findSkuCategoryByParentIdIsNull() {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryDomain.findSkuCategoryByParentIdIsNull();
        List vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    public PcsSkuCategoryVO findByParentID(Long parentID) {
        PcsSkuCategory category = this.pcsSkuCategoryDomain.findByParentID(parentID);
        PcsSkuCategoryVO vo = (PcsSkuCategoryVO)this.pcsSkuCategoryDomain.buildFromModel(category);
        return vo;
    }

    public List<Long> findProductIdsBySkuCodes(List<String> skuCodes) {
        return this.pcsSkuCategoryDomain.findProductIdsBySkuCodes(skuCodes);
    }

    public List<Long> findProductIdListByCategoryFrontRelationIds(List<Long> ids) {
        return this.pcsSkuCategoryDomain.findProductIdListByCategoryFrontRelationIds(ids);
    }

    public List<PcsFrontBackCategoryVO> findFrontBackCategoryList(Map<String, Object> params) {
        return this.pcsSkuCategoryDomain.findFrontBackCategoryList(params);
    }

    public List<PcsSkuCategoryVO> findFrontCategoryList(Map<String, Object> params) {
        return this.pcsSkuCategoryDomain.findFrontCategoryList(params);
    }

    public List<PcsSkuCategoryVO> findBackCategoryList(Map<String, Object> params) {
        return this.pcsSkuCategoryDomain.findBackCategoryList(params);
    }

    public List<PcsSkuCategoryRelationVO> findBackCategoryRelationList(PcsSkuCategoryRelationCond cond) {
        List<PcsSkuCategoryRelation> recordList = this.pcsSkuCategoryDomain.findBackCategoryRelationList(cond);
        List vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryRelationVO.class);
        return vos;
    }

    public void saveOrUpdateBackCategoryRelationList(List<PcsSkuCategoryRelationVO> relationList) {
        List relations = BeanUtil.buildListFrom(relationList, PcsSkuCategoryRelation.class);
        this.pcsSkuCategoryDomain.saveOrUpdateBackCategoryRelationList(relations);
    }

    public void saveOrUpdateBackCategoryRelation(PcsSkuCategoryRelationVO vo) {
        PcsSkuCategoryRelation relation = (PcsSkuCategoryRelation)BeanUtil.buildFrom((Object)vo, PcsSkuCategoryRelation.class);
        this.pcsSkuCategoryDomain.saveOrUpdateBackCategoryRelation(relation);
    }

    public Integer addFrontCategoryRelation(PcsSkuCategoryRelationVO vo) {
        PcsSkuCategoryRelation relation = (PcsSkuCategoryRelation)BeanUtil.buildFrom((Object)vo, PcsSkuCategoryRelation.class);
        return this.pcsSkuCategoryDomain.addFrontCategoryRelation(relation);
    }

    public Integer addBackCategoryRelation(PcsSkuCategoryRelationVO vo) {
        PcsSkuCategoryRelation relation = (PcsSkuCategoryRelation)BeanUtil.buildFrom((Object)vo, PcsSkuCategoryRelation.class);
        return this.pcsSkuCategoryDomain.addBackCategoryRelation(relation);
    }

    public Integer addFrontBackCategoryRelation(PcsFrontBackCategoryVO vo) {
        return this.pcsSkuCategoryDomain.addFrontBackCategoryRelation(vo);
    }

    public Integer updateBackCategoryRelation(PcsSkuCategoryRelationVO vo) {
        PcsSkuCategoryRelation relation = (PcsSkuCategoryRelation)BeanUtil.buildFrom((Object)vo, PcsSkuCategoryRelation.class);
        return this.pcsSkuCategoryDomain.updateBackCategoryRelation(relation);
    }

    public void updateSkuCategoryRelation(PcsSkuCategoryRelationVO relation) {
        this.pcsSkuCategoryDomain.updateFrontCategoryRelation((PcsSkuCategoryRelation)BeanUtil.buildFrom((Object)relation, PcsSkuCategoryRelation.class));
    }

    public List<PcsSkuCategoryRelationVO> findFrontCategoryRelation(PcsSkuCategoryRelationCond cond) {
        List<PcsSkuCategoryRelation> relationList = this.pcsSkuCategoryDomain.findFrontCategoryRelation(cond);
        List vos = BeanUtil.buildListFrom(relationList, PcsSkuCategoryRelationVO.class);
        return vos;
    }

    public List<Long> findFrontCategoryIdListByBackCategoryId(Long backCategoryRelationId) {
        return this.pcsSkuCategoryDomain.findFrontCategoryIdListByBackCategoryId(backCategoryRelationId);
    }

    public List<Long> findFrontCategoryIdListByBackCategoryIds(List<Long> backCategoryRelationIds) {
        return this.pcsSkuCategoryDomain.findFrontCategoryIdListByBackCategoryIds(backCategoryRelationIds);
    }

    public List<Long> findBackCategoryIdListByFrontCategoryId(Long frontCategoryRelationId) {
        return this.pcsSkuCategoryDomain.findBackCategoryIdListByFrontCategoryId(frontCategoryRelationId);
    }

    public Integer countOfFrontCategoryRelation(PcsSkuCategoryRelationCond cond) {
        return this.pcsSkuCategoryDomain.countOfFrontCategoryRelation(cond);
    }

    public void updateFrontCategoryRelation(PcsSkuCategoryRelationVO vo) {
        PcsSkuCategoryRelation relation = (PcsSkuCategoryRelation)BeanUtil.buildFrom((Object)vo, PcsSkuCategoryRelation.class);
        this.pcsSkuCategoryDomain.updateFrontCategoryRelation(relation);
    }

    public void deleteFrontCategoryRelationList(List<Long> idList) {
        this.pcsSkuCategoryDomain.deleteFrontCategoryRelationList(idList);
    }

    public void deleteBackCategoryRelationList(List<Long> idList) {
        this.pcsSkuCategoryDomain.deleteBackCategoryRelationList(idList);
    }

    public void synFrontCategoryRelation(String skuCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", skuCode);
        List<PcsSkuCategoryVO> backCategoryList = this.findBackCategoryList(params);
        PcsSkuVO sku = this.pcsSkuDomain.findByCode(skuCode);
        if (sku == null) {
            log.warn("[synFrontCategoryRelation] SKU[{}] not found!", (Object)sku);
            return;
        }
        ArrayList<Long> backIds = new ArrayList<Long>();
        int i = 0;
        while (i < backCategoryList.size()) {
            PcsSkuCategoryVO backCategory = backCategoryList.get(i);
            backIds.add(backCategory.getId());
            ++i;
        }
        List<Long> newFrontCategoryIds = this.findFrontCategoryIdListByBackCategoryIds(backIds);
        log.info("[synFrontCategoryRelation] \u540c\u6b65sku[{}]\uff0c\u76f8\u5173\u7684\u540e\u53f0\u7c7b\u76ee:id[{}], \u524d\u53f0\u7c7b\u76ee:id[{}]", new Object[]{skuCode, StringUtils.join(backIds, (String)", "), StringUtils.join(newFrontCategoryIds, (String)", ")});
        PcsSkuCategoryRelationCond cond = new PcsSkuCategoryRelationCond();
        cond.setSkuCode(skuCode);
        cond.setNotCategoryIdList(newFrontCategoryIds);
        List<PcsSkuCategoryRelationVO> toDelBackRelationList = this.findFrontCategoryRelation(cond);
        ArrayList<Long> toDelIdList = new ArrayList<Long>();
        int i2 = 0;
        while (i2 < toDelBackRelationList.size()) {
            PcsSkuCategoryRelationVO relation = toDelBackRelationList.get(i2);
            toDelIdList.add(relation.getId());
            ++i2;
        }
        this.deleteFrontCategoryRelationList(toDelIdList);
        if (EmptyUtil.isNotEmpty(toDelIdList)) {
            log.info("synFrontCategoryRelation \u540c\u6b65sku[{}]\u7c7b\u76ee\u65f6\uff0c\u6e05\u9664\u7684\u524d\u53f0\u7c7b\u76ee:[{}]", (Object)skuCode, (Object)StringUtils.join(toDelIdList, (String)", "));
        }
        ArrayList<Long> needToAddCategoryIds = new ArrayList<Long>();
        int i3 = 0;
        while (i3 < newFrontCategoryIds.size()) {
            Long categoryId = newFrontCategoryIds.get(i3);
            PcsSkuCategoryRelationVO relation = new PcsSkuCategoryRelationVO();
            relation.setSkuCode(skuCode);
            relation.setCategoryId(categoryId);
            PcsSkuCategoryRelationCond frontCond = new PcsSkuCategoryRelationCond();
            frontCond.setSkuCode(skuCode);
            frontCond.setCategoryId(categoryId);
            List<PcsSkuCategoryRelationVO> list = this.findFrontCategoryRelation(frontCond);
            if (EmptyUtil.isEmpty(list)) {
                this.addFrontCategoryRelation(relation);
                needToAddCategoryIds.add(relation.getCategoryId());
            }
            ++i3;
        }
        if (EmptyUtil.isNotEmpty(needToAddCategoryIds)) {
            log.info("synFrontCategoryRelation \u540c\u6b65sku[{}]\u7c7b\u76ee\u65f6\uff0c\u6dfb\u52a0\u7684\u7684\u524d\u53f0\u7c7b\u76ee\uff1a[{}]", (Object)sku.getCode(), (Object)StringUtils.join(needToAddCategoryIds, (String)", "));
        }
    }

    public void saveFrontCategoryRelationByBack(PcsSkuCategoryRelationVO backCategoryRelation) {
        List<Long> frontCategoryIdList = this.findFrontCategoryIdListByBackCategoryId(backCategoryRelation.getCategoryId());
        int i = 0;
        while (i < frontCategoryIdList.size()) {
            Long frontCategoryId = frontCategoryIdList.get(i);
            PcsSkuCategoryRelationCond cond = new PcsSkuCategoryRelationCond();
            cond.setSkuCode(backCategoryRelation.getSkuCode());
            cond.setCategoryId(frontCategoryId);
            Integer ret = this.countOfFrontCategoryRelation(cond);
            if (ret != null && ret == 0) {
                PcsSkuCategoryRelation relation = new PcsSkuCategoryRelation();
                relation.setSkuCode(backCategoryRelation.getSkuCode());
                relation.setCategoryId(frontCategoryId);
                this.pcsSkuCategoryDomain.addFrontCategoryRelation(relation);
            }
            ++i;
        }
    }

    public void deleteFrontCategoryRelationByBack(PcsSkuCategoryRelationVO backCategoryRelation) {
        List<Long> frontCategoryIdList = this.findFrontCategoryIdListByBackCategoryId(backCategoryRelation.getCategoryId());
        int i = 0;
        while (i < frontCategoryIdList.size()) {
            Long frontCategoryId = frontCategoryIdList.get(i);
            PcsSkuCategoryRelationCond cond = new PcsSkuCategoryRelationCond();
            cond.setSkuCode(backCategoryRelation.getSkuCode());
            cond.setCategoryId(frontCategoryId);
            List<PcsSkuCategoryRelation> frontRelationList = this.pcsSkuCategoryDomain.findFrontCategoryRelation(cond);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (PcsSkuCategoryRelation relation : frontRelationList) {
                idList.add(relation.getId());
            }
            this.deleteFrontCategoryRelationList(idList);
            ++i;
        }
    }

    public List<Long> findProductIdsByCategoryFrontRelationIds(List<Long> ids) {
        return this.pcsSkuCategoryDomain.findProductIdListByCategoryFrontRelationIds(ids);
    }

    public List<PcsSkuCategoryRelationVO> findBackCategoryRelation(PcsSkuCategoryRelationCond cond) {
        List<PcsSkuCategoryRelation> relations = this.pcsSkuCategoryDomain.findBackCategoryRelationList(cond);
        return BeanUtil.buildListFrom(relations, PcsSkuCategoryRelationVO.class);
    }

    public List<PcsFrontBackCategoryVO> findAllFrontBackCategoryList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.pcsSkuCategoryDomain.findFrontBackCategoryList(params);
    }

    public List<PcsSkuCategoryVO> findAllFrontCategoryList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.pcsSkuCategoryDomain.findFrontCategoryList(params);
    }

    public List<PcsSkuCategoryVO> findAllBackCategoryList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<PcsSkuCategoryVO> recordList = this.pcsSkuCategoryDomain.findBackCategoryList(params);
        return recordList;
    }

    public List<PcsSkuCategoryVO> findAllFirstBackCategoryList() {
        return this.pcsSkuCategoryDomain.findAllFirstBackCategoryList();
    }

    public Long createFrontCategory(PcsSkuCategoryVO record) {
        return this.pcsSkuCategoryDomain.createFrontCategory((PcsSkuCategory)this.pcsSkuCategoryDomain.buildFromVO(record));
    }

    public boolean updateFrontCategory(PcsSkuCategoryVO vo) {
        PcsSkuCategory record = (PcsSkuCategory)this.pcsSkuCategoryDomain.buildFromVO(vo);
        return this.pcsSkuCategoryDomain.updateFrontCategory(record);
    }

    @Transactional
    public boolean updateFrontBackCategoryRelationByFrontId(PcsFrontBackCategoryVO frontBackCategoryVO) {
        Long frontSkuCategoryId = frontBackCategoryVO.getFrontSkuCategoryId();
        List backSKuCategoryIdList = frontBackCategoryVO.getBackSKuCategoryIdList();
        if (frontSkuCategoryId != null) {
            this.pcsSkuCategoryDomain.deleteFrontBackCategoryRelationByFrontId(frontSkuCategoryId);
            if (CollectionUtils.isNotEmpty((Collection)backSKuCategoryIdList)) {
                for (Long id : backSKuCategoryIdList) {
                    PcsFrontBackCategoryVO vo = new PcsFrontBackCategoryVO();
                    vo.setFrontSkuCategoryId(frontSkuCategoryId);
                    vo.setBackSKuCategoryId(id);
                    this.pcsSkuCategoryDomain.addFrontBackCategoryRelation(vo);
                }
            }
            return true;
        }
        return false;
    }

    public List<Long> listLeafCategoryId(List<Long> categoryIds) {
        if (CollectionUtils.isEmpty(categoryIds)) {
            return Lists.newArrayList();
        }
        List<Long> result = this.pcsSkuCategoryMapper.listLeafCategoryId(categoryIds);
        return result;
    }

    public List<PcsFrontBackCategoryVO> findRelationBackCategoryByFrontCategoryId(Long frontId) {
        return this.pcsSkuCategoryDomain.findRelationBackCategoryByFrontCategoryId(frontId);
    }

    public Map<String, PcsSkuCategoryVO> findFirstCategoryBySkucodes(List<String> skuCodes) {
        HashMap<String, PcsSkuCategoryVO> map = new HashMap<String, PcsSkuCategoryVO>();
        List<PcsSkuCategoryVO> categoryList = this.pcsSkuCategoryMapper.findCodePNameBySkuCodeList(skuCodes);
        for (PcsSkuCategoryVO vo : categoryList) {
            PcsSkuCategoryVO pcsSkuCategoryVO = new PcsSkuCategoryVO();
            if (vo.getId() != null) {
                pcsSkuCategoryVO = this.pcsSkuCategoryDomain.findFirstCategoryByParentId(vo.getId());
            }
            pcsSkuCategoryVO.setProductName(vo.getProductName());
            map.put(vo.getSkucode(), pcsSkuCategoryVO);
        }
        return map;
    }

    public Map<String, PcsSkuCategoryVO> findFirstCategoryIdBySkucodes(List<String> skuCodes) {
        HashMap<String, PcsSkuCategoryVO> map = new HashMap<String, PcsSkuCategoryVO>();
        log.info("findFirstCategoryIdBySkucodes skuCodes" + skuCodes);
        List<PcsSkuCategoryVO> categoryList = this.pcsSkuCategoryMapper.findCodeBySkuCodeList(skuCodes);
        log.info("findFirstCategoryIdBySkucodes list" + categoryList);
        if (CollectionUtils.isNotEmpty(categoryList)) {
            for (PcsSkuCategoryVO vo : categoryList) {
                PcsSkuCategoryVO pcsSkuCategoryVO = new PcsSkuCategoryVO();
                log.info("findFirstCategoryIdBySkucodes vo" + vo);
                if (vo == null) continue;
                if (vo.getId() != null) {
                    pcsSkuCategoryVO = this.pcsSkuCategoryDomain.findFirstCategoryByParentId(vo.getId());
                }
                map.put(vo.getSkucode(), pcsSkuCategoryVO);
            }
        }
        return map;
    }

    public PcsSkuCategoryVO findFirstCategoryById(Long id) {
        PcsSkuCategoryVO pcsSkuCategoryVO = this.pcsSkuCategoryDomain.findFirstCategoryByParentId(id);
        return pcsSkuCategoryVO;
    }

    public Map<Long, PcsSkuCategoryVO> findFirstCategoryByIds(List<Long> ids) {
        HashMap<Long, PcsSkuCategoryVO> map = new HashMap<Long, PcsSkuCategoryVO>();
        for (Long id : ids) {
            PcsSkuCategoryVO pcsSkuCategoryVO = this.pcsSkuCategoryDomain.findFirstCategoryByParentId(id);
            map.put(id, pcsSkuCategoryVO);
        }
        return map;
    }

    public List<Long> findByCondCategory(PcsSkuCategoryCond cond) {
        return this.pcsSkuCategoryDomain.findByCondCategory(cond);
    }

    public List<PcsSkuCategoryVO> findByCondCategoryCron(PcsSkuCategoryCond cond) {
        return this.pcsSkuCategoryDomain.findByCondCategoryCron(cond);
    }

    public List<CategoryTreeNodeVO> listAllCategoryTreeNode() {
        List<CategoryTreeNodeVO> result = this.pcsSkuCategoryDomain.listAllCategoryTreeNode();
        return result;
    }

    public List<CategoryTreeNodeVO> listCategoryTreeNodeByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<CategoryTreeNodeVO> result = this.pcsSkuCategoryDomain.listTreeNodeByCategoryIds(ids);
        return result;
    }

    public List<PcsSkuCategoryVO> findCategoryByIds(PcsSkuCategoryCond cond) {
        return this.pcsSkuCategoryDomain.findCategoryByIds(cond);
    }

    public PcsSkuCategoryGmInfo findGmByCategoryId(Integer categoryId) {
        PcsSkuCategoryGm pcsSkuCategoryGm = this.pcsSkuCategoryGmMapper.selectByCategoryId(categoryId);
        if (pcsSkuCategoryGm != null) {
            PcsSkuCategoryGmInfo gmInfo = new PcsSkuCategoryGmInfo();
            BeanUtils.copyProperties((Object)pcsSkuCategoryGm, (Object)gmInfo);
            return gmInfo;
        }
        return null;
    }
}

