/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.cond.OpSpvCond;
import com.thebeastshop.pegasus.merchandise.domain.OpProdSkuDomain;
import com.thebeastshop.pegasus.merchandise.model.OpProdSku;
import com.thebeastshop.pegasus.merchandise.service.McOpSpvService;
import com.thebeastshop.pegasus.merchandise.vo.OpSpvVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mcOpSpvService")
public class McOpSpvServiceImpl
implements McOpSpvService {
    @Autowired
    private OpProdSkuDomain opProdSkuDomain;

    public List<OpSpvVO> findByProdIds(List<Long> prodIds) {
        List<OpProdSku> list = this.opProdSkuDomain.findByProdIds(prodIds);
        return BeanUtil.buildListFrom(list, OpSpvVO.class);
    }

    public List<OpSpvVO> findBySkuCode(String skuCode) {
        List<OpProdSku> list = this.opProdSkuDomain.findBySkuCode(skuCode);
        return BeanUtil.buildListFrom(list, OpSpvVO.class);
    }

    public Integer getProductIdByskuCode(String skuCode) {
        Integer productId = this.opProdSkuDomain.getProductIdByskuCode(skuCode);
        return productId;
    }

    public List<OpSpvVO> findAll() {
        List<OpProdSku> list = this.opProdSkuDomain.findAll();
        return BeanUtil.buildListFrom(list, OpSpvVO.class);
    }

    public List<String> getALLSkuCode() {
        return this.opProdSkuDomain.getALLSkuCode();
    }

    public Long create(OpSpvVO prodSkuVO) {
        this.opProdSkuDomain.create((OpProdSku)this.opProdSkuDomain.buildFromVO(prodSkuVO));
        return prodSkuVO.getId();
    }

    public boolean update(OpSpvVO prodSkuVO) {
        return this.opProdSkuDomain.update((OpProdSku)this.opProdSkuDomain.buildFromVO(prodSkuVO));
    }

    public Long createOrUpdate(OpSpvVO prodSku) {
        OpSpvCond cond = new OpSpvCond();
        cond.setProductId(prodSku.getProductId());
        cond.setSkuCodes((List)Lists.newArrayList((Object[])new String[]{prodSku.getSkuCode()}));
        List<OpSpvVO> list = this.findByPcsProdSkuCond(cond);
        if (CollectionUtils.isEmpty(list)) {
            return this.create(prodSku);
        }
        prodSku.setId(list.get(0).getId());
        boolean ret = this.update(prodSku);
        if (ret) {
            return prodSku.getId();
        }
        return -1L;
    }

    public boolean deleteById(Long id) {
        return this.opProdSkuDomain.deleteById(id);
    }

    public boolean deleteByProdId(Long prodId) {
        return this.opProdSkuDomain.deleteByProdId(prodId);
    }

    public List<OpSpvVO> findByProdId(Long prodId) {
        List<OpProdSku> list = this.opProdSkuDomain.findByProdId(prodId);
        return BeanUtil.buildListFrom(list, OpSpvVO.class);
    }

    public List<OpSpvVO> findByPcsProdSkuCond(OpSpvCond opSpvCond) {
        List<OpSpvVO> list = this.opProdSkuDomain.findByPcsProdSkuCond(opSpvCond);
        return list;
    }

    public Map<String, List<OpSpvVO>> mapBySkuCodes(List<String> skuCodes) {
        OpSpvCond spvCond = new OpSpvCond();
        spvCond.setSkuCodes(skuCodes);
        List<OpSpvVO> list = this.opProdSkuDomain.findByPcsProdSkuCond(spvCond);
        HashMap<String, List<OpSpvVO>> map = new HashMap<String, List<OpSpvVO>>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (OpSpvVO spvVO : list) {
                String skuCode = spvVO.getSkuCode();
                ArrayList<OpSpvVO> spvList = (ArrayList<OpSpvVO>)map.get(skuCode);
                if (spvList == null) {
                    spvList = new ArrayList<OpSpvVO>();
                    map.put(skuCode, spvList);
                }
                spvList.add(spvVO);
            }
        }
        return map;
    }
}

