/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.price;

import com.thebeastshop.pegasus.merchandise.enums.PriceCalTypeEnum;
import com.thebeastshop.pegasus.merchandise.price.AbstractPriceCalculator;
import com.thebeastshop.pegasus.merchandise.price.DiscountFactorType;
import com.thebeastshop.pegasus.merchandise.price.PriceCalculator;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;
import java.math.BigDecimal;
import java.util.List;

public class DiscountPriceCalculator
extends AbstractPriceCalculator
implements PriceCalculator {
    protected BigDecimal factor;
    protected Integer factorType;
    protected Long campaignId;

    public DiscountPriceCalculator(PriceCalculator sourcePriceCalculator, BigDecimal factor, Integer factorType, Long campaignId) {
        super(sourcePriceCalculator);
        this.factor = factor;
        this.factorType = factorType;
        this.campaignId = campaignId;
    }

    @Override
    public BigDecimal calculate(List<PriceCalResultVO> results) {
        BigDecimal targetPrice = this.getPrevPrice(results);
        PriceCalResultVO result = new PriceCalResultVO();
        result.setType(PriceCalTypeEnum.CAMPAIGN);
        result.setOriginalPrice(targetPrice);
        result.setExtId(this.campaignId);
        if (this.factor == null) {
            return targetPrice;
        }
        if (this.factorType == null) {
            return targetPrice;
        }
        if (this.factorType.equals(DiscountFactorType.DISCOUNT_PRICE.getId()) || this.factorType.equals(DiscountFactorType.DIFFERENT_DISCOUNT.getId())) {
            targetPrice = targetPrice.multiply(this.factor.divide(BigDecimal.TEN));
        } else if (this.factorType.equals(DiscountFactorType.FIXED_PRICE.getId()) || this.factorType.equals(DiscountFactorType.DIFFERENT_PRICE.getId())) {
            targetPrice = this.factor;
        }
        if (results != null) {
            result.setFinalPrice(targetPrice);
            results.add(result);
        }
        return targetPrice;
    }
}

