/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsTagCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsTagMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsClPsDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsTagDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuTag;
import com.thebeastshop.pegasus.merchandise.model.ProdTag;
import com.thebeastshop.pegasus.merchandise.vo.PcsTagVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsTagDomain")
public class PcsTagDomainImpl
implements PcsTagDomain {
    private static final Logger log = LoggerFactory.getLogger(PcsTagDomainImpl.class);
    @Autowired
    private PcsTagMapper pcsTagMapper;
    @Autowired
    private PcsClPsDomain pcsClPsDomain;

    @Override
    @Transactional
    public int addTag(PcsTagVO tagVO) {
        int ret = this.pcsTagMapper.insert(tagVO);
        if (ret > 0) {
            Random random = new Random();
            int n = random.nextInt(99);
            tagVO.setCode("T0" + n + tagVO.getId());
            this.pcsTagMapper.update(tagVO);
        }
        return ret;
    }

    @Override
    @Transactional
    public int updateTag(PcsTagVO tagVO) {
        int ret = this.pcsTagMapper.update(tagVO);
        List<String> codeList = this.pcsTagMapper.querySkuCodeListByTagId(tagVO.getId());
        this.pcsClPsDomain.saveSkuCodeList(codeList, 1);
        return ret;
    }

    @Override
    public PcsTagVO findTagById(Long id) {
        return this.pcsTagMapper.findById(id);
    }

    @Override
    public List<PcsTagVO> queryTagListByProdId(Long prodId) {
        return this.pcsTagMapper.queryTagListByProdId(prodId);
    }

    @Override
    public List<ProdSkuVO> queryProdTagListByTagCode(PcsTagCond cond) {
        return this.pcsTagMapper.queryProdTagListByTagCode(cond);
    }

    @Override
    @Transactional
    public int saveOrUpdateProdTag(ProdTag prodTag) {
        int count = this.pcsTagMapper.countOfProdTag(prodTag);
        if (count == 0) {
            count = this.pcsTagMapper.insertProdTag(prodTag);
            log.info("\u65b0\u589e" + count);
            log.info("add record:" + prodTag.toString());
            return 1;
        }
        prodTag.setActive(1);
        count = this.pcsTagMapper.updateProdTag(prodTag);
        log.info("\u66f4\u65b0\uff1a" + count);
        log.info("update record:" + prodTag.toString());
        return 2;
    }

    @Override
    @Transactional
    public int updateProdTagByCodeList(ProdSkuVO prod, List<String> codeList, boolean isEmptyBeforeUpdate) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (isEmptyBeforeUpdate) {
            params.put("productId", prod.getProdId());
            List<ProdTag> toDelProdTagList = this.pcsTagMapper.queryToDeleteProdTagList(params);
            if (!toDelProdTagList.isEmpty()) {
                ArrayList<Long> toDelIdList = new ArrayList<Long>();
                int i = 0;
                while (i < toDelProdTagList.size()) {
                    ProdTag toDelProdTag = toDelProdTagList.get(i);
                    toDelIdList.add(toDelProdTag.getId());
                    ++i;
                }
                HashMap<String, Object> delParams = new HashMap<String, Object>();
                delParams.put("ids", toDelIdList);
                delParams.put("active", 0);
                int count = this.pcsTagMapper.updateProdTagActiveByIds(delParams);
                log.info("\u5220\u9664\u91cf\uff1a" + count);
            }
        }
        ArrayList<ProdTag> prodTagList = new ArrayList<ProdTag>();
        int i = 0;
        while (i < codeList.size()) {
            String code = codeList.get(i);
            ProdTag prodTag = new ProdTag();
            prodTag.setProductCode(prod.getProdCode());
            prodTag.setProductId(prod.getProdId());
            prodTag.setTagCode(code);
            prodTagList.add(prodTag);
            ++i;
        }
        int ret = 0;
        int i2 = 0;
        while (i2 < prodTagList.size()) {
            ProdTag prodTag = (ProdTag)prodTagList.get(i2);
            prodTag.setSort(i2);
            ret += this.saveOrUpdateProdTag(prodTag);
            ++i2;
        }
        return ret;
    }

    @Override
    public List<PcsTagVO> queryTagList(Map<String, Object> params) {
        return this.pcsTagMapper.queryTagList(params);
    }

    @Override
    public List<ProdSkuVO> queryProdSkuListByTagParams(List<String> idList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", idList);
        return this.pcsTagMapper.queryProdSkuListByTagParams(params);
    }

    @Override
    public int saveOrUpdateSkuTag(PcsSkuTag skuTag) {
        return 0;
    }

    @Override
    public int deleteProdTagByIds(List<String> idList) {
        HashMap<String, Object> delParams = new HashMap<String, Object>();
        delParams.put("ids", idList);
        delParams.put("active", 0);
        return this.pcsTagMapper.updateProdTagActiveByIds(delParams);
    }
}

