/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuBarcodeMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuDistributeChannelMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsBrandDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsBuyerDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCategoryDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCustomMadeDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuSalesPriceChangeDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsTagDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsBrand;
import com.thebeastshop.pegasus.merchandise.model.PcsSku;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuBarcode;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategory;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCostPriceChange;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCustomMade;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuDistributeChannel;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuDistributeChannelExample;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuExample;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuSupplierChange;
import com.thebeastshop.pegasus.merchandise.service.McPcsWatermarkService;
import com.thebeastshop.pegasus.merchandise.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuBarcodeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsSkuDomain")
public class PcsSkuDomainImpl
extends AbstractBaseDomain<PcsSkuVO, PcsSku>
implements PcsSkuDomain,
CheckAble,
CodeAble {
    @Autowired
    private McPcsWatermarkService mcPcsWatermarkService;
    @Autowired
    private PcsTagDomain pcsTagDomain;
    @Autowired
    private PcsSkuMapper pcsSkuMapper;
    @Autowired
    private PcsSkuCategoryDomain pcsSkuCategoryDomain;
    @Autowired
    private PcsBuyerDomain pcsBuyerDomain;
    @Autowired
    private PcsSkuSalesPriceChangeDomain pcsSkuSalesPriceChangeDomain;
    @Autowired
    private PcsSkuCustomMadeDomain pcsSkuCustomMadeDomain;
    @Autowired
    private PcsBrandDomain pcsBrandDomain;
    @Autowired
    private PcsSkuDistributeChannelMapper pcsSkuDistributeChannelMapper;
    @Autowired
    private PcsSkuBarcodeMapper pcsSkuBarcodeMapper;

    @Override
    @Transactional
    public Long create(PcsSku record) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            this.initDefaultValue(record);
            this.pcsSkuMapper.insertSelective(record);
            try {
                String code = this.generateSkuCode(record);
                if (this.check(code).booleanValue()) {
                    record.setCode(code);
                    if (record.getSkuStatus() == 1) {
                        record.setLastSubmitTime(new Date());
                    }
                } else {
                    throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u590d");
                }
                this.pcsSkuMapper.updateByPrimaryKeySelective(record);
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
                throw new PurchaseException("PC0006", "\u751f\u6210SKUCODE\u5931\u8d25");
            }
            String skuCode = record.getCode();
            if (record.getSkuStatus() == 1) {
                this.pcsSkuSalesPriceChangeDomain.create(skuCode, record.getSalesPrice());
                this.pcsSkuSalesPriceChangeDomain.createCostPriceChange(skuCode, record.getCostPrice());
                this.pcsSkuSalesPriceChangeDomain.createSupplierChange(skuCode, record.getDefaultSupplierId().intValue());
            }
            this.getBarcodeList(record);
            this.createPcsSkuBarcode(record.getBarcodeList());
            if (EmptyUtil.isNotEmpty((Object)record.getPictureFileId())) {
                PegasusUtilFacade.getInstance().modifyFileName(record.getPictureFileId().longValue(), String.valueOf(record.getCode()) + ".jpg");
            }
            return record.getId();
        }
        return null;
    }

    private void getBarcodeList(PcsSku vo) {
        ArrayList<PcsSkuBarcode> barcodeList = new ArrayList<PcsSkuBarcode>();
        if (EmptyUtil.isNotEmpty((String)vo.getBarcode())) {
            String[] barcodeArr;
            String[] stringArray = barcodeArr = vo.getBarcode().split(",");
            int n = barcodeArr.length;
            int n2 = 0;
            while (n2 < n) {
                String barcode = stringArray[n2];
                PcsSkuBarcode pcsSkuBarcode = new PcsSkuBarcode();
                pcsSkuBarcode.setAvailable(true);
                pcsSkuBarcode.setBarcode(barcode);
                pcsSkuBarcode.setSkuCode(vo.getCode());
                barcodeList.add(pcsSkuBarcode);
                ++n2;
            }
        }
        vo.setBarcodeList(barcodeList);
    }

    @Override
    @Transactional
    public List<Long> createSkus(List<PcsSku> list) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (PcsSku pcsSku : list) {
            ids.add(this.create(pcsSku));
        }
        return ids;
    }

    private void initDefaultValue(PcsSku record) {
        record.setCode("");
        record.setCreateTime(new Date());
        record.setPointDeductRule(0);
        record.setPointDeductPoint(new BigDecimal("0.00"));
        record.setPointDuductPrice(new BigDecimal("0.00"));
        record.setCanRemark(0);
    }

    @Override
    @Transactional
    public boolean update(PcsSku record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            PcsSku oldRecord = this.findById(record.getId());
            List<PcsSkuSalesPriceChange> salesPriceChangelist = this.pcsSkuSalesPriceChangeDomain.findByCode(oldRecord.getCode());
            if ((EmptyUtil.isNotEmpty((Object)record.getSalesPrice()) || EmptyUtil.isEmpty(salesPriceChangelist)) && record.getOptType() != 1 && record.getSkuStatus() == 1) {
                record.setOldSalesPrice(record.getSalesPrice());
                if (this.canUpdateSalesPrice(record.getCode()).booleanValue()) {
                    this.pcsSkuSalesPriceChangeDomain.create(record.getCode(), record.getSalesPrice());
                    record.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
                    record.setLastSubmitTime(new Date());
                    String string = record.getCode();
                }
            }
            List<PcsSkuCostPriceChange> costPriceChangelist = this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCode(oldRecord.getCode());
            boolean costPriceNeedApproval = false;
            if (record.getOptType() != 1) {
                costPriceNeedApproval = this.costPriceNeedApproval(record);
            }
            if ((EmptyUtil.isNotEmpty((Object)record.getCostPrice()) || EmptyUtil.isEmpty(costPriceChangelist)) && record.getOptType() != 1 && record.getSkuStatus() == 1 && costPriceNeedApproval) {
                record.setOldCostPrice(record.getCostPrice());
                if (this.canUpdateCostPrice(record.getCode()).booleanValue()) {
                    this.pcsSkuSalesPriceChangeDomain.createCostPriceChange(record.getCode(), record.getCostPrice());
                    record.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
                    record.setLastSubmitTime(new Date());
                }
            }
            List<PcsSkuSupplierChange> supplierChangelist = this.pcsSkuSalesPriceChangeDomain.findSupplierChangeByCode(oldRecord.getCode());
            if ((EmptyUtil.isNotEmpty((Object)record.getDefaultSupplierId()) || EmptyUtil.isEmpty(supplierChangelist)) && record.getOptType() != 1 && record.getSkuStatus() == 1) {
                record.setOldSupplierId(record.getDefaultSupplierId());
                if (this.canUpdateSupplier(record.getCode()).booleanValue()) {
                    this.pcsSkuSalesPriceChangeDomain.createSupplierChange(record.getCode(), record.getDefaultSupplierId().intValue());
                    record.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
                    record.setLastSubmitTime(new Date());
                }
            }
            if (record.getOptType() != 1 && record.getSkuStatus() == 0) {
                record.setOldSalesPrice(record.getSalesPrice());
                record.setOldSupplierId(record.getDefaultSupplierId());
                record.setOldCostPrice(record.getCostPrice());
            }
            this.setNonField(record, costPriceNeedApproval);
            if (record.getOptType() != 1 && oldRecord.getSkuStatus() != null && record.getSkuStatus() == 0) {
                record.setSkuStatus(oldRecord.getSkuStatus());
            }
            boolean result = this.pcsSkuMapper.updateByPrimaryKeySelective(record) != 0;
            oldRecord.setBarcode(record.getBarcode());
            this.getBarcodeList(oldRecord);
            this.createPcsSkuBarcode(oldRecord.getBarcodeList());
            if (result && EmptyUtil.isNotEmpty((Object)record.getPictureFileId())) {
                PegasusUtilFacade.getInstance().modifyFileName(record.getPictureFileId().longValue(), String.valueOf(oldRecord.getCode()) + ".jpg");
            }
            return result;
        }
        return false;
    }

    private void setNonField(PcsSku record, boolean costPriceNeedApproval) {
        record.setSalesPrice(null);
        if (costPriceNeedApproval) {
            record.setCostPrice(null);
        }
        record.setDefaultSupplierId(null);
        record.setCode(null);
        record.setIsImported(null);
        record.setIsMadeBySelf(null);
    }

    @Override
    public boolean costPriceNeedApproval(PcsSku record) {
        List<PcsSkuCostPriceChange> costPriceChangelist = this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(record.getCode(), 2);
        BigDecimal costPrice = BigDecimal.ZERO;
        if (EmptyUtil.isNotEmpty(costPriceChangelist)) {
            Date changeTime = new Date(0L);
            for (PcsSkuCostPriceChange skuCostPriceChange : costPriceChangelist) {
                if (skuCostPriceChange.getChangeStatus() != 2 || !skuCostPriceChange.getChangeTime().after(changeTime)) continue;
                costPrice = skuCostPriceChange.getNewPrice();
                changeTime = skuCostPriceChange.getChangeTime();
            }
        }
        BigDecimal growth = record.getCostPrice().subtract(costPrice);
        return costPrice.compareTo(BigDecimal.ZERO) == 0 || growth.divide(costPrice, 3, RoundingMode.HALF_UP).compareTo(new BigDecimal(0.02)) > 0 && growth.compareTo(new BigDecimal("0")) > 0;
    }

    @Override
    public Boolean canUpdateSalesPrice(String code) {
        List<PcsSkuSalesPriceChange> processingPriceList = this.pcsSkuSalesPriceChangeDomain.findByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (processingPriceList.size() > 0) {
            return false;
        }
        processingPriceList = this.pcsSkuSalesPriceChangeDomain.findByCodeAndStatus(code, PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS);
        if (processingPriceList.size() > 0) {
            return false;
        }
        List<PcsSkuCostPriceChange> processingCostPriceList = this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (EmptyUtil.isNotEmpty(processingCostPriceList)) {
            return false;
        }
        processingCostPriceList = this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS);
        if (EmptyUtil.isNotEmpty(processingCostPriceList)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean auditSkuSalesPriceChange(String code, Boolean isPass, Integer type) {
        PcsSkuVO pcsSkuVO = this.findByCode(code);
        if (EmptyUtil.isEmpty((Object)pcsSkuVO)) {
            throw new PurchaseException("PC0001", "sku\u5b9e\u4f53\u4e3a\u7a7a");
        }
        if (!pcsSkuVO.getSkuStatus().equals(PcsSku.SKU_STATUS_WAITING_VERIFY) && !pcsSkuVO.getSkuStatus().equals(PcsSku.SKU_STATUS_WAITING_FINANCE_VERIFY)) {
            throw new PurchaseException("PC0002", "\u5fc5\u987b\u662f\u5f85\u5ba1\u6838\u72b6\u6001");
        }
        PcsSkuSalesPriceChange pcsSkuSalesPriceChange = this.pcsSkuSalesPriceChangeDomain.auditSkuSalesPriceChange(code, isPass, type);
        PcsSkuCostPriceChange pcsSkuCostPriceChange = this.pcsSkuSalesPriceChangeDomain.auditSkuCostPriceChange(code, isPass, type);
        PcsSkuSupplierChange pcsSkuSupplierChange = this.pcsSkuSalesPriceChangeDomain.auditSkuSupplierChange(code, isPass, type);
        PcsSku pcsSku = new PcsSku();
        pcsSku.setId(pcsSkuVO.getId());
        if (EmptyUtil.isNotEmpty((Object)pcsSkuSalesPriceChange)) {
            if (pcsSkuSalesPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_SUCCESS)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_ABLE);
                pcsSku.setSalesPrice(pcsSkuSalesPriceChange.getNewPrice());
                pcsSku.setLastAuditTime(new Date());
            } else if (pcsSkuSalesPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_WAITING_FINANCE_VERIFY);
            } else if (pcsSkuSalesPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_REJECT)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_REJECT);
            }
        }
        if (EmptyUtil.isNotEmpty((Object)pcsSkuCostPriceChange)) {
            if (pcsSkuCostPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_SUCCESS)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_ABLE);
                pcsSku.setCostPrice(pcsSkuCostPriceChange.getNewPrice());
                pcsSku.setLastAuditTime(new Date());
            } else if (pcsSkuCostPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_WAITING_FINANCE_VERIFY);
            } else if (pcsSkuCostPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_REJECT)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_REJECT);
            }
        }
        if (EmptyUtil.isNotEmpty((Object)pcsSkuSupplierChange)) {
            if (pcsSkuSupplierChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_SUCCESS)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_ABLE);
                pcsSku.setLastAuditTime(new Date());
                pcsSku.setDefaultSupplierId(pcsSkuSupplierChange.getNewSupplierId().longValue());
            } else if (pcsSkuSalesPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_WAITING_FINANCE_VERIFY);
            } else if (pcsSkuSupplierChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_REJECT)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_REJECT);
            }
        }
        this.pcsSkuMapper.updateByPrimaryKeySelective(pcsSku);
        return true;
    }

    @Override
    public PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        return this.pcsSkuSalesPriceChangeDomain.buildFromModel(this.pcsSkuSalesPriceChangeDomain.findSkuSalesPriceChangeByCodeAndProcessing(code, 1));
    }

    @Override
    public List<PcsSku> findSkuByCodes(List<String> codes) {
        ArrayList<PcsSku> recordList = new ArrayList<PcsSku>();
        for (String code : codes) {
            PcsSku record = this.findSkuByCode(code);
            if (!EmptyUtil.isNotEmpty((Object)record) || !EmptyUtil.isNotEmpty((Object)record.getId())) continue;
            recordList.add(record);
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    @Transactional
    public Boolean convertSku(PcsSku sku, long skuCustomMadeId) {
        PcsSkuCustomMade pcsSkuCustomMade = this.pcsSkuCustomMadeDomain.findById(skuCustomMadeId);
        sku.setIsJit(0);
        if (EmptyUtil.isNotEmpty((Object)pcsSkuCustomMade) && pcsSkuCustomMade.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_WAITING_CONVERT)) {
            if (this.create(sku) > 0L) {
                pcsSkuCustomMade.setSkuStatus(PcsSkuCustomMade.SKU_STATUS_CONVERT);
                if (this.pcsSkuCustomMadeDomain.update(pcsSkuCustomMade)) {
                    return true;
                }
                throw new PurchaseException("PC0010", "sku\u5b9a\u5236\u5355\u66f4\u65b0\u5931\u8d25");
            }
            throw new PurchaseException("PC0009", "sku\u521b\u5efa\u5931\u8d25");
        }
        throw new PurchaseException("PC0002", "\u72b6\u6001\u5fc5\u987b\u662f\u5f85\u8f6c\u6362");
    }

    @Override
    @Transactional
    public boolean transferSku(List<String> skuCodes, Long buyerId) {
        if (EmptyUtil.isEmpty(skuCodes) || NullUtil.isNull((Object)buyerId)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsBuyerInfoVO toBuyer = this.pcsBuyerDomain.getBuyerInfoById(buyerId);
        if (NullUtil.isNull((Object)toBuyer) || PcsBuyerInfoVO.DISABLE_YES.equals(toBuyer.getDisable())) {
            throw new PurchaseException("PC0002", "\u91c7\u8d2d\u5458\u5df2\u5220\u9664");
        }
        PcsSkuExample example = new PcsSkuExample();
        example.createCriteria().andCodeIn((List)skuCodes);
        PcsSku update = new PcsSku();
        update.setBuyerId(buyerId);
        return this.pcsSkuMapper.updateByExampleSelective(update, example) > 0;
    }

    private PcsSku findSkuByCode(String code) {
        PcsSkuExample example = new PcsSkuExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsSku> recordList = this.pcsSkuMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return null;
        }
        if (recordList.size() > 1) {
            throw new PurchaseException("PC0007", " \u6839\u636ecode[" + code + "]\u80fd\u67e5\u51fa2\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u8bb0\u5f55");
        }
        return recordList.get(0);
    }

    @Override
    public PcsSku findById(long id) {
        if (EmptyUtil.isEmpty((Object)id)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return this.pcsSkuMapper.selectByPrimaryKey(id);
    }

    @Override
    public PcsSkuVO findByCode(String code) {
        return this.findByCode(code, false, true, false);
    }

    @Override
    public PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories) {
        return this.findByCode(code, widthFrontCategories, withBackCategories, false);
    }

    @Override
    public PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories, boolean withBuyerName) {
        List<PcsSkuCategory> categoryList;
        PcsBuyerInfoVO buyer;
        if (EmptyUtil.isEmpty((String)code)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        this.log.debug("pcsSkuDomain.findByCode code: " + code + ", widthFrontCategories: " + widthFrontCategories + ", withBackCategories: " + withBackCategories + ", withBuyerName: " + withBuyerName);
        List<PcsSkuVO> voList = this.pcsSkuMapper.findSkuByCodes(Arrays.asList(code));
        this.log.debug("sku result list: " + JSON.toJSONString(voList));
        if (CollectionUtils.isEmpty(voList)) {
            return null;
        }
        if (voList.size() > 1) {
            throw new PurchaseException("PC0007", " \u6839\u636ecode\u80fd\u67e5\u51fa2\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u8bb0\u5f55");
        }
        PcsSkuVO sku = voList.get(0);
        if (withBuyerName && sku.getBuyerId() != null && (buyer = this.pcsBuyerDomain.getBuyerInfoById(sku.getBuyerId())) != null) {
            sku.setBuyerName(buyer.getRealName());
        }
        if (widthFrontCategories) {
            categoryList = this.pcsSkuCategoryDomain.findFrontCategoriesBySkuCode(sku.getCode());
            sku.setFrontCategoryList(BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class));
        }
        if (withBackCategories) {
            categoryList = this.pcsSkuCategoryDomain.findBackCategoriesBySkuCode(sku.getCode());
            sku.setBackCategoryList(BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class));
            ArrayList<PcsSkuCategoryVO> secondaryCategoryList = new ArrayList<PcsSkuCategoryVO>();
            for (PcsSkuCategoryVO category : sku.getBackCategoryList()) {
                if (category.getId() == null || category.getId().equals(sku.getCategoryId())) continue;
                secondaryCategoryList.add(category);
            }
            sku.setSecondaryCategoryList(secondaryCategoryList);
        }
        sku.setBarcodeList(this.model2VO(this.pcsSkuBarcodeMapper.selectBySkuCode(sku.getCode())));
        return sku;
    }

    private List<PcsSkuBarcodeVO> model2VO(List<PcsSkuBarcode> list) {
        ArrayList<PcsSkuBarcodeVO> voList = new ArrayList<PcsSkuBarcodeVO>();
        if (list != null) {
            for (PcsSkuBarcode pcsSkuBarcode : list) {
                PcsSkuBarcodeVO vo = new PcsSkuBarcodeVO();
                BeanUtils.copyProperties((Object)pcsSkuBarcode, (Object)vo);
                voList.add(vo);
            }
        }
        return voList;
    }

    @Override
    public List<PcsSkuVO> findByNameOrCode(String arg0) {
        this.log.debug("findByNameOrCode: " + arg0);
        if (EmptyUtil.isEmpty((String)arg0)) {
            return Collections.emptyList();
        }
        List<PcsSkuVO> voList = this.pcsSkuMapper.findSkuByNameOrCode(arg0);
        this.log.debug("findByNameOrCode: result: " + JSON.toJSONString(voList));
        if (CollectionUtils.isEmpty(voList)) {
            return Collections.emptyList();
        }
        return voList;
    }

    @Override
    public List<PcsSkuVO> findByCond(PcsSkuCond cond) {
        return this.pcsSkuMapper.findSkuByCond(cond);
    }

    @Override
    public List<PcsSkuVO> findByCondForExport(PcsSkuCond cond) {
        return this.pcsSkuMapper.findSkuByCondForExport(cond);
    }

    @Override
    public List<Map<String, Object>> findSkuCanSaleAndCanSeeByChannelCode(String channelCode) {
        return this.pcsSkuMapper.findSkuCanSaleAndCanSeeByChannelCode(channelCode);
    }

    @Override
    public Map<String, Object> findSkuCanSaleAndCanSeeInfo(String channelCode, String skuCode) {
        return this.pcsSkuMapper.findSkuCanSaleAndCanSeeInfo(channelCode, skuCode);
    }

    @Override
    public List<PcsSkuVO> findSkuTagByCond(PcsSkuCond cond) {
        return this.pcsSkuMapper.findSkuTagByCond(cond);
    }

    public Boolean check(Object obj) {
        PcsSku record = (PcsSku)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsSku record, Boolean isCreate) {
        PcsSku oldRecord;
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && NullUtil.isNotNull((Object)(oldRecord = this.pcsSkuMapper.selectByPrimaryKey(record.getId()))) && EmptyUtil.isNotEmpty((Object)oldRecord.getPictureFileId()) && EmptyUtil.isNotEmpty((Object)record.getPictureFileId()) && !oldRecord.getPictureFileId().equals(record.getPictureFileId())) {
            PegasusUtilFacade.getInstance().deleteFileById(oldRecord.getPictureFileId().longValue());
        }
        return true;
    }

    private Boolean check(String code) {
        PcsSkuExample example = new PcsSkuExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsSku> recordList = this.pcsSkuMapper.selectByExample(example);
        if (recordList.size() == 0) {
            return true;
        }
        return false;
    }

    public String generateCode(Object id) {
        return null;
    }

    private String generateSkuCode(PcsSku record) {
        String categoryCode = "";
        String createYear = "";
        Integer num = 0;
        String key = "";
        PcsSkuCategory skuCategory = this.pcsSkuCategoryDomain.findBackCategoryById(record.getCategoryId());
        if (!NullUtil.isNotNull((Object)skuCategory)) {
            throw new PurchaseException("PC0001", " sku \u54c1\u7c7b\u65e0\u76f8\u5173\u6570\u636e");
        }
        categoryCode = skuCategory.getCode();
        createYear = DateUtil.format((Date)DateUtil.getNow(), (String)"yyyy");
        createYear = createYear.substring(2);
        PcsSkuExample example = new PcsSkuExample();
        PcsSkuExample.Criteria criteria = example.createCriteria();
        criteria.andCodeLike(String.valueOf(categoryCode) + createYear + "%");
        example.setOrderByClause("id desc limit 1");
        List<PcsSku> skus = this.pcsSkuMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(skus)) {
            num = 1;
        } else {
            String tmp = skus.get(0).getCode();
            String prefix = String.valueOf(categoryCode) + createYear;
            int i = tmp.toUpperCase().indexOf(prefix.toUpperCase());
            tmp = tmp.substring(i + prefix.length());
            tmp = StringUtils.left((String)tmp, (int)3);
            Integer _num = Integer.parseInt(tmp);
            num = _num = Integer.valueOf(_num + 1);
        }
        PcsBrand brand = this.pcsBrandDomain.findById(record.getBrandId());
        key = NullUtil.isNotNull((Object)brand) && !NumberUtil.isNullOrZero((Number)brand.getIsOwn()) ? (record.getSkuType().equals(PcsSku.SKU_TYPE_FINISHED_PRODUCT) ? (NumberUtil.isNullOrZero((Number)record.getIsImported()) ? (!NumberUtil.isNullOrZero((Number)record.getIsMadeBySelf()) ? "1" : "2") : (!NumberUtil.isNullOrZero((Number)record.getIsMadeBySelf()) ? "3" : "4")) : "0") : (record.getSkuType().equals(PcsSku.SKU_TYPE_FINISHED_PRODUCT) ? (!NumberUtil.isNullOrZero((Number)record.getIsImported()) ? (!NumberUtil.isNullOrZero((Number)record.getIsMadeBySelf()) ? "5" : "6") : (!NumberUtil.isNullOrZero((Number)record.getIsMadeBySelf()) ? "7" : "8")) : "9");
        if (EmptyUtil.isEmpty((String)categoryCode) || EmptyUtil.isEmpty((String)createYear) || NumberUtil.isNullOrZero((Number)num) || EmptyUtil.isEmpty((String)key)) {
            throw new PurchaseException("PC0001", " \u751f\u6210skucode\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryCode", categoryCode);
        params.put("createYear", createYear);
        params.put("num", num);
        params.put("key", key);
        String code = CodeGenerator.getInstance().generate("PCS_SKU", params);
        return code;
    }

    @Override
    public List<PcsSkuVO> findByCodes(List<String> codes) {
        return this.findByCodes(codes, false);
    }

    @Override
    public List<PcsSkuVO> findByCodes(List<String> codes, boolean withCategories) {
        List<Object> list = EmptyUtil.isEmpty(codes) ? new ArrayList() : this.pcsSkuMapper.findSkuByCodes(codes);
        int i = 0;
        while (i < list.size()) {
            PcsSkuVO skuVO = (PcsSkuVO)list.get(i);
            if (withCategories) {
                List<PcsSkuCategory> categoryList = this.pcsSkuCategoryDomain.findFrontCategoriesBySkuCode(skuVO.getCode());
                skuVO.setFrontCategoryList(BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class));
            }
            ++i;
        }
        return list;
    }

    @Override
    public List<PcsSkuInfoVO> allSkuInfo() {
        return this.pcsSkuMapper.allSkuInfo();
    }

    @Override
    public PcsSkuInfoVO findStockByCode(String skuCode) {
        return this.pcsSkuMapper.findStockByCode(skuCode);
    }

    @Override
    public List<PcsSkuVO> findChannelSkuForNoDistribute(PcsSkuCond cond) {
        return this.pcsSkuMapper.findChannelSkuForNoDistribute(cond);
    }

    @Override
    @Transactional
    public void setSkuChannel(List<String> skuCodeList, List<String> channelCodeList, Long operatorId) {
        PcsSkuDistributeChannelExample example = new PcsSkuDistributeChannelExample();
        PcsSkuDistributeChannelExample.Criteria criteria = example.createCriteria();
        if (skuCodeList != null && skuCodeList.size() > 0) {
            for (String skuCode : skuCodeList) {
                criteria.andSkuCodeEqualTo(skuCode);
                List<PcsSkuDistributeChannel> list = this.pcsSkuDistributeChannelMapper.selectByExample(example);
                if (list != null && list.size() > 0) {
                    for (PcsSkuDistributeChannel pcsSkuDistributeChannel : list) {
                        pcsSkuDistributeChannel.setCancelFlag(1);
                        this.pcsSkuDistributeChannelMapper.updateByPrimaryKey(pcsSkuDistributeChannel);
                    }
                }
                if (channelCodeList == null || channelCodeList.size() <= 0) continue;
                for (String channelCode : channelCodeList) {
                    PcsSkuDistributeChannel pcsSkuDistributeChannel = new PcsSkuDistributeChannel();
                    pcsSkuDistributeChannel.setCancelFlag(0);
                    pcsSkuDistributeChannel.setChannelCode(channelCode);
                    pcsSkuDistributeChannel.setCreateTime(Calendar.getInstance().getTime());
                    pcsSkuDistributeChannel.setCreateUserId(operatorId);
                    pcsSkuDistributeChannel.setSkuCode(skuCode);
                    this.pcsSkuDistributeChannelMapper.insert(pcsSkuDistributeChannel);
                }
            }
        }
    }

    @Override
    public List<PcsSkuVO> findSkuByIds(List<Long> ids) {
        return this.pcsSkuMapper.findSkuByIds(ids);
    }

    @Override
    public Boolean canUpdateCostPrice(String code) {
        List<PcsSkuCostPriceChange> processingPriceList = this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (processingPriceList.size() > 0) {
            return false;
        }
        processingPriceList = this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS);
        if (processingPriceList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean canUpdateSupplier(String code) {
        List<PcsSkuSupplierChange> processingPriceList = this.pcsSkuSalesPriceChangeDomain.findSupplierChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (processingPriceList.size() > 0) {
            return false;
        }
        processingPriceList = this.pcsSkuSalesPriceChangeDomain.findSupplierChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS);
        if (processingPriceList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public List<Long> updateSkus(List<PcsSkuVO> list) {
        return null;
    }

    public boolean update(PcsSkuVO vo) {
        if (vo.getOptType() == 1) {
            Boolean result = this.update((PcsSku)this.buildFromVO(vo));
            return result;
        }
        PcsSkuVO oldSkuVO = this.findByCode(vo.getCode());
        boolean waitingVerify = false;
        if (!oldSkuVO.getSalesPrice().equals(vo.getSalesPrice())) {
            vo.setOldSalesPrice(oldSkuVO.getSalesPrice());
        }
        if (!oldSkuVO.getCostPrice().equals(vo.getCostPrice())) {
            vo.setOldCostPrice(oldSkuVO.getCostPrice());
            waitingVerify = true;
        }
        if (!oldSkuVO.getDefaultSupplierId().equals(vo.getDefaultSupplierId())) {
            vo.setOldSupplierId(oldSkuVO.getDefaultSupplierId());
            waitingVerify = true;
        }
        if (vo.getSkuStatus() != null && vo.getSkuStatus() == 1) {
            if (!oldSkuVO.getSalesPrice().equals(oldSkuVO.getOldSalesPrice())) {
                waitingVerify = true;
            }
            if (!oldSkuVO.getDefaultSupplierId().equals(oldSkuVO.getOldSupplierId())) {
                waitingVerify = true;
            }
            if (!oldSkuVO.getCostPrice().equals(oldSkuVO.getOldCostPrice())) {
                waitingVerify = true;
            }
        }
        Boolean result = this.update((PcsSku)this.buildFromVO(vo));
        ArrayList<Long> categoryIds = vo.getSecondaryCategoryIds();
        if (categoryIds == null) {
            categoryIds = new ArrayList<Long>();
        }
        categoryIds.add(vo.getCategoryId());
        return result;
    }

    @Override
    public long countSkuByCond(PcsSkuCond cond) {
        return this.pcsSkuMapper.countSkuByCond(cond);
    }

    @Override
    public String getCrossBorderFlagByCodes(List<String> codes) {
        return this.pcsSkuMapper.getCrossBorderFlagByCodes(codes);
    }

    @Override
    public Integer updateSkuCategoryNameByCode(String skuCategoryName, String skuCode) {
        return this.pcsSkuMapper.updateSkuCategoryNameByCode(skuCategoryName, skuCode);
    }

    @Override
    public List<Integer> getSalesPriceByCodes(List<String> codes) {
        return this.pcsSkuMapper.getSalesPriceByCodes(codes);
    }

    @Override
    public List<Map> getSalesPriceByProdId(Long prodId) {
        return this.pcsSkuMapper.getSalesPriceByProdId(prodId);
    }

    @Override
    public void createPcsSkuBarcode(List<PcsSkuBarcode> barcodeList) {
        if (EmptyUtil.isNotEmpty(barcodeList)) {
            String skuCode = barcodeList.get(0).getSkuCode();
            this.pcsSkuBarcodeMapper.deleteBySkuCode(skuCode);
            for (PcsSkuBarcode pcsSkuBarcode : barcodeList) {
                this.pcsSkuBarcodeMapper.insert(pcsSkuBarcode);
            }
        }
    }

    @Override
    public List<PcsSkuBarcodeVO> selectByBarCode(String barCode) {
        return this.pcsSkuBarcodeMapper.selectByBarCode(barCode);
    }

    @Override
    public List<PcsSkuVO> findSkuAuditByIds(List<Long> ids) {
        return this.pcsSkuMapper.findSkuAuditByIds(ids);
    }

    @Override
    public Boolean isExistsSpecialCategory(List<String> skuCodes, List<Integer> categoryIds) {
        if (this.pcsSkuMapper.getSpecialCategoryBySkuCodes(skuCodes, categoryIds) > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isOnlyExistsSpecialCategory(List<String> skuCodes, List<Integer> categoryIds) {
        if (this.pcsSkuMapper.getSpecialCategoryBySkuCodes(skuCodes, categoryIds) > 0 && this.pcsSkuMapper.getOtherCategoryBySkuCodes(skuCodes, categoryIds) <= 0) {
            return true;
        }
        return false;
    }

    @Override
    public List<PcsSkuVO> findSkuBySupplierId(Long supplierId) {
        return this.pcsSkuMapper.findSkuBySupplierId(supplierId);
    }

    @Override
    public int updateSku(PcsSku record) {
        return this.pcsSkuMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public Integer getMonthlyByCodes(List<String> skuCodes) {
        return this.pcsSkuMapper.getMonthlyByCodes(skuCodes);
    }
}

