/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryRelationCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuCategoryMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCategoryDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategory;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategoryExample;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategoryRelation;
import com.thebeastshop.pegasus.merchandise.vo.CategoryTreeNodeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsFrontBackCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsSkuCategoryDomain")
public class PcsSkuCategoryDomainImpl
extends AbstractBaseDomain<PcsSkuCategoryVO, PcsSkuCategory>
implements PcsSkuCategoryDomain,
CheckAble {
    private static final String CODE_SEPARATOR = "_";
    private static final String NAME_SEPARATOR = "/";
    @Autowired
    private PcsSkuCategoryMapper pcsSkuCategoryMapper;

    @Override
    @Transactional
    public Long create(PcsSkuCategory record) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            record.setFullName(this.getFullName(record));
            if (record.getParentId() == null || record.getParentId() == 0L) {
                record.setIsLeaf(0);
            } else {
                record.setIsLeaf(1);
            }
            this.pcsSkuCategoryMapper.insertSelective(record);
            try {
                if (this.check(record.getCode(), record.getId()).booleanValue()) {
                    this.pcsSkuCategoryMapper.updateByPrimaryKeySelective(record);
                    return record.getId();
                }
                throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u590d");
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
                throw new PurchaseException("PC0006", e.getLocalizedMessage());
            }
        }
        return null;
    }

    @Override
    public Long createBackCategory(PcsSkuCategory record) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            record.setFullName(this.getBackFullName(record));
            if (record.getParentId() == null || record.getParentId() == 0L) {
                record.setIsLeaf(0);
            } else {
                record.setIsLeaf(1);
            }
            this.pcsSkuCategoryMapper.insertBackCategorySelective(record);
            try {
                if (this.check(record.getCode(), record.getId()).booleanValue()) {
                    this.pcsSkuCategoryMapper.updateBackCategoryByPrimaryKeySelective(record);
                    return record.getId();
                }
                throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u590d");
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
                throw new PurchaseException("PC0006", e.getLocalizedMessage());
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsSkuCategory record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            record.setFullName(this.getFullName(record));
            return this.pcsSkuCategoryMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public boolean updateBackCategory(PcsSkuCategory record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            record.setFullName(this.getBackFullName(record));
            return this.pcsSkuCategoryMapper.updateBackCategoryByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public PcsSkuCategory findById(long id) {
        return this.pcsSkuCategoryMapper.selectByPrimaryKey(id);
    }

    @Override
    public PcsSkuCategory findBackCategoryById(long id) {
        return this.pcsSkuCategoryMapper.selectBackCategoryByPrimaryKey(id);
    }

    @Override
    public List<PcsSkuCategory> findFrontCategoriesBySkuCode(String skuCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", skuCode);
        return this.pcsSkuCategoryMapper.findFrontCategory(params);
    }

    @Override
    public List<PcsSkuCategory> findBackCategoriesBySkuCode(String skuCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", skuCode);
        return this.pcsSkuCategoryMapper.findBackCategory(params);
    }

    @Override
    public List<PcsSkuCategory> findFrontCategoriesBySkuCodeList(List<String> skuCodeList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCodeList", skuCodeList);
        return this.pcsSkuCategoryMapper.findFrontCategory(params);
    }

    @Override
    public List<PcsSkuCategory> findAllChildrens(long parentId) {
        PcsSkuCategoryExample example = new PcsSkuCategoryExample();
        example.createCriteria().andParentIdEqualTo(parentId);
        List<PcsSkuCategory> childrens = this.pcsSkuCategoryMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(childrens)) {
            return Collections.emptyList();
        }
        return childrens;
    }

    @Override
    public List<PcsSkuCategory> findAllBackCategoryChildrens(long parentId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parentId", parentId);
        List<PcsSkuCategory> childrens = this.pcsSkuCategoryMapper.findBackCategory(params);
        if (CollectionUtils.isEmpty(childrens)) {
            return Collections.emptyList();
        }
        return childrens;
    }

    @Override
    public List<PcsSkuCategory> findAll() {
        PcsSkuCategoryExample example = new PcsSkuCategoryExample();
        example.setOrderByClause("id");
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuCategory> findAllFrontCategories() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("withoutRelation", 1);
        params.put("orderBy", "cg.ID");
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryMapper.findFrontCategory(params);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public PcsSkuCategory findByCode(String code) {
        PcsSkuCategoryExample example = new PcsSkuCategoryExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return null;
        }
        if (recordList.size() > 1) {
            throw new PurchaseException("PC0007", " \u6839\u636ecode\u80fd\u67e5\u51fa2\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u8bb0\u5f55");
        }
        return recordList.get(0);
    }

    @Override
    public List<PcsSkuCategory> findByName(String name) {
        PcsSkuCategoryExample example = new PcsSkuCategoryExample();
        example.createCriteria().andNameLike("%" + name + "%");
        example.setOrderByClause("ID LIMIT 20 ");
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuCategory> findBackCategoryByName(String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("nameLike", "%" + name + "%");
        params.put("orderByClause", "ID LIMIT 20 ");
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryMapper.findBackCategory(params);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuCategory> findByIds(List<Long> ids) {
        ArrayList<PcsSkuCategory> recordList = new ArrayList<PcsSkuCategory>();
        for (long id : ids) {
            PcsSkuCategory record = this.findById(id);
            if (!EmptyUtil.isNotEmpty((Object)record) || !EmptyUtil.isNotEmpty((Object)record.getId())) continue;
            recordList.add(record);
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuCategory> findBackCategoriesByIds(List<Long> ids) {
        ArrayList<PcsSkuCategory> recordList = new ArrayList<PcsSkuCategory>();
        for (long id : ids) {
            PcsSkuCategory record = this.findBackCategoryById(id);
            if (!EmptyUtil.isNotEmpty((Object)record) || !EmptyUtil.isNotEmpty((Object)record.getId())) continue;
            recordList.add(record);
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuCategory> findByCodeAndRightLikeCode(String code) {
        List<PcsSkuCategory> recordList = new ArrayList<PcsSkuCategory>();
        HashMap<String, Object> selfMap = new HashMap<String, Object>();
        selfMap.put("withoutRelation", 1);
        selfMap.put("code", code);
        List<PcsSkuCategory> selfList = this.pcsSkuCategoryMapper.findFrontCategory(selfMap);
        if (CollectionUtils.isNotEmpty(selfList)) {
            recordList.addAll(selfList);
        }
        if (CollectionUtils.isEmpty(recordList = this.findChildrenCategoryList(selfList, recordList))) {
            return Collections.emptyList();
        }
        return recordList;
    }

    private List<PcsSkuCategory> findChildrenCategoryList(List<PcsSkuCategory> parentCategoryList, List<PcsSkuCategory> recordList) {
        if (CollectionUtils.isEmpty(parentCategoryList)) {
            return recordList;
        }
        HashMap<String, Object> childrenMap = new HashMap<String, Object>();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        for (PcsSkuCategory parentCategory : parentCategoryList) {
            Integer isLeaf = parentCategory.getIsLeaf();
            if (isLeaf == null || isLeaf != 0) continue;
            parentIdList.add(parentCategory.getId());
        }
        if (CollectionUtils.isEmpty(parentIdList)) {
            return recordList;
        }
        childrenMap.put("withoutRelation", 1);
        childrenMap.put("parentIdList", parentIdList);
        List<PcsSkuCategory> childrenList = this.pcsSkuCategoryMapper.findFrontCategory(childrenMap);
        if (CollectionUtils.isNotEmpty(childrenList)) {
            recordList.addAll(childrenList);
        }
        return this.findChildrenCategoryList(childrenList, recordList);
    }

    @Override
    public List<PcsSkuCategory> findSkuCategoryByParentIdIsNull() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parentIdIsNull", 1);
        params.put("withoutRelation", 1);
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryMapper.findFrontCategory(params);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public PcsSkuCategory findByParentID(Long parentID) {
        PcsSkuCategoryExample example = new PcsSkuCategoryExample();
        example.createCriteria().andIdEqualTo(parentID);
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return null;
        }
        return recordList.get(0);
    }

    @Override
    public List<Long> findProductIdsBySkuCodes(List<String> skuCodes) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCodes", skuCodes);
        return this.pcsSkuCategoryMapper.findProductIdsBySkuCodes(params);
    }

    @Override
    public List<Long> findProductIdListByCategoryFrontRelationIds(List<Long> ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("idList", ids);
        return this.pcsSkuCategoryMapper.findProductIdListByCategoryFrontRelation(params);
    }

    @Override
    public List<PcsFrontBackCategoryVO> findFrontBackCategoryList(Map<String, Object> params) {
        List<PcsFrontBackCategoryVO> list = this.pcsSkuCategoryMapper.findFrontBackCategory(params);
        int i = 0;
        while (i < list.size()) {
            Long bid;
            PcsFrontBackCategoryVO fbCategoryVO = list.get(i);
            HashMap<String, Object> fParams = new HashMap<String, Object>();
            Long fid = fbCategoryVO.getFrontSkuCategoryId();
            if (fid != null) {
                fParams.put("id", fid);
                List<PcsSkuCategoryVO> frontCategories = this.findFrontCategoryList(fParams);
                if (EmptyUtil.isNotEmpty(frontCategories)) {
                    fbCategoryVO.setFrontSkuCategory(frontCategories.get(0));
                }
            }
            if ((bid = fbCategoryVO.getBackSKuCategoryId()) != null) {
                HashMap<String, Object> bParams = new HashMap<String, Object>();
                bParams.put("id", bid);
                List<PcsSkuCategoryVO> backCategories = this.findBackCategoryList(bParams);
                if (EmptyUtil.isNotEmpty(backCategories)) {
                    fbCategoryVO.setBackSkuCategory(backCategories.get(0));
                }
            }
            ++i;
        }
        return list;
    }

    @Override
    public List<PcsSkuCategoryVO> findFrontCategoryList(Map<String, Object> params) {
        return BeanUtil.buildListFrom(this.pcsSkuCategoryMapper.findFrontCategory(params), PcsSkuCategoryVO.class);
    }

    @Override
    public List<PcsSkuCategoryVO> findBackCategoryList(Map<String, Object> params) {
        return BeanUtil.buildListFrom(this.pcsSkuCategoryMapper.findBackCategory(params), PcsSkuCategoryVO.class);
    }

    @Override
    public List<PcsSkuCategoryRelation> findBackCategoryRelationList(PcsSkuCategoryRelationCond cond) {
        return this.pcsSkuCategoryMapper.findBackCategoryRelation(cond);
    }

    @Override
    @Transactional
    public void saveOrUpdateBackCategoryRelationList(List<PcsSkuCategoryRelation> relationList) {
        for (PcsSkuCategoryRelation relation : relationList) {
            this.saveOrUpdateBackCategoryRelation(relation);
        }
    }

    @Override
    public void saveOrUpdateBackCategoryRelation(PcsSkuCategoryRelation relation) {
        PcsSkuCategoryRelationCond cond = new PcsSkuCategoryRelationCond();
        cond.setSkuCode(relation.getSkuCode());
        cond.setCategoryId(relation.getCategoryId());
        List<PcsSkuCategoryRelation> list = this.pcsSkuCategoryMapper.findBackCategoryRelation(cond);
        if (EmptyUtil.isEmpty(list)) {
            this.addBackCategoryRelation(relation);
        }
    }

    @Override
    @Transactional
    public Integer addFrontCategoryRelation(PcsSkuCategoryRelation relation) {
        return this.pcsSkuCategoryMapper.insertFrontCategoryRelation(relation);
    }

    @Override
    @Transactional
    public Integer addBackCategoryRelation(PcsSkuCategoryRelation relation) {
        return this.pcsSkuCategoryMapper.insertBackCategoryRelation(relation);
    }

    @Override
    public Integer addFrontBackCategoryRelation(PcsFrontBackCategoryVO frontBackCategoryVO) {
        return this.pcsSkuCategoryMapper.insertFrontBackCategoryRelation(frontBackCategoryVO);
    }

    @Override
    @Transactional
    public Integer updateBackCategoryRelation(PcsSkuCategoryRelation relation) {
        return this.pcsSkuCategoryMapper.updateBackCategoryRelation(relation);
    }

    @Override
    public List<PcsSkuCategoryRelation> findFrontCategoryRelation(PcsSkuCategoryRelationCond cond) {
        return this.pcsSkuCategoryMapper.findFrontCategoryRelation(cond);
    }

    @Override
    public List<Long> findFrontCategoryIdListByBackCategoryId(Long backCategoryRelationId) {
        return this.pcsSkuCategoryMapper.findFrontCategoryIdListByBackCategoryId(backCategoryRelationId);
    }

    @Override
    public List<Long> findFrontCategoryIdListByBackCategoryIds(List<Long> backCategoryRelationIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", backCategoryRelationIds);
        return this.pcsSkuCategoryMapper.findFrontCategoryIdListByBackCategoryIds(params);
    }

    @Override
    public List<Long> findBackCategoryIdListByFrontCategoryId(Long frontCategoryRelationId) {
        return this.pcsSkuCategoryMapper.findBackCategoryIdListByFrontCategoryId(frontCategoryRelationId);
    }

    @Override
    public Integer countOfFrontCategoryRelation(PcsSkuCategoryRelationCond cond) {
        return this.pcsSkuCategoryMapper.countOfFrontCategoryRelation(cond);
    }

    @Override
    public Integer updateFrontCategoryRelation(PcsSkuCategoryRelation relation) {
        return this.pcsSkuCategoryMapper.updateFrontCategoryRelation(relation);
    }

    @Override
    public Integer deleteFrontCategoryRelationList(List<Long> idList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (EmptyUtil.isNotEmpty(idList)) {
            params.put("idList", idList);
            return this.pcsSkuCategoryMapper.deleteFrontCategoryRelation(params);
        }
        return 0;
    }

    @Override
    public Integer deleteBackCategoryRelationList(List<Long> idList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (EmptyUtil.isNotEmpty(idList)) {
            params.put("idList", idList);
            return this.pcsSkuCategoryMapper.deleteBackCategoryRelation(params);
        }
        return 0;
    }

    public Boolean check(Object obj) {
        PcsSkuCategory record = (PcsSkuCategory)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsSkuCategory record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsSkuCategoryExample example1 = new PcsSkuCategoryExample();
        PcsSkuCategoryExample example2 = new PcsSkuCategoryExample();
        example1.createCriteria().andNameEqualTo(record.getName());
        example2.createCriteria().andCodeEqualTo(record.getCode());
        List<PcsSkuCategory> oldList = null;
        oldList = this.pcsSkuCategoryMapper.selectByExample(example1);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "name\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "name\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        oldList = this.pcsSkuCategoryMapper.selectByExample(example2);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        return true;
    }

    private Boolean check(String code, Long id) {
        PcsSkuCategoryExample example = new PcsSkuCategoryExample();
        example.createCriteria().andCodeEqualTo(code).andIdNotEqualTo(id);
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryMapper.selectByExample(example);
        if (recordList.size() == 0) {
            return true;
        }
        return false;
    }

    private String getFullName(PcsSkuCategory record) {
        if (EmptyUtil.isEmpty((Object)record)) {
            return "";
        }
        if (EmptyUtil.isEmpty((Object)record.getParentId())) {
            return record.getName();
        }
        return String.valueOf(this.getFullName(this.findById(record.getParentId()))) + NAME_SEPARATOR + record.getName();
    }

    private String getBackFullName(PcsSkuCategory record) {
        if (EmptyUtil.isEmpty((Object)record)) {
            return "";
        }
        if (EmptyUtil.isEmpty((Object)record.getParentId())) {
            return record.getName();
        }
        return String.valueOf(this.getBackFullName(this.findBackCategoryById(record.getParentId()))) + NAME_SEPARATOR + record.getName();
    }

    private String getFrontFullName(PcsSkuCategory record) {
        if (EmptyUtil.isEmpty((Object)record)) {
            return "";
        }
        if (EmptyUtil.isEmpty((Object)record.getParentId())) {
            return record.getName();
        }
        return String.valueOf(this.getFrontFullName(this.pcsSkuCategoryMapper.selectFrontCategoryByPrimaryKey(record.getParentId()))) + NAME_SEPARATOR + record.getName();
    }

    @Override
    public List<PcsSkuCategoryVO> findAllFirstBackCategoryList() {
        return this.pcsSkuCategoryMapper.findAllFirstBackCategoryList();
    }

    @Override
    public PcsSkuCategoryVO findFirstCategoryByParentId(Long id) {
        PcsSkuCategoryVO vo = this.pcsSkuCategoryMapper.findFirstCategoryByParentId(id);
        return vo;
    }

    @Override
    public List<PcsFrontBackCategoryVO> findRelationBackCategoryByFrontCategoryId(Long frontId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("frontSkuCategoryId", frontId);
        List<PcsFrontBackCategoryVO> list = this.pcsSkuCategoryMapper.findFrontBackCategory(params);
        int i = 0;
        while (i < list.size()) {
            PcsFrontBackCategoryVO fbCategoryVO = list.get(i);
            Long bid = fbCategoryVO.getBackSKuCategoryId();
            if (bid != null) {
                HashMap<String, Object> bParams = new HashMap<String, Object>();
                bParams.put("id", bid);
                List<PcsSkuCategoryVO> backCategories = this.findBackCategoryList(bParams);
                if (EmptyUtil.isNotEmpty(backCategories)) {
                    fbCategoryVO.setBackSkuCategory(backCategories.get(0));
                }
            }
            ++i;
        }
        return list;
    }

    @Override
    public Long createFrontCategory(PcsSkuCategory record) {
        if (this.check(record).booleanValue() && this.checkFront(record, true).booleanValue()) {
            record.setFullName(this.getFrontFullName(record));
            if (record.getParentId() == null || record.getParentId() == 0L) {
                record.setIsLeaf(0);
            } else {
                record.setIsLeaf(1);
            }
            this.pcsSkuCategoryMapper.insertFrontCategory(record);
            try {
                if (this.check(record.getCode(), record.getId()).booleanValue()) {
                    List<PcsFrontBackCategoryVO> backVO;
                    this.pcsSkuCategoryMapper.updateFrontCategoryByPrimaryKeySelective(record);
                    if (record.getParentId() != null && CollectionUtils.isNotEmpty(backVO = this.findRelationBackCategoryByFrontCategoryId(record.getParentId()))) {
                        this.deleteFrontBackCategoryRelationByFrontId(record.getParentId());
                        for (PcsFrontBackCategoryVO frontBackCategoryVO : backVO) {
                            PcsFrontBackCategoryVO vo = new PcsFrontBackCategoryVO();
                            vo.setFrontSkuCategoryId(record.getId());
                            vo.setBackSKuCategoryId(frontBackCategoryVO.getBackSKuCategoryId());
                            this.addFrontBackCategoryRelation(vo);
                        }
                    }
                    return record.getId();
                }
                throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u590d");
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
                throw new PurchaseException("PC0006", e.getLocalizedMessage());
            }
        }
        return null;
    }

    @Override
    public boolean updateFrontCategory(PcsSkuCategory record) {
        if (this.check(record).booleanValue() && this.checkFront(record, false).booleanValue()) {
            record.setFullName(this.getFrontFullName(record));
            return this.pcsSkuCategoryMapper.updateFrontCategoryByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public Integer deleteFrontBackCategoryRelationByFrontId(Long frontId) {
        return this.pcsSkuCategoryMapper.deleteFrontBackCategoryRelationByFrontId(frontId);
    }

    private Boolean checkFront(PcsSkuCategory record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        List<PcsSkuCategory> oldList = null;
        HashMap<String, Object> params1 = new HashMap<String, Object>();
        HashMap<String, Object> params2 = new HashMap<String, Object>();
        params1.put("name", record.getName());
        params2.put("code", record.getCode());
        oldList = this.pcsSkuCategoryMapper.findFrontCategory(params1);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "name\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "name\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        oldList = this.pcsSkuCategoryMapper.findFrontCategory(params2);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        return true;
    }

    @Override
    public List<Long> findByCondCategory(PcsSkuCategoryCond cond) {
        return this.pcsSkuCategoryMapper.findByCondCategory(cond);
    }

    @Override
    public List<CategoryTreeNodeVO> listAllCategoryTreeNode() {
        List<PcsSkuCategory> leafCategories = this.pcsSkuCategoryMapper.listAllLeafCategory();
        ArrayList result = Lists.newArrayList();
        for (PcsSkuCategory entity : leafCategories) {
            this.buildTreeNodeUp(result, entity);
        }
        this.addRootNode(result);
        return result;
    }

    @Override
    public List<CategoryTreeNodeVO> listTreeNodeByCategoryIds(List<Long> ids) {
        List<PcsSkuCategory> categoryList = this.pcsSkuCategoryMapper.getCategoryByIds(ids);
        ArrayList result = Lists.newArrayList();
        for (PcsSkuCategory entity : categoryList) {
            this.buildTreeNodeUp(result, entity);
        }
        this.addRootNode(result);
        return result;
    }

    private void buildTreeNodeUp(List<CategoryTreeNodeVO> list, PcsSkuCategory entity) {
        CategoryTreeNodeVO vo = new CategoryTreeNodeVO();
        vo.setId(entity.getId().toString());
        Long parentId = entity.getParentId();
        vo.setParent(parentId == null ? "root" : parentId.toString());
        vo.setText(entity.getName());
        if (entity.getIsLeaf() == 0) {
            vo.setType("first");
        } else {
            vo.setType("second");
        }
        list.add((CategoryTreeNodeVO)vo);
        if (entity.getIsLeaf() == 1 && parentId != null) {
            if (list == null) {
                list = Lists.newArrayList();
                this.buildTreeNodeUp(list, this.pcsSkuCategoryMapper.selectByPrimaryKey(parentId));
            } else {
                CategoryTreeNodeVO treeNodeVO = new CategoryTreeNodeVO();
                treeNodeVO.setId(String.valueOf(parentId));
                if (!list.contains(treeNodeVO)) {
                    this.buildTreeNodeUp(list, this.pcsSkuCategoryMapper.selectByPrimaryKey(parentId));
                }
            }
        }
    }

    private void addRootNode(List<CategoryTreeNodeVO> list) {
        if (list == null) {
            list = Lists.newArrayList();
        }
        CategoryTreeNodeVO rootNode = new CategoryTreeNodeVO();
        rootNode.setId("root");
        rootNode.setText("\u5546\u54c1\u7c7b\u76ee");
        rootNode.setType("root");
        rootNode.setParent("#");
        list.add(rootNode);
    }

    @Override
    public List<PcsSkuCategoryVO> findByCondCategoryCron(PcsSkuCategoryCond cond) {
        return this.pcsSkuCategoryMapper.findByCondCategoryCron(cond);
    }

    @Override
    public List<PcsSkuCategoryVO> findCategoryByIds(PcsSkuCategoryCond cond) {
        return this.pcsSkuCategoryMapper.findCategoryByIds(cond);
    }
}

