/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsReceiveRuleCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsReceiveRuleMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsMaterialCategoryDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsReceiveRuleDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsReceiveRule;
import com.thebeastshop.pegasus.merchandise.vo.PcsMaterialCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsReceiveMaterialQcItemVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsReceiveRuleVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsReceiveRuleDomain")
public class PcsReceiveRuleDomainImpl
extends AbstractBaseDomain<PcsReceiveRuleVO, PcsReceiveRule>
implements PcsReceiveRuleDomain {
    @Autowired
    private PcsReceiveRuleMapper pcsReceiveRuleMapper;
    @Autowired
    private PcsMaterialCategoryDomain pcsMaterialCategoryDomain;

    @Override
    public PcsReceiveRuleVO findById(Long id, boolean cascade) {
        PcsReceiveRuleVO ruleVO = this.pcsReceiveRuleMapper.findById(id);
        if (cascade && NullUtil.isNotNull((Object)ruleVO)) {
            List<Long> materialCategoryIds = this.pcsReceiveRuleMapper.findMaterialCategoryIdByReceiveRuleId(ruleVO.getId());
            ruleVO.setMaterialCategoryIds(materialCategoryIds);
        }
        return ruleVO;
    }

    @Override
    public List<PcsReceiveRuleVO> findByCond(PcsReceiveRuleCond cond) {
        List<PcsReceiveRuleVO> ruleVOList = this.pcsReceiveRuleMapper.findByCond(cond);
        if (EmptyUtil.isNotEmpty(ruleVOList)) {
            ArrayList<Long> ruleIds = new ArrayList<Long>();
            for (PcsReceiveRuleVO ruleVO : ruleVOList) {
                ruleIds.add(ruleVO.getId());
            }
            List<PcsReceiveMaterialQcItemVO> list = this.pcsReceiveRuleMapper.findMaterialCategoryIdByReceiveRuleIds(ruleIds);
            if (EmptyUtil.isNotEmpty(list)) {
                HashMap<Long, ArrayList<Long>> ruleMcMap = new HashMap<Long, ArrayList<Long>>();
                for (PcsReceiveMaterialQcItemVO mc : list) {
                    ArrayList<Long> mcList = (ArrayList<Long>)ruleMcMap.get(mc.getReceiveRuleId());
                    if (NullUtil.isNull((Object)mcList)) {
                        mcList = new ArrayList<Long>();
                        ruleMcMap.put(mc.getReceiveRuleId(), mcList);
                    }
                    mcList.add(mc.getMaterialCategoryId());
                }
                for (PcsReceiveRuleVO ruleVO : ruleVOList) {
                    ruleVO.setMaterialCategoryIds((List)ruleMcMap.get(ruleVO.getId()));
                }
            }
        }
        return ruleVOList;
    }

    @Override
    @Transactional
    public boolean add(PcsReceiveRuleVO vo) {
        List<Long> materialCategoryIds = this.findLeafMaterialCategory(vo.getMaterialCategoryIds());
        vo.setMaterialCategoryIds(materialCategoryIds);
        PcsReceiveRule rule = (PcsReceiveRule)this.buildFromVO(vo);
        this.pcsReceiveRuleMapper.insert(rule);
        this.pcsReceiveRuleMapper.updateCode(this.generateCode(rule.getId()), rule.getId());
        vo.setId(rule.getId());
        this.addReceiveMaterial(vo);
        return true;
    }

    @Override
    @Transactional
    public boolean add(List<PcsReceiveRuleVO> voList) {
        boolean result = false;
        if (EmptyUtil.isNotEmpty(voList)) {
            for (PcsReceiveRuleVO vo : voList) {
                result = this.add(vo);
                if (!result) break;
            }
        }
        return result;
    }

    @Override
    @Transactional
    public boolean update(PcsReceiveRuleVO vo) {
        List<Long> materialCategoryIds = this.findLeafMaterialCategory(vo.getMaterialCategoryIds());
        vo.setMaterialCategoryIds(materialCategoryIds);
        this.pcsReceiveRuleMapper.updateByPrimaryKeySelective((PcsReceiveRule)this.buildFromVO(vo));
        this.delReceiveMaterialByReceiveRuleId(vo.getId());
        this.addReceiveMaterial(vo);
        return true;
    }

    @Override
    @Transactional
    public boolean update(List<PcsReceiveRuleVO> voList) {
        boolean result = false;
        if (EmptyUtil.isNotEmpty(voList)) {
            for (PcsReceiveRuleVO vo : voList) {
                result = this.update(vo);
                if (!result) break;
            }
        }
        return result;
    }

    @Override
    @Transactional
    public boolean del(Long id) {
        this.delReceiveMaterialByReceiveRuleId(id);
        this.pcsReceiveRuleMapper.deleteByPrimaryKey(id);
        return true;
    }

    private void delReceiveMaterialByReceiveRuleId(Long receiveRuleId) {
        this.pcsReceiveRuleMapper.deleteQcItemByReceiveRuleId(receiveRuleId);
        this.pcsReceiveRuleMapper.deleteMaterialCategoryByReceiveRuleId(receiveRuleId);
    }

    private void addReceiveMaterial(PcsReceiveRuleVO vo) {
        if (EmptyUtil.isNotEmpty((List)vo.getMaterialCategoryIds())) {
            try {
                for (Long materialCategoryId : vo.getMaterialCategoryIds()) {
                    this.pcsReceiveRuleMapper.insertMaterialCategoryQcItemId(materialCategoryId, vo.getQualityCheckItemId());
                    this.pcsReceiveRuleMapper.insertMaterialCategoryReceiveRuleId(materialCategoryId, vo.getId());
                }
            }
            catch (Exception e) {
                throw new PurchaseException("PC0002", "\u5b58\u5728\u6750\u8d28\u5df2\u7ecf\u5173\u8054\u4e86\u5212\u75d5\u8d28\u68c0\u9879\u4e0b\u7684\u67d0\u4e2a\u89c4\u5219\uff01");
            }
        }
    }

    private List<Long> findLeafMaterialCategory(List<Long> materialCategoryIds) {
        if (EmptyUtil.isEmpty(materialCategoryIds)) {
            throw new PurchaseException("PC0002", "\u65e0\u5173\u8054\u6750\u8d28!");
        }
        List<PcsMaterialCategoryVO> leafCategorys = this.pcsMaterialCategoryDomain.findLeafById(materialCategoryIds);
        if (EmptyUtil.isEmpty(leafCategorys)) {
            throw new PurchaseException("PC0002", "\u65e0\u5173\u8054\u53f6\u5b50\u6750\u8d28\u5206\u7c7b!");
        }
        ArrayList<Long> leafCategoryIds = new ArrayList<Long>();
        for (PcsMaterialCategoryVO leaf : leafCategorys) {
            leafCategoryIds.add(leaf.getId());
        }
        return leafCategoryIds;
    }

    private String generateCode(Long id) {
        String code = id.toString();
        if (code.length() >= 3) {
            return code;
        }
        StringBuilder sb = new StringBuilder();
        int i = code.length();
        while (i < 3) {
            sb.append("0");
            ++i;
        }
        return String.valueOf(sb.toString()) + code;
    }
}

