/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsBuyerCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsBusinessCategoryPermissionMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsBuyerInfoMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsPurchaseCategoryPermissionMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsBuyerDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsBusinessCategoryPermission;
import com.thebeastshop.pegasus.merchandise.model.PcsBuyerInfo;
import com.thebeastshop.pegasus.merchandise.model.PcsBuyerInfoExample;
import com.thebeastshop.pegasus.merchandise.model.PcsPurchaseCategoryPermission;
import com.thebeastshop.pegasus.merchandise.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.UserInfo;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pcsBuyerDomain")
public class PcsBuyerDomainImpl
extends AbstractBaseDomain<PcsBuyerInfoVO, PcsBuyerInfo>
implements PcsBuyerDomain {
    @Autowired
    private PcsBuyerInfoMapper pcsBuyerInfoMapper;
    @Autowired
    private PcsBusinessCategoryPermissionMapper businessCategoryPermissionMapper;
    @Autowired
    private PcsPurchaseCategoryPermissionMapper purchaseCategoryPermissionMapper;

    @Override
    public PcsBuyerInfoVO getBuyerInfoById(Long id) {
        PcsBuyerInfo buyerInfo = this.pcsBuyerInfoMapper.selectByPrimaryKey(id);
        return (PcsBuyerInfoVO)BeanUtil.buildFrom((Object)buyerInfo, PcsBuyerInfoVO.class);
    }

    @Override
    public List<PcsBuyerInfoVO> getAllBuyers() {
        PcsBuyerInfoExample example = new PcsBuyerInfoExample();
        example.createCriteria().getAllCriteria();
        List<PcsBuyerInfo> buyerInfoVOs = this.pcsBuyerInfoMapper.selectAll();
        return BeanUtil.buildListFrom(buyerInfoVOs, PcsBuyerInfoVO.class);
    }

    @Override
    public List<Map<String, String>> getAllBuyerInfos() {
        List<PcsBuyerInfoVO> buyers = this.getAllBuyers();
        ArrayList<Map<String, String>> buyerInfos = new ArrayList<Map<String, String>>();
        for (PcsBuyerInfoVO buyer : buyers) {
            HashMap<String, String> buyerInfoMap = new HashMap<String, String>();
            buyerInfoMap.put("value", buyer.getId().toString());
            buyerInfoMap.put("text", buyer.getRealName());
            buyerInfoMap.put("loginUserId", String.valueOf(buyer.getLoginUserId()));
            buyerInfos.add(buyerInfoMap);
        }
        if (CollectionUtils.isEmpty(buyerInfos)) {
            return Collections.EMPTY_LIST;
        }
        return buyerInfos;
    }

    @Override
    public List<PcsBuyerInfo> getBuyerByCond(PcsBuyerCond cond) {
        return this.pcsBuyerInfoMapper.getBuyerInfoByCond(cond);
    }

    @Override
    public Boolean newBuyer(PcsBuyerInfo buyerInfo) {
        if (this.pcsBuyerInfoMapper.insertSelective(buyerInfo) > 0) {
            return true;
        }
        throw new PurchaseException("PC0011", "\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public Boolean updateBuyerInfo(PcsBuyerInfo buyer) {
        if (this.pcsBuyerInfoMapper.updateByPrimaryKeySelective(buyer) > 0) {
            return true;
        }
        throw new PurchaseException("PC0011", "\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public boolean disableBuyerById(Long buyerId) {
        if (NullUtil.isNull((Object)buyerId)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u9519\u8bef");
        }
        this.pcsBuyerInfoMapper.disableBuyerById(buyerId);
        return true;
    }

    @Override
    public UserInfo findCategoryManagerByBuyer(Integer buyerId) {
        return this.pcsBuyerInfoMapper.selectCategoryManagerByBuyer(buyerId);
    }

    @Override
    public Integer addPurchaseCategoryPermission(PcsPurchaseCategoryPermission purchaseCategoryPermission) {
        return this.purchaseCategoryPermissionMapper.insertSelective(purchaseCategoryPermission);
    }

    @Override
    public Integer addBusinessCategoryPermission(PcsBusinessCategoryPermission businessCategoryPermission) {
        return this.businessCategoryPermissionMapper.insertSelective(businessCategoryPermission);
    }

    @Override
    public int deletePurchaseCategoryPermByUserId(Integer userId) {
        return this.purchaseCategoryPermissionMapper.deleteByUserId(userId);
    }

    @Override
    public int deleteBusinessCategoryPermByUserId(Integer userId) {
        return this.businessCategoryPermissionMapper.deleteByUserId(userId);
    }
}

