/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.cond.OpAttributeCond;
import com.thebeastshop.pegasus.merchandise.cond.OpProductCond;
import com.thebeastshop.pegasus.merchandise.cond.OpSpvCond;
import com.thebeastshop.pegasus.merchandise.conf.PropertyConfigurer;
import com.thebeastshop.pegasus.merchandise.dao.OpProductMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpAttributeDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpChannelDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpChnCanSaleProdDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpProdCanSelfDeliveryDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpProdDynmContDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpProdSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpProductDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpSpvPriceChangeDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCombinationDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.exception.OperationException;
import com.thebeastshop.pegasus.merchandise.model.OpChannel;
import com.thebeastshop.pegasus.merchandise.model.OpChnCanSaleProd;
import com.thebeastshop.pegasus.merchandise.model.OpProdSku;
import com.thebeastshop.pegasus.merchandise.model.OpProduct;
import com.thebeastshop.pegasus.merchandise.model.OpProductExample;
import com.thebeastshop.pegasus.merchandise.model.OpSpvPriceChange;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeVO;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeValueVO;
import com.thebeastshop.pegasus.merchandise.vo.OpChnCanSaleProdVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProductExcelVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProductVO;
import com.thebeastshop.pegasus.merchandise.vo.OpSpvVO;
import com.thebeastshop.pegasus.merchandise.vo.OpSubSkuGroupVO;
import com.thebeastshop.pegasus.merchandise.vo.OpTagVO;
import com.thebeastshop.pegasus.merchandise.vo.OpWatermarkVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="opProductDomain")
public class OpProductDomainImpl
extends AbstractBaseDomain<OpProductVO, OpProduct>
implements OpProductDomain {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpProductDomainImpl.class);
    private static final String DEFAULT_CONBINED_SPV_SKU_CODE = "__";
    private static final int DEFAULT_SPV_MIN_AMOUNT = 1;
    @Autowired
    private OpProductMapper opProductMapper;
    @Autowired
    private OpProdSkuDomain opProdSkuDomain;
    @Autowired
    private PcsSkuDomain pcsSkuDomain;
    @Autowired
    private OpChnCanSaleProdDomain opChnCanSaleProdDomain;
    @Autowired
    private OpProdCanSelfDeliveryDomain opProdCanSelfDeliveryDomain;
    @Autowired
    private OpChannelDomain opChannelDomain;
    @Autowired
    private OpProdDynmContDomain opProdDynmContDomain;
    @Autowired
    private OpAttributeDomain opAttributeDomain;
    @Autowired
    private OpSpvPriceChangeDomain opSpvPriceChangeDomain;
    @Autowired
    private PcsSkuCombinationDomain pcsSkuCombinationDomain;
    @Autowired
    private PropertyConfigurer propertyConfigurer;
    private Map<String, Object> mapping = new HashMap<String, Object>();

    public OpProductDomainImpl() {
        this.mapping.put("product.delivery.fedex.categories", "119,305");
        this.mapping.put("product.delivery.sfair.categories", "120");
    }

    private List<Long> getCategoryIdsFromProperties(String propertiesKey) {
        String strResult = (String)this.mapping.get(propertiesKey);
        if (StringUtils.isBlank((String)strResult)) {
            return Lists.newArrayList();
        }
        String[] values = strResult.split(",");
        ArrayList results = Lists.newArrayList();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            results.add(Long.valueOf(value));
            ++n2;
        }
        return results;
    }

    private List<Long> getFexExCategoryIds() {
        return this.getCategoryIdsFromProperties("product.delivery.fedex.categories");
    }

    private List<Long> getSFAirCategoryIds() {
        return this.getCategoryIdsFromProperties("product.delivery.sfair.categories");
    }

    private void setupDefaultExpressType(OpProduct product, List<String> skuCodes) {
        List<Integer> fxCategoryIds = this.getCategoriesByType("prod.delivery.FX.categories");
        List<Integer> sfaCategoryIds = this.getCategoriesByType("prod.delivery.SFA.categories");
        LOGGER.info("[\u8bbe\u7f6e\u9ed8\u8ba4\u914d\u9001\u65b9\u5f0f] \u8054\u90a6\u7c7b\u76ee: {}, \u987a\u98ce\u7a7a\u8fd0\u7c7b\u76ee: {}", (Object)StringUtils.join(fxCategoryIds, (String)", "), (Object)StringUtils.join(sfaCategoryIds, (String)", "));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fxCategoryIds) && this.pcsSkuDomain.isExistsSpecialCategory(skuCodes, fxCategoryIds).booleanValue()) {
            LOGGER.info("[\u8bbe\u7f6e\u9ed8\u8ba4\u914d\u9001\u65b9\u5f0f:\u8054\u90a6]");
            product.setExpressType(Integer.valueOf(this.propertyConfigurer.getProperty("prod.delivery.type.FX", "0")));
        } else if (CollectionUtils.isNotEmpty(sfaCategoryIds) && this.pcsSkuDomain.isOnlyExistsSpecialCategory(skuCodes, sfaCategoryIds).booleanValue()) {
            LOGGER.info("[\u8bbe\u7f6e\u9ed8\u8ba4\u914d\u9001\u65b9\u5f0f:\u987a\u98ce\u7a7a\u8fd0]");
            product.setExpressType(Integer.valueOf(this.propertyConfigurer.getProperty("prod.delivery.type.SFA", "0")));
        } else {
            LOGGER.info("[\u8bbe\u7f6e\u9ed8\u8ba4\u914d\u9001\u65b9\u5f0f:\u987a\u98ce\u9646\u8fd0]");
            product.setExpressType(Integer.valueOf(this.propertyConfigurer.getProperty("prod.delivery.type.default", "0")));
        }
    }

    private List<Integer> getCategoriesByType(String type) {
        ArrayList categoryIds = Lists.newArrayList();
        String[] split = this.propertyConfigurer.getProperty(type, "0").split(",");
        if (split != null && split.length > 0) {
            try {
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    categoryIds.add(Integer.valueOf(s));
                    ++n2;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("\u914d\u7f6e\u6587\u4ef6\u4e2d\u914d\u9001\u5feb\u9012\u9ed8\u8ba4\u4e8c\u7ea7\u7c7b\u76ee\u7f16\u53f7\u6307\u5b9a\u975e\u6cd5");
                throw new OperationException("\u914d\u7f6e\u6587\u4ef6\u4e2d\u914d\u9001\u5feb\u9012\u9ed8\u8ba4\u4e8c\u7ea7\u7c7b\u76ee\u7f16\u53f7\u6307\u5b9a\u975e\u6cd5");
            }
        }
        LOGGER.info("\u914d\u7f6e\u7684\u4e8c\u7ea7\u7c7b\u76ee\u7f16\u53f7\u4e3a\uff1a" + categoryIds);
        return categoryIds;
    }

    private boolean createWithSkuCodes(OpProductVO prod, List<String> skuCodes, boolean createSku) {
        OpProduct product = (OpProduct)BeanUtil.buildFrom((Object)prod, OpProduct.class);
        this.setupDefaultExpressType(product, skuCodes);
        this.opProductMapper.insert(product);
        HashMap<String, Long> params = new HashMap<String, Long>();
        Long prodId = product.getId();
        params.put("id", prodId);
        product.setCode(CodeGenerator.getInstance().generate("OP_PROD_CODE", params));
        if (createSku && org.apache.commons.collections.CollectionUtils.isNotEmpty(skuCodes)) {
            for (String skuCode : skuCodes) {
                OpProdSku vo = new OpProdSku();
                vo.setProductId(prodId);
                vo.setSkuCode(skuCode);
                this.opProdSkuDomain.create(vo);
            }
        }
        this.opProductMapper.updateByPrimaryKeySelective(product);
        prod.setId(product.getId());
        return product.getId() > 0L;
    }

    @Override
    public boolean create(OpProductVO prod) {
        List skuCodes = prod.getSkuCodes();
        return this.createWithSkuCodes(prod, skuCodes, true);
    }

    private List<String> getCombinedSkuCodes(OpProductVO prod) {
        ArrayList<String> skuCodes = new ArrayList<String>();
        List spvList = prod.getSpvList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)spvList)) {
            for (OpSpvVO spvVO : spvList) {
                List skuCmbList = spvVO.getSkuCombinationList();
                for (PcsSkuCombinationVO skuCmbVO : skuCmbList) {
                    skuCodes.add(skuCmbVO.getSubSkuCode());
                }
            }
        }
        return skuCodes;
    }

    @Override
    public boolean createCombinedProduct(OpProductVO prod) {
        prod.setCombined(Boolean.valueOf(true));
        List<String> skuCodes = this.getCombinedSkuCodes(prod);
        if (!this.createWithSkuCodes(prod, skuCodes, false)) {
            return false;
        }
        List attributeList = prod.getAttributeList();
        LinkedHashMap<String, OpAttributeVO> attrIdMap = new LinkedHashMap<String, OpAttributeVO>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)attributeList)) {
            for (OpAttributeVO attrVo : attributeList) {
                attrVo.setProductId(prod.getId());
                attrVo.setGroupName(attrVo.getName());
                attrVo.setCombined(Integer.valueOf(1));
                this.opAttributeDomain.createWithValues(attrVo);
                attrIdMap.put(attrVo.getName(), attrVo);
            }
        }
        List spvList = prod.getSpvList();
        Integer prodStatus = prod.getProdStatus();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)spvList)) {
            for (OpSpvVO spvVo : spvList) {
                spvVo.setProductId(prod.getId());
                spvVo.setSkuCode(DEFAULT_CONBINED_SPV_SKU_CODE);
                spvVo.setMinAmount(Integer.valueOf(1));
                this.opProdSkuDomain.createCombinedSpv(attrIdMap, spvVo, prodStatus);
            }
        }
        return true;
    }

    @Override
    public boolean updateCombinedProduct(OpProductVO prod) {
        int flag;
        prod.setCombined(Boolean.valueOf(true));
        OpProduct product = new OpProduct();
        product.setId(prod.getId());
        product.setName(prod.getName());
        product.setNameCn(prod.getNameCn());
        product.setDescription(prod.getDescription());
        product.setProdStatus(prod.getProdStatus());
        product.setIsLuckybag(prod.getIsLuckybag());
        int temProdStatus = prod.getTemProdStatus();
        int prodStatus = prod.getProdStatus();
        List attributeList = prod.getAttributeList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)attributeList)) {
            int i = 0;
            while (i < attributeList.size()) {
                OpAttributeVO attrVo = (OpAttributeVO)attributeList.get(i);
                attrVo.setId(attrVo.getId());
                attrVo.setGroupName(attrVo.getName());
                boolean flag2 = this.opAttributeDomain.updateWithValues(attrVo);
                if (!flag2) {
                    return flag2;
                }
                ++i;
            }
        }
        List spvList = prod.getSpvList();
        boolean flag4 = false;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)spvList)) {
            int i = 0;
            while (i < spvList.size()) {
                boolean flag3;
                BigDecimal salesPrice;
                OpSpvVO spvVo = (OpSpvVO)spvList.get(i);
                OpSpvPriceChange obj = this.opSpvPriceChangeDomain.getCurrentAduitPrice(spvVo.getId());
                if (obj != null && (salesPrice = obj.getSalesPrice()).longValue() != spvVo.getSalesPrice().longValue()) {
                    flag4 = true;
                }
                if (!(flag3 = this.opProdSkuDomain.updateCombinedSpv(spvVo, temProdStatus, prodStatus))) {
                    return flag3;
                }
                ++i;
            }
        }
        if (!flag4 && prod.getTemProdStatus().longValue() == 9L) {
            product.setProdStatus(prod.getTemProdStatus());
        }
        return (flag = this.opProductMapper.updateByPrimaryKeySelective(product)) >= 1;
    }

    @Override
    public boolean update(OpProductVO product) {
        return this.opProductMapper.updateByPrimaryKeySelective((OpProduct)BeanUtil.buildFrom((Object)product, OpProduct.class)) != 0;
    }

    @Override
    public boolean updateProdAndSku(OpProductVO product) {
        OpProduct opProduct;
        this.opProdSkuDomain.deleteByProdId(product.getId());
        if (product.getSkuCodes() != null && !product.getSkuCodes().isEmpty()) {
            for (String skuCode : product.getSkuCodes()) {
                OpProdSku prodSku = new OpProdSku();
                prodSku.setSkuCode(skuCode);
                prodSku.setProductId(product.getId());
                this.opProdSkuDomain.create(prodSku);
            }
        }
        return this.opProductMapper.updateByPrimaryKeySelective(opProduct = (OpProduct)BeanUtil.buildFrom((Object)product, OpProduct.class)) != 0;
    }

    public boolean updateN(OpProductVO product) {
        Long prodId = product.getId();
        List skuCodes = product.getSkuCodes();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)skuCodes)) {
            return this.opProductMapper.updateByPrimaryKeySelective((OpProduct)BeanUtil.buildFrom((Object)product, OpProduct.class)) != 0;
        }
        List<OpProdSku> skus = this.opProdSkuDomain.findByProdId(prodId);
        ArrayList<String> existSkus = new ArrayList<String>(skus.size());
        HashMap<String, Long> existSkuIds = new HashMap<String, Long>();
        for (OpProdSku sku : skus) {
            existSkus.add(sku.getSkuCode());
            existSkuIds.put(sku.getSkuCode(), sku.getId());
        }
        ArrayList delSkus = new ArrayList(existSkus);
        ArrayList newSkus = new ArrayList(skuCodes);
        delSkus.removeAll(skuCodes);
        newSkus.removeAll(existSkus);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(newSkus)) {
            for (String newSku : newSkus) {
                OpProdSku vo = new OpProdSku();
                vo.setProductId(prodId);
                vo.setSkuCode(newSku);
                this.opProdSkuDomain.create(vo);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(delSkus)) {
            for (String delSku : delSkus) {
                this.opProdSkuDomain.deleteById((Long)existSkuIds.get(delSku));
            }
            List<OpChnCanSaleProdVO> opChnCanSaleProds = this.opChnCanSaleProdDomain.findByProdIds(Arrays.asList(prodId));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(opChnCanSaleProds)) {
                ArrayList<String> allSkus = new ArrayList<String>(newSkus);
                allSkus.addAll(existSkus);
                allSkus.removeAll(delSkus);
                for (OpChnCanSaleProdVO opChnCanSaleProd : opChnCanSaleProds) {
                    OpChnCanSaleProdVO updateCanSalProd = new OpChnCanSaleProdVO();
                    updateCanSalProd.setId(opChnCanSaleProd.getId());
                    ArrayList<String> saleSkus = new ArrayList<String>(Arrays.asList(opChnCanSaleProd.getCanSaleSku().split(",")));
                    ArrayList<String> seeSkus = new ArrayList<String>(Arrays.asList(opChnCanSaleProd.getCanSeeSku().split(",")));
                    saleSkus.retainAll(allSkus);
                    seeSkus.retainAll(allSkus);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleSkus)) {
                        updateCanSalProd.setCanSaleSku(StringUtils.join(saleSkus, (String)","));
                    }
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(seeSkus)) {
                        updateCanSalProd.setCanSeeSku(StringUtils.join(seeSkus, (String)","));
                    }
                    this.opChnCanSaleProdDomain.update((OpChnCanSaleProd)BeanUtil.buildFrom((Object)updateCanSalProd, OpChnCanSaleProd.class));
                }
            }
        }
        return this.opProductMapper.updateByPrimaryKeySelective((OpProduct)BeanUtil.buildFrom((Object)product, OpProduct.class)) != 0;
    }

    @Override
    public boolean deleteById(Long id) {
        List<OpChnCanSaleProdVO> chnCanSaleProds = this.opChnCanSaleProdDomain.findByProdIds(Collections.singletonList(id));
        ArrayList<String> onshellChnCodes = new ArrayList<String>();
        boolean i = false;
        for (OpChnCanSaleProdVO chnCanSaleProd : chnCanSaleProds) {
            OpChannel channel;
            if (1 != chnCanSaleProd.getOnShelf() || (channel = this.opChannelDomain.findByCode(chnCanSaleProd.getChannelCode())) == null) continue;
            onshellChnCodes.add(channel.getName());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(onshellChnCodes)) {
            throw new OperationException("OP1004", "\u8bf7\u5148\u628a" + StringUtils.join(onshellChnCodes, (String)",") + "\u4e0b\u67b6\uff0c\u518d\u5220\u9664\uff01");
        }
        try {
            this.opProdSkuDomain.deleteByProdId(id);
            this.opChnCanSaleProdDomain.deleteByProdId(id);
            this.opProdCanSelfDeliveryDomain.deleteByProdId(id);
            this.opProdDynmContDomain.deleteByProdId(id);
            return this.opProductMapper.deleteByPrimaryKey(id) != 0;
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            throw new OperationException("OP1004", "\u5220\u9664PROD\u5931\u8d25\uff01");
        }
    }

    @Override
    public List<OpProductVO> findByCond(OpProductCond cond) {
        List list = BeanUtil.buildListFrom(this.opProductMapper.findByCriteria(cond), OpProductVO.class);
        for (OpProductVO vo : list) {
            if (cond.getWithAttribute() != null && cond.getWithAttribute().booleanValue()) {
                OpAttributeCond attrCond = new OpAttributeCond();
                attrCond.setProductId(vo.getId());
                attrCond.setWithValues(Boolean.valueOf(true));
                attrCond.setActive(Boolean.valueOf(true));
                List<OpAttributeVO> attrList = this.opAttributeDomain.findByCondition(attrCond);
                vo.setAttributeList(attrList);
            }
            if (cond.getWithSpv() == null || !cond.getWithSpv().booleanValue()) continue;
            OpSpvCond spvCond = new OpSpvCond();
            spvCond.setProductId(vo.getId());
            spvCond.setWithSku(cond.getWithSku());
            spvCond.setWithSkuCombination(cond.getWithSku());
            List<OpSpvVO> spvList = this.opProdSkuDomain.findByPcsProdSkuCond(spvCond);
            vo.setSpvList(spvList);
            if (vo.getCombined() == null || !vo.getCombined().booleanValue()) continue;
            Map<String, OpSubSkuGroupVO> subSkuGroups = this.getSubSkuGroups(vo);
            vo.setSubSkuGroups(subSkuGroups);
        }
        return list;
    }

    private Map<String, OpSubSkuGroupVO> getSubSkuGroups(OpProductVO productVO) {
        LinkedHashMap<String, OpSubSkuGroupVO> groups = new LinkedHashMap<String, OpSubSkuGroupVO>();
        List spvList = productVO.getSpvList();
        List attributeList = productVO.getAttributeList();
        HashMap<Long, PcsSkuCombinationVO> attrValueIdSubSkuMap = new HashMap<Long, PcsSkuCombinationVO>();
        for (OpSpvVO spvVO : spvList) {
            List skuCombinationList = spvVO.getSkuCombinationList();
            for (PcsSkuCombinationVO skuCombinationVO : skuCombinationList) {
                LinkedHashMap subSkuAttrMap = skuCombinationVO.getAttrValueIds();
                for (Long id : subSkuAttrMap.keySet()) {
                    attrValueIdSubSkuMap.put((Long)subSkuAttrMap.get(id), skuCombinationVO);
                }
            }
        }
        for (OpAttributeVO attrVO : attributeList) {
            List attrValueList = attrVO.getAttributeValueList();
            OpSubSkuGroupVO subSkuGroupVO = (OpSubSkuGroupVO)groups.get(attrVO.getGroupName());
            if (subSkuGroupVO == null) {
                subSkuGroupVO = new OpSubSkuGroupVO(attrVO.getGroupName());
                subSkuGroupVO.setAttributeId(attrVO.getId());
                groups.put(attrVO.getGroupName(), subSkuGroupVO);
            }
            for (OpAttributeValueVO attrValueVO : attrValueList) {
                PcsSkuCombinationVO subSkuVO = (PcsSkuCombinationVO)attrValueIdSubSkuMap.get(attrValueVO.getId());
                subSkuVO.setAttrName(attrVO.getName());
                subSkuVO.setAttrValue(attrValueVO.getValueText());
                subSkuVO.setOpAttributeVO(attrVO);
                subSkuGroupVO.addSubSku(subSkuVO);
            }
        }
        return groups;
    }

    @Override
    public List<OpProductVO> findBySkuCode(String skuCode) {
        return BeanUtil.buildListFrom(this.opProductMapper.findBySkuCode(skuCode), OpProductVO.class);
    }

    @Override
    public List<OpProductExcelVO> findExportListByCond(OpProductCond cond) {
        return BeanUtil.buildListFrom(this.opProductMapper.findExportListByCriteria(cond), OpProductExcelVO.class);
    }

    @Override
    public List<OpProductVO> findByNameOrCode(String name) {
        OpProductExample example = new OpProductExample();
        OpProductExample.Criteria criteria = example.createCriteria();
        criteria.andCodeLike(SQLUtils.allLike((String)name));
        example.or().andNameLike(SQLUtils.allLike((String)name));
        example.or().andNameCnLike(SQLUtils.allLike((String)name));
        example.setOrderByClause("CODE  LIMIT 20");
        return BeanUtil.buildListFrom(this.opProductMapper.selectByExample(example), OpProductVO.class);
    }

    @Override
    public List<OpProductVO> findProdWithSpvByNameOrCode(String arg0) {
        List prods = BeanUtil.buildListFrom(this.opProductMapper.findNoCombinedProdByCodeOrName(arg0), OpProductVO.class);
        for (OpProductVO prod : prods) {
            OpSpvCond spvCond = new OpSpvCond();
            spvCond.setProductId(prod.getId());
            spvCond.setWithSku(Boolean.valueOf(false));
            ArrayList<String> skuCodes = new ArrayList<String>();
            List<OpProdSku> spvList = this.opProdSkuDomain.findByProdId(prod.getId());
            for (OpProdSku skuVO : spvList) {
                skuCodes.add(skuVO.getSkuCode());
            }
            prod.setSkuCodes(skuCodes);
        }
        return prods;
    }

    @Override
    public OpProductVO findById(Long id) {
        OpProduct opProduct = this.opProductMapper.selectByPrimaryKey(id);
        return (OpProductVO)BeanUtil.buildFrom((Object)opProduct, OpProductVO.class);
    }

    @Override
    public List<OpProductVO> findByIds(List<Long> ids) {
        return this.findByIds(ids, false);
    }

    @Override
    public List<OpProductVO> findProdWithWatermarkByIds(List<Long> ids) {
        return this.findProdWithWatermarkByIds(ids, false);
    }

    @Override
    public List<OpProductVO> findProdWithTagByIds(List<Long> ids) {
        return this.findProdWithTagByIds(ids, false);
    }

    @Override
    public List<Long> findProdWatermarkProdIdsByParams(Map<String, Object> params) {
        return this.opProductMapper.findProdWatermarkProdIdsByParams(params);
    }

    @Override
    public List<Long> findProdTagProdIdsByParams(Map<String, Object> params) {
        return this.opProductMapper.findProdTagProdIdsByParams(params);
    }

    @Override
    public List<OpProduct> listProdMat(Map<String, Object> params) {
        Integer page = MapUtils.getInteger(params, (Object)"page", (Integer)1);
        Integer size = MapUtils.getInteger(params, (Object)"size", (Integer)20);
        if (page > 0) {
            page = page - 1;
        }
        int start = page * size;
        params.put("start", start);
        params.put("criteriaStr", "LIMIT " + start + ", " + size);
        if (params.get("combined") == null) {
            params.put("combined", "-1");
        }
        List<OpProduct> list = this.opProductMapper.listProdMat(params);
        this.log.info("[listProdMat] result: " + JSON.toJSONString(list));
        return list;
    }

    public List<OpProductVO> findProdByIds(List<Long> ids, boolean withCategories) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", ids);
        List<OpProduct> productList = this.opProductMapper.queryByIds(params);
        List productVOList = BeanUtil.buildListFrom(productList, OpProductVO.class);
        return productVOList;
    }

    @Override
    public List<OpWatermarkVO> queryWatermarksByProdId(Map<String, Object> params) {
        List<OpWatermarkVO> watermarkList = this.opProductMapper.queryWatermarksByParams(params);
        return watermarkList;
    }

    @Override
    public List<OpTagVO> queryTagsByProdId(Map<String, Object> params) {
        List<OpTagVO> tagList = this.opProductMapper.queryTagsByParams(params);
        return tagList;
    }

    @Override
    public List<Map> listProdMat(OpProductCond cond) {
        return null;
    }

    public List<OpProductVO> findProdWithWatermarkByIds(List<Long> ids, boolean withCategories) {
        List<OpProductVO> productVOList = this.findProdByIds(ids, withCategories);
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (OpProductVO opProd : productVOList) {
            params.put("id", opProd.getId());
            params.put("active", 1);
            List<OpWatermarkVO> watermarkList = this.opProductMapper.queryWatermarksByParams(params);
            opProd.setWatermarkLis(watermarkList);
        }
        return productVOList;
    }

    public List<OpProductVO> findProdWithTagByIds(List<Long> ids, boolean withCategories) {
        List<OpProductVO> productVOList = this.findProdByIds(ids, withCategories);
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (OpProductVO opProd : productVOList) {
            params.put("id", opProd.getId());
            params.put("active", 1);
            List<OpTagVO> tagList = this.opProductMapper.queryTagsByParams(params);
            opProd.setTags(tagList);
        }
        return productVOList;
    }

    @Override
    public List<OpProductVO> findByIds(List<Long> ids, boolean withCategories) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", ids);
        List<OpProduct> productList = this.opProductMapper.queryByIds(params);
        List productVOList = BeanUtil.buildListFrom(productList, OpProductVO.class);
        return productVOList;
    }

    @Override
    public List<Long> findProductIdsByCampaignIds(List<Long> ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", ids);
        List<Long> idList = this.opProductMapper.findProductIdsByCampaignIds(params);
        return idList;
    }

    @Override
    public List<Long> findProductIdsByCodes(List<String> codes) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("codes", codes);
        List<Long> idList = this.opProductMapper.findProductIdsByCodes(params);
        return idList;
    }

    @Override
    public int updateByExampleSelective(OpProductVO vo) {
        OpProductExample example = new OpProductExample();
        OpProductExample.Criteria criteria = example.createCriteria();
        criteria.andCodeEqualTo(vo.getCode());
        OpProduct product = new OpProduct();
        product.setSeq(vo.getSeq());
        product.setSort1(vo.getSort1());
        product.setSort2(vo.getSort2());
        return this.opProductMapper.updateByExampleSelective(product, example);
    }

    @Override
    public OpProductVO findProductByCode(String code) {
        OpProduct po = this.opProductMapper.selectByCode(code);
        OpProductVO opProductVO = (OpProductVO)BeanUtil.buildFrom((Object)po, OpProductVO.class);
        return opProductVO;
    }

    @Override
    public Boolean isExistsSpecialCategory(Long productId, List<Integer> categoryIds) {
        if (this.opProductMapper.getSpecialCategoryByProductId(productId, categoryIds) > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isOnlyExistsSpecialCategory(Long productId, List<Integer> categoryIds) {
        if (this.opProductMapper.getSpecialCategoryByProductId(productId, categoryIds) > 0 && this.opProductMapper.getOtherCategoryByProductId(productId, categoryIds) <= 0) {
            return true;
        }
        return false;
    }

    @Override
    public Long getIdByCode(String code) {
        if (code == null) {
            return null;
        }
        return this.opProductMapper.getIdByCode(code);
    }

    @Override
    public String getCodeById(Long id) {
        if (id == null) {
            return null;
        }
        OpProduct opProduct = this.opProductMapper.selectByPrimaryKey(id);
        if (opProduct == null) {
            return null;
        }
        return opProduct.getCode();
    }

    @Override
    public OpProductVO findCombinedProductByProdId(Long productId) {
        OpProductVO opProductVO = (OpProductVO)BeanUtil.buildFrom((Object)this.opProductMapper.selectByPrimaryKey(productId), OpProductVO.class);
        if (opProductVO != null && opProductVO.getCombined().booleanValue()) {
            OpSpvCond spvCond = new OpSpvCond();
            spvCond.setProductId(productId);
            spvCond.setWithSkuCombination(Boolean.valueOf(true));
            opProductVO.setSpvList(this.opProdSkuDomain.findSpvCombinedByProdId(productId));
        }
        return opProductVO;
    }

    @Override
    public List<OpProductVO> findCombinedProdAuditList(OpProductCond cond) {
        return this.opProductMapper.findCombinedProdAuditList(cond);
    }

    @Override
    public Boolean auditCombinedProdByProdId(OpProductCond cond) {
        List<OpProdSku> list;
        if (cond.getProdStatus() == null) {
            throw new OperationException("OP0001", "\u4ea7\u54c1\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (cond.getChangeStatus() == null) {
            throw new OperationException("OP0001", "\u4ef7\u683c\u53d8\u66f4\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (cond.getId() == null) {
            throw new OperationException("OP0001", "\u4ea7\u54c1Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OpProduct baseicOpProduct = this.opProductMapper.selectByPrimaryKey(cond.getId());
        int temProdStatus = baseicOpProduct.getProdStatus();
        OpProduct opProduct = new OpProduct();
        opProduct.setId(cond.getId());
        opProduct.setProdStatus(cond.getProdStatus());
        opProduct.setLastAuditTime(new Date());
        this.opProductMapper.updateByPrimaryKeySelective(opProduct);
        this.opSpvPriceChangeDomain.updatePriceChangeStatusByProductId(cond.getId(), cond.getChangeStatus());
        if (temProdStatus == 3 && cond.getProdStatus() == 9 && org.apache.commons.collections.CollectionUtils.isNotEmpty(list = this.opProdSkuDomain.findByProdId(cond.getId()))) {
            for (OpProdSku spv : list) {
                Long spvId = spv.getId();
                OpSpvPriceChange obj = this.opSpvPriceChangeDomain.getCurrentAduitPrice(spvId);
                BigDecimal price = obj.getSalesPrice();
                OpProdSku opProdSku = new OpProdSku();
                opProdSku.setId(spvId);
                opProdSku.setSalesPrice(price);
                opProdSku.setCombined(true);
                this.opProdSkuDomain.update(opProdSku);
            }
        }
        return true;
    }

    @Override
    public Boolean getCrossBorderFlagListByCode(String code, Integer crossBorderFlag) {
        if (this.opProductMapper.getCrossBorderFlagListByCode(code, crossBorderFlag) > 0) {
            return true;
        }
        return false;
    }

    @Override
    public List<PcsSkuVO> getSkuListByProductCode(String productCode) {
        OpProductVO productVO = this.findProductByCode(productCode);
        ArrayList skuCodes = Lists.newArrayList();
        if (productVO.getCombined().booleanValue()) {
            OpProductVO product = this.findCombinedProductByProdId(productVO.getId());
            List spvList = product.getSpvList();
            if (product != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)spvList)) {
                for (OpSpvVO opSpvVO : spvList) {
                    List list = opSpvVO.getSkuCombinationList();
                    if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) continue;
                    for (PcsSkuCombinationVO item : list) {
                        skuCodes.add(item.getSubSkuCode());
                    }
                }
            }
        } else {
            List<OpProductVO> productList = this.findProdWithSpvByNameOrCode(productCode);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(productList)) {
                for (OpProductVO opProductVO : productList) {
                    skuCodes.addAll(opProductVO.getSkuCodes());
                }
            }
        }
        List<PcsSkuVO> resultList = this.pcsSkuDomain.findByCodes(skuCodes);
        return resultList;
    }
}

