/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.conf;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.conf.PropertyConfigurer;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LuhanConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuhanConfig.class);
    private PropertyConfigurer propertyConfigurer;
    private List<String> prodCodes;
    private Date startTime;
    private Map<String, Object> prodMap = new HashMap<String, Object>();

    public LuhanConfig(PropertyConfigurer propertyConfigurer) {
        this.propertyConfigurer = propertyConfigurer;
        this.reflush();
    }

    public List<String> getProdCodes() {
        return this.prodCodes;
    }

    public void setProdCodes(List<String> prodCodes) {
        this.prodCodes = prodCodes;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public boolean isLuhanProd(String code) {
        return this.prodMap.containsKey(code);
    }

    public synchronized void reflush() {
        String time = this.propertyConfigurer.getProperty("prod.luhan.start_time");
        this.startTime = DateUtil.parse((String)time, (String)"yyyy-MM-dd hh:mm:ss");
        String codes = this.propertyConfigurer.getProperty("prod.luhan.codes");
        Object[] codeArr = codes.split(",");
        this.prodCodes = Lists.newArrayList((Object[])codeArr);
        LOGGER.info("\u3010\u9e7f\u6657\u6d3b\u52a8\u3011\u5237\u65b0\u914d\u7f6e: \u5f00\u59cb\u65f6\u95f4: {} \u5546\u54c1CODES: {}", (Object)this.startTime, (Object)StringUtils.join((Object[])codeArr, (String)","));
        this.prodMap = new HashMap<String, Object>();
        for (String code : this.prodCodes) {
            this.prodMap.put(code, true);
        }
    }

    public void setupProd(PsProductVO productVO) {
        Date now;
        if (this.isLuhanProd(productVO.getCode()) && (now = new Date()).before(this.startTime)) {
            LOGGER.info("\u3010\u9e7f\u6657\u5546\u54c1\u3011\u6b64\u4e3a\u9e7f\u6657\u5546\u54c1[CODE: {}], \u65f6\u95f4\u672a\u5230\uff0c\u8bbe\u7f6e\u672a\u4e0a\u67b6");
            productVO.setOnShelfChnCodes(new ArrayList());
            productVO.setOffShelfChnCodes(new ArrayList());
        }
    }
}

